/*
 * Decompiled with CFR 0.152.
 */
package net.bumblebee.claysoldiers.commands;

import com.mojang.brigadier.ImmutableStringReader;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.regex.Pattern;
import net.bumblebee.claysoldiers.util.color.ColorHelper;
import net.minecraft.class_124;
import net.minecraft.class_2172;
import net.minecraft.class_2561;

public class ColorHelperArgumentType
implements ArgumentType<ColorHelper> {
    private static final Collection<String> EXAMPLES = List.of("normal", "#FFFFFF", "#EFD3C4", "black", "aqua");
    public static final String INVALID_COLOR = "argument.csr.color_type.invalid";
    public static final DynamicCommandExceptionType ERROR_INVALID_VALUE = new DynamicCommandExceptionType(string -> class_2561.method_54159((String)INVALID_COLOR, (Object[])new Object[]{string}));
    public static final List<String> SUGGESTIONS = ColorHelperArgumentType.buildSuggestions();
    private static final Pattern HEX_PATTERN = Pattern.compile("^#?([A-Fa-f0-9]{6})$");

    public static ColorHelperArgumentType colorArgumentType() {
        return new ColorHelperArgumentType();
    }

    private static String readHexString(StringReader reader) throws CommandSyntaxException {
        char symbol;
        StringBuilder input = new StringBuilder();
        boolean isHex = false;
        if (reader.canRead()) {
            char startChar = reader.peek();
            input.append(startChar);
            isHex = startChar == '#';
            reader.skip();
        }
        boolean valid = false;
        while (reader.canRead() && !Character.isWhitespace(symbol = reader.peek())) {
            input.append(symbol);
            valid = isHex && HEX_PATTERN.matcher(input).matches();
            reader.skip();
        }
        if (isHex && !valid) {
            throw ERROR_INVALID_VALUE.create((Object)"Not a valid hex color");
        }
        return input.toString();
    }

    public ColorHelper parse(StringReader reader) throws CommandSyntaxException {
        String s = ColorHelperArgumentType.readHexString(reader);
        class_124 chatFormatting = class_124.method_533((String)s);
        if (chatFormatting != null) {
            return ColorHelper.color(chatFormatting.method_532());
        }
        if (s.equals("normal")) {
            return ColorHelper.EMPTY;
        }
        if (s.equals("jeb_")) {
            return ColorHelper.jeb();
        }
        try {
            return ColorHelper.color(Integer.parseInt(s.substring(1), 16));
        }
        catch (NumberFormatException e) {
            throw ERROR_INVALID_VALUE.createWithContext((ImmutableStringReader)reader, (Object)e.getMessage());
        }
    }

    public <S> CompletableFuture<Suggestions> listSuggestions(CommandContext<S> context, SuggestionsBuilder builder) {
        return class_2172.method_9265(SUGGESTIONS, (SuggestionsBuilder)builder);
    }

    public Collection<String> getExamples() {
        return EXAMPLES;
    }

    public static List<String> buildSuggestions() {
        ArrayList<String> list = new ArrayList<String>();
        list.add("normal");
        list.addAll(class_124.method_540((boolean)true, (boolean)false));
        list.remove(class_124.field_1070.method_537());
        list.add("jeb_");
        return list;
    }
}

