/*
 * Decompiled with CFR 0.152.
 */
package net.bumblebee.claysoldiers.commands;

import com.mojang.brigadier.ImmutableStringReader;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import net.bumblebee.claysoldiers.init.ModRegistries;
import net.bumblebee.claysoldiers.team.ClayMobTeam;
import net.bumblebee.claysoldiers.util.codec.CodecUtils;
import net.minecraft.class_151;
import net.minecraft.class_2168;
import net.minecraft.class_2172;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_7157;
import net.minecraft.class_7225;

public abstract class DefaultedResourceLocationArgument
implements ArgumentType<class_2960> {
    private static final Collection<String> EXAMPLES = List.of("foo:bar", "zee");
    public static final String INVALID_RESOURCE_LOCATION = "argument.csr.resource_location.invalid";
    public static final DynamicCommandExceptionType ERROR_INVALID_VALUE = new DynamicCommandExceptionType(string -> class_2561.method_54159((String)INVALID_RESOURCE_LOCATION, (Object[])new Object[]{string}));

    public static AllClayMobTeam all(class_7157 context) {
        return new AllClayMobTeam(context);
    }

    public static SoldierItemType itemType(class_7157 context) {
        return new SoldierItemType(context);
    }

    public static class_2960 key(String key, CommandContext<class_2168> context) {
        return (class_2960)context.getArgument(key, class_2960.class);
    }

    protected abstract boolean isValid(class_2960 var1);

    public class_2960 parse(StringReader reader) throws CommandSyntaxException {
        class_2960 res = DefaultedResourceLocationArgument.read(reader);
        if (!this.isValid(res)) {
            throw ERROR_INVALID_VALUE.create((Object)res.toString());
        }
        return res;
    }

    private static class_2960 read(StringReader reader) throws CommandSyntaxException {
        int i = reader.getCursor();
        String s = DefaultedResourceLocationArgument.readGreedy(reader);
        try {
            return CodecUtils.parse(s);
        }
        catch (class_151 resourcelocationexception) {
            reader.setCursor(i);
            throw class_2960.field_13354.createWithContext((ImmutableStringReader)reader);
        }
    }

    private static String readGreedy(StringReader reader) {
        int i = reader.getCursor();
        while (reader.canRead() && class_2960.method_12831((char)reader.peek())) {
            reader.skip();
        }
        return reader.getString().substring(i, reader.getCursor());
    }

    public Collection<String> getExamples() {
        return EXAMPLES;
    }

    public abstract <S> CompletableFuture<Suggestions> listSuggestions(CommandContext<S> var1, SuggestionsBuilder var2);

    public static class AllClayMobTeam
    extends DefaultedResourceLocationArgument {
        private final class_7225<ClayMobTeam> registryLookup;

        public AllClayMobTeam(class_7157 context) {
            this.registryLookup = context.method_46762(ModRegistries.CLAY_MOB_TEAMS);
        }

        @Override
        protected boolean isValid(class_2960 key) {
            return this.registryLookup.method_46746(class_5321.method_29179(ModRegistries.CLAY_MOB_TEAMS, (class_2960)key)).isPresent();
        }

        @Override
        public <S> CompletableFuture<Suggestions> listSuggestions(CommandContext<S> context, SuggestionsBuilder builder) {
            return class_2172.method_9257(this.registryLookup.method_46754().map(class_5321::method_29177), (SuggestionsBuilder)builder);
        }
    }

    public static class SoldierItemType
    extends DefaultedResourceLocationArgument {
        private final class_7157 context;

        public SoldierItemType(class_7157 context) {
            this.context = context;
        }

        @Override
        protected boolean isValid(class_2960 key) {
            Optional registryLookup = this.context.method_46759(ModRegistries.SOLDIER_ITEM_TYPES);
            if (registryLookup.isEmpty()) {
                return true;
            }
            return ((class_7225.class_7226)registryLookup.orElseThrow()).method_46746(class_5321.method_29179(ModRegistries.SOLDIER_ITEM_TYPES, (class_2960)key)).isPresent();
        }

        @Override
        public <S> CompletableFuture<Suggestions> listSuggestions(CommandContext<S> context, SuggestionsBuilder builder) {
            CompletableFuture completableFuture;
            Object object = context.getSource();
            if (object instanceof class_2172) {
                class_2172 sharedsuggestionprovider = (class_2172)object;
                completableFuture = sharedsuggestionprovider.method_41213(ModRegistries.SOLDIER_ITEM_TYPES, class_2172.class_7078.field_37263, builder, context);
            } else {
                completableFuture = builder.buildFuture();
            }
            return completableFuture;
        }
    }
}

