/*
 * Decompiled with CFR 0.152.
 */
package net.bumblebee.claysoldiers.datamap;

import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import io.netty.buffer.ByteBuf;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import net.bumblebee.claysoldiers.soldierproperties.translation.KeyableTranslatableProperty;
import net.bumblebee.claysoldiers.util.codec.CodecUtils;
import net.minecraft.class_1304;
import net.minecraft.class_2540;
import net.minecraft.class_3542;
import net.minecraft.class_9135;
import net.minecraft.class_9139;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public enum SoldierEquipmentSlot implements class_3542,
KeyableTranslatableProperty
{
    MAINHAND(Type.HAND, 0, 0, "mainhand"),
    OFFHAND(Type.HAND, 1, 5, "offhand"),
    FEET(Type.ARMOR, 0, 1, "feet"),
    LEGS(Type.ARMOR, 1, 2, "legs"),
    CHEST(Type.ARMOR, 2, 3, "chest"),
    HEAD(Type.ARMOR, 3, 4, "head"),
    CAPE(Type.ARMOR, 4, 6, "cape"),
    BACKPACK(Type.BACKPACK, 0, 7, "backpack"),
    BACKPACK_PASSIVE(Type.BACKPACK, 1, 8, "backpack_passive");

    public static final String SOLDIER_SLOT_PREFIX = "clay_soldier.slot.csr.";
    public static final List<SoldierEquipmentSlot> HANDS;
    public static final List<SoldierEquipmentSlot> BACKPACK_SLOTS;
    public static final List<SoldierEquipmentSlot> NO_SLOT;
    public static final List<SoldierEquipmentSlot> CUSTOM_EQUIP;
    public static final Codec<SoldierEquipmentSlot> CODEC;
    public static final class_9139<class_2540, SoldierEquipmentSlot> STREAM_CODEC;
    public static final class_9139<class_2540, List<SoldierEquipmentSlot>> LIST_STREAM_CODEC;
    public static final class_9139<ByteBuf, Optional<SoldierEquipmentSlot>> OPTIONAL_STREAM_CODEC;
    private final Type type;
    private final int index;
    private final int filterFlag;
    private final String name;
    public static final MapCodec<List<SoldierEquipmentSlot>> CODEC_MAPPED;

    private SoldierEquipmentSlot(Type pType, int pIndex, int pFilterFlag, String pName) {
        this.type = pType;
        this.index = pIndex;
        this.filterFlag = pFilterFlag;
        this.name = pName;
    }

    @Override
    public String translatableKey() {
        return SOLDIER_SLOT_PREFIX + this.method_15434();
    }

    public Type getType() {
        return this.type;
    }

    public int getIndex() {
        return this.index;
    }

    public int getFilterFlag() {
        return this.filterFlag;
    }

    public String getName() {
        return this.name;
    }

    public boolean isArmor() {
        return this.type == Type.ARMOR;
    }

    public String method_15434() {
        return this.name;
    }

    public static Optional<SoldierEquipmentSlot> getFromSlot(class_1304 slot) {
        return switch (slot) {
            default -> throw new MatchException(null, null);
            case class_1304.field_6169 -> Optional.of(HEAD);
            case class_1304.field_6174 -> Optional.of(CHEST);
            case class_1304.field_6172 -> Optional.of(LEGS);
            case class_1304.field_6166 -> Optional.of(FEET);
            case class_1304.field_6173 -> Optional.of(MAINHAND);
            case class_1304.field_6171 -> Optional.of(OFFHAND);
            case class_1304.field_48824 -> Optional.empty();
        };
    }

    @Nullable
    public static class_1304 convertToSlot(SoldierEquipmentSlot soldierEquipmentSlot) {
        return switch (soldierEquipmentSlot.ordinal()) {
            case 5 -> class_1304.field_6169;
            case 4 -> class_1304.field_6174;
            case 3 -> class_1304.field_6172;
            case 2 -> class_1304.field_6166;
            case 0 -> class_1304.field_6173;
            case 1 -> class_1304.field_6171;
            default -> null;
        };
    }

    static {
        HANDS = List.of(MAINHAND, OFFHAND);
        BACKPACK_SLOTS = List.of(BACKPACK, BACKPACK_PASSIVE);
        NO_SLOT = List.of();
        CUSTOM_EQUIP = NO_SLOT;
        CODEC = class_3542.method_28140(SoldierEquipmentSlot::values);
        STREAM_CODEC = CodecUtils.createEnumStreamCodec(SoldierEquipmentSlot.class);
        LIST_STREAM_CODEC = STREAM_CODEC.method_56433(class_9135.method_56363());
        OPTIONAL_STREAM_CODEC = new class_9139<ByteBuf, Optional<SoldierEquipmentSlot>>(){

            public Optional<SoldierEquipmentSlot> decode(ByteBuf byteBuf) {
                byte i = byteBuf.readByte();
                return i == -1 ? Optional.empty() : Optional.of(SoldierEquipmentSlot.values()[i]);
            }

            public void encode(ByteBuf o, Optional<SoldierEquipmentSlot> soldierEquipmentSlot) {
                o.writeByte(soldierEquipmentSlot.map(Enum::ordinal).orElse(-1).intValue());
            }
        };
        CODEC_MAPPED = Codec.mapEither((MapCodec)CustomSlotType.CODEC.fieldOf("slot"), CodecUtils.singularOrPluralCodecOptional(CODEC, "slot")).xmap(CustomSlotType::getFromEither, CustomSlotType::createEither);
    }

    public static enum Type {
        HAND,
        ARMOR,
        BACKPACK;

    }

    private static enum CustomSlotType implements class_3542
    {
        CUSTOM_PICK_UP("capability_pick_up", List.of()),
        HANDS("hands", HANDS),
        BACK_PACKS("backpacks", BACKPACK_SLOTS);

        public static final Codec<CustomSlotType> CODEC;
        private final String serializedName;
        private final List<SoldierEquipmentSlot> slots;

        private CustomSlotType(String serializedName, List<SoldierEquipmentSlot> slots) {
            this.serializedName = serializedName;
            this.slots = slots;
        }

        @NotNull
        public String method_15434() {
            return this.serializedName;
        }

        private static List<SoldierEquipmentSlot> getFromEither(Either<CustomSlotType, Set<SoldierEquipmentSlot>> either) {
            if (either.left().isPresent()) {
                return ((CustomSlotType)((Object)either.left().get())).slots;
            }
            return ((Set)either.right().orElseThrow()).stream().toList();
        }

        private static Either<CustomSlotType, Set<SoldierEquipmentSlot>> createEither(List<SoldierEquipmentSlot> slots) {
            if (slots.isEmpty()) {
                return Either.left((Object)((Object)CUSTOM_PICK_UP));
            }
            if (slots.size() != 2) {
                return Either.right(Set.copyOf(slots));
            }
            if (slots.get(0) == MAINHAND && slots.get(1) == OFFHAND || slots.get(0) == OFFHAND && slots.get(1) == MAINHAND) {
                return Either.left((Object)((Object)HANDS));
            }
            return Either.right(Set.copyOf(slots));
        }

        static {
            CODEC = class_3542.method_28140(CustomSlotType::values);
        }
    }
}

