/*
 * Decompiled with CFR 0.152.
 */
package net.bumblebee.claysoldiers.datamap;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiFunction;
import net.bumblebee.claysoldiers.ClaySoldiersCommon;
import net.bumblebee.claysoldiers.capability.CustomEquipCapability;
import net.bumblebee.claysoldiers.claypoifunction.ClayPoiFunction;
import net.bumblebee.claysoldiers.claypoifunction.ClayPoiSource;
import net.bumblebee.claysoldiers.claypoifunction.ClaySoldierInventorySetter;
import net.bumblebee.claysoldiers.clayremovalcondition.RemovalCondition;
import net.bumblebee.claysoldiers.clayremovalcondition.RemovalConditionType;
import net.bumblebee.claysoldiers.claysoldierpredicate.ClayPredicate;
import net.bumblebee.claysoldiers.claysoldierpredicate.ClayPredicates;
import net.bumblebee.claysoldiers.datamap.DropRateProperty;
import net.bumblebee.claysoldiers.datamap.SoldierEquipmentSlot;
import net.bumblebee.claysoldiers.datamap.SoldierPickUpPriority;
import net.bumblebee.claysoldiers.soldierproperties.SoldierPropertyMap;
import net.bumblebee.claysoldiers.soldierproperties.customproperties.RangedAttackType;
import net.bumblebee.claysoldiers.soldierproperties.customproperties.specialattack.SpecialAttack;
import net.bumblebee.claysoldiers.soldierproperties.customproperties.specialattack.SpecialAttackType;
import net.bumblebee.claysoldiers.soldierproperties.customproperties.specialattack.SpecialEffectCategory;
import net.minecraft.class_1799;
import net.minecraft.class_9129;
import net.minecraft.class_9135;
import net.minecraft.class_9139;
import org.jetbrains.annotations.Nullable;

public final class SoldierHoldableEffect {
    public static final Codec<SoldierHoldableEffect> CODEC = RecordCodecBuilder.create(in -> in.group((App)SoldierPropertyMap.CODEC.optionalFieldOf("properties", (Object)SoldierPropertyMap.EMPTY_MAP).forGetter(SoldierHoldableEffect::properties), (App)SoldierEquipmentSlot.CODEC_MAPPED.forGetter(SoldierHoldableEffect::slots), (App)SoldierPickUpPriority.CODEC.optionalFieldOf("pick_priority", (Object)SoldierPickUpPriority.NORMAL.get()).forGetter(SoldierHoldableEffect::pickUpPriority), (App)DropRateProperty.CODEC.optionalFieldOf("drop_rate", (Object)DropRateProperty.NORMAL.get()).forGetter(SoldierHoldableEffect::dropRate), (App)Codec.intRange((int)1, (int)64).optionalFieldOf("max_stack_size", (Object)1).forGetter(s -> s.maxStackSize), (App)ClayPredicate.CODEC.optionalFieldOf("predicate", (Object)ClayPredicates.ConstantPredicate.getAlwaysTruePredicate()).forGetter(SoldierHoldableEffect::predicate), (App)ClayPoiFunction.CODEC.listOf().optionalFieldOf("on_pick", List.of()).forGetter(s -> s.onPickUpFunction), (App)RemovalConditionType.PAIR_CODEC.optionalFieldOf("removal_condition", Map.of()).forGetter(s -> s.removalConditionType)).apply((Applicative)in, SoldierHoldableEffect::new));
    public static final class_9139<class_9129, SoldierHoldableEffect> STREAM_CODEC = new class_9139<class_9129, SoldierHoldableEffect>(){

        public SoldierHoldableEffect decode(class_9129 registryFriendlyByteBuf) {
            return new SoldierHoldableEffect((SoldierPropertyMap)SoldierPropertyMap.STREAM_CODEC.decode((Object)registryFriendlyByteBuf), (List)SoldierEquipmentSlot.LIST_STREAM_CODEC.decode((Object)registryFriendlyByteBuf), (Integer)class_9135.field_48550.decode((Object)registryFriendlyByteBuf), ((Float)class_9135.field_48552.decode((Object)registryFriendlyByteBuf)).floatValue(), (Integer)class_9135.field_48550.decode((Object)registryFriendlyByteBuf), (ClayPredicate)ClayPredicate.STREAM_CODEC.decode((Object)registryFriendlyByteBuf), (List)ClayPoiFunction.LIST_STREAM_CODEC.decode((Object)registryFriendlyByteBuf), (Map)RemovalConditionType.PAIR_STREAM_CODEC.decode((Object)registryFriendlyByteBuf));
        }

        public void encode(class_9129 byteBuf, SoldierHoldableEffect soldierHoldableEffect) {
            SoldierPropertyMap.STREAM_CODEC.encode((Object)byteBuf, (Object)soldierHoldableEffect.properties);
            SoldierEquipmentSlot.LIST_STREAM_CODEC.encode((Object)byteBuf, soldierHoldableEffect.slots);
            class_9135.field_48550.encode((Object)byteBuf, (Object)soldierHoldableEffect.pickUpPriority);
            class_9135.field_48552.encode((Object)byteBuf, (Object)Float.valueOf(soldierHoldableEffect.dropRate));
            class_9135.field_48550.encode((Object)byteBuf, (Object)soldierHoldableEffect.maxStackSize);
            ClayPredicate.STREAM_CODEC.encode((Object)byteBuf, soldierHoldableEffect.predicate);
            ClayPoiFunction.LIST_STREAM_CODEC.encode((Object)byteBuf, soldierHoldableEffect.onPickUpFunction);
            RemovalConditionType.PAIR_STREAM_CODEC.encode((Object)byteBuf, soldierHoldableEffect.removalConditionType);
        }
    };
    private final SoldierPropertyMap properties;
    private final List<SoldierEquipmentSlot> slots;
    private final int pickUpPriority;
    private final float dropRate;
    private final int maxStackSize;
    private final ClayPredicate<?> predicate;
    private final List<ClayPoiFunction<?>> onPickUpFunction;
    private final Map<RemovalConditionType<?>, RemovalCondition> removalConditionType;

    private SoldierHoldableEffect(SoldierPropertyMap properties, List<SoldierEquipmentSlot> slots, int pickUpPriority, float dropRate, int maxStackSize, ClayPredicate<?> predicate, List<ClayPoiFunction<?>> onPickUpFunction, Map<RemovalConditionType<?>, RemovalCondition> removalConditionType) {
        this.properties = properties;
        this.slots = slots;
        this.pickUpPriority = pickUpPriority;
        this.dropRate = dropRate;
        this.predicate = predicate;
        this.onPickUpFunction = onPickUpFunction;
        this.removalConditionType = removalConditionType;
        this.maxStackSize = maxStackSize;
    }

    private SoldierHoldableEffect(SoldierPropertyMap.Builder properties, List<SoldierEquipmentSlot> slots, SoldierPickUpPriority pickUpPriority, DropRateProperty dropRate, ClayPredicate<?> predicate, List<ClayPoiFunction<?>> onPickUpFunction) {
        this(properties.build(), slots, pickUpPriority.get(), dropRate.get().floatValue(), 1, predicate, onPickUpFunction, Map.of());
    }

    public SoldierHoldableEffect(SoldierPropertyMap.Builder properties, SoldierEquipmentSlot slot) {
        this(properties, slot, SoldierPickUpPriority.NORMAL);
    }

    public SoldierHoldableEffect(SoldierPropertyMap.Builder properties, SoldierEquipmentSlot slot, SoldierPickUpPriority pickUpPriority) {
        this(properties, List.of(slot), pickUpPriority, DropRateProperty.NORMAL, ClayPredicates.ConstantPredicate.getAlwaysTruePredicate(), List.of());
    }

    public float damage() {
        return this.properties.damage();
    }

    public boolean throwable() {
        return this.properties.throwable().canPerformRangedAttack();
    }

    public boolean throwableType(RangedAttackType type) {
        return this.properties.throwable() == type;
    }

    public List<SpecialAttack<?>> getSpecialRangedAttacks() {
        return this.properties.specialAttacks(SpecialAttackType.RANGED, SpecialEffectCategory.BOTH);
    }

    public SoldierPropertyMap properties() {
        return this.properties;
    }

    public List<SoldierEquipmentSlot> slots() {
        return this.slots;
    }

    public int pickUpPriority() {
        return this.pickUpPriority;
    }

    public float dropRate() {
        return this.dropRate;
    }

    public int getMaxStackSize() {
        return this.maxStackSize;
    }

    public ClayPredicate<?> predicate() {
        return this.predicate;
    }

    public List<ClayPoiFunction<?>> getOnPickUpFunctions() {
        return this.onPickUpFunction;
    }

    public void executePickUpFunctions(ClaySoldierInventorySetter soldier, class_1799 source) {
        for (ClayPoiFunction<?> pickUpFunction : this.onPickUpFunction) {
            pickUpFunction.accept(soldier, ClayPoiSource.createSource(source));
        }
    }

    public Collection<RemovalCondition> getRemovalConditions() {
        return this.removalConditionType.values();
    }

    @Nullable
    public CustomEquipCapability getCustomEquipCapability(class_1799 stack) {
        BiFunction<class_1799, SoldierHoldableEffect, CustomEquipCapability> factory = ClaySoldiersCommon.CAPABILITY_MANGER.getCustomEquip(stack);
        if (factory != null) {
            return factory.apply(stack, this);
        }
        return null;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        SoldierHoldableEffect that = (SoldierHoldableEffect)obj;
        return Objects.equals(this.properties, that.properties) && Objects.equals(this.slots, that.slots) && this.pickUpPriority == that.pickUpPriority && Float.floatToIntBits(this.dropRate) == Float.floatToIntBits(that.dropRate) && Objects.equals(this.predicate, that.predicate);
    }

    public int hashCode() {
        return Objects.hash(this.properties, this.slots, this.pickUpPriority, Float.valueOf(this.dropRate), this.predicate);
    }

    public String toString() {
        return "SoldierHoldableEffect[properties=" + String.valueOf(this.properties) + ", slots=" + String.valueOf(this.slots) + ", pickUpPriority=" + this.pickUpPriority + ", dropRate=" + this.dropRate + ", predicate=" + String.valueOf(this.predicate) + "]";
    }

    public static Builder of(SoldierPropertyMap.Builder properties) {
        return new Builder(properties.build());
    }

    public static class Builder {
        private final SoldierPropertyMap properties;
        private final List<ClayPoiFunction<?>> onPickUpFunction;
        private List<SoldierEquipmentSlot> slots = List.of();
        private int pickUpPriority = SoldierPickUpPriority.NORMAL.get();
        private float dropRate = DropRateProperty.NORMAL.get().floatValue();
        private ClayPredicate<?> predicate = ClayPredicates.ConstantPredicate.getAlwaysTruePredicate();
        private final Map<RemovalConditionType<?>, RemovalCondition> removalConditionType = new HashMap();
        private int maxStackSize = 1;

        public Builder(SoldierPropertyMap properties) {
            this.properties = properties;
            this.onPickUpFunction = new ArrayList();
        }

        public Builder setSlots(List<SoldierEquipmentSlot> slots) {
            this.slots = slots;
            return this;
        }

        public Builder setSlot(SoldierEquipmentSlot slots) {
            this.slots = List.of(slots);
            return this;
        }

        public Builder setPickUpPriority(SoldierPickUpPriority pickUpPriority) {
            this.pickUpPriority = pickUpPriority.get();
            return this;
        }

        public Builder setPickUpPriority(int weight) {
            this.pickUpPriority = weight;
            return this;
        }

        public Builder setMaxStackSize(int size) {
            this.maxStackSize = size;
            return this;
        }

        public Builder setDropRate(float dropRate) {
            this.dropRate = dropRate;
            return this;
        }

        public Builder setDropRate(DropRateProperty dropRate) {
            this.dropRate = dropRate.get().floatValue();
            return this;
        }

        public Builder setPredicate(ClayPredicate<?> predicate) {
            this.predicate = predicate;
            return this;
        }

        public Builder addPickUpEffect(ClayPoiFunction<?> effect) {
            this.onPickUpFunction.add(effect);
            return this;
        }

        public <T extends RemovalCondition> Builder removalCondition(RemovalConditionType<T> type, T context) {
            this.removalConditionType.put(type, context);
            return this;
        }

        public SoldierHoldableEffect build() {
            return new SoldierHoldableEffect(this.properties, this.slots, this.pickUpPriority, this.dropRate, this.maxStackSize, this.predicate, this.onPickUpFunction, this.removalConditionType);
        }
    }
}

