/*
 * Decompiled with CFR 0.152.
 */
package net.bumblebee.claysoldiers.datamap.armor;

import java.util.ArrayList;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.bumblebee.claysoldiers.datamap.SoldierEquipmentSlot;
import net.bumblebee.claysoldiers.datamap.armor.ClientWearableRenderer;
import net.bumblebee.claysoldiers.datamap.armor.SoldierWearableEffect;
import net.bumblebee.claysoldiers.util.color.ColorHelper;
import net.minecraft.class_1738;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_3489;
import net.minecraft.class_5455;
import net.minecraft.class_8053;
import net.minecraft.class_9282;
import net.minecraft.class_9334;

public class ClientSoldierWearableEffect
extends SoldierWearableEffect
implements ClientWearableRenderer {
    private static final Map<SoldierEquipmentSlot, class_1738> DEFAULT_MAP = new EnumMap<SoldierEquipmentSlot, class_1738>(SoldierEquipmentSlot.class);
    private class_1799 armorStack;
    private List<SoldierWearableEffect.TrimHolder> finishedArmorTrims;

    public ClientSoldierWearableEffect(class_1738 item, ColorHelper color, Set<SoldierWearableEffect.SoldierArmorTrim> trims, boolean offsetColor) {
        super(item, color, trims, offsetColor);
    }

    public static SoldierWearableEffect create(class_1738 item, ColorHelper color, Set<SoldierWearableEffect.SoldierArmorTrim> trims, boolean offsetColor) {
        return new ClientSoldierWearableEffect(item, color, trims, offsetColor);
    }

    public class_1738 defaultModel(SoldierEquipmentSlot slot) {
        return DEFAULT_MAP.get(slot);
    }

    @Override
    public class_1799 getArmorCopyStack() {
        if (this.armorStack != null) {
            return this.armorStack;
        }
        class_1738 copyModel = this.copyModel();
        if (copyModel == null) {
            return class_1799.field_8037;
        }
        this.armorStack = copyModel.method_7854();
        if (this.armorStack.method_31573(class_3489.field_48803) && !this.getColorHelper().equals(ColorHelper.EMPTY)) {
            this.armorStack.method_57379(class_9334.field_49644, (Object)new class_9282(this.getColorHelper().getColorStatic(), false));
        }
        return this.armorStack;
    }

    @Override
    public Iterable<SoldierWearableEffect.TrimHolder> getArmorTrims(class_5455 access) {
        if (this.finishedArmorTrims != null) {
            return this.finishedArmorTrims;
        }
        this.finishedArmorTrims = new ArrayList<SoldierWearableEffect.TrimHolder>();
        for (SoldierWearableEffect.SoldierArmorTrim trim : this.trims) {
            class_8053 armorTrim = trim.createTrim(access);
            if (armorTrim == null) continue;
            this.finishedArmorTrims.add(new SoldierWearableEffect.TrimHolder(armorTrim, trim.getColor()));
        }
        return this.finishedArmorTrims;
    }

    static {
        DEFAULT_MAP.put(SoldierEquipmentSlot.HEAD, (class_1738)class_1802.field_8743);
        DEFAULT_MAP.put(SoldierEquipmentSlot.CHEST, (class_1738)class_1802.field_8523);
        DEFAULT_MAP.put(SoldierEquipmentSlot.LEGS, (class_1738)class_1802.field_8396);
        DEFAULT_MAP.put(SoldierEquipmentSlot.FEET, (class_1738)class_1802.field_8660);
    }
}

