/*
 * Decompiled with CFR 0.152.
 */
package net.bumblebee.claysoldiers.datamap.armor;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Map;
import net.bumblebee.claysoldiers.datamap.SoldierEquipmentSlot;
import net.bumblebee.claysoldiers.datamap.armor.SoldierWearableEffect;
import net.bumblebee.claysoldiers.datamap.armor.accessories.RenderableAccessory;
import net.bumblebee.claysoldiers.datamap.armor.accessories.SoldierAccessorySlot;
import net.minecraft.class_9129;
import net.minecraft.class_9135;
import net.minecraft.class_9139;
import org.jetbrains.annotations.Nullable;

public class SoldierMultiWearable {
    public static final Codec<SoldierMultiWearable> CODEC = RecordCodecBuilder.create(in -> in.group((App)Codec.unboundedMap(SoldierEquipmentSlot.CODEC, SoldierWearableEffect.CODEC).optionalFieldOf("armor", Map.of()).forGetter(m -> m.armorItemSlotMap), (App)SoldierAccessorySlot.MAP_CODEC.optionalFieldOf("accessories", Map.of()).forGetter(m -> m.accessories)).apply((Applicative)in, SoldierMultiWearable::new));
    public static final class_9139<class_9129, SoldierMultiWearable> STREAM_CODEC = class_9139.method_56435((class_9139)class_9135.method_57992(i -> new EnumMap(SoldierEquipmentSlot.class), SoldierEquipmentSlot.STREAM_CODEC, SoldierWearableEffect.STREAM_CODEC, (int)SoldierEquipmentSlot.values().length), m -> m.armorItemSlotMap, SoldierAccessorySlot.MAP_STREAM_CODEC, m -> m.accessories, SoldierMultiWearable::new);
    private final EnumMap<SoldierEquipmentSlot, SoldierWearableEffect> armorItemSlotMap;
    private final Map<SoldierAccessorySlot<?>, RenderableAccessory> accessories;

    private SoldierMultiWearable(Map<SoldierEquipmentSlot, SoldierWearableEffect> map, Map<SoldierAccessorySlot<?>, RenderableAccessory> accessories) {
        this.armorItemSlotMap = map.isEmpty() ? new EnumMap(SoldierEquipmentSlot.class) : new EnumMap<SoldierEquipmentSlot, SoldierWearableEffect>(map);
        this.accessories = accessories;
    }

    @Nullable
    public SoldierWearableEffect wearableEffect(SoldierEquipmentSlot slot) {
        return this.armorItemSlotMap.get(slot);
    }

    public Map<SoldierAccessorySlot<?>, RenderableAccessory> getAccessories() {
        return this.accessories;
    }

    public String toString() {
        if (this.armorItemSlotMap.isEmpty()) {
            if (this.accessories.isEmpty()) {
                return "SoldierMultiWearable{Empty}";
            }
            return "SoldierMultiWearable{Accessories: %s}".formatted(this.accessories.keySet());
        }
        if (this.accessories.isEmpty()) {
            return "SoldierMultiWearable{Armor: %s}".formatted(this.armorItemSlotMap);
        }
        return "SoldierMultiWearable{Armor: %s, Accessories: %s}".formatted(this.armorItemSlotMap, this.accessories.values());
    }

    public boolean isEmpty() {
        return this.accessories.isEmpty() && this.armorItemSlotMap.isEmpty();
    }

    public static SoldierMultiWearable empty() {
        return new SoldierMultiWearable(new EnumMap<SoldierEquipmentSlot, SoldierWearableEffect>(SoldierEquipmentSlot.class), Map.of());
    }

    public static Builder of() {
        return new Builder();
    }

    public static SoldierMultiWearable single(SoldierEquipmentSlot slot, SoldierWearableEffect effect) {
        return SoldierMultiWearable.of().put(slot, effect).build();
    }

    public static <T extends RenderableAccessory> SoldierMultiWearable accessory(SoldierAccessorySlot<T> key, T value) {
        return SoldierMultiWearable.of().put(key, value).build();
    }

    public static class Builder {
        private final Map<SoldierEquipmentSlot, SoldierWearableEffect> map = new EnumMap<SoldierEquipmentSlot, SoldierWearableEffect>(SoldierEquipmentSlot.class);
        private final Map<SoldierAccessorySlot<?>, RenderableAccessory> accessories = new HashMap();

        public Builder put(SoldierEquipmentSlot key, SoldierWearableEffect value) {
            this.map.put(key, value);
            return this;
        }

        public <T extends RenderableAccessory> Builder put(SoldierAccessorySlot<T> key, T value) {
            this.accessories.put(key, value);
            return this;
        }

        public SoldierMultiWearable build() {
            return new SoldierMultiWearable(this.map, this.accessories);
        }

        public int wearableSize() {
            return this.map.size();
        }
    }
}

