/*
 * Decompiled with CFR 0.152.
 */
package net.bumblebee.claysoldiers.datamap.armor;

import java.util.HashSet;
import java.util.Set;
import net.bumblebee.claysoldiers.datamap.armor.SoldierWearableEffect;
import net.bumblebee.claysoldiers.util.color.ColorHelper;
import net.minecraft.class_1738;
import net.minecraft.class_5321;
import net.minecraft.class_8054;
import net.minecraft.class_8056;
import org.jetbrains.annotations.Nullable;

public class SoldierWearableBuilder {
    private final Set<SoldierWearableEffect.SoldierArmorTrim> trims = new HashSet<SoldierWearableEffect.SoldierArmorTrim>();
    private ColorHelper color = ColorHelper.EMPTY;
    @Nullable
    private final class_1738 armorCopy;
    private boolean offsetColor = false;

    private SoldierWearableBuilder(@Nullable class_1738 armorCopy) {
        this.armorCopy = armorCopy;
    }

    public static SoldierWearableBuilder armor(class_1738 armorCopy) {
        return new SoldierWearableBuilder(armorCopy);
    }

    public static SoldierWearableBuilder empty() {
        return new SoldierWearableBuilder(null);
    }

    public SoldierWearableBuilder color(ColorHelper color) {
        this.color = color;
        return this;
    }

    public SoldierWearableBuilder color(int color) {
        this.color = ColorHelper.color(color);
        return this;
    }

    public SoldierWearableBuilder affectedOffsetColor() {
        this.offsetColor = true;
        return this;
    }

    public SoldierWearableBuilder addTrim(class_5321<class_8056> pattern, class_5321<class_8054> material) {
        return this.addTrim(pattern, material, ColorHelper.EMPTY);
    }

    public SoldierWearableBuilder addTrim(class_5321<class_8056> pattern, class_5321<class_8054> material, ColorHelper color) {
        this.trims.add(new SoldierWearableEffect.SoldierArmorTrim(pattern, material, color));
        return this;
    }

    public SoldierWearableEffect build() {
        return new SoldierWearableEffect(this.armorCopy, this.color, this.trims, this.offsetColor);
    }
}

