/*
 * Decompiled with CFR 0.152.
 */
package net.bumblebee.claysoldiers.datamap.armor;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.HashSet;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import net.bumblebee.claysoldiers.ClaySoldiersCommon;
import net.bumblebee.claysoldiers.datamap.armor.ClientSoldierWearableEffect;
import net.bumblebee.claysoldiers.util.codec.CodecUtils;
import net.bumblebee.claysoldiers.util.color.ColorHelper;
import net.minecraft.class_1738;
import net.minecraft.class_1792;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_5455;
import net.minecraft.class_6880;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import net.minecraft.class_8053;
import net.minecraft.class_8054;
import net.minecraft.class_8056;
import net.minecraft.class_9129;
import net.minecraft.class_9135;
import net.minecraft.class_9139;
import org.jetbrains.annotations.Nullable;

public class SoldierWearableEffect {
    public static final Codec<SoldierWearableEffect> CODEC = RecordCodecBuilder.create(in -> in.group((App)ArmorModel.CODEC.optionalFieldOf("model", (Object)ArmorModel.EMPTY).forGetter(s -> s.armorModel), (App)CodecUtils.singularOrPluralCodecOptional(SoldierArmorTrim.CODEC, "trim").forGetter(SoldierWearableEffect::trims), (App)ColorHelper.CODEC.optionalFieldOf("color", (Object)ColorHelper.EMPTY).forGetter(SoldierWearableEffect::getColorHelper), (App)Codec.BOOL.optionalFieldOf("offset_color", (Object)false).forGetter(s -> s.offsetColor)).apply((Applicative)in, SoldierWearableEffect::createSided));
    public static final class_9139<class_9129, SoldierWearableEffect> STREAM_CODEC = class_9139.method_56905(ArmorModel.STREAM_CODEC, s -> s.armorModel, (class_9139)SoldierArmorTrim.STREAM_CODEC.method_56433(class_9135.method_56374(HashSet::new)), SoldierWearableEffect::trims, ColorHelper.STREAM_CODEC, SoldierWearableEffect::getColorHelper, (class_9139)class_9135.field_48547, SoldierWearableEffect::isAffectedByOffsetColor, SoldierWearableEffect::createSided);
    private final ColorHelper color;
    private final ArmorModel armorModel;
    protected final Set<SoldierArmorTrim> trims;
    private final boolean offsetColor;

    private SoldierWearableEffect(ArmorModel model, ColorHelper color, Set<SoldierArmorTrim> trims, boolean offsetColor) {
        this.color = color;
        this.armorModel = model;
        this.trims = trims;
        this.offsetColor = offsetColor;
    }

    public SoldierWearableEffect(@Nullable class_1738 item, ColorHelper color, Set<SoldierArmorTrim> trims, boolean offsetColor) {
        this(item == null ? ArmorModel.EMPTY : new ArmorModel(item), color, trims, offsetColor);
    }

    public ColorHelper getColorHelper() {
        return this.color;
    }

    @Nullable
    public class_1738 copyModel() {
        return this.armorModel.item;
    }

    private Set<SoldierArmorTrim> trims() {
        return this.trims;
    }

    public boolean isNoArmorRender() {
        return this.armorModel.empty();
    }

    public boolean isAffectedByOffsetColor() {
        return this.offsetColor;
    }

    private static SoldierWearableEffect createSided(ArmorModel model, Set<SoldierArmorTrim> trims, ColorHelper color, boolean colorOffset) {
        if (ClaySoldiersCommon.PLATFORM.isClient()) {
            return ClientSoldierWearableEffect.create(model.item, color, trims, colorOffset);
        }
        return new SoldierWearableEffect(model, color, trims, colorOffset);
    }

    public String toString() {
        return "%s{%s, %s}".formatted(this.getClass().getSimpleName(), this.armorModel, !this.trims.isEmpty() ? "Trims(" + this.trims.size() + ")" : "No Trims");
    }

    private record ArmorModel(class_1738 item, boolean empty) {
        private static final ArmorModel EMPTY = new ArmorModel(null, true);
        private static final Codec<ArmorModel> CODEC = Codec.either((Codec)class_7923.field_41178.method_39673(), (Codec)Codec.BOOL).xmap(ArmorModel::fromEither, a -> a.empty ? Either.right((Object)true) : Either.left((Object)a.item));
        private static final class_9139<class_9129, ArmorModel> STREAM_CODEC = class_9135.method_56382((class_9139)class_9135.method_56365((class_5321)class_7924.field_41197)).method_56432(s -> s.map(i -> {
            ArmorModel armorModel;
            if (i instanceof class_1738) {
                class_1738 armorItem = (class_1738)i;
                armorModel = new ArmorModel(armorItem);
            } else {
                armorModel = EMPTY;
            }
            return armorModel;
        }).orElse(EMPTY), a -> a.empty ? Optional.empty() : Optional.of(a.item));

        private ArmorModel(class_1738 item) {
            this(Objects.requireNonNull(item), false);
        }

        @Override
        public String toString() {
            return "ArmorModel[%s]".formatted(this.empty ? "Empty" : this.item);
        }

        private static ArmorModel fromEither(Either<class_1792, Boolean> either) {
            ArmorModel armorModel;
            if (either.right().isPresent()) {
                return EMPTY;
            }
            Object t = either.left().orElseThrow();
            if (t instanceof class_1738) {
                class_1738 armorItem = (class_1738)t;
                armorModel = new ArmorModel(armorItem);
            } else {
                armorModel = EMPTY;
            }
            return armorModel;
        }
    }

    public static class SoldierArmorTrim {
        private static final Codec<SoldierArmorTrim> CODEC = RecordCodecBuilder.create(in -> in.group((App)class_2960.field_25139.fieldOf("pattern").forGetter(t -> t.pattern), (App)class_2960.field_25139.fieldOf("material").forGetter(t -> t.material), (App)ColorHelper.CODEC.optionalFieldOf("color", (Object)ColorHelper.EMPTY).forGetter(t -> t.color)).apply((Applicative)in, SoldierArmorTrim::new));
        private static final class_9139<class_9129, SoldierArmorTrim> STREAM_CODEC = class_9139.method_56436((class_9139)class_2960.field_48267, s -> s.pattern, (class_9139)class_2960.field_48267, s -> s.material, ColorHelper.STREAM_CODEC, s -> s.color, SoldierArmorTrim::new);
        private final class_2960 pattern;
        private final class_2960 material;
        private final ColorHelper color;

        private SoldierArmorTrim(class_2960 pattern, class_2960 material, ColorHelper color) {
            this.pattern = pattern;
            this.material = material;
            this.color = color;
        }

        public SoldierArmorTrim(class_5321<class_8056> pattern, class_5321<class_8054> material, ColorHelper color) {
            this(pattern.method_29177(), material.method_29177(), color);
        }

        @Nullable
        public class_8053 createTrim(class_5455 access) {
            Optional trimPattern = access.method_30530(class_7924.field_42082).method_55841(this.pattern);
            Optional trimMaterial = access.method_30530(class_7924.field_42083).method_55841(this.material);
            if (trimPattern.isPresent() && trimMaterial.isPresent()) {
                return new class_8053((class_6880)trimMaterial.orElseThrow(), (class_6880)trimPattern.orElseThrow());
            }
            return null;
        }

        public ColorHelper getColor() {
            return this.color;
        }
    }

    public record TrimHolder(class_8053 trim, ColorHelper color) {
    }
}

