/*
 * Decompiled with CFR 0.152.
 */
package net.bumblebee.claysoldiers.datamap.armor.accessories;

import com.mojang.serialization.Codec;
import io.netty.buffer.ByteBuf;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import net.bumblebee.claysoldiers.datamap.armor.accessories.RenderableAccessory;
import net.bumblebee.claysoldiers.datamap.armor.accessories.custom.CapeRenderable;
import net.bumblebee.claysoldiers.datamap.armor.accessories.custom.GliderRenderable;
import net.bumblebee.claysoldiers.datamap.armor.accessories.custom.ShieldRenderable;
import net.bumblebee.claysoldiers.datamap.armor.accessories.custom.SkullRenderable;
import net.bumblebee.claysoldiers.datamap.armor.accessories.custom.SnorkelRenderable;
import net.bumblebee.claysoldiers.datamap.armor.accessories.custom.StringRenderLayer;
import net.minecraft.class_3542;
import net.minecraft.class_9129;
import net.minecraft.class_9135;
import net.minecraft.class_9139;

public class SoldierAccessorySlot<T extends RenderableAccessory>
implements class_3542 {
    public static final SoldierAccessorySlot<CapeRenderable> CAPE = new SoldierAccessorySlot<CapeRenderable>("cape", CapeRenderable.CODEC, CapeRenderable.STREAM_CODEC.method_56430());
    public static final SoldierAccessorySlot<SnorkelRenderable> SNORKEL = new SoldierAccessorySlot<SnorkelRenderable>("snorkel", SnorkelRenderable.CODEC, SnorkelRenderable.STREAM_CODEC.method_56430());
    public static final SoldierAccessorySlot<GliderRenderable> GLIDER = new SoldierAccessorySlot<GliderRenderable>("glider", GliderRenderable.CODEC, GliderRenderable.STREAM_CODEC);
    public static final SoldierAccessorySlot<SkullRenderable> HEAD_ITEM = new SoldierAccessorySlot<SkullRenderable>("skull", SkullRenderable.CODEC, SkullRenderable.STREAM_CODEC);
    public static final SoldierAccessorySlot<ShieldRenderable> SHIELD = new SoldierAccessorySlot<ShieldRenderable>("shield", ShieldRenderable.CODEC, ShieldRenderable.STREAM_CODEC.method_56430());
    public static final SoldierAccessorySlot<StringRenderLayer> STRING = new SoldierAccessorySlot<StringRenderLayer>("wrapped", StringRenderLayer.CODEC, StringRenderLayer.STREAM_CODEC.method_56430());
    private static final SoldierAccessorySlot<?>[] SLOTS = new SoldierAccessorySlot[]{CAPE, SNORKEL, GLIDER, HEAD_ITEM, SHIELD, STRING};
    private static final Codec<SoldierAccessorySlot<?>> CODEC = class_3542.method_53955(SoldierAccessorySlot::values);
    public static final Codec<Map<SoldierAccessorySlot<?>, RenderableAccessory>> MAP_CODEC = Codec.dispatchedMap(CODEC, SoldierAccessorySlot::getCodecForAccessory);
    private static final class_9139<ByteBuf, SoldierAccessorySlot<?>> STREAM_CODEC = new class_9139<ByteBuf, SoldierAccessorySlot<?>>(){

        public void encode(ByteBuf byteBuf, SoldierAccessorySlot<?> soldierAccessorySlot) {
            byteBuf.writeByte((int)SoldierAccessorySlot.getSlotIndex(soldierAccessorySlot));
        }

        public SoldierAccessorySlot<?> decode(ByteBuf byteBuf) {
            return SLOTS[byteBuf.readByte()];
        }
    };
    public static final class_9139<class_9129, Map<SoldierAccessorySlot<?>, RenderableAccessory>> MAP_STREAM_CODEC = new class_9139<class_9129, Map<SoldierAccessorySlot<?>, RenderableAccessory>>(){

        public Map<SoldierAccessorySlot<?>, RenderableAccessory> decode(class_9129 byteBuf) {
            int i = class_9135.method_57989((ByteBuf)byteBuf, (int)Integer.MAX_VALUE);
            HashMap m = new HashMap(Math.min(i, 65536));
            for (int j = 0; j < i; ++j) {
                SoldierAccessorySlot key = (SoldierAccessorySlot)STREAM_CODEC.decode((Object)byteBuf);
                RenderableAccessory value = (RenderableAccessory)key.streamCodec.decode((Object)byteBuf);
                m.put(key, value);
            }
            return m;
        }

        public void encode(class_9129 byteBuf, Map<SoldierAccessorySlot<?>, RenderableAccessory> map) {
            class_9135.method_57990((ByteBuf)byteBuf, (int)map.size(), (int)Integer.MAX_VALUE);
            map.forEach((key, value) -> {
                STREAM_CODEC.encode((Object)byteBuf, key);
                key.encode(byteBuf, (RenderableAccessory)value);
            });
        }
    };
    private final String serializedName;
    private final Codec<T> accesoryCodec;
    private final class_9139<class_9129, T> streamCodec;

    private SoldierAccessorySlot(String serializedName, Codec<T> accesoryCodec, class_9139<class_9129, T> streamCodec) {
        this.serializedName = serializedName;
        this.accesoryCodec = accesoryCodec;
        this.streamCodec = streamCodec;
    }

    public static SoldierAccessorySlot<?>[] values() {
        return SLOTS;
    }

    private static byte getSlotIndex(SoldierAccessorySlot<?> slot) {
        for (byte i = 0; i < SLOTS.length; i = (byte)(i + 1)) {
            if (SLOTS[i] != slot) continue;
            return i;
        }
        throw new IllegalArgumentException("No slot found for " + String.valueOf(slot));
    }

    public String method_15434() {
        return this.serializedName;
    }

    private Codec<T> getCodecForAccessory() {
        return this.accesoryCodec;
    }

    private void encode(class_9129 byteBuf, RenderableAccessory accessory) {
        try {
            this.streamCodec.encode((Object)byteBuf, (Object)accessory);
        }
        catch (ClassCastException e) {
            throw new IllegalArgumentException("%s cannot be encoded for %s".formatted(accessory, this.serializedName), e);
        }
    }

    public String toString() {
        return "AccessorySlot[%s]".formatted(this.serializedName);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SoldierAccessorySlot that = (SoldierAccessorySlot)o;
        return Objects.equals(this.serializedName, that.serializedName);
    }

    public int hashCode() {
        return Objects.hashCode(this.serializedName);
    }
}

