/*
 * Decompiled with CFR 0.152.
 */
package net.bumblebee.claysoldiers.datamap.armor.accessories.custom;

import com.mojang.authlib.properties.PropertyMap;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import net.bumblebee.claysoldiers.ClaySoldiersCommon;
import net.bumblebee.claysoldiers.datamap.armor.accessories.IAccessoryRenderLayer;
import net.bumblebee.claysoldiers.datamap.armor.accessories.RenderableAccessory;
import net.bumblebee.claysoldiers.entity.soldier.AbstractClaySoldierEntity;
import net.bumblebee.claysoldiers.util.color.ColorHelper;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1747;
import net.minecraft.class_1792;
import net.minecraft.class_1921;
import net.minecraft.class_2190;
import net.minecraft.class_2248;
import net.minecraft.class_2484;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_5321;
import net.minecraft.class_5598;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import net.minecraft.class_8080;
import net.minecraft.class_811;
import net.minecraft.class_836;
import net.minecraft.class_9129;
import net.minecraft.class_9135;
import net.minecraft.class_9139;
import net.minecraft.class_9296;
import net.minecraft.class_976;
import org.jetbrains.annotations.Nullable;

public class SkullRenderable
implements RenderableAccessory {
    public static final Codec<SkullRenderable> CODEC = RecordCodecBuilder.create(in -> in.group((App)class_7923.field_41178.method_39673().fieldOf("item").forGetter(s -> s.headStack), (App)ColorHelper.CODEC.optionalFieldOf("color", (Object)ColorHelper.EMPTY).forGetter(s -> s.colorHelper), (App)class_9296.field_49359.optionalFieldOf("profile").forGetter(s -> Optional.ofNullable(s.profile))).apply((Applicative)in, (head, color, profile) -> new SkullRenderable((class_1792)head, (ColorHelper)color, profile.orElse(null))));
    public static final class_9139<class_9129, SkullRenderable> STREAM_CODEC = class_9139.method_56436((class_9139)class_9135.method_56365((class_5321)class_7924.field_41197), s -> s.headStack, ColorHelper.STREAM_CODEC, s -> s.colorHelper, (class_9139)class_9135.method_56382((class_9139)class_9296.field_49360), s -> Optional.ofNullable(s.profile), (head, color, profile) -> new SkullRenderable((class_1792)head, (ColorHelper)color, profile.orElse(null)));
    private static final float RANDOM_SCALE_FACTOR = 1.1875f;
    private final class_1792 headStack;
    private final ColorHelper colorHelper;
    @Nullable
    private final class_9296 profile;

    public SkullRenderable(class_1792 headStack) {
        this(headStack, ColorHelper.EMPTY, null);
    }

    public SkullRenderable(class_1792 headStack, String playerName) {
        this(headStack, ColorHelper.EMPTY, new class_9296(Optional.of(playerName), Optional.empty(), new PropertyMap()));
    }

    public SkullRenderable(class_1792 headStack, ColorHelper colorHelper, class_9296 profile) {
        class_1747 blockItem;
        this.headStack = headStack;
        this.colorHelper = colorHelper;
        this.profile = profile;
        if (!colorHelper.isEmpty() && headStack instanceof class_1747 && !((blockItem = (class_1747)headStack).method_7711() instanceof class_2190)) {
            ClaySoldiersCommon.LOGGER.error("SkullRenderer Color only supported for Skulls not blocks");
        }
    }

    @Override
    public void render(IAccessoryRenderLayer renderedFrom, class_4587 pPoseStack, class_4597 pBuffer, int pPackedLight, AbstractClaySoldierEntity claySoldier, float pPartialTick, boolean isFalling) {
        class_2248 class_22482;
        class_1792 item = this.headStack;
        pPoseStack.method_22903();
        if (claySoldier.method_6109()) {
            pPoseStack.method_46416(0.0f, 0.03125f, 0.0f);
            pPoseStack.method_22905(0.7f, 0.7f, 0.7f);
            pPoseStack.method_46416(0.0f, 1.0f, 0.0f);
        }
        renderedFrom.getSoldierModel().method_2838().method_22703(pPoseStack);
        if (item instanceof class_1747 && (class_22482 = ((class_1747)item).method_7711()) instanceof class_2190) {
            class_8080 walkanimationstate;
            class_2190 abstractSkullBlock = (class_2190)class_22482;
            pPoseStack.method_22905(1.1875f, -1.1875f, -1.1875f);
            pPoseStack.method_22904(-0.5, 0.0, -0.5);
            class_2484.class_2485 skyllType = abstractSkullBlock.method_9327();
            class_5598 skullmodelbase = renderedFrom.getSkullBase(skyllType);
            if (skullmodelbase == null) {
                return;
            }
            class_1921 rendertype = class_836.method_3578((class_2484.class_2485)skyllType, (class_9296)this.profile);
            class_1297 entity = claySoldier.method_5854();
            if (entity instanceof class_1309) {
                class_1309 livingentity = (class_1309)entity;
                walkanimationstate = livingentity.field_42108;
            } else {
                walkanimationstate = claySoldier.field_42108;
            }
            float f3 = walkanimationstate.method_48572(pPartialTick);
            SkullRenderable.renderSkull(f3, pPoseStack, pBuffer, pPackedLight, skullmodelbase, rendertype, this.colorHelper, (class_1309)claySoldier, pPartialTick);
        } else {
            class_976.method_32798((class_4587)pPoseStack, (boolean)false);
            renderedFrom.getItemInHandRenderer().method_3233((class_1309)claySoldier, this.headStack.method_7854(), class_811.field_4316, false, pPoseStack, pBuffer, pPackedLight);
        }
        pPoseStack.method_22909();
    }

    private static void renderSkull(float pMouthAnimation, class_4587 pPoseStack, class_4597 pBufferSource, int pPackedLight, class_5598 pModel, class_1921 pRenderType, ColorHelper colorHelper, class_1309 soldier, float partialTick) {
        pPoseStack.method_22903();
        pPoseStack.method_46416(0.5f, 0.0f, 0.5f);
        pPoseStack.method_22905(-1.0f, -1.0f, 1.0f);
        class_4588 vertexconsumer = pBufferSource.getBuffer(pRenderType);
        pModel.method_2821(pMouthAnimation, 180.0f, 0.0f);
        pModel.method_2828(pPoseStack, vertexconsumer, pPackedLight, class_4608.field_21444, colorHelper.getColor(soldier, partialTick));
        pPoseStack.method_22909();
    }
}

