/*
 * Decompiled with CFR 0.152.
 */
package net.bumblebee.claysoldiers.entity;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.UUID;
import java.util.function.Consumer;
import net.bumblebee.claysoldiers.ClaySoldiersCommon;
import net.bumblebee.claysoldiers.capability.AssignablePoiCapability;
import net.bumblebee.claysoldiers.capability.IBlockCache;
import net.bumblebee.claysoldiers.entity.ClayMobRideableEntity;
import net.bumblebee.claysoldiers.entity.goal.UseAssignedPoiGoal;
import net.bumblebee.claysoldiers.init.ModEffects;
import net.bumblebee.claysoldiers.init.ModItems;
import net.bumblebee.claysoldiers.init.ModParticles;
import net.bumblebee.claysoldiers.init.ModTags;
import net.bumblebee.claysoldiers.item.BrickedItemHolder;
import net.bumblebee.claysoldiers.item.ClayBrushItem;
import net.bumblebee.claysoldiers.item.TestItem;
import net.bumblebee.claysoldiers.team.ClayMobTeam;
import net.bumblebee.claysoldiers.team.ClayMobTeamManger;
import net.bumblebee.claysoldiers.team.IClayMobTeamReference;
import net.bumblebee.claysoldiers.team.TeamHolder;
import net.bumblebee.claysoldiers.team.TeamLoyaltyManger;
import net.bumblebee.claysoldiers.team.TeamPlayerData;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1282;
import net.minecraft.class_1293;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1314;
import net.minecraft.class_14;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_2392;
import net.minecraft.class_2394;
import net.minecraft.class_2397;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2512;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3417;
import net.minecraft.class_4050;
import net.minecraft.class_4135;
import net.minecraft.class_5455;
import net.minecraft.class_7;
import net.minecraft.class_7225;
import net.minecraft.class_8103;
import net.minecraft.class_8109;
import net.minecraft.class_8111;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ClayMobEntity
extends class_1314
implements TeamHolder {
    public static final float DEFAULT_SCALE = 0.25f;
    protected static final double DEFAULT_ATTACK_REACH = (double)0.7f;
    private static final class_2940<Boolean> SLIME_ROOT_SYNC = class_2945.method_12791(ClayMobEntity.class, (class_2941)class_2943.field_13323);
    private static final class_2940<Byte> DATA_FLAGS_ID = class_2945.method_12791(ClayMobEntity.class, (class_2941)class_2943.field_13319);
    private static final class_2940<Boolean> HAS_POI_POS = class_2945.method_12791(ClayMobEntity.class, (class_2941)class_2943.field_13323);
    private static final class_2940<Boolean> USING_POI = class_2945.method_12791(ClayMobEntity.class, (class_2941)class_2943.field_13323);
    public static final String WORK_POI_LANG_KEY = "clay_mob_work.%s.poi.%s";
    public static final String WORK_POI_CLEARED_LANG = "clay_mob_work.%s.poi.%s".formatted("csr", "cleared");
    public static final String WORK_POI_INVALID_LANG = "clay_mob_work.%s.poi.%s".formatted("csr", "invalid");
    protected static final byte SITTING_FLAG = 1;
    private static final byte WAXED_FLAG = 2;
    public static final String SITTING_TAG = "Sitting";
    public static final String WAXED_TAG = "Waxed";
    public static final String POI_POS_TAG = "PoiPos";
    public static final String SPAWNED_FROM_TAG = "SpawnedFrom";
    public static final String DROP_SPAWNED_FROM_TAG = "DropSpawnedFrom";
    protected static final byte TEAM_CHANGE_EVENT = 77;
    protected static final byte SPAWN_HEARTS_EVENT = 78;
    protected static final byte SPAWN_ANGRY_EVENT = 79;
    protected static final byte SPAWN_HAPPY_EVENT = 80;
    protected DamageCalculator inWallDamage = (w, e) -> w ? 0.5f : 1.0f;
    protected DamageCalculator ownerDamage = (w, e) -> 100.0f;
    protected DamageCalculator otherPlayerDamage = (w, e) -> w ? 8.0f : 100.0f;
    protected DamageCalculator explosionDamage = (w, e) -> w ? 0.4f : 0.5f;
    protected DamageCalculator clayDamage = (w, e) -> (float)this.method_18390(e);
    protected DamageCalculator defaultDamage = (w, e) -> w ? 75.0f : 100.0f;
    private final class_8109 clayDamageSources;
    private class_1799 spawnedFrom = class_1799.field_8037;
    private boolean dropSpawnedFrom = false;
    @Nullable
    private class_2338 poiPos = null;
    @Nullable
    private IBlockCache<AssignablePoiCapability> poiPosCapability;
    private boolean orderedToSit = false;
    @Nullable
    private IClayMobTeamReference cachedTeam = null;
    @Nullable
    public TeamPlayerData teamPlayerData = null;
    @Nullable
    private TeamPlayerData.PlayerData cachedTeamOwner = null;
    private long lastOwnerChange = -1L;

    protected ClayMobEntity(class_1299<? extends ClayMobEntity> pEntityType, class_1937 pLevel) {
        super(pEntityType, pLevel);
        this.clayDamageSources = ClaySoldiersCommon.PLATFORM.createClayDamageSources(pLevel.method_30349());
        this.getPlayerTeamData(pLevel);
        this.method_5971();
    }

    private void getPlayerTeamData(class_1937 level) {
        if (this.teamPlayerData != null) {
            return;
        }
        if (level instanceof class_3218) {
            class_3218 serverLevel = (class_3218)level;
            this.teamPlayerData = TeamLoyaltyManger.getTeamPlayerData(serverLevel);
        } else {
            this.teamPlayerData = TeamLoyaltyManger.getClientTeamPlayerData();
        }
    }

    protected void method_5693(class_2945.class_9222 builder) {
        super.method_5693(builder);
        builder.method_56912(SLIME_ROOT_SYNC, (Object)false);
        builder.method_56912(DATA_FLAGS_ID, (Object)0);
        builder.method_56912(HAS_POI_POS, (Object)false);
        builder.method_56912(USING_POI, (Object)false);
    }

    public boolean isSlimeRooted() {
        return (Boolean)this.field_6011.method_12789(SLIME_ROOT_SYNC);
    }

    public void setSlimeRooted(boolean slimeRooted) {
        this.field_6011.method_12778(SLIME_ROOT_SYNC, (Object)slimeRooted);
    }

    protected void method_6020(class_1293 pEffectInstance, @Nullable class_1297 pEntity) {
        super.method_6020(pEffectInstance, pEntity);
        if (pEffectInstance.method_5579().method_55838(ModEffects.SLIME_ROOT)) {
            class_1297 class_12972 = this.method_5854();
            if (class_12972 instanceof class_1309) {
                class_1309 livingVehicle = (class_1309)class_12972;
                livingVehicle.method_6092(pEffectInstance);
            }
            this.setSlimeRooted(true);
        }
    }

    protected void method_6129(class_1293 pEffectInstance) {
        super.method_6129(pEffectInstance);
        if (pEffectInstance.method_5579().method_55838(ModEffects.SLIME_ROOT)) {
            this.setSlimeRooted(false);
        }
    }

    public void method_5652(class_2487 pCompound) {
        super.method_5652(pCompound);
        if (!this.spawnedFrom.method_7960()) {
            pCompound.method_10566(SPAWNED_FROM_TAG, this.spawnedFrom.method_57358((class_7225.class_7874)this.method_56673()));
            pCompound.method_10556(DROP_SPAWNED_FROM_TAG, this.dropSpawnedFrom);
        }
        pCompound.method_10556(SITTING_TAG, this.orderedToSit);
        pCompound.method_10556(WAXED_TAG, this.isWaxed());
        if (this.getPoiPos() != null) {
            pCompound.method_10566(POI_POS_TAG, class_2512.method_10692((class_2338)this.getPoiPos()));
        }
    }

    public void method_5749(class_2487 pCompound) {
        super.method_5749(pCompound);
        if (pCompound.method_10573(SPAWNED_FROM_TAG, 10)) {
            this.spawnedFrom = ClayMobEntity.getSpawnedFromFromTag(pCompound, this.method_56673());
            if (pCompound.method_10545(DROP_SPAWNED_FROM_TAG)) {
                this.dropSpawnedFrom = pCompound.method_10577(DROP_SPAWNED_FROM_TAG);
            }
        }
        if (this.method_6059(ModEffects.SLIME_ROOT)) {
            this.setSlimeRooted(true);
        }
        this.orderedToSit = pCompound.method_10577(SITTING_TAG);
        this.setInSittingPose(this.orderedToSit);
        if (this.orderedToSit) {
            this.method_18380(class_4050.field_40118);
        }
        this.setWaxed(pCompound.method_10577(WAXED_TAG));
        this.setPoiPos(class_2512.method_10691((class_2487)pCompound, (String)POI_POS_TAG).orElse(null));
    }

    public static class_1799 getSpawnedFromFromTag(class_2487 tag, class_5455 registries) {
        return class_1799.method_57359((class_7225.class_7874)registries, (class_2487)tag.method_10562(SPAWNED_FROM_TAG));
    }

    public class_8109 method_48923() {
        return this.clayDamageSources;
    }

    public boolean method_5643(class_1282 source, float amount) {
        if (amount == Float.MAX_VALUE || source.method_49708(class_8111.field_44869)) {
            return super.method_5643(source, amount);
        }
        if (source.method_49708(class_8111.field_42341)) {
            return false;
        }
        if (this.sameTeamAs(source.method_5529()) && !this.getClayTeam().isFriendlyFireAllowed()) {
            return false;
        }
        float newDamage = amount;
        boolean waxed = this.isWaxed();
        if (source.method_48789(class_8103.field_42249)) {
            newDamage *= this.explosionDamage.calculate(waxed, source.method_5529());
        }
        if (source.method_48789(ModTags.DamageTypes.CLAY_SOLDIER_DAMAGE) || source.method_5529() instanceof ClayMobEntity) {
            class_1297 class_12972 = this.method_5854();
            if (class_12972 instanceof ClayMobRideableEntity) {
                ClayMobRideableEntity rideableEntity = (ClayMobRideableEntity)class_12972;
                rideableEntity.method_5643(source, newDamage * rideableEntity.shareDamagePercent());
                newDamage *= 1.0f - rideableEntity.shareDamagePercent();
            }
            newDamage *= this.clayDamage.calculate(waxed, source.method_5529());
        } else {
            class_1657 player;
            class_1297 class_12973 = source.method_5529();
            newDamage = class_12973 instanceof class_1657 ? (newDamage *= this.isOwnedBy(player = (class_1657)class_12973) ? this.ownerDamage.calculate(waxed, (class_1297)player) : this.otherPlayerDamage.calculate(waxed, (class_1297)player)) : (source.method_49708(class_8111.field_42340) ? (newDamage *= this.inWallDamage.calculate(waxed, source.method_5529())) : (newDamage *= this.defaultDamage.calculate(waxed, source.method_5529())));
        }
        return super.method_5643(source, newDamage);
    }

    public float getCustomArmorValue() {
        return 0.0f;
    }

    public void setSpawnedFrom(class_1799 spawnedFrom, boolean allowDropping) {
        this.spawnedFrom = spawnedFrom;
        this.dropSpawnedFrom = allowDropping;
    }

    public boolean dropSpawnedFrom() {
        return this.dropSpawnedFrom;
    }

    public class_1799 getSpawnedFrom() {
        return this.spawnedFrom;
    }

    protected class_238 method_53511() {
        class_238 aabb;
        double attackReach;
        class_1297 vehicle = this.method_5854();
        double d = attackReach = this.isSlimeRooted() ? this.getDefaultAttackReach() * 0.7 : this.getDefaultAttackReach();
        if (vehicle != null) {
            class_238 aabb1 = vehicle.method_5829();
            class_238 aabb2 = this.method_5829();
            aabb = new class_238(Math.min(aabb2.field_1323, aabb1.field_1323), aabb2.field_1322, Math.min(aabb2.field_1321, aabb1.field_1321), Math.max(aabb2.field_1320, aabb1.field_1320), aabb2.field_1325, Math.max(aabb2.field_1324, aabb1.field_1324));
        } else {
            aabb = this.method_5829();
        }
        return aabb.method_1009(attackReach, 0.0, attackReach);
    }

    protected abstract double getDefaultAttackReach();

    protected void method_6099(class_3218 serverLevel, class_1282 pSource, boolean pRecentlyHit) {
        super.method_6099(serverLevel, pSource, pRecentlyHit);
        if (!this.dropSpawnedFrom) {
            return;
        }
        ClayMobEntity.dropSpawnedFrom(serverLevel, this.spawnedFrom, arg_0 -> ((ClayMobEntity)this).method_5775(arg_0), pSource.method_5529() instanceof class_1657, this.method_5809());
    }

    public static void dropSpawnedFrom(class_3218 level, class_1799 spawnedFrom, Consumer<class_1799> spawnInWorld, boolean alwaysDrop, boolean onFire) {
        float chance;
        float f = chance = alwaysDrop ? 1.0f : (float)level.method_8401().method_146().method_8356(ClaySoldiersCommon.CLAY_SOLDIER_DROP_RULE) / 100.0f;
        if (chance >= level.field_9229.method_43057()) {
            class_1792 class_17922;
            if (onFire && (class_17922 = spawnedFrom.method_7909()) instanceof BrickedItemHolder) {
                BrickedItemHolder brickedItemHolder = (BrickedItemHolder)class_17922;
                spawnInWorld.accept(brickedItemHolder.getBrickedItem(spawnedFrom));
            } else {
                spawnInWorld.accept(spawnedFrom);
            }
        }
    }

    public boolean isAbleToRide() {
        return false;
    }

    public boolean canMountEntity(class_1309 livingEntity) {
        return false;
    }

    public boolean canBeKilledByItem() {
        return true;
    }

    public void spawnItemBreakParticles(class_1799 pStack, int pAmount) {
        if (pStack.method_7960()) {
            return;
        }
        for (int i = 0; i < pAmount; ++i) {
            class_243 vec3 = new class_243(((double)this.field_5974.method_43057() - 0.5) * 0.1, Math.random() * 0.1 + 0.1, 0.0);
            vec3 = vec3.method_1037(-this.method_36455() * ((float)Math.PI / 180));
            vec3 = vec3.method_1024(-this.method_36454() * ((float)Math.PI / 180));
            double d0 = (double)(-this.field_5974.method_43057()) * 0.6 - 0.3;
            class_243 vec31 = new class_243(((double)this.field_5974.method_43057() - 0.5) * 0.3, d0, 0.6);
            vec31 = vec31.method_1037(-this.method_36455() * ((float)Math.PI / 180));
            vec31 = vec31.method_1024(-this.method_36454() * ((float)Math.PI / 180));
            vec31 = vec31.method_1031(this.method_23317(), this.method_23320(), this.method_23321());
            this.method_37908().method_8406((class_2394)new class_2392(class_2398.field_11218, pStack), vec31.field_1352, vec31.field_1351, vec31.field_1350, vec3.field_1352, vec3.field_1351 + 0.05, vec3.field_1350);
        }
    }

    public void method_5711(byte id) {
        switch (id) {
            case 60: {
                return;
            }
            case 78: {
                this.spawnParticleAround((class_2394)ModParticles.SMALL_HEART_PARTICLE.get());
                return;
            }
            case 79: {
                this.spawnParticleAround((class_2394)ModParticles.SMALL_ANGRY_PARTICLE.get());
                return;
            }
            case 80: {
                this.spawnParticleAround((class_2394)ModParticles.SMALL_HAPPY_PARTICLE.get());
                return;
            }
        }
        super.method_5711(id);
    }

    public boolean method_5756(class_1657 pPlayer) {
        return false;
    }

    protected OptionalInt openMenuScreen(class_1657 player) {
        return OptionalInt.empty();
    }

    protected class_2561 getInventoryName() {
        return this.method_5476();
    }

    protected class_1269 method_5992(class_1657 pPlayer, class_1268 pHand) {
        if (ModItems.TEST_ITEM.is(pPlayer.method_5998(pHand))) {
            if (pHand == class_1268.field_5808) {
                TestItem.log(this, this.getInfoState());
            }
            return class_1269.method_29236((boolean)this.method_37908().method_8608());
        }
        if (pPlayer.method_5715() && pPlayer.method_7337()) {
            if (!this.method_37908().field_9236 && this.openMenuScreen(pPlayer).isPresent()) {
                return class_1269.field_21466;
            }
            return class_1269.method_29236((boolean)this.method_37908().method_8608());
        }
        class_1799 itemInHand = pPlayer.method_5998(pHand);
        ClayBrushItem.Mode mode = ClayBrushItem.getMode(itemInHand);
        if (mode != null && this.isOwnedBy(pPlayer)) {
            this.clayBrushEffect(mode, itemInHand, pPlayer);
            return class_1269.method_29236((boolean)this.method_37908().method_8608());
        }
        if (this.isClayFood(itemInHand)) {
            this.method_6025(this.method_6063());
            itemInHand.method_57008(1, (class_1309)pPlayer);
            if (this.method_37908().method_8608()) {
                this.method_5783(class_3417.field_20614, 1.0f, 1.0f);
                this.spawnParticleAround((class_2394)ModParticles.SMALL_HEART_PARTICLE.get());
            }
            return class_1269.method_29236((boolean)this.method_37908().method_8608());
        }
        if (itemInHand.method_31573(ModTags.Items.CLAY_WAX)) {
            itemInHand.method_57008(1, (class_1309)pPlayer);
            this.setWaxed(true);
            if (this.method_37908().method_8608()) {
                this.method_5783(class_3417.field_29543, 1.0f, 1.0f);
                this.spawnParticleAround((class_2394)ModParticles.SMALL_WAXED_PARTICLE.get());
            }
            return class_1269.method_29236((boolean)this.method_37908().method_8608());
        }
        return super.method_5992(pPlayer, pHand);
    }

    protected boolean isClayFood(class_1799 stack) {
        return stack.method_31573(ModTags.Items.CLAY_FOOD);
    }

    protected boolean clayBrushEffect(ClayBrushItem.Mode mode, class_1799 itemInHand, class_1657 player) {
        if (mode == ClayBrushItem.Mode.COMMAND) {
            if (!this.method_37908().method_8608()) {
                this.tryToSit(player, !this.isOrderedToSit());
            }
            return true;
        }
        if (mode == ClayBrushItem.Mode.POI) {
            if (!this.method_37908().field_9236 && player instanceof class_3222) {
                class_3222 serverPlayer = (class_3222)player;
                this.setPoiPos(ClayBrushItem.getPoiPos(itemInHand));
                serverPlayer.method_43502(this.getPoiSetDisplayName(), true);
            }
            return true;
        }
        return false;
    }

    public class_2561 getPoiSetDisplayName() {
        if (this.getPoiPos() == null) {
            return class_2561.method_43471((String)WORK_POI_CLEARED_LANG);
        }
        class_2680 blockState = this.method_37908().method_8320(this.getPoiPos());
        if (blockState.method_26215()) {
            this.setPoiPos(null);
            return class_2561.method_43469((String)WORK_POI_INVALID_LANG, (Object[])new Object[]{class_2561.method_43471((String)class_2246.field_10124.method_9539())});
        }
        return class_2561.method_43471((String)blockState.method_26204().method_9539()).method_27693(" (" + this.getPoiPos().method_23854() + ")");
    }

    protected void tryToSit(@Nullable class_1657 player, boolean sitting) {
        this.setOrderedToSit(sitting);
        this.field_6282 = false;
        this.field_6189.method_6340();
        this.method_5980(null);
        class_1309 class_13092 = this.method_5642();
        if (class_13092 instanceof ClayMobEntity) {
            ClayMobEntity clayMob = (ClayMobEntity)class_13092;
            clayMob.tryToSit(null, sitting);
        }
    }

    protected void spawnParticleAround(class_2394 particleOptions) {
        for (int i = 0; i < 2; ++i) {
            double xSpeed = this.field_5974.method_43059() * 0.02;
            double ySpeed = this.field_5974.method_43059() * 0.02;
            double zSpeed = this.field_5974.method_43059() * 0.02;
            this.method_37908().method_8406(particleOptions, this.method_23322(0.5), this.method_23319() + 0.25, this.method_23325(0.5), xSpeed, ySpeed, zSpeed);
        }
    }

    @Override
    @NotNull
    public ClayMobTeam getClayTeam() {
        class_2960 team = this.getClayTeamType();
        if (this.cachedTeam == null || !this.cachedTeam.isValidForKey(team)) {
            this.cachedTeam = ClayMobTeamManger.getReferenceOrDefault(team, this.method_56673(), () -> {
                ClayMobTeamManger.LOGGER.error("{} has a Team ({}) that does not exist anymore", (Object)this.getClass().getSimpleName(), (Object)team);
                this.setClayTeamType(ClayMobTeamManger.DEFAULT_TYPE);
            });
        }
        return this.cachedTeam == null ? ClayMobTeamManger.ERROR : this.cachedTeam.value();
    }

    @Override
    @Nullable
    public UUID getClayTeamOwnerUUID() {
        return this.getCachedTeamOwner().map(TeamPlayerData.PlayerData::getUUID).orElse(null);
    }

    @Override
    @Nullable
    public class_1657 getClayTeamOwner() {
        if (this.getClayTeamOwnerUUID() == null) {
            return null;
        }
        return this.method_37908().method_18470(this.getClayTeamOwnerUUID());
    }

    public class_2561 getOwnerDisplayName() {
        return this.getCachedTeamOwner().map(TeamPlayerData.PlayerData::getLastDisplayName).orElse(null);
    }

    private Optional<TeamPlayerData.PlayerData> getCachedTeamOwner() {
        if (this.teamPlayerData == null) {
            this.getPlayerTeamData(this.method_37908());
        }
        if (this.teamPlayerData != null && (this.lastOwnerChange < 0L || this.lastOwnerChange <= this.teamPlayerData.lastChangeTime())) {
            this.cachedTeamOwner = this.teamPlayerData.getPlayerForTeam(this.getClayTeamType());
            this.lastOwnerChange = this.teamPlayerData.lastChangeTime();
        }
        return Optional.ofNullable(this.cachedTeamOwner);
    }

    @Override
    public boolean tryClaimingTeam(class_1657 player) {
        if (!this.getClayTeam().canBeUsed(player)) {
            return false;
        }
        return this.teamPlayerData != null && this.teamPlayerData.putPlayerIfAbsent(this.getClayTeamType(), player);
    }

    @Override
    public boolean unableToMoveToOwner() {
        return TeamHolder.super.unableToMoveToOwner();
    }

    protected void setDataFlag(int pMask, boolean pValue) {
        int i = ((Byte)this.field_6011.method_12789(DATA_FLAGS_ID)).byteValue();
        i = pValue ? (i |= pMask) : (i &= ~pMask);
        this.field_6011.method_12778(DATA_FLAGS_ID, (Object)((byte)(i & 0xFF)));
    }

    protected boolean getDataFlag(int pMask) {
        byte i = (Byte)this.field_6011.method_12789(DATA_FLAGS_ID);
        return (i & pMask) != 0;
    }

    @Override
    public boolean isOrderedToSit() {
        class_1309 class_13092 = this.method_5642();
        if (class_13092 instanceof ClayMobEntity) {
            ClayMobEntity clayMob = (ClayMobEntity)class_13092;
            return clayMob.orderedToSit;
        }
        return this.orderedToSit;
    }

    @Override
    public void setOrderedToSit(boolean sit) {
        this.orderedToSit = sit;
    }

    @Override
    public boolean isInSittingPose() {
        return this.getDataFlag(1);
    }

    @Override
    public void setInSittingPose(boolean sitting) {
        this.setDataFlag(1, sitting);
    }

    @Nullable
    public class_1799 method_31480() {
        if (this.spawnedFrom == null || this.spawnedFrom.method_7960()) {
            return null;
        }
        class_1799 copy = this.spawnedFrom.method_7972();
        this.modifyPickResult(copy);
        return copy;
    }

    protected void modifyPickResult(class_1799 stack) {
    }

    @Nullable
    public class_2561 getWorkStatus() {
        if (this.isInSittingPose()) {
            return class_2561.method_43471((String)"clay_mob_status.csr.sitting");
        }
        return this.usingPoi() ? class_2561.method_43470((String)"clay_mob_status.csr.using_poi") : null;
    }

    public boolean tryToTeleportToOwner() {
        class_1657 livingentity = this.getClayTeamOwner();
        if (livingentity != null) {
            return this.teleportToAroundBlockPos(livingentity.method_24515());
        }
        return false;
    }

    private boolean teleportToAroundBlockPos(class_2338 p_350657_) {
        for (int i = 0; i < 10; ++i) {
            int j = this.field_5974.method_39332(-3, 3);
            int k = this.field_5974.method_39332(-3, 3);
            if (Math.abs(j) < 2 && Math.abs(k) < 2) continue;
            int l = this.field_5974.method_39332(-1, 1);
            if (!this.maybeTeleportTo(p_350657_.method_10263() + j, p_350657_.method_10264() + l, p_350657_.method_10260() + k)) continue;
            return true;
        }
        return false;
    }

    private boolean maybeTeleportTo(int x, int y, int z) {
        ClayMobEntity moving;
        class_1297 class_12972 = this.method_49694();
        if (class_12972 instanceof class_1308) {
            class_1308 mob = (class_1308)class_12972;
            v0 = mob;
        } else {
            v0 = moving = this;
        }
        if (!this.canTeleportTo(new class_2338(x, y, z), (class_1308)moving)) {
            return false;
        }
        moving.method_5859((double)x + 0.5, y, (double)z + 0.5);
        moving.method_5942().method_6340();
        return true;
    }

    private boolean canTeleportTo(class_2338 pos, class_1308 moving) {
        class_7 pathtype = class_14.method_57625((class_1308)moving, (class_2338)pos);
        if (pathtype != class_7.field_12) {
            return false;
        }
        class_2680 blockstate = moving.method_37908().method_8320(pos.method_10074());
        if (!this.canFlyToOwner() && blockstate.method_26204() instanceof class_2397) {
            return false;
        }
        class_2338 blockpos = pos.method_10059((class_2382)moving.method_24515());
        return moving.method_37908().method_8587((class_1297)moving, moving.method_5829().method_996(blockpos));
    }

    protected boolean canFlyToOwner() {
        class_1297 class_12972 = this.method_49694();
        if (class_12972 instanceof ClayMobEntity) {
            ClayMobEntity clayMob = (ClayMobEntity)class_12972;
            return clayMob.canFlyToOwner();
        }
        return false;
    }

    public boolean shouldTryTeleportToOwner() {
        return false;
    }

    public void sendSpawnPayload(class_3222 tracking) {
    }

    public void method_5837(class_3222 serverPlayer) {
        super.method_5837(serverPlayer);
        this.sendSpawnPayload(serverPlayer);
    }

    public void setWaxed(boolean waxed) {
        this.setDataFlag(2, waxed);
    }

    public boolean isWaxed() {
        return this.getDataFlag(2);
    }

    @Nullable
    public class_2338 getPoiPos() {
        return this.poiPos;
    }

    public void setPoiPos(@Nullable class_2338 pos) {
        this.poiPos = pos;
        boolean hasPos = pos != null;
        this.field_6011.method_12778(HAS_POI_POS, (Object)hasPos);
        class_1937 class_19372 = this.method_37908();
        if (class_19372 instanceof class_3218) {
            class_3218 serverLevel = (class_3218)class_19372;
            this.poiPosCapability = hasPos ? UseAssignedPoiGoal.createCache(this, serverLevel) : null;
        }
    }

    @Nullable
    public AssignablePoiCapability getPoiCapability() {
        return this.poiPosCapability == null ? null : this.poiPosCapability.getCapability();
    }

    public void setUsingPoi(boolean usingPoi) {
        this.field_6011.method_12778(USING_POI, (Object)usingPoi);
    }

    public boolean usingPoi() {
        return (Boolean)this.field_6011.method_12789(USING_POI);
    }

    protected boolean hasPoiPos() {
        return (Boolean)this.field_6011.method_12789(HAS_POI_POS);
    }

    protected void method_6087(class_1297 entity) {
        if (entity instanceof class_1657) {
            return;
        }
        super.method_6087(entity);
    }

    protected void method_59928() {
        this.method_5783(class_3417.field_37336, 0.3f, 1.0f);
    }

    public List<String> getInfoState() {
        ArrayList<String> info = new ArrayList<String>(4);
        info.add("TeamPlayerData: " + String.valueOf(this.teamPlayerData));
        info.add("CachedTeam: " + String.valueOf(this.cachedTeam));
        info.add("Owner: " + String.valueOf(this.cachedTeamOwner == null ? "Null" : this.cachedTeamOwner));
        info.add("PoiPos: " + String.valueOf(this.poiPos) + " PoiCap: " + String.valueOf(this.poiPosCapability));
        info.add("Active Goals:");
        this.field_6201.method_35115().stream().filter(class_4135::method_19056).map(g -> g.method_19058().getClass().getSimpleName()).forEach(c -> info.add(" - " + c));
        return info;
    }

    @FunctionalInterface
    protected static interface DamageCalculator {
        public float calculate(boolean var1, @Nullable class_1297 var2);
    }
}

