/*
 * Decompiled with CFR 0.152.
 */
package net.bumblebee.claysoldiers.entity;

import java.util.HashMap;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.BiPredicate;
import net.bumblebee.claysoldiers.ClaySoldiersCommon;
import net.bumblebee.claysoldiers.entity.soldier.AbstractClaySoldierEntity;
import net.bumblebee.claysoldiers.init.ModEntityTypes;
import net.bumblebee.claysoldiers.soldierproperties.SoldierVehicleProperties;
import net.minecraft.class_1297;
import net.minecraft.class_1299;

public final class ClaySoldierRideableMap {
    private static final Map<class_1299<?>, BiPredicate<? extends class_1297, AbstractClaySoldierEntity>> MAP = new HashMap();
    private static final Map<class_1299<?>, BiConsumer<? extends class_1297, AbstractClaySoldierEntity>> ON_RIDE_MAP = new HashMap();

    public static <T extends class_1297> boolean test(T entity, AbstractClaySoldierEntity claySoldierEntity) {
        SoldierVehicleProperties vehicleProperties = ClaySoldiersCommon.DATA_MAP.getVehicleProperties(entity.method_5864());
        if (vehicleProperties != null && !vehicleProperties.predicate().test(claySoldierEntity)) {
            return false;
        }
        BiPredicate<? extends class_1297, AbstractClaySoldierEntity> predicate = MAP.get(entity.method_5864());
        return predicate != null && predicate.test(entity, claySoldierEntity);
    }

    public static <T extends class_1297> void onRide(T entity, AbstractClaySoldierEntity claySoldierEntity) {
        BiConsumer<? extends class_1297, AbstractClaySoldierEntity> consumer = ON_RIDE_MAP.get(entity.method_5864());
        if (consumer != null) {
            consumer.accept(entity, claySoldierEntity);
        }
    }

    private static <T extends class_1297> void setPredicate(class_1299<T> entityType, BiPredicate<T, AbstractClaySoldierEntity> predicate) {
        MAP.put(entityType, predicate);
    }

    private static <T extends class_1297> void setPredicate(class_1299<T> entityType, BiPredicate<T, AbstractClaySoldierEntity> predicate, BiConsumer<T, AbstractClaySoldierEntity> onRide) {
        ClaySoldierRideableMap.setPredicate(entityType, predicate);
        ON_RIDE_MAP.put(entityType, onRide);
    }

    static {
        ClaySoldierRideableMap.setPredicate(class_1299.field_6140, (rabbit, claySoldier) -> true);
        ClaySoldierRideableMap.setPredicate(class_1299.field_6128, (endermite, claySoldier) -> true, (endermite, soldier) -> endermite.method_5971());
        ClaySoldierRideableMap.setPredicate(ModEntityTypes.CLAY_HORSE_ENTITY.get(), (horse, soldier) -> true);
        ClaySoldierRideableMap.setPredicate(ModEntityTypes.CLAY_PEGASUS_ENTITY.get(), (horse, soldier) -> true);
        ClaySoldierRideableMap.setPredicate(ModEntityTypes.CLAY_SOLDIER_ENTITY.get(), (soldierToRide, soldier) -> {
            if (!soldierToRide.getAttackType().rideable() || !soldier.sameTeamAs((class_1297)soldierToRide)) {
                return false;
            }
            return soldierToRide.getSoldierSize() >= soldier.getSoldierSize() + 1.0f && soldier.canPerformRangeAttack();
        });
        ClaySoldierRideableMap.setPredicate(class_1299.field_6113, (turtle, claySoldier) -> turtle.method_6109());
        ClaySoldierRideableMap.setPredicate(class_1299.field_6069, (slime, soldier) -> slime.method_7152() == 1 && soldier.canPerformRangeAttack());
    }
}

