/*
 * Decompiled with CFR 0.152.
 */
package net.bumblebee.claysoldiers.entity;

import com.mojang.datafixers.util.Either;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.DynamicOps;
import java.util.EnumSet;
import java.util.List;
import java.util.function.Consumer;
import net.bumblebee.claysoldiers.entity.ClayMobEntity;
import net.bumblebee.claysoldiers.entity.ClayMobTeamOwnerEntity;
import net.bumblebee.claysoldiers.entity.VampiricClayMob;
import net.bumblebee.claysoldiers.entity.goal.ClayMobSitGoal;
import net.bumblebee.claysoldiers.entity.soldier.AbstractClaySoldierEntity;
import net.bumblebee.claysoldiers.entity.soldier.ClaySoldierInventoryHandler;
import net.bumblebee.claysoldiers.entity.soldier.ClaySoldierLike;
import net.bumblebee.claysoldiers.init.ModEntityTypes;
import net.bumblebee.claysoldiers.soldierproperties.customproperties.specialattack.SpecialAttack;
import net.bumblebee.claysoldiers.soldierproperties.customproperties.specialattack.SpecialAttackType;
import net.bumblebee.claysoldiers.util.codec.CodecUtils;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1313;
import net.minecraft.class_1335;
import net.minecraft.class_1347;
import net.minecraft.class_1352;
import net.minecraft.class_1400;
import net.minecraft.class_1657;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2509;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3532;
import net.minecraft.class_3730;
import net.minecraft.class_5132;
import net.minecraft.class_5134;
import net.minecraft.class_5425;
import net.minecraft.class_5712;
import net.minecraft.class_6880;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

public class ClayWraithEntity
extends ClayMobTeamOwnerEntity
implements ClaySoldierLike,
VampiricClayMob {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final double WRAITH_ATTACK_REACH = Math.sqrt(2.04f) - (double)0.6f;
    public static final float FLAP_DEGREES_PER_TICK = 45.836624f;
    public static final int TICKS_PER_FLAP = class_3532.method_15386((float)3.9269907f);
    public static final float WRAITH_SCALE = 0.5f;
    protected static final class_2940<Byte> DATA_FLAGS_ID = class_2945.method_12791(ClayWraithEntity.class, (class_2941)class_2943.field_13319);
    private static final int FLAG_IS_CHARGING = 1;
    private static final byte MIN_LIFE_SPAN = 0;
    private static final byte MAX_LIFE_SPAN = 63;
    public static final String WRAITH_ATTACK_TAG = "WraithAttacks";
    public static final String LIFE_TICKS_TAG = "LifeTicks";
    public static final String MAX_LIFE_TICKS_TAG = "MaxLifeTicks";
    @Nullable
    private class_2338 boundOrigin;
    private int maxLimitedLifeTicks = -1;
    private int limitedLifeTicks;
    private List<SpecialAttack<?>> attackFunctions = List.of();

    public ClayWraithEntity(class_1299<? extends ClayMobEntity> pEntityType, class_1937 pLevel) {
        super(pEntityType, pLevel);
        this.field_6207 = new WraithMovementControl(this);
    }

    public boolean method_5776() {
        return this.field_6012 % TICKS_PER_FLAP == 0;
    }

    public static class_5132 setWraithAttributes() {
        return class_1308.method_26828().method_26868(class_5134.field_23716, 20.0).method_26868(class_5134.field_23724, 0.0).method_26868(class_5134.field_23721, 2.5).method_26868(class_5134.field_23723, 0.1).method_26868(class_5134.field_23719, 0.3).method_26868(class_5134.field_23717, 16.0).method_26868(class_5134.field_23718, 0.5).method_26866();
    }

    protected void method_5959() {
        this.field_6201.method_6277(0, (class_1352)new WraithSitGoal(this));
        this.field_6201.method_6277(1, (class_1352)new class_1347((class_1308)this));
        this.field_6201.method_6277(2, (class_1352)new WraithChargeAttackGoal());
        this.field_6201.method_6277(3, (class_1352)new WraithRandomMoveGoal());
        this.field_6185.method_6277(0, (class_1352)new class_1400((class_1308)this, AbstractClaySoldierEntity.class, false, this::targetPredicate));
    }

    @Override
    protected boolean targetPredicate(class_1309 other) {
        if (!(other instanceof ClayMobEntity)) {
            return false;
        }
        ClayMobEntity target = (ClayMobEntity)other;
        return this.shouldAttackTeamHolder(target);
    }

    @Override
    protected double getDefaultAttackReach() {
        return WRAITH_ATTACK_REACH;
    }

    @Override
    protected void handleTeamChange(class_2960 teamId) {
    }

    public void method_5784(class_1313 pType, class_243 pPos) {
        super.method_5784(pType, pPos);
        this.method_5852();
    }

    @Override
    public void method_5773() {
        this.field_5960 = true;
        super.method_5773();
        this.field_5960 = false;
        this.method_5875(true);
        if (!this.isNightForVampire()) {
            --this.limitedLifeTicks;
        }
        if (this.hasLimitedLife() && this.limitedLifeTicks <= 0) {
            this.updateLifePercent();
            this.method_5768();
        }
        if (!this.method_37908().field_9236 && this.hasLimitedLife() && this.limitedLifeTicks % 5 == 0) {
            this.updateLifePercent();
        }
    }

    @Override
    protected void method_5693(class_2945.class_9222 pBuilder) {
        super.method_5693(pBuilder);
        pBuilder.method_56912(DATA_FLAGS_ID, (Object)0);
    }

    @Override
    public void method_5652(class_2487 pCompound) {
        super.method_5652(pCompound);
        if (this.boundOrigin != null) {
            pCompound.method_10569("BoundX", this.boundOrigin.method_10263());
            pCompound.method_10569("BoundY", this.boundOrigin.method_10264());
            pCompound.method_10569("BoundZ", this.boundOrigin.method_10260());
        }
        if (this.hasLimitedLife()) {
            pCompound.method_10569(MAX_LIFE_TICKS_TAG, this.maxLimitedLifeTicks);
            pCompound.method_10569(LIFE_TICKS_TAG, this.limitedLifeTicks);
        }
        if (!this.attackFunctions.isEmpty()) {
            ClayWraithEntity.writeSpecialAttackToTag(pCompound, this.attackFunctions);
        }
    }

    public static void writeSpecialAttackToTag(class_2487 tag, List<SpecialAttack<?>> attacks) {
        SpecialAttack.LIST_CODEC.encodeStart((DynamicOps)class_2509.field_11560, attacks).resultOrPartial(arg_0 -> ((Logger)LOGGER).error(arg_0)).ifPresent(wraithAttack -> tag.method_10566(WRAITH_ATTACK_TAG, wraithAttack));
    }

    @Override
    public void method_5749(class_2487 pCompound) {
        super.method_5749(pCompound);
        if (pCompound.method_10545("BoundX")) {
            this.boundOrigin = new class_2338(pCompound.method_10550("BoundX"), pCompound.method_10550("BoundY"), pCompound.method_10550("BoundZ"));
        }
        this.readItemPersistentData(pCompound);
    }

    @Nullable
    public class_2338 getBoundOrigin() {
        return this.boundOrigin;
    }

    public void setBoundOrigin(@Nullable class_2338 pBoundOrigin) {
        this.boundOrigin = pBoundOrigin;
    }

    public void setLimitedLife(int pLimitedLifeTicks) {
        this.maxLimitedLifeTicks = pLimitedLifeTicks;
        this.limitedLifeTicks = pLimitedLifeTicks;
    }

    public boolean hasLimitedLife() {
        return this.maxLimitedLifeTicks > 0;
    }

    public int getLimitedLifeTicks() {
        return this.limitedLifeTicks;
    }

    public boolean isCharging() {
        byte i = (Byte)this.field_6011.method_12789(DATA_FLAGS_ID);
        return (i & 1) != 0;
    }

    public void setIsCharging(boolean pCharging) {
        int i = ((Byte)this.field_6011.method_12789(DATA_FLAGS_ID)).byteValue();
        i = pCharging ? (i |= 1) : (i &= 0xFFFFFFFE);
        this.field_6011.method_12778(DATA_FLAGS_ID, (Object)((byte)(i & 0xFF)));
    }

    public int getLifePoint() {
        return (Byte)this.field_6011.method_12789(DATA_FLAGS_ID) >> 1;
    }

    private void updateLifePercent() {
        float percent = this.maxLimitedLifeTicks <= 0 ? 1.0f : (float)this.limitedLifeTicks / (float)this.maxLimitedLifeTicks;
        if (percent < 0.0f) {
            percent = 0.0f;
        } else if (percent > 1.0f) {
            percent = 1.0f;
        }
        byte b = (byte)((this.isCharging() ? (byte)1 : 0) | (byte)((byte)(percent * 63.0f) << 1));
        this.field_6011.method_12778(DATA_FLAGS_ID, (Object)b);
    }

    protected class_3414 method_5994() {
        return class_3417.field_14812;
    }

    protected class_3414 method_6002() {
        return class_3417.field_14964;
    }

    protected class_3414 method_6011(class_1282 pDamageSource) {
        return class_3417.field_15072;
    }

    public float method_5718() {
        return 1.0f;
    }

    private void doAttackFunctions(class_1309 target) {
        for (SpecialAttack<?> attack : this.attackFunctions) {
            if (!attack.getAttackType().is(SpecialAttackType.MELEE)) continue;
            attack.performAttackEffect(this, (class_1297)target);
        }
    }

    public void setAttackFunctions(List<SpecialAttack<?>> attacks) {
        this.attackFunctions = attacks;
    }

    @Override
    public ClayMobEntity asClayMob() {
        return this;
    }

    @Override
    public <T extends ClaySoldierInventoryHandler> void copyInventory(T toCopyTo) {
    }

    @Override
    public void readItemPersistentData(class_2487 tag) {
        if (tag.method_10573(LIFE_TICKS_TAG, 3)) {
            this.limitedLifeTicks = tag.method_10550(LIFE_TICKS_TAG);
            this.maxLimitedLifeTicks = Math.max(tag.method_10550(MAX_LIFE_TICKS_TAG), this.limitedLifeTicks);
        } else if (tag.method_10573(LIFE_TICKS_TAG, 8)) {
            CodecUtils.getTimeFromEither((Either<Integer, String>)Either.right((Object)tag.method_10558(LIFE_TICKS_TAG))).ifSuccess(ticks -> {
                this.limitedLifeTicks = ticks;
                this.maxLimitedLifeTicks = Math.max(tag.method_10550(MAX_LIFE_TICKS_TAG), this.limitedLifeTicks);
            }).ifError(err -> LOGGER.error("Error Reading {} for Wraith as Seconds: {}", (Object)LIFE_TICKS_TAG, (Object)err.message()));
        }
        if (tag.method_10573(WRAITH_ATTACK_TAG, 10)) {
            SpecialAttack.LIST_CODEC.parse((DynamicOps)class_2509.field_11560, (Object)tag.method_10580(WRAITH_ATTACK_TAG)).resultOrPartial(arg_0 -> ((Logger)LOGGER).error(arg_0)).ifPresent(specialAttack -> {
                this.attackFunctions = specialAttack;
            });
        }
    }

    @Override
    public float getNightPower() {
        return (this.method_37908().method_30272() + 1.0f) * 1.5f;
    }

    public float method_6029() {
        return super.method_6029() * this.getPowerMultiplier();
    }

    @Nullable
    public static ClayWraithEntity spawnWraith(class_3218 level, ClayMobEntity caster, int duration) {
        return ClayWraithEntity.spawnWraith(level, caster, duration, true, w -> {});
    }

    @Nullable
    public static ClayWraithEntity spawnWraith(class_3218 level, ClayMobEntity caster, int duration, Consumer<ClayWraithEntity> onSpawn) {
        return ClayWraithEntity.spawnWraith(level, caster, duration, false, onSpawn);
    }

    @Nullable
    private static ClayWraithEntity spawnWraith(class_3218 level, ClayMobEntity caster, int duration, boolean summoned, Consumer<ClayWraithEntity> onSpawn) {
        if (duration <= 0) {
            return null;
        }
        class_2338 bound = caster.method_24515();
        ClayWraithEntity wraith = (ClayWraithEntity)ModEntityTypes.CLAY_WRAITH.get().method_5883(caster.method_37908());
        if (wraith != null) {
            wraith.method_60949(caster.method_19538(), caster.method_36454(), caster.method_36455());
            wraith.method_5943((class_5425)level, level.method_8404(bound), summoned ? class_3730.field_16471 : class_3730.field_16468, null);
            wraith.setBoundOrigin(bound);
            wraith.setLimitedLife(20 * (duration + caster.method_59922().method_43048(duration)));
            wraith.setClayTeamType(caster.getClayTeamType());
            level.method_30771((class_1297)wraith);
            level.method_43276((class_6880)class_5712.field_28738, bound, class_5712.class_7397.method_43285((class_1297)caster));
            onSpawn.accept(wraith);
        }
        return wraith;
    }

    @Override
    public class_1936 getLevel() {
        return this.method_37908();
    }

    class WraithMovementControl
    extends class_1335 {
        public WraithMovementControl(ClayWraithEntity wraith) {
            super((class_1308)wraith);
        }

        public void method_6240() {
            if (this.field_6374 == class_1335.class_1336.field_6378) {
                class_243 vec3 = new class_243(this.field_6370 - ClayWraithEntity.this.method_23317(), this.field_6369 - ClayWraithEntity.this.method_23318(), this.field_6367 - ClayWraithEntity.this.method_23321());
                double d0 = vec3.method_1033();
                if (d0 < ClayWraithEntity.this.method_5829().method_995()) {
                    this.field_6374 = class_1335.class_1336.field_6377;
                    ClayWraithEntity.this.method_18799(ClayWraithEntity.this.method_18798().method_1021(0.5));
                } else {
                    ClayWraithEntity.this.method_18799(ClayWraithEntity.this.method_18798().method_1019(vec3.method_1021(this.field_6372 * 0.05 / d0)));
                    if (ClayWraithEntity.this.method_5968() == null) {
                        class_243 vec31 = ClayWraithEntity.this.method_18798();
                        ClayWraithEntity.this.method_36456(-((float)class_3532.method_15349((double)vec31.field_1352, (double)vec31.field_1350)) * 57.295776f);
                        ClayWraithEntity.this.field_6283 = ClayWraithEntity.this.method_36454();
                    } else {
                        double d2 = ClayWraithEntity.this.method_5968().method_23317() - ClayWraithEntity.this.method_23317();
                        double d1 = ClayWraithEntity.this.method_5968().method_23321() - ClayWraithEntity.this.method_23321();
                        ClayWraithEntity.this.method_36456(-((float)class_3532.method_15349((double)d2, (double)d1)) * 57.295776f);
                        ClayWraithEntity.this.field_6283 = ClayWraithEntity.this.method_36454();
                    }
                }
            }
        }
    }

    static class WraithSitGoal
    extends ClayMobSitGoal {
        public WraithSitGoal(ClayMobEntity clayMobEntity) {
            super(clayMobEntity);
        }

        @Override
        public boolean method_6264() {
            if (this.isCurrentlyFighting()) {
                return false;
            }
            if (this.clayMobEntity.method_5765()) {
                return false;
            }
            if (this.clayMobEntity.method_5816()) {
                return false;
            }
            class_1657 owner = this.clayMobEntity.getClayTeamOwner();
            if (owner == null) {
                return false;
            }
            return !(this.clayMobEntity.method_5858((class_1297)owner) < 144.0 && owner.method_6065() != null || !this.clayMobEntity.isOrderedToSit());
        }
    }

    class WraithChargeAttackGoal
    extends class_1352 {
        public WraithChargeAttackGoal() {
            this.method_6265(EnumSet.of(class_1352.class_4134.field_18405));
        }

        public boolean method_6264() {
            class_1309 livingentity = ClayWraithEntity.this.method_5968();
            return livingentity != null && livingentity.method_5805() && !ClayWraithEntity.this.method_5962().method_6241() && ClayWraithEntity.this.field_5974.method_43048(WraithChargeAttackGoal.method_38848((int)7)) == 0 && ClayWraithEntity.this.method_5858((class_1297)livingentity) > 4.0;
        }

        public boolean method_6266() {
            return ClayWraithEntity.this.method_5962().method_6241() && ClayWraithEntity.this.isCharging() && ClayWraithEntity.this.method_5968() != null && ClayWraithEntity.this.method_5968().method_5805();
        }

        public void method_6269() {
            class_1309 livingentity = ClayWraithEntity.this.method_5968();
            if (livingentity != null) {
                class_243 vec3 = livingentity.method_33571();
                ClayWraithEntity.this.field_6207.method_6239(vec3.field_1352, vec3.field_1351, vec3.field_1350, 1.0);
            }
            ClayWraithEntity.this.setIsCharging(true);
            ClayWraithEntity.this.method_5783(class_3417.field_14898, 1.0f, 1.0f);
        }

        public void method_6270() {
            ClayWraithEntity.this.setIsCharging(false);
        }

        public boolean method_38846() {
            return true;
        }

        public void method_6268() {
            class_1309 target = ClayWraithEntity.this.method_5968();
            if (target != null) {
                if (ClayWraithEntity.this.method_5829().method_1014(2.0).method_994(target.method_5829())) {
                    ClayWraithEntity.this.method_6121((class_1297)target);
                    ClayWraithEntity.this.doAttackFunctions(target);
                    ClayWraithEntity.this.setIsCharging(false);
                } else {
                    double distanceToTarget = ClayWraithEntity.this.method_5858((class_1297)target);
                    if (distanceToTarget < 9.0) {
                        class_243 targetPos = target.method_33571();
                        ClayWraithEntity.this.field_6207.method_6239(targetPos.field_1352, targetPos.field_1351, targetPos.field_1350, 1.0);
                    }
                }
            }
        }
    }

    class WraithRandomMoveGoal
    extends class_1352 {
        public WraithRandomMoveGoal() {
            this.method_6265(EnumSet.of(class_1352.class_4134.field_18405));
        }

        public boolean method_6264() {
            if (ClayWraithEntity.this.isOrderedToSit()) {
                return false;
            }
            return !ClayWraithEntity.this.method_5962().method_6241() && ClayWraithEntity.this.field_5974.method_43048(WraithRandomMoveGoal.method_38848((int)7)) == 0;
        }

        public boolean method_6266() {
            return false;
        }

        public void method_6268() {
            class_2338 blockpos = ClayWraithEntity.this.getBoundOrigin();
            if (blockpos == null) {
                blockpos = ClayWraithEntity.this.method_24515();
            }
            for (int i = 0; i < 3; ++i) {
                class_2338 blockpos1 = blockpos.method_10069(ClayWraithEntity.this.field_5974.method_43048(15) - 7, ClayWraithEntity.this.field_5974.method_43048(11) - 5, ClayWraithEntity.this.field_5974.method_43048(15) - 7);
                if (!ClayWraithEntity.this.method_37908().method_22347(blockpos1)) continue;
                ClayWraithEntity.this.field_6207.method_6239((double)blockpos1.method_10263() + 0.5, (double)blockpos1.method_10264() + 0.5, (double)blockpos1.method_10260() + 0.5, 0.25);
                if (ClayWraithEntity.this.method_5968() != null) break;
                ClayWraithEntity.this.method_5988().method_6230((double)blockpos1.method_10263() + 0.5, (double)blockpos1.method_10264() + 0.5, (double)blockpos1.method_10260() + 0.5, 180.0f, 20.0f);
                break;
            }
        }
    }
}

