/*
 * Decompiled with CFR 0.152.
 */
package net.bumblebee.claysoldiers.entity.boss;

import com.mojang.serialization.Codec;
import java.util.EnumSet;
import java.util.function.BiConsumer;
import java.util.function.BiPredicate;
import java.util.function.Predicate;
import net.bumblebee.claysoldiers.entity.boss.BossClaySoldierEntity;
import net.bumblebee.claysoldiers.init.ModRegistries;
import net.minecraft.class_1282;
import net.minecraft.class_3213;
import net.minecraft.class_52;
import net.minecraft.class_5321;
import org.jetbrains.annotations.Nullable;

public class BossClaySoldierBehaviour {
    public static final Codec<BossClaySoldierBehaviour> CODEC = ModRegistries.BOSS_CLAY_SOLDIER_BEHAVIOURS_REGISTRY.method_39673();
    @Nullable
    private final class_5321<class_52> deathLoot;
    private final BossClaySoldierEntity.BossTypes initialType;
    private final EnumSet<BossClaySoldierEntity.BossTypes> allowedTypes;
    private final BiConsumer<BossClaySoldierEntity, class_1282> onDeath;
    private final Predicate<BossClaySoldierEntity> shouldDie;
    private final BiConsumer<BossClaySoldierEntity, class_3213> setupBossEvent;
    private final BiConsumer<BossClaySoldierEntity, class_3213> modifyBossEventProgress;
    private final BiPredicate<BossClaySoldierEntity, class_1282> onHurt;

    protected BossClaySoldierBehaviour(BossClaySoldierEntity.BossTypes initial, @Nullable class_5321<class_52> deathLoot, BossClaySoldierEntity.BossTypes[] allowedOther, BiConsumer<BossClaySoldierEntity, class_1282> onDeath, Predicate<BossClaySoldierEntity> shouldDie, BiConsumer<BossClaySoldierEntity, class_3213> setupBossEvent, BiConsumer<BossClaySoldierEntity, class_3213> modifyBossEventProgress, BiPredicate<BossClaySoldierEntity, class_1282> onHurt) {
        this.deathLoot = deathLoot;
        this.onDeath = onDeath;
        this.shouldDie = shouldDie;
        this.setupBossEvent = setupBossEvent;
        this.modifyBossEventProgress = modifyBossEventProgress;
        this.onHurt = onHurt;
        this.allowedTypes = EnumSet.of(initial, allowedOther);
        this.initialType = initial;
    }

    public static Builder of(BossClaySoldierEntity.BossTypes type, @Nullable class_5321<class_52> deathLoot) {
        return new Builder(type, deathLoot);
    }

    public void setUpBoss(BossClaySoldierEntity boss, class_3213 bossEvent) {
        boss.setBossType(this.initialType);
        this.setupBossEvent.accept(boss, bossEvent);
    }

    public void onDeath(BossClaySoldierEntity bossEntity, class_1282 damageSource) {
        this.onDeath.accept(bossEntity, damageSource);
    }

    public boolean onHurt(BossClaySoldierEntity bossEntity, class_1282 damageSource) {
        return this.onHurt.test(bossEntity, damageSource);
    }

    public boolean shouldDie(BossClaySoldierEntity bossEntity) {
        return this.shouldDie.test(bossEntity);
    }

    @Nullable
    public class_5321<class_52> getLootTable() {
        return this.deathLoot;
    }

    public void getBossEventProgress(BossClaySoldierEntity bossEntity, class_3213 event) {
        this.modifyBossEventProgress.accept(bossEntity, event);
    }

    public boolean isAllowed(BossClaySoldierEntity.BossTypes type) {
        return this.allowedTypes.contains((Object)type);
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }

    public static class Builder {
        private final class_5321<class_52> deathLoot;
        private final BossClaySoldierEntity.BossTypes initialType;
        private BiConsumer<BossClaySoldierEntity, class_1282> onDeath = (b, d) -> {};
        private Predicate<BossClaySoldierEntity> shouldDie = b -> true;
        private BossClaySoldierEntity.BossTypes[] allowedBossTypes = new BossClaySoldierEntity.BossTypes[0];
        private BiConsumer<BossClaySoldierEntity, class_3213> setupBossEvent = (b, e) -> {};
        private BiConsumer<BossClaySoldierEntity, class_3213> modifyBossEventProgress = (b, e) -> e.method_5408(b.method_6032() / b.method_6063());
        private BiPredicate<BossClaySoldierEntity, class_1282> onHurt = (b, d) -> true;

        public Builder(BossClaySoldierEntity.BossTypes initialType, class_5321<class_52> deathLoot) {
            this.deathLoot = deathLoot;
            this.initialType = initialType;
        }

        public Builder setBossEvent(BiConsumer<BossClaySoldierEntity, class_3213> modifyBossEvent) {
            this.setupBossEvent = modifyBossEvent;
            return this;
        }

        public Builder setModifyBossEventProgress(BiConsumer<BossClaySoldierEntity, class_3213> modifyBossEventProgress) {
            this.modifyBossEventProgress = modifyBossEventProgress;
            return this;
        }

        public Builder setOnDeath(BiConsumer<BossClaySoldierEntity, class_1282> onDeath) {
            this.onDeath = onDeath;
            return this;
        }

        public Builder setShouldDie(Predicate<BossClaySoldierEntity> shouldDie) {
            this.shouldDie = shouldDie;
            return this;
        }

        public Builder setAllowedBossTypes(BossClaySoldierEntity.BossTypes ... allowdBossTypes) {
            this.allowedBossTypes = allowdBossTypes;
            return this;
        }

        public Builder setOnHurt(BiPredicate<BossClaySoldierEntity, class_1282> onHurt) {
            this.onHurt = onHurt;
            return this;
        }

        public BossClaySoldierBehaviour build() {
            return new BossClaySoldierBehaviour(this.initialType, this.deathLoot, this.allowedBossTypes, this.onDeath, this.shouldDie, this.setupBossEvent, this.modifyBossEventProgress, this.onHurt);
        }
    }
}

