/*
 * Decompiled with CFR 0.152.
 */
package net.bumblebee.claysoldiers.entity.boss;

import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.OptionalInt;
import java.util.UUID;
import java.util.function.Consumer;
import net.bumblebee.claysoldiers.ClaySoldiersCommon;
import net.bumblebee.claysoldiers.entity.ClayMobEntity;
import net.bumblebee.claysoldiers.entity.boss.BossClaySoldierBehaviour;
import net.bumblebee.claysoldiers.entity.boss.ClayBlockProjectileEntity;
import net.bumblebee.claysoldiers.entity.goal.ClaySodlierBreathAirGoal;
import net.bumblebee.claysoldiers.entity.goal.ClaySoldierMeleeAttackGoal;
import net.bumblebee.claysoldiers.entity.goal.target.ClaySoldierNearestTargetGoal;
import net.bumblebee.claysoldiers.entity.goal.workgoal.WorkSelectorGoal;
import net.bumblebee.claysoldiers.entity.soldier.AbstractClaySoldierEntity;
import net.bumblebee.claysoldiers.entity.soldier.status.SoldierStatusHolder;
import net.bumblebee.claysoldiers.init.ModBossBehaviours;
import net.bumblebee.claysoldiers.init.ModRegistries;
import net.bumblebee.claysoldiers.init.ModTags;
import net.bumblebee.claysoldiers.networking.spawnpayloads.ClayBossSpawnPayload;
import net.bumblebee.claysoldiers.soldierproperties.SoldierPropertyMap;
import net.bumblebee.claysoldiers.soldierproperties.SoldierPropertyMapReader;
import net.bumblebee.claysoldiers.soldierproperties.SoldierPropertyTypes;
import net.bumblebee.claysoldiers.soldierproperties.combined.SoldierPropertyCombinedMap;
import net.bumblebee.claysoldiers.soldierproperties.customproperties.AttackTypeProperty;
import net.minecraft.class_1259;
import net.minecraft.class_1266;
import net.minecraft.class_1282;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1314;
import net.minecraft.class_1315;
import net.minecraft.class_1352;
import net.minecraft.class_1376;
import net.minecraft.class_1379;
import net.minecraft.class_1381;
import net.minecraft.class_1399;
import net.minecraft.class_1603;
import net.minecraft.class_1657;
import net.minecraft.class_173;
import net.minecraft.class_1799;
import net.minecraft.class_181;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2374;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2509;
import net.minecraft.class_2512;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3213;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3542;
import net.minecraft.class_3730;
import net.minecraft.class_5132;
import net.minecraft.class_5134;
import net.minecraft.class_52;
import net.minecraft.class_5321;
import net.minecraft.class_5425;
import net.minecraft.class_8567;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

public class BossClaySoldierEntity
extends AbstractClaySoldierEntity {
    private static final class_2940<Byte> BOSS_TYPE = class_2945.method_12791(BossClaySoldierEntity.class, (class_2941)class_2943.field_13319);
    private static final Logger LOGGER = ClaySoldiersCommon.LOGGER;
    private static final String BASE_PROPERTIES_TAG = "baseProperties";
    private static final String TYPE_TAG = "bossType";
    private static final String BOSS_AI_TAG = "bossAI";
    private static final String MINION_OWNER_TAG = "minionOwner";
    private static final String MINIONS_TAG = "minions";
    private static final String PHASE_COMPLETED_TAG = "phaseCompleted";
    private static final SoldierStatusHolder EMPTY = () -> null;
    private final class_3213 bossEvent;
    private final SoldierPropertyCombinedMap baseProperties;
    @Nullable
    private BossClaySoldierBehaviour bossAI;
    @Nullable
    private BossClaySoldierEntity minionOwner;
    @Nullable
    private UUID minionOwnerUUID;
    @Nullable
    private List<BossClaySoldierEntity> minions;
    @Nullable
    private List<UUID> minionUUIDs;
    private int phaseCompleted = 0;
    private int nextMinionGlow = 0;

    public BossClaySoldierEntity(class_1299<? extends BossClaySoldierEntity> pEntityType, class_1937 pLevel) {
        super(pEntityType, pLevel, AttackTypeProperty.BOSS, s -> EMPTY);
        this.otherPlayerDamage = (w, e) -> w ? 0.9f : 1.0f;
        this.defaultDamage = (w, e) -> w ? 0.9f : 1.0f;
        this.clayDamage = (w, e) -> w ? 0.25f : 0.5f;
        this.bossEvent = new class_3213(this.method_5476(), class_1259.class_1260.field_5786, class_1259.class_1261.field_5795);
        this.baseProperties = new SoldierPropertyCombinedMap();
    }

    public void setBossAI(@NotNull BossClaySoldierBehaviour bossAI) {
        if (this.bossAI != null || bossAI == null) {
            throw new IllegalStateException("Cannot set Boss Ai twice");
        }
        this.bossAI = bossAI;
        this.bossAI.setUpBoss(this, this.bossEvent);
    }

    @NotNull
    public BossClaySoldierBehaviour getBossAI() {
        return Objects.requireNonNull(this.bossAI, "Boss AI not initialized");
    }

    public static class_5132 bossAttributes() {
        return class_1308.method_26828().method_26868(class_5134.field_23716, 40.0).method_26868(class_5134.field_23724, 5.0).method_26868(class_5134.field_23721, 2.5).method_26868(class_5134.field_23723, 0.1).method_26868(class_5134.field_23719, 0.3).method_26868(class_5134.field_23717, 24.0).method_26868(class_5134.field_23718, 0.6).method_26866();
    }

    @Override
    public void method_5652(class_2487 pCompound) {
        super.method_5652(pCompound);
        if (!this.baseProperties.isEmpty()) {
            BossClaySoldierEntity.writeBasePropertiesToTag(this.baseProperties, pCompound);
        }
        BossTypes.CODEC.encodeStart((DynamicOps)class_2509.field_11560, (Object)this.getBossType()).ifSuccess(tag -> pCompound.method_10566(TYPE_TAG, tag)).ifError(err -> LOGGER.error("Error saving Boss Type: {}", (Object)err.message()));
        BossClaySoldierEntity.writeBossAIToTag(this.getBossAI(), pCompound);
        if (this.minionOwner != null) {
            pCompound.method_25927(MINION_OWNER_TAG, this.minionOwner.method_5667());
        }
        if (this.minions != null) {
            class_2499 listTag = new class_2499();
            this.minions.forEach(minion -> listTag.add((Object)class_2512.method_25929((UUID)minion.method_5667())));
            pCompound.method_10566(MINIONS_TAG, (class_2520)listTag);
        }
        if (this.phaseCompleted > 0) {
            pCompound.method_10569(PHASE_COMPLETED_TAG, this.phaseCompleted);
        }
    }

    @Override
    public void method_5749(class_2487 pCompound) {
        super.method_5749(pCompound);
        this.readAndSetBasePropertiesFromTag(pCompound);
        if (this.readAndSetBossAI(pCompound) && pCompound.method_10545(TYPE_TAG)) {
            BossTypes.CODEC.parse((DynamicOps)class_2509.field_11560, (Object)pCompound.method_10580(TYPE_TAG)).ifSuccess(this::setBossType).ifError(err -> LOGGER.error("Error parsing Boss Type: {}", (Object)err.message()));
        }
        if (this.method_16914()) {
            this.bossEvent.method_5413(this.method_5476());
        }
        if (pCompound.method_10545(MINION_OWNER_TAG)) {
            this.minionOwnerUUID = pCompound.method_25926(MINION_OWNER_TAG);
        }
        if (pCompound.method_10573(MINIONS_TAG, 9)) {
            class_2499 listTag = pCompound.method_10554(MINIONS_TAG, 11);
            this.minionUUIDs = new ArrayList<UUID>(listTag.size());
            for (class_2520 tag : listTag) {
                this.minionUUIDs.add(class_2512.method_25930((class_2520)tag));
            }
        }
        if (pCompound.method_10545(PHASE_COMPLETED_TAG)) {
            this.phaseCompleted = pCompound.method_10550(PHASE_COMPLETED_TAG);
        }
    }

    @Override
    public void readItemPersistentData(class_2487 tag) {
        if (!this.readAndSetBossAI(tag)) {
            this.setBossAI(ModBossBehaviours.DEFAULT.get());
        }
        this.readAndSetBasePropertiesFromTag(tag);
    }

    private boolean readAndSetBossAI(class_2487 pCompound) {
        if (pCompound.method_10545(BOSS_AI_TAG)) {
            return BossClaySoldierBehaviour.CODEC.parse((DynamicOps)class_2509.field_11560, (Object)pCompound.method_10580(BOSS_AI_TAG)).ifSuccess(this::setBossAI).ifError(err -> LOGGER.error("Error parsing Boss AI: {}", (Object)err.message())).isSuccess();
        }
        return false;
    }

    public static void writeBossAIToTag(BossClaySoldierBehaviour ai, class_2487 pCompound) {
        BossClaySoldierBehaviour.CODEC.encodeStart((DynamicOps)class_2509.field_11560, (Object)ai).ifSuccess(tag -> pCompound.method_10566(BOSS_AI_TAG, tag)).ifError(err -> LOGGER.error("Error saving Boss AI: {}", (Object)err.message()));
    }

    public static void writeBasePropertiesToTag(SoldierPropertyMap properties, class_2487 compound) {
        SoldierPropertyMap.CODEC_FOR_NON_ITEM.encodeStart((DynamicOps)class_2509.field_11560, (Object)properties).ifSuccess(tag -> compound.method_10566(BASE_PROPERTIES_TAG, tag)).ifError(err -> LOGGER.error("Error saving Base Properties: {}", (Object)err.message()));
    }

    private void readAndSetBasePropertiesFromTag(class_2487 compound) {
        if (compound.method_10545(BASE_PROPERTIES_TAG)) {
            SoldierPropertyMap.CODEC_FOR_NON_ITEM.parse((DynamicOps)class_2509.field_11560, (Object)compound.method_10580(BASE_PROPERTIES_TAG)).ifSuccess(this::setBaseProperties).ifError(err -> LOGGER.error("Error parsing Base Properties: {}", (Object)err.message()));
        }
    }

    @Override
    protected void method_5959() {
        this.field_6201.method_6277(0, (class_1352)new ClaySodlierBreathAirGoal(this));
        this.field_6201.method_6277(0, (class_1352)new class_1381((class_1603)this, 1.0, 40, 20.0f));
        this.field_6201.method_6277(1, (class_1352)new ClaySoldierMeleeAttackGoal(this, 1.0, false));
        this.field_6201.method_6277(2, (class_1352)new class_1379((class_1314)this, 1.0));
        this.field_6201.method_6277(3, (class_1352)new class_1376((class_1308)this));
        this.field_6185.method_6277(0, (class_1352)new class_1399((class_1314)this, new Class[]{this.getClass()}));
        this.field_6185.method_6277(1, (class_1352)new ClaySoldierNearestTargetGoal(this, true, x$0 -> this.targetPredicate((class_1309)x$0), this::specificTargetPredicate));
    }

    @Override
    protected void method_5693(class_2945.class_9222 builder) {
        super.method_5693(builder);
        builder.method_56912(BOSS_TYPE, (Object)((byte)BossTypes.NORMAL.ordinal()));
    }

    @Override
    public boolean method_5643(class_1282 source, float amount) {
        boolean aiAllowHurt = true;
        if (this.bossAI != null) {
            aiAllowHurt = this.bossAI.onHurt(this, source);
        }
        if (!aiAllowHurt) {
            return false;
        }
        return super.method_5643(source, amount);
    }

    @Override
    public boolean hasNoTeam() {
        return true;
    }

    @Override
    protected boolean isClayFood(class_1799 stack) {
        return false;
    }

    @Override
    protected WorkSelectorGoal getOrCreateWorkSelectorGoal() {
        return new WorkSelectorGoal(this, List.of());
    }

    @Override
    @Nullable
    public UUID getClayTeamOwnerUUID() {
        return null;
    }

    @Override
    public void sendSpawnPayload(class_3222 tracking) {
        ClaySoldiersCommon.NETWORK_MANGER.sendToPlayer(tracking, new ClayBossSpawnPayload(this));
        super.sendSpawnPayload(tracking);
    }

    public void method_5665(@Nullable class_2561 name) {
        super.method_5665(name);
        this.bossEvent.method_5413(this.method_5476());
    }

    protected void method_5958() {
        if (this.bossAI != null) {
            this.bossAI.getBossEventProgress(this, this.bossEvent);
        }
        if (this.field_6012 % 200 == 0) {
            boolean shouldMinionsGlow;
            this.loadMinions();
            boolean bl = shouldMinionsGlow = this.nextMinionGlow < this.field_6012;
            if (shouldMinionsGlow) {
                this.nextMinionGlow += 400;
            }
            if (this.minions != null) {
                Iterator<BossClaySoldierEntity> each = this.minions.iterator();
                while (each.hasNext()) {
                    BossClaySoldierEntity minion = each.next();
                    if (!minion.method_5805() && minion.getMinionOwner() == null) {
                        each.remove();
                        if (this.minionUUIDs == null) continue;
                        this.minionUUIDs.remove(minion.method_5667());
                        continue;
                    }
                    if (!shouldMinionsGlow) continue;
                    minion.method_6092(new class_1293(class_1294.field_5912, 60, 0, false, false, true));
                }
            }
        }
    }

    @Override
    public void method_5837(class_3222 serverPlayer) {
        super.method_5837(serverPlayer);
        this.bossEvent.method_14088(serverPlayer);
    }

    public void method_5742(class_3222 serverPlayer) {
        super.method_5742(serverPlayer);
        this.bossEvent.method_14088(serverPlayer);
    }

    public void method_5650(class_1297.class_5529 reason) {
        super.method_5650(reason);
        this.bossEvent.method_14094();
    }

    public void setBaseProperties(SoldierPropertyMapReader baseProperties) {
        if (!baseProperties.attackType().compatibleWith(this.getAttackType())) {
            throw new IllegalArgumentException("Cannot set Base Properties of %s as Attack Type %s is not compatible with the Attack Type of the Boss (%s).".formatted(baseProperties, baseProperties.attackType(), this.getAttackType()));
        }
        this.baseProperties.clear();
        this.baseProperties.combineMap(baseProperties);
        this.propertyCombiner.addBaseProperties(baseProperties);
        this.propertyCombiner.combine();
    }

    public SoldierPropertyMap getBaseProperties() {
        return this.baseProperties;
    }

    @Override
    public float getSoldierSize() {
        if (this.allProperties() == null) {
            return 1.0f;
        }
        return Math.max(0.2f, this.allProperties().getSoldierSize());
    }

    @Override
    protected boolean specificTargetPredicate(class_1309 target) {
        return this.targetPredicate(target);
    }

    @Override
    protected boolean dropInventoryOnDeath() {
        return false;
    }

    @Override
    public boolean method_20820(class_1799 pStack) {
        return false;
    }

    @Override
    public boolean method_5939(class_1799 pStack) {
        return pStack.method_31573(ModTags.Items.SOLDIER_BOSS_EQUIPABLE);
    }

    @Override
    public boolean canRevive() {
        return false;
    }

    @Override
    public boolean canBeKilledByItem() {
        return false;
    }

    @Override
    protected OptionalInt openMenuScreen(class_1657 player) {
        return OptionalInt.empty();
    }

    @NotNull
    public BossTypes getBossType() {
        return BossTypes.values()[(Byte)this.field_6011.method_12789(BOSS_TYPE)];
    }

    public void setBossType(@NotNull BossTypes type) {
        if (this.method_37908().method_8608() || !this.getBossAI().isAllowed(type)) {
            return;
        }
        this.field_6011.method_12778(BOSS_TYPE, (Object)((byte)type.ordinal()));
    }

    @Override
    protected void specializedAttack(class_1297 target) {
        if (this.isVampire()) {
            this.method_6025(2.0f);
        }
    }

    @Override
    protected float getAttackPower(class_1297 target) {
        return target instanceof ClayMobEntity ? 10.0f : 1.0f;
    }

    @Override
    public void method_7105(@NotNull class_1309 target, float pVelocity) {
        this.performRangedAttack(target.method_23317(), target.method_23318() + (double)target.method_5751() * 0.5, target.method_23321(), 0.75f);
    }

    private void performRangedAttack(double x, double y, double z, float size) {
        if (!this.method_5701()) {
            this.method_37908().method_8444(null, 1024, this.method_24515(), 0);
        }
        double skullX = this.method_23317();
        double skullY = this.method_23318();
        double skullZ = this.method_23321();
        double dX = x - skullX;
        double dY = y - skullY;
        double dZ = z - skullZ;
        class_243 velocity = new class_243(dX, dY, dZ);
        ClayBlockProjectileEntity clayBlock = new ClayBlockProjectileEntity(this.method_37908(), (class_1309)this, velocity.method_1029());
        clayBlock.method_7432((class_1297)this);
        clayBlock.method_23327(skullX, skullY, skullZ);
        clayBlock.setBlockSize(size);
        this.method_37908().method_8649((class_1297)clayBlock);
    }

    private BossClaySoldierEntity getMinionOwner() {
        if (this.minionOwner != null) {
            return this.minionOwner;
        }
        class_1937 class_19372 = this.method_37908();
        if (class_19372 instanceof class_3218) {
            class_3218 serverLevel = (class_3218)class_19372;
            if (this.minionOwnerUUID != null) {
                this.minionOwner = (BossClaySoldierEntity)serverLevel.method_14190(this.minionOwnerUUID);
            }
        }
        return this.minionOwner;
    }

    private void loadMinions() {
        if (this.minions != null || this.minionUUIDs == null) {
            return;
        }
        class_1937 class_19372 = this.method_37908();
        if (class_19372 instanceof class_3218) {
            class_3218 serverLevel = (class_3218)class_19372;
            this.minions = new ArrayList<BossClaySoldierEntity>(this.minionUUIDs.size());
            Iterator<UUID> uuidIterator = this.minionUUIDs.iterator();
            while (uuidIterator.hasNext()) {
                UUID uuidMinion = uuidIterator.next();
                BossClaySoldierEntity minion = (BossClaySoldierEntity)serverLevel.method_14190(uuidMinion);
                if (minion != null) {
                    this.minions.add(minion);
                    continue;
                }
                uuidIterator.remove();
                LOGGER.error("Minion {} of {} was not found in the world.", (Object)uuidMinion, (Object)this);
            }
        }
    }

    public int getMinionCount() {
        this.loadMinions();
        return this.minions == null ? 0 : this.minions.size();
    }

    public void addAllMinions(List<BossClaySoldierEntity> minionsToAdd) {
        this.loadMinions();
        if (this.minions == null || this.minionUUIDs == null) {
            this.minions = new ArrayList<BossClaySoldierEntity>(minionsToAdd.size());
            this.minionUUIDs = new ArrayList<UUID>(minionsToAdd.size());
        }
        this.minions.addAll(minionsToAdd);
        minionsToAdd.forEach(minion -> this.minionUUIDs.add(minion.method_5667()));
        if (this.minions.size() != this.minionUUIDs.size()) {
            throw new IllegalStateException("Minion UUIDs and Minions do not match");
        }
    }

    public void setMinionOwner(@Nullable BossClaySoldierEntity minionOwner) {
        this.minionOwner = minionOwner;
        this.minionOwnerUUID = minionOwner == null ? null : minionOwner.method_5667();
    }

    public void notifyMinionOwnerOfDeath() {
        if (this.method_37908().method_8608()) {
            return;
        }
        BossClaySoldierEntity minionOwner = this.getMinionOwner();
        if (minionOwner == null) {
            LOGGER.error("{} tried to notify Minion Owner of death, but owner was null.", (Object)this);
            return;
        }
        minionOwner.removeMinion(this);
    }

    private void removeMinion(BossClaySoldierEntity minion) {
        this.loadMinions();
        if (this.minions == null || this.minionUUIDs == null) {
            LOGGER.error("Minion Owner {} of {} did not have minions.", (Object)this, (Object)minion);
            return;
        }
        this.minionUUIDs.remove(minion.method_5667());
        if (!this.minions.remove(minion)) {
            LOGGER.error("Minion Owner {} of {} did not contain this.", (Object)this, (Object)minion);
        }
        if (this.minions.isEmpty()) {
            this.minions = null;
            this.minionUUIDs = null;
        }
    }

    public int getPhaseCompleted() {
        return this.phaseCompleted;
    }

    public void completePhase() {
        ++this.phaseCompleted;
    }

    @Override
    public void method_6078(class_1282 damageSource) {
        if (!this.getBossAI().shouldDie(this)) {
            return;
        }
        super.method_6078(damageSource);
        this.getBossAI().onDeath(this, damageSource);
    }

    protected boolean isUndead() {
        return this.getBossType() != BossTypes.NORMAL;
    }

    protected boolean isVampire() {
        return this.getBossType() == BossTypes.VAMPIRE;
    }

    @Override
    public boolean isZombie() {
        return this.getBossType() == BossTypes.ZOMBIE;
    }

    protected boolean shouldWalkToTarget(@Nullable class_243 pos) {
        return pos == null || !this.isUndead() || !this.method_37908().method_8311(class_2338.method_49638((class_2374)pos));
    }

    @Nullable
    public class_1315 method_5943(class_5425 level, class_1266 difficulty, class_3730 spawnType, @Nullable class_1315 spawnGroupData) {
        if (this.bossAI == null) {
            this.setBossAI(ModBossBehaviours.DEFAULT.get());
        }
        if (!this.baseProperties.isEmpty()) {
            this.setBaseProperties(SoldierPropertyMap.of(SoldierPropertyTypes.SIZE.get().createProperty(Float.valueOf(level.method_8409().method_43057() * 3.0f + 1.0f))));
        }
        return super.method_5943(level, difficulty, spawnType, spawnGroupData);
    }

    public List<class_1799> getBossDeathLoot(class_1282 damageSource) {
        class_1937 class_19372 = this.method_37908();
        if (class_19372 instanceof class_3218) {
            class_3218 serverLevel = (class_3218)class_19372;
            if (this.bossAI != null) {
                class_5321<class_52> lootTableKey = this.bossAI.getLootTable();
                if (lootTableKey == null) {
                    return List.of();
                }
                class_52 lootTable = this.method_37908().method_8503().method_58576().method_58295(lootTableKey);
                class_8567.class_8568 paramBuilder = new class_8567.class_8568(serverLevel).method_51874(class_181.field_1226, (Object)this).method_51874(class_181.field_24424, (Object)this.method_19538()).method_51874(class_181.field_1231, (Object)damageSource).method_51877(class_181.field_1230, (Object)damageSource.method_5529()).method_51877(class_181.field_1227, (Object)damageSource.method_5526());
                if (this.field_6238 > 0 && this.field_6258 != null) {
                    paramBuilder = paramBuilder.method_51874(class_181.field_1233, (Object)this.field_6258).method_51871(this.field_6258.method_7292());
                }
                return lootTable.method_51879(paramBuilder.method_51875(class_173.field_1173), this.method_51851());
            }
        }
        return List.of();
    }

    @Override
    public List<String> getInfoState() {
        List<String> list = super.getInfoState();
        list.add(String.format("Boss Type: %s", new Object[]{this.getBossType()}));
        list.add(String.format("Boss AI: %s", ModRegistries.BOSS_CLAY_SOLDIER_BEHAVIOURS_REGISTRY.method_10221((Object)this.getBossAI())));
        list.add(String.format("Base Properties: %s", this.baseProperties));
        if (!this.method_37908().method_8608()) {
            this.getMinionOwner();
            this.loadMinions();
            list.add("MinionOwner: " + String.valueOf(this.minionOwner) + (this.minionOwnerUUID == null ? "" : " (uuid)"));
            list.add("Minions: " + String.valueOf(this.minions == null ? "null" : Integer.valueOf(this.minions.size())) + " | " + String.valueOf(this.minionUUIDs == null ? "null" : Integer.valueOf(this.minionUUIDs.size())));
            list.add("Phase Completed: " + this.phaseCompleted);
        }
        return list;
    }

    public static enum BossTypes implements class_3542
    {
        NORMAL("normal", event -> event.method_5416(class_1259.class_1260.field_5780)),
        ZOMBIE("zombie", event -> event.method_5416(class_1259.class_1260.field_5785)),
        VAMPIRE("vampire", event -> event.method_5406(true).method_5416(class_1259.class_1260.field_5784));

        public static final Codec<BossTypes> CODEC;
        private final String serializedName;

        private BossTypes(String serializedName, Consumer<class_1259> modifyBossEvent) {
            this.serializedName = serializedName;
        }

        public String method_15434() {
            return this.serializedName;
        }

        static {
            CODEC = class_3542.method_28140(BossTypes::values);
        }
    }
}

