/*
 * Decompiled with CFR 0.152.
 */
package net.bumblebee.claysoldiers.entity.boss;

import com.mojang.serialization.DynamicOps;
import net.bumblebee.claysoldiers.entity.client.ClientClaySoldierEntity;
import net.bumblebee.claysoldiers.entity.soldier.AbstractClaySoldierEntity;
import net.bumblebee.claysoldiers.init.ModDamageTypes;
import net.bumblebee.claysoldiers.init.ModEntityTypes;
import net.bumblebee.claysoldiers.init.ModRegistries;
import net.bumblebee.claysoldiers.team.ClayMobTeam;
import net.bumblebee.claysoldiers.team.ClayMobTeamManger;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1668;
import net.minecraft.class_1890;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2378;
import net.minecraft.class_2388;
import net.minecraft.class_239;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2509;
import net.minecraft.class_2680;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3730;
import net.minecraft.class_3966;
import net.minecraft.class_4048;
import net.minecraft.class_4050;
import net.minecraft.class_5425;
import net.minecraft.class_6880;
import net.minecraft.class_7225;
import net.minecraft.class_7924;
import net.minecraft.class_8080;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClayBlockProjectileEntity
extends class_1668 {
    private static final class_2940<Float> BLOCK_SIZE = class_2945.method_12791(ClayBlockProjectileEntity.class, (class_2941)class_2943.field_13320);
    private static final class_2940<Integer> SOLDIER_TEAM_ID = class_2945.method_12791(ClayBlockProjectileEntity.class, (class_2941)class_2943.field_13327);
    private static final class_2680 CLAY_BLOCKSTATE = class_2246.field_10460.method_9564();
    private static final String BLOCK_SIZE_TAG = "BlockSize";
    private static final String PIERCE_TAG = "PierceCount";
    private static final String SOLDIER_TEAM_ID_TAG = "soldierTeam";
    private static final String LIFETIME_TAG = "LifeTime";
    private static final Logger LOGGER = LoggerFactory.getLogger(ClayBlockProjectileEntity.class);
    private final class_1282 damageSource;
    @Nullable
    private ClientClaySoldierEntity clientSoldier;
    @Nullable
    private class_8080 walkState;
    public int showParticle = 3;
    public int rot = 0;
    private int pierceCount = 0;
    private int lifeTime = 140;

    public ClayBlockProjectileEntity(class_1299<? extends ClayBlockProjectileEntity> entityType, class_1937 level) {
        super(entityType, level);
        this.field_51893 = 0.02;
        this.damageSource = new class_1282((class_6880)level.method_30349().method_30530(class_7924.field_42534).method_40264(ModDamageTypes.CLAY_HURT).orElseThrow(), (class_1297)this, null);
    }

    public ClayBlockProjectileEntity(class_1937 level, class_1309 owner, class_243 movement) {
        super(ModEntityTypes.CLAY_BLOCK_PROJECTILE.get(), owner, movement, level);
        this.field_51893 = 0.02;
        this.damageSource = new class_1282((class_6880)level.method_30349().method_30530(class_7924.field_42534).method_40264(ModDamageTypes.CLAY_HURT).orElseThrow(), (class_1297)this, (class_1297)owner);
    }

    public ClayBlockProjectileEntity(class_1937 level, class_1309 owner, float yOffset) {
        super(ModEntityTypes.CLAY_BLOCK_PROJECTILE.get(), owner.method_23317(), owner.method_23318() + (double)yOffset, owner.method_23321(), level);
        this.field_51893 = 0.02;
        this.method_7432((class_1297)owner);
        this.damageSource = new class_1282((class_6880)level.method_30349().method_30530(class_7924.field_42534).method_40264(ModDamageTypes.CLAY_HURT).orElseThrow(), (class_1297)this, (class_1297)owner);
    }

    public void method_5652(class_2487 compound) {
        super.method_5652(compound);
        if (this.getBlockSize() != 1.0f) {
            compound.method_10548(BLOCK_SIZE_TAG, this.getBlockSize());
        }
        if (this.pierceCount > 0) {
            compound.method_10569(PIERCE_TAG, this.pierceCount);
        }
        if (this.hasClayTeam()) {
            class_2960.field_25139.encodeStart((DynamicOps)class_2509.field_11560, (Object)this.getClayTeam().method_40237().method_29177()).ifSuccess(tag -> compound.method_10566(SOLDIER_TEAM_ID_TAG, tag)).ifError(err -> LOGGER.error("Error saving Clay Team to Tag: {}", (Object)err.message()));
        }
        compound.method_10569(LIFETIME_TAG, this.lifeTime);
    }

    public void method_5749(class_2487 compound) {
        super.method_5749(compound);
        if (compound.method_10573(BLOCK_SIZE_TAG, 99)) {
            this.setBlockSize(Math.max(0.2f, compound.method_10583(BLOCK_SIZE_TAG)));
        }
        if (compound.method_10573(PIERCE_TAG, 3)) {
            this.setPierceCount(compound.method_10550(PIERCE_TAG));
        }
        if (compound.method_10545(SOLDIER_TEAM_ID_TAG)) {
            class_2960.field_25139.parse((DynamicOps)class_2509.field_11560, (Object)compound.method_10580(SOLDIER_TEAM_ID_TAG)).ifSuccess(this::setClayTeam).ifError(err -> LOGGER.error("Error reading Clay Team: {}", (Object)err.message()));
        }
        if (compound.method_10573(LIFETIME_TAG, 3)) {
            this.lifeTime = compound.method_10550(LIFETIME_TAG);
        }
    }

    protected void method_5693(class_2945.class_9222 builder) {
        super.method_5693(builder);
        builder.method_56912(BLOCK_SIZE, (Object)Float.valueOf(1.0f));
        builder.method_56912(SOLDIER_TEAM_ID, (Object)-1);
    }

    protected void method_7454(class_3966 result) {
        super.method_7454(result);
        class_1937 class_19372 = this.method_37908();
        if (class_19372 instanceof class_3218) {
            class_3218 serverlevel = (class_3218)class_19372;
            class_1297 entity = result.method_17782();
            class_1297 class_12972 = this.method_24921();
            if (class_12972 instanceof class_1309) {
                class_1309 livingentity = (class_1309)class_12972;
                boolean didHurt = entity.method_5643(this.damageSource, 4.0f * this.getBlockSize());
                if (didHurt) {
                    if (entity.method_5805()) {
                        class_1890.method_60107((class_3218)serverlevel, (class_1297)entity, (class_1282)this.damageSource);
                    } else {
                        livingentity.method_6025(2.0f);
                    }
                }
            } else {
                entity.method_5643(this.method_48923().method_48831(), 2.5f * this.getBlockSize());
            }
        }
    }

    protected void method_7488(class_239 result) {
        super.method_7488(result);
        this.onHitEffect(result, false);
    }

    private void onHitEffect(@Nullable class_239 hitResult, boolean forceDelete) {
        if (!this.method_37908().method_8608()) {
            if (forceDelete || this.pierceCount < 0 || hitResult.method_17783() == class_239.class_240.field_1332) {
                if (this.hasClayTeam()) {
                    this.spawnSoldier((class_3218)this.method_37908());
                }
                this.method_31472();
            } else {
                --this.pierceCount;
            }
        } else {
            float particleOffset = 0.08f;
            int i = 0;
            while ((float)i < 5.0f * Math.max(1.0f, this.getBlockSize() * this.getBlockSize())) {
                this.method_37908().method_8406((class_2394)new class_2388(class_2398.field_11217, CLAY_BLOCKSTATE), this.method_23317(), this.method_23318(), this.method_23321(), ((double)this.method_59922().method_43057() - 0.5) * (double)particleOffset, ((double)this.method_59922().method_43057() - 0.5) * (double)particleOffset, ((double)this.method_59922().method_43057() - 0.5) * (double)particleOffset);
                ++i;
            }
        }
    }

    private void spawnSoldier(class_3218 level) {
        AbstractClaySoldierEntity soldier = (AbstractClaySoldierEntity)ModEntityTypes.CLAY_SOLDIER_ENTITY.get().method_5883((class_1937)level);
        if (soldier != null) {
            class_243 pos = this.method_19538();
            class_2960 team = this.getClayTeam().method_40237().method_29177();
            soldier.setClayTeamType(team);
            soldier.method_33574(pos);
            soldier.setSpawnedFrom(ClayMobTeamManger.createStackForTeam(team, (class_7225.class_7874)level.method_30349()), false);
            soldier.method_60949(pos, this.method_36454(), this.method_36455());
            soldier.field_6241 = soldier.method_36454();
            soldier.field_6283 = soldier.method_36454();
            soldier.method_5943((class_5425)level, level.method_8404(soldier.method_24515()), class_3730.field_16471, null);
            level.method_8649((class_1297)soldier);
        }
    }

    public boolean method_5643(class_1282 source, float amount) {
        return false;
    }

    protected boolean method_7468() {
        return false;
    }

    public boolean method_5809() {
        return false;
    }

    @Nullable
    protected class_2394 method_7467() {
        if (this.showParticle++ >= 3) {
            this.showParticle = 0;
            return new class_2388(class_2398.field_11206, class_2246.field_10460.method_9564());
        }
        return null;
    }

    public void setBlockSize(float size) {
        this.field_6011.method_12778(BLOCK_SIZE, (Object)Float.valueOf(size));
    }

    public float getBlockSize() {
        return ((Float)this.field_6011.method_12789(BLOCK_SIZE)).floatValue();
    }

    public void method_5674(class_2940<?> key) {
        super.method_5674(key);
        if (BLOCK_SIZE.equals(key)) {
            this.method_18382();
        }
        if (SOLDIER_TEAM_ID.equals(key) && this.method_37908().method_8608()) {
            class_6880.class_6883<ClayMobTeam> holder = this.getClayTeam();
            if (holder != null) {
                this.walkState = new class_8080();
                this.clientSoldier = ClientClaySoldierEntity.createAsProjectile(this.walkState, holder);
            } else {
                this.clientSoldier = null;
                this.walkState = null;
            }
        }
    }

    public class_4048 method_18377(class_4050 pose) {
        return super.method_18377(pose).method_18383(this.getBlockSize());
    }

    public void setPierceCount(int pierceCount) {
        this.pierceCount = pierceCount;
    }

    public void setClayTeam(class_2960 id) {
        ClayMobTeamManger.getOptional(id, (class_7225.class_7874)this.method_56673()).ifPresentOrElse(team -> this.field_6011.method_12778(SOLDIER_TEAM_ID, (Object)this.method_56673().method_30530(ModRegistries.CLAY_MOB_TEAMS).method_10206(team)), () -> LOGGER.error("Error Setting Team {} for Clay Block Projectile", (Object)id));
    }

    public boolean hasClayTeam() {
        return (Integer)this.field_6011.method_12789(SOLDIER_TEAM_ID) >= 0;
    }

    @Nullable
    private class_6880.class_6883<ClayMobTeam> getClayTeam() {
        class_2378 reg = this.method_56673().method_30530(ModRegistries.CLAY_MOB_TEAMS);
        return reg.method_40265(((Integer)this.field_6011.method_12789(SOLDIER_TEAM_ID)).intValue()).orElse(null);
    }

    @Nullable
    public ClientClaySoldierEntity getClientSoldier() {
        return this.clientSoldier;
    }

    public void clientTick(float partialTick) {
        if (this.walkState != null) {
            float f = Math.min(partialTick * 4.0f, 1.0f);
            this.walkState.method_48568(f, 0.4f);
        }
    }

    public void method_5773() {
        super.method_5773();
        --this.lifeTime;
        if (this.lifeTime <= 0) {
            this.onHitEffect(null, true);
        }
    }
}

