/*
 * Decompiled with CFR 0.152.
 */
package net.bumblebee.claysoldiers.entity.boss;

import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import net.bumblebee.claysoldiers.ClaySoldiersCommon;
import net.bumblebee.claysoldiers.datamap.SoldierEquipmentSlot;
import net.bumblebee.claysoldiers.entity.boss.BossClaySoldierBehaviour;
import net.bumblebee.claysoldiers.entity.boss.BossClaySoldierEntity;
import net.bumblebee.claysoldiers.entity.boss.RandomSoldierPropertyGenerator;
import net.bumblebee.claysoldiers.init.ModBossBehaviours;
import net.bumblebee.claysoldiers.init.ModRegistries;
import net.bumblebee.claysoldiers.init.ModTags;
import net.bumblebee.claysoldiers.soldierproperties.SoldierProperty;
import net.bumblebee.claysoldiers.soldierproperties.SoldierPropertyMap;
import net.bumblebee.claysoldiers.soldierproperties.SoldierPropertyMapReader;
import net.bumblebee.claysoldiers.soldierproperties.SoldierPropertyTypes;
import net.bumblebee.claysoldiers.team.ClayMobTeamManger;
import net.minecraft.class_156;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2960;
import net.minecraft.class_5819;
import org.jetbrains.annotations.Nullable;

public enum ClaySoldierBossEquipment {
    NORMAL(ModBossBehaviours.DEFAULT, Map.of(), () -> SoldierPropertyMap.of(new SoldierProperty<Float>(SoldierPropertyTypes.SIZE.get(), Float.valueOf(5.0f)), SoldierPropertyTypes.ATTACK_RANGE.get().createProperty(Float.valueOf(1.0f)))),
    VAMPIRE(ModBossBehaviours.VAMPIRE, Map.of(), () -> SoldierPropertyMap.of(new SoldierProperty<Float>(SoldierPropertyTypes.SIZE.get(), Float.valueOf(4.0f)), new SoldierProperty<Float>(SoldierPropertyTypes.ATTACK_RANGE.get(), Float.valueOf(1.0f)))),
    ZOMBIE(ModBossBehaviours.ZOMBIE, Map.of(), () -> SoldierPropertyMap.of(new SoldierProperty<Float>(SoldierPropertyTypes.SIZE.get(), Float.valueOf(4.0f)), new SoldierProperty<Float>(SoldierPropertyTypes.ATTACK_RANGE.get(), Float.valueOf(1.0f)))),
    RANDOM((boss, weight, team, waxed) -> ClaySoldierBossEquipment.setUpRandom(boss, weight));

    private final SetupFunction generator;

    private ClaySoldierBossEquipment(Supplier<BossClaySoldierBehaviour> bossAI, Map<SoldierEquipmentSlot, Supplier<class_1799>> equipment, Supplier<SoldierPropertyMap> baseProperties) {
        this((boss, weight, team, waxed) -> {
            boss.setBaseProperties((SoldierPropertyMapReader)baseProperties.get());
            if (team == null) {
                team = class_156.method_40083(boss.method_56673().method_30530(ModRegistries.CLAY_MOB_TEAMS).method_10235().stream().filter(t -> !t.equals((Object)ClayMobTeamManger.NO_TEAM_TYPE)).toList(), (class_5819)boss.method_59922()).orElse(ClayMobTeamManger.DEFAULT_TYPE);
            }
            boss.setClayTeamType(team);
            equipment.forEach((slot, item) -> boss.setItemSlot((SoldierEquipmentSlot)slot, (class_1799)item.get()));
            boss.setWaxed(waxed);
            boss.setBossAI((BossClaySoldierBehaviour)bossAI.get());
        });
    }

    private ClaySoldierBossEquipment(SetupFunction generator) {
        this.generator = generator;
    }

    public void setUp(BossClaySoldierEntity boss, int weight, @Nullable class_2960 team, boolean waxed) {
        this.generator.setUp(boss, weight, team, waxed);
    }

    public static void setUpRandom(BossClaySoldierEntity boss, int weight) {
        class_5819 random = boss.method_59922();
        class_2960 team = class_156.method_40083(boss.method_56673().method_30530(ModRegistries.CLAY_MOB_TEAMS).method_10235().stream().filter(t -> !t.equals((Object)ClayMobTeamManger.NO_TEAM_TYPE)).toList(), (class_5819)random).orElse(ClayMobTeamManger.DEFAULT_TYPE);
        boss.setBossAI((BossClaySoldierBehaviour)((Supplier)class_156.method_32309(List.of(ModBossBehaviours.VAMPIRE, ModBossBehaviours.DEFAULT), (class_5819)random)).get());
        boss.setClayTeamType(team);
        if (weight <= 0) {
            return;
        }
        if (random.method_43056()) {
            --weight;
            boss.setWaxed(true);
        }
        for (SoldierEquipmentSlot slot : SoldierEquipmentSlot.values()) {
            if (weight <= 0) break;
            if (!random.method_43056()) continue;
            Optional opt = class_156.method_40083(ClaySoldiersCommon.DATA_MAP.getHoldableEffectForSlot(slot), (class_5819)random);
            if (opt.isPresent() && ((class_1792)opt.get()).method_7854().method_31573(ModTags.Items.SOLDIER_BOSS_EQUIPABLE)) {
                boss.setItemSlot(slot, ((class_1792)opt.orElseThrow()).method_7854());
                --weight;
                continue;
            }
            Optional opt2 = class_156.method_40083(ClaySoldiersCommon.DATA_MAP.getHoldableEffectForSlot(slot), (class_5819)random);
            if (!opt2.isPresent() || !((class_1792)opt2.get()).method_7854().method_31573(ModTags.Items.SOLDIER_BOSS_EQUIPABLE)) continue;
            boss.setItemSlot(slot, ((class_1792)opt2.orElseThrow()).method_7854());
            --weight;
        }
        SoldierPropertyMap map = RandomSoldierPropertyGenerator.generateRandom(random, weight + 3, RandomSoldierPropertyGenerator.BOSS);
        RandomSoldierPropertyGenerator.generateRandom(random, RandomSoldierPropertyGenerator.BOSS_WEIGHTLESS.size(), RandomSoldierPropertyGenerator.BOSS_WEIGHTLESS).forEach(map::addPropertyForce);
        boss.setBaseProperties(map);
    }

    private static interface SetupFunction {
        public void setUp(BossClaySoldierEntity var1, int var2, @Nullable class_2960 var3, boolean var4);
    }
}

