/*
 * Decompiled with CFR 0.152.
 */
package net.bumblebee.claysoldiers.entity.boss;

import java.util.Collection;
import java.util.Set;
import net.bumblebee.claysoldiers.soldierproperties.SoldierProperty;
import net.bumblebee.claysoldiers.soldierproperties.SoldierPropertyMap;
import net.bumblebee.claysoldiers.soldierproperties.SoldierPropertyType;
import net.bumblebee.claysoldiers.soldierproperties.SoldierPropertyTypes;
import net.bumblebee.claysoldiers.soldierproperties.combined.SoldierPropertyCombinedMap;
import net.bumblebee.claysoldiers.soldierproperties.customproperties.DamageBlock;
import net.bumblebee.claysoldiers.soldierproperties.customproperties.UnitProperty;
import net.minecraft.class_5819;
import org.jetbrains.annotations.Nullable;

public interface RandomSoldierPropertyGenerator<T> {
    public static final RandomSoldierPropertyGenerator<Float> SIZE_GENERATOR = RandomSoldierPropertyGenerator.createFloatRange(SoldierPropertyTypes.SIZE.get(), 0.5f, 10.0f);
    public static final RandomSoldierPropertyGenerator<Float> OPTIONAL_PROTECTION_GENERATOR = RandomSoldierPropertyGenerator.createOptionalFloatRange(SoldierPropertyTypes.PROTECTION.get(), 0.0f, 20.0f);
    public static final RandomSoldierPropertyGenerator<Float> OPTIONAL_DAMAGE_GENERATOR = RandomSoldierPropertyGenerator.createOptionalFloatRange(SoldierPropertyTypes.DAMAGE.get(), 0.0f, 5.0f);
    public static final RandomSoldierPropertyGenerator<Float> OPTIONAL_HEAVY_GENERATOR = RandomSoldierPropertyGenerator.createOptionalFloatRange(SoldierPropertyTypes.HEAVY.get(), 0.0f, 5.0f);
    public static final RandomSoldierPropertyGenerator<Float> OPTIONAL_ATTACK_RANGE_GENERATOR = RandomSoldierPropertyGenerator.createOptionalFloatRange(SoldierPropertyTypes.ATTACK_RANGE.get(), 0.0f, 0.5f);
    public static final RandomSoldierPropertyGenerator<UnitProperty> BOUNCE_GENERATOR = RandomSoldierPropertyGenerator.createUnit(SoldierPropertyTypes.BOUNCE.get());
    public static final RandomSoldierPropertyGenerator<UnitProperty> GLOW_GENERATOR = RandomSoldierPropertyGenerator.createUnit(SoldierPropertyTypes.GLOW_IN_THE_DARK.get());
    public static final RandomSoldierPropertyGenerator<UnitProperty> GLOW_OUTLINE_GENERATOR = RandomSoldierPropertyGenerator.createUnit(SoldierPropertyTypes.GLOW_OUTLINE.get());
    public static final RandomSoldierPropertyGenerator<UnitProperty> CAN_SWIM = RandomSoldierPropertyGenerator.createConstant(SoldierPropertyTypes.BOUNCE.get());
    public static final RandomSoldierPropertyGenerator<UnitProperty> SEE_INVISIBILITY = RandomSoldierPropertyGenerator.createConstant(SoldierPropertyTypes.BOUNCE.get());
    public static final RandomSoldierPropertyGenerator<Integer> OPTIONAL_BREATH_HOLD = RandomSoldierPropertyGenerator.createOptionalIntRange(SoldierPropertyTypes.BREATH_HOLD.get(), 0, 1000);
    public static final RandomSoldierPropertyGenerator<Float> OPTIONAL_EXPLOSION_RESISTANCE = RandomSoldierPropertyGenerator.createOptionalFloatRange(SoldierPropertyTypes.EXPLOSION_RESISTANCE.get(), 0.0f, 20.0f);
    public static final RandomSoldierPropertyGenerator<DamageBlock> OPTIONAL_DAMAGE_BLOCK = random -> {
        if (random.method_43056()) {
            return null;
        }
        return new SoldierProperty<DamageBlock>(SoldierPropertyTypes.DAMAGE_BLOCK.get(), new DamageBlock(RandomSoldierPropertyGenerator.floatRange(random, 0.1f, 1.0f), random.method_39332(1, 5)));
    };
    public static final RandomSoldierPropertyGenerator<Integer> OPTIONAL_SET_ON_FIRE = RandomSoldierPropertyGenerator.createOptionalIntRange(SoldierPropertyTypes.SET_ON_FIRE.get(), 0, 2);
    public static final Set<RandomSoldierPropertyGenerator<?>> BOSS = Set.of(CAN_SWIM, SEE_INVISIBILITY, SIZE_GENERATOR, OPTIONAL_PROTECTION_GENERATOR, OPTIONAL_SET_ON_FIRE, OPTIONAL_DAMAGE_GENERATOR, OPTIONAL_DAMAGE_BLOCK, OPTIONAL_HEAVY_GENERATOR, OPTIONAL_ATTACK_RANGE_GENERATOR);
    public static final Set<RandomSoldierPropertyGenerator<?>> BOSS_WEIGHTLESS = Set.of(BOUNCE_GENERATOR, GLOW_GENERATOR, GLOW_OUTLINE_GENERATOR, OPTIONAL_BREATH_HOLD, OPTIONAL_EXPLOSION_RESISTANCE);

    public static SoldierPropertyMap generateRandom(class_5819 random, int maxWeight, Collection<RandomSoldierPropertyGenerator<?>> generators) {
        if (generators.isEmpty()) {
            return SoldierPropertyMap.EMPTY_MAP;
        }
        SoldierPropertyCombinedMap map = new SoldierPropertyCombinedMap();
        for (RandomSoldierPropertyGenerator<?> gen : generators) {
            SoldierProperty<?> res = gen.generate(random);
            if (res == null) continue;
            map.combineProperty(res);
            if (--maxWeight > 0) continue;
            return map;
        }
        return map;
    }

    private static RandomSoldierPropertyGenerator<Float> createFloatRange(SoldierPropertyType<Float> type, float min, float max) {
        return random -> new SoldierProperty<Float>(type, Float.valueOf(RandomSoldierPropertyGenerator.floatRange(random, min, max)));
    }

    private static RandomSoldierPropertyGenerator<Float> createOptionalFloatRange(SoldierPropertyType<Float> type, float min, float max) {
        return random -> random.method_43056() ? RandomSoldierPropertyGenerator.createFloatRange(type, min, max).generate(random) : null;
    }

    private static RandomSoldierPropertyGenerator<UnitProperty> createUnit(SoldierPropertyType<UnitProperty> type) {
        return random -> random.method_43056() ? SoldierProperty.unit(type) : null;
    }

    private static RandomSoldierPropertyGenerator<UnitProperty> createConstant(SoldierPropertyType<UnitProperty> type) {
        return random -> SoldierProperty.unit(type);
    }

    private static RandomSoldierPropertyGenerator<Integer> createOptionalIntRange(SoldierPropertyType<Integer> type, int min, int max) {
        return random -> new SoldierProperty<Integer>(type, random.method_39332(min, max));
    }

    private static float floatRange(class_5819 random, float min, float max) {
        return min + (random.method_43057() * max - min);
    }

    @Nullable
    public SoldierProperty<T> generate(class_5819 var1);
}

