/*
 * Decompiled with CFR 0.152.
 */
package net.bumblebee.claysoldiers.entity.client;

import net.bumblebee.claysoldiers.ClaySoldiersCommon;
import net.bumblebee.claysoldiers.datamap.SoldierEquipmentSlot;
import net.bumblebee.claysoldiers.entity.client.ClayMobStatusRenderlayer;
import net.bumblebee.claysoldiers.entity.client.ClaySoldierArmorLayer;
import net.bumblebee.claysoldiers.entity.client.ClaySoldierModel;
import net.bumblebee.claysoldiers.entity.client.WaxedRenderLayer;
import net.bumblebee.claysoldiers.entity.client.accesories.AccessoryRenderLayer;
import net.bumblebee.claysoldiers.entity.soldier.AbstractClaySoldierEntity;
import net.bumblebee.claysoldiers.team.ClayMobTeam;
import net.minecraft.class_1297;
import net.minecraft.class_1306;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1799;
import net.minecraft.class_1921;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_3883;
import net.minecraft.class_3887;
import net.minecraft.class_4050;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_5253;
import net.minecraft.class_5602;
import net.minecraft.class_5617;
import net.minecraft.class_572;
import net.minecraft.class_759;
import net.minecraft.class_7833;
import net.minecraft.class_811;
import net.minecraft.class_909;
import net.minecraft.class_976;
import net.minecraft.class_989;

public abstract class AbstractClaySoldierRenderer
extends class_909<AbstractClaySoldierEntity, ClaySoldierModel> {
    private static final float SCALE = 0.25f;
    private final class_759 itemInHandRenderer;

    protected AbstractClaySoldierRenderer(class_5617.class_5618 pContext, ClaySoldierModel model) {
        super(pContext, (class_572)model, 0.125f, 0.25f, 0.25f, 0.25f);
        this.field_4738.removeIf(layer -> layer.getClass() == class_976.class || layer.getClass() == class_989.class);
        this.itemInHandRenderer = pContext.method_43338();
        this.method_4046(new ClaySoldierArmorLayer((class_3883<AbstractClaySoldierEntity, ClaySoldierModel>)this, new ClaySoldierModel(pContext.method_32167(class_5602.field_27642)), new ClaySoldierModel(pContext.method_32167(class_5602.field_27643)), pContext.method_48481(), pContext.method_32168()));
        this.method_4046(new AccessoryRenderLayer((class_3883<AbstractClaySoldierEntity, ClaySoldierModel>)this, pContext.method_32170(), this.itemInHandRenderer, pContext.method_32168()));
        this.method_4046(new ClayMobStatusRenderlayer(this, pContext.method_32166(), pContext.method_32168()));
        this.method_4046(new WaxedRenderLayer(this));
        this.method_4046((class_3887)new ClaySoldierItemInHandLayer((class_3883<AbstractClaySoldierEntity, ClaySoldierModel>)this, this.itemInHandRenderer));
    }

    protected void scale(AbstractClaySoldierEntity claySoldier, class_4587 poseStack, float partialTickTime) {
        poseStack.method_22905(0.25f, 0.25f, 0.25f);
        this.scaleExplode(claySoldier, poseStack, partialTickTime);
    }

    public void render(AbstractClaySoldierEntity claySoldier, float pEntityYaw, float pPartialTicks, class_4587 pPoseStack, class_4597 pBuffer, int pPackedLight) {
        boolean shouldGlow;
        boolean bodyVisible;
        class_2350 direction;
        class_1297 vehicle;
        boolean shouldSit;
        pPoseStack.method_22903();
        ((ClaySoldierModel)this.field_4737).field_3447 = this.method_4044((class_1309)claySoldier, pPartialTicks);
        ((ClaySoldierModel)this.field_4737).field_3449 = shouldSit = claySoldier.method_5765() && claySoldier.method_5854() != null && ClaySoldiersCommon.COMMON_HOOKS.shouldRiderSit(claySoldier.method_5854());
        ((ClaySoldierModel)this.field_4737).field_3448 = claySoldier.method_6109();
        float yBodyRot = class_3532.method_17821((float)pPartialTicks, (float)claySoldier.field_6220, (float)claySoldier.field_6283);
        float yHeadRot = class_3532.method_17821((float)pPartialTicks, (float)claySoldier.field_6259, (float)claySoldier.field_6241);
        float netHeadYaw = yHeadRot - yBodyRot;
        if (shouldSit && claySoldier.method_5854() instanceof class_1309 && (vehicle = claySoldier.method_5854()) instanceof class_1309) {
            class_1309 livingentity = (class_1309)vehicle;
            yBodyRot = class_3532.method_17821((float)pPartialTicks, (float)livingentity.field_6220, (float)livingentity.field_6283);
            netHeadYaw = yHeadRot - yBodyRot;
            float f6 = class_3532.method_15393((float)netHeadYaw);
            if (f6 < -85.0f) {
                f6 = -85.0f;
            }
            if (f6 >= 85.0f) {
                f6 = 85.0f;
            }
            yBodyRot = yHeadRot - f6;
            if (f6 * f6 > 2500.0f) {
                yBodyRot += f6 * 0.2f;
            }
            netHeadYaw = yHeadRot - yBodyRot;
        }
        float headPitch = class_3532.method_16439((float)pPartialTicks, (float)claySoldier.field_6004, (float)claySoldier.method_36455());
        if (AbstractClaySoldierRenderer.method_38563((class_1309)claySoldier)) {
            headPitch *= -1.0f;
            netHeadYaw *= -1.0f;
        }
        netHeadYaw = class_3532.method_15393((float)netHeadYaw);
        if (claySoldier.method_41328(class_4050.field_18078) && (direction = claySoldier.method_18401()) != null) {
            float f3 = claySoldier.method_18381(class_4050.field_18076) - 0.1f;
            pPoseStack.method_46416((float)(-direction.method_10148()) * f3, 0.0f, (float)(-direction.method_10165()) * f3);
        }
        float ageInTicks = this.method_4045((class_1309)claySoldier, pPartialTicks);
        float scale = claySoldier.method_55693();
        pPoseStack.method_22905(scale, scale, scale);
        this.method_4058((class_1309)claySoldier, pPoseStack, ageInTicks, yBodyRot, pPartialTicks, 1.0f);
        pPoseStack.method_22905(-1.0f, -1.0f, 1.0f);
        this.scale(claySoldier, pPoseStack, pPartialTicks);
        pPoseStack.method_46416(0.0f, -1.501f, 0.0f);
        float limbSwingAmount = 0.0f;
        float limbSwing = 0.0f;
        if (!shouldSit && claySoldier.method_5805()) {
            limbSwingAmount = claySoldier.getWalkAnimation().method_48570(pPartialTicks);
            limbSwing = claySoldier.getWalkAnimation().method_48572(pPartialTicks);
            if (claySoldier.method_6109()) {
                limbSwing *= 3.0f;
            }
            if (limbSwingAmount > 1.0f) {
                limbSwingAmount = 1.0f;
            }
        }
        ((ClaySoldierModel)this.field_4737).method_17086((class_1309)claySoldier, limbSwing, limbSwingAmount, pPartialTicks);
        ((ClaySoldierModel)this.field_4737).setupAnim(claySoldier, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
        if (claySoldier.getRidingPose() == AbstractClaySoldierEntity.RidingPose.FIREWORK) {
            pPoseStack.method_22904(0.0, 0.5, 0.0);
        }
        class_310 minecraft = class_310.method_1551();
        boolean isInvisible = !(bodyVisible = this.isBodyVisible(claySoldier));
        class_1921 rendertype = this.method_24302((class_1309)claySoldier, bodyVisible, isInvisible, shouldGlow = minecraft.method_27022((class_1297)claySoldier));
        if (rendertype != null) {
            class_4588 vertexconsumer = pBuffer.getBuffer(rendertype);
            int overlay = AbstractClaySoldierRenderer.method_23622((class_1309)claySoldier, (float)this.getWhiteOverlayProgress(claySoldier, pPartialTicks));
            ClayMobTeam variant = this.getVariantForColor(claySoldier);
            this.renderModel(claySoldier, pPoseStack, vertexconsumer, pPackedLight, overlay, variant.getColor((class_1309)claySoldier, pPartialTicks), isInvisible ? 38 : 255);
        }
        for (class_3887 renderlayer : this.field_4738) {
            renderlayer.method_4199(pPoseStack, pBuffer, pPackedLight, (class_1297)claySoldier, limbSwing, limbSwingAmount, pPartialTicks, ageInTicks, netHeadYaw, headPitch);
        }
        this.renderCarried(claySoldier, pPoseStack, pBuffer, pPackedLight);
        pPoseStack.method_22909();
        if (this.method_4071((class_1308)claySoldier)) {
            this.method_3926((class_1297)claySoldier, claySoldier.method_5476(), pPoseStack, pBuffer, pPackedLight, pPartialTicks);
        }
    }

    protected void renderModel(AbstractClaySoldierEntity soldier, class_4587 pPoseStack, class_4588 vertexConsumer, int pPackedLight, int overlayCords, int color, int alpha) {
        ((ClaySoldierModel)this.field_4737).method_2828(pPoseStack, vertexConsumer, pPackedLight, overlayCords, class_5253.class_5254.method_58144((int)alpha, (int)color));
    }

    protected ClayMobTeam getVariantForColor(AbstractClaySoldierEntity claySoldier) {
        return claySoldier.getClayTeam();
    }

    private void renderCarried(AbstractClaySoldierEntity soldier, class_4587 pPoseStack, class_4597 pBuffer, int pPackedLight) {
        if (!soldier.getCarriedStack().method_7960()) {
            pPoseStack.method_22903();
            pPoseStack.method_22904(0.0, -0.55, 0.0);
            pPoseStack.method_22907(class_7833.field_40716.rotationDegrees(135.0f));
            pPoseStack.method_22907(class_7833.field_40714.rotationDegrees(90.0f));
            pPoseStack.method_22905(1.5f, 1.5f, 1.5f);
            this.itemInHandRenderer.method_3233((class_1309)soldier, soldier.getCarriedStack(), class_811.field_4319, false, pPoseStack, pBuffer, pPackedLight);
            pPoseStack.method_22909();
        }
    }

    private void scaleExplode(AbstractClaySoldierEntity claySoldier, class_4587 pPoseStack, float pPartialTickTime) {
        float swelling = claySoldier.getSwelling(pPartialTickTime);
        float f1 = 1.0f + class_3532.method_15374((float)(swelling * 100.0f)) * swelling * 0.01f;
        swelling = class_3532.method_15363((float)swelling, (float)0.0f, (float)1.0f);
        swelling *= swelling;
        swelling *= swelling;
        float f2 = (1.0f + swelling * 0.4f) * f1;
        float f3 = (1.0f + swelling * 0.1f) / f1;
        pPoseStack.method_22905(f2, f3, f2);
    }

    protected float getWhiteOverlayProgress(AbstractClaySoldierEntity claySoldier, float pPartialTicks) {
        float swelling = claySoldier.getSwelling(pPartialTicks);
        return (int)(swelling * 10.0f) % 2 == 0 ? 0.0f : class_3532.method_15363((float)swelling, (float)0.5f, (float)1.0f);
    }

    protected int getBlockLightLevel(AbstractClaySoldierEntity pEntity, class_2338 pPos) {
        return pEntity.allProperties().isGlowing() ? 15 : super.method_24087((class_1297)pEntity, pPos);
    }

    protected boolean isBodyVisible(AbstractClaySoldierEntity livingEntity) {
        return super.method_4056((class_1309)livingEntity) && !livingEntity.allProperties().isInvisible();
    }

    public String toString() {
        return ((Object)((Object)this)).getClass().getSimpleName();
    }

    private static class ClaySoldierItemInHandLayer
    extends class_989<AbstractClaySoldierEntity, ClaySoldierModel> {
        public ClaySoldierItemInHandLayer(class_3883<AbstractClaySoldierEntity, ClaySoldierModel> renderer, class_759 itemInHandRenderer) {
            super(renderer, itemInHandRenderer);
        }

        protected void method_4192(class_1309 livingEntity, class_1799 itemStack, class_811 displayContext, class_1306 arm, class_4587 poseStack, class_4597 buffer, int packedLight) {
            if (arm == class_1306.field_6182 && ((AbstractClaySoldierEntity)livingEntity).handsOccupied(SoldierEquipmentSlot.OFFHAND)) {
                return;
            }
            if (arm == class_1306.field_6183 && ((AbstractClaySoldierEntity)livingEntity).handsOccupied(SoldierEquipmentSlot.MAINHAND)) {
                return;
            }
            super.method_4192(livingEntity, itemStack, displayContext, arm, poseStack, buffer, packedLight);
        }
    }
}

