/*
 * Decompiled with CFR 0.152.
 */
package net.bumblebee.claysoldiers.entity.client;

import com.google.common.collect.Maps;
import java.util.Locale;
import java.util.Map;
import net.bumblebee.claysoldiers.ClaySoldiersClient;
import net.bumblebee.claysoldiers.datamap.SoldierEquipmentSlot;
import net.bumblebee.claysoldiers.datamap.armor.ClientSoldierWearableEffect;
import net.bumblebee.claysoldiers.datamap.armor.ClientWearableRenderer;
import net.bumblebee.claysoldiers.datamap.armor.SoldierWearableEffect;
import net.bumblebee.claysoldiers.entity.client.ClaySoldierModel;
import net.bumblebee.claysoldiers.entity.client.SlimeRootLayer;
import net.bumblebee.claysoldiers.entity.soldier.AbstractClaySoldierEntity;
import net.bumblebee.claysoldiers.item.itemeffectholder.ItemStackWithEffect;
import net.minecraft.class_1059;
import net.minecraft.class_1092;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1738;
import net.minecraft.class_1741;
import net.minecraft.class_1799;
import net.minecraft.class_2960;
import net.minecraft.class_3879;
import net.minecraft.class_3883;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_4722;
import net.minecraft.class_6880;
import net.minecraft.class_918;
import org.jetbrains.annotations.Nullable;

public class ClaySoldierArmorLayer
extends SlimeRootLayer<AbstractClaySoldierEntity, ClaySoldierModel> {
    private static final Map<String, class_2960> ARMOR_LOCATION_CACHE = Maps.newHashMap();
    private final ClaySoldierModel innerModel;
    private final ClaySoldierModel outerModel;
    private final class_1059 armorTrimAtlas;

    public ClaySoldierArmorLayer(class_3883<AbstractClaySoldierEntity, ClaySoldierModel> pRenderer, ClaySoldierModel pInnerModel, ClaySoldierModel pOuterModel, class_1092 pModelManager, class_918 itemRenderer) {
        super(pRenderer, itemRenderer);
        this.innerModel = pInnerModel;
        this.outerModel = pOuterModel;
        this.armorTrimAtlas = pModelManager.method_24153(class_4722.field_42071);
    }

    public void render(class_4587 pPoseStack, class_4597 pBuffer, int pPackedLight, AbstractClaySoldierEntity pLivingEntity, float pLimbSwing, float pLimbSwingAmount, float pPartialTicks, float pAgeInTicks, float pNetHeadYaw, float pHeadPitch) {
        this.renderArmorPiece(pPoseStack, pBuffer, pLivingEntity, SoldierEquipmentSlot.CHEST, pPackedLight, this.getArmorModel(SoldierEquipmentSlot.CHEST), pPartialTicks);
        this.renderArmorPiece(pPoseStack, pBuffer, pLivingEntity, SoldierEquipmentSlot.LEGS, pPackedLight, this.getArmorModel(SoldierEquipmentSlot.LEGS), pPartialTicks);
        this.renderArmorPiece(pPoseStack, pBuffer, pLivingEntity, SoldierEquipmentSlot.FEET, pPackedLight, this.getArmorModel(SoldierEquipmentSlot.FEET), pPartialTicks);
        this.renderArmorPiece(pPoseStack, pBuffer, pLivingEntity, SoldierEquipmentSlot.HEAD, pPackedLight, this.getArmorModel(SoldierEquipmentSlot.HEAD), pPartialTicks);
        this.renderSlimeRoot(pPoseStack, pBuffer, pLivingEntity, pPackedLight);
    }

    private void renderArmorPiece(class_4587 pPoseStack, class_4597 pBuffer, AbstractClaySoldierEntity claySoldier, SoldierEquipmentSlot pSlot, int pPackedLight, ClaySoldierModel pModel, float partialTicks) {
        ClientSoldierWearableEffect wearableEffect = (ClientSoldierWearableEffect)this.getWearableEffect(claySoldier, pSlot);
        if (wearableEffect == null) {
            return;
        }
        class_1738 armoritem = wearableEffect.copyModel();
        if (armoritem == null) {
            armoritem = wearableEffect.defaultModel(pSlot);
        }
        class_1799 armorCopyStack = wearableEffect.getArmorCopyStack();
        if (SoldierEquipmentSlot.getFromSlot(armoritem.method_7685()).orElse(null) == pSlot) {
            ((ClaySoldierModel)this.method_17165()).method_2818(pModel);
            this.setPartVisibility(pModel, pSlot);
            class_3879 model = this.getArmorModelHook(claySoldier, armorCopyStack, pSlot, pModel);
            boolean usesInnerModel = this.usesInnerModel(pSlot);
            if (!wearableEffect.isNoArmorRender()) {
                int color = wearableEffect.getColor(claySoldier, partialTicks);
                ClientWearableRenderer.renderModel(pPoseStack, pBuffer, pPackedLight, model, color, this.getArmorResource((class_1297)claySoldier, armorCopyStack, pSlot, null));
            }
            if (armorCopyStack.method_7958()) {
                ClientWearableRenderer.renderGlint(pPoseStack, pBuffer, pPackedLight, model);
            }
            wearableEffect.renderTrims((class_1309)claySoldier, this.armorTrimAtlas, (class_6880<class_1741>)armoritem.method_7686(), pPoseStack, pBuffer, pPackedLight, model, usesInnerModel, partialTicks);
        }
    }

    private void setPartVisibility(ClaySoldierModel pModel, SoldierEquipmentSlot pSlot) {
        pModel.method_2805(false);
        switch (pSlot) {
            case HEAD: {
                pModel.field_3398.field_3665 = true;
                pModel.field_3394.field_3665 = true;
                break;
            }
            case CHEST: {
                pModel.field_3391.field_3665 = true;
                pModel.field_3401.field_3665 = true;
                pModel.field_27433.field_3665 = true;
                break;
            }
            case LEGS: {
                pModel.field_3391.field_3665 = true;
                pModel.field_3392.field_3665 = true;
                pModel.field_3397.field_3665 = true;
                break;
            }
            case FEET: {
                pModel.field_3392.field_3665 = true;
                pModel.field_3397.field_3665 = true;
            }
        }
    }

    private ClaySoldierModel getArmorModel(SoldierEquipmentSlot pSlot) {
        return this.usesInnerModel(pSlot) ? this.innerModel : this.outerModel;
    }

    private boolean usesInnerModel(SoldierEquipmentSlot pSlot) {
        return pSlot == SoldierEquipmentSlot.LEGS;
    }

    private class_3879 getArmorModelHook(AbstractClaySoldierEntity entity, class_1799 itemStack, SoldierEquipmentSlot slot, ClaySoldierModel model) {
        return ClaySoldiersClient.CLIENT_HOOKS.getArmorModel((class_1309)entity, itemStack, SoldierEquipmentSlot.convertToSlot(slot), model);
    }

    private class_2960 getArmorResource(class_1297 entity, class_1799 stack, SoldierEquipmentSlot slot, @Nullable String type) {
        String s1;
        class_2960 resourcelocation;
        class_1738 item = (class_1738)stack.method_7909();
        String texture = item.method_7686().method_55840();
        String domain = "minecraft";
        int idx = texture.indexOf(58);
        if (idx != -1) {
            domain = texture.substring(0, idx);
            texture = texture.substring(idx + 1);
        }
        if ((resourcelocation = ARMOR_LOCATION_CACHE.get(s1 = String.format(Locale.ROOT, "%s:textures/models/armor/%s_layer_%d%s.png", domain, texture, this.usesInnerModel(slot) ? 2 : 1, type == null ? "" : String.format(Locale.ROOT, "_%s", type)))) == null) {
            resourcelocation = class_2960.method_60654((String)s1);
            ARMOR_LOCATION_CACHE.put(s1, resourcelocation);
        }
        return resourcelocation;
    }

    @Nullable
    private SoldierWearableEffect getWearableEffect(AbstractClaySoldierEntity claySoldier, SoldierEquipmentSlot slot) {
        ItemStackWithEffect stackWithEffect = claySoldier.getItemBySlot(slot);
        if (stackWithEffect == null || stackWithEffect.isEmpty() || claySoldier.isFallingWithGlider(slot)) {
            return null;
        }
        return stackWithEffect.wearableEffectMap().wearableEffect(slot);
    }
}

