/*
 * Decompiled with CFR 0.152.
 */
package net.bumblebee.claysoldiers.entity.client;

import com.mojang.logging.LogUtils;
import java.util.Locale;
import java.util.Objects;
import net.bumblebee.claysoldiers.entity.client.AbstractClaySoldierRenderer;
import net.bumblebee.claysoldiers.entity.soldier.AbstractClaySoldierEntity;
import net.bumblebee.claysoldiers.init.ModEntityTypes;
import net.bumblebee.claysoldiers.soldierproperties.customproperties.AttackTypeProperty;
import net.bumblebee.claysoldiers.team.ClayMobTeam;
import net.bumblebee.claysoldiers.team.ClayMobTeamManger;
import net.bumblebee.claysoldiers.util.color.ColorHelper;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_5569;
import net.minecraft.class_6880;
import net.minecraft.class_7225;
import net.minecraft.class_8080;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

public class ClientClaySoldierEntity
extends AbstractClaySoldierEntity {
    private static final Logger LOGGER = LogUtils.getLogger();
    @Nullable
    private final AbstractClaySoldierRenderer renderer;
    private final class_8080 fakeWalkState;
    private ColorHelper offsetColor = ColorHelper.EMPTY;
    private class_6880.class_6883<ClayMobTeam> clayMobTeamId;
    private class_1799 cachedPickResult;
    private float scale = 1.0f;
    private boolean waxed = false;

    private ClientClaySoldierEntity(class_1299<? extends AbstractClaySoldierEntity> pEntityType, class_2338 pos, class_8080 fakeWalkState, class_6880.class_6883<ClayMobTeam> clayMobTeamId) {
        super(pEntityType, (class_1937)class_310.method_1551().field_1687, AttackTypeProperty.NORMAL);
        this.fakeWalkState = fakeWalkState;
        this.clayMobTeamId = clayMobTeamId;
        this.renderer = ClientClaySoldierEntity.createRenderer(pEntityType, this);
        this.method_31744(class_5569.field_27243);
        this.method_23327(pos.method_10263(), pos.method_10264(), pos.method_10260());
    }

    public static ClientClaySoldierEntity create(class_1299<? extends AbstractClaySoldierEntity> type, class_2487 tag, class_2338 pos, class_8080 state, class_6880.class_6883<ClayMobTeam> id, float size) {
        ClientClaySoldierEntity soldier = new ClientClaySoldierEntity(type, pos, state, id);
        soldier.waxed = tag.method_10577("Waxed");
        soldier.readArmorSaveData(tag);
        soldier.offsetColor = ColorHelper.getFromTag("OffsetColor", tag);
        soldier.scale = size;
        return soldier;
    }

    public static ClientClaySoldierEntity createAsProjectile(class_8080 state, class_6880.class_6883<ClayMobTeam> clayMobTeam) {
        return new ClientClaySoldierEntity(ModEntityTypes.CLAY_SOLDIER_ENTITY.get(), class_2338.field_10980, state, clayMobTeam);
    }

    public void setUpCape() {
        this.moveCloak(0.0, 0.0, 0.0);
        this.moveCloak(0.0, 0.0, 10.0);
    }

    private static AbstractClaySoldierRenderer createRenderer(class_1299<? extends AbstractClaySoldierEntity> type, AbstractClaySoldierEntity soldier) {
        try {
            return Objects.requireNonNull((AbstractClaySoldierRenderer)class_310.method_1551().method_1561().method_3953((class_1297)soldier));
        }
        catch (ClassCastException | NullPointerException e) {
            LOGGER.error("Could not create Renderer for Type {}, {}", (Object)type.method_5882(), (Object)e.getMessage());
            return null;
        }
    }

    public void render(float yaw, float partialTicks, class_4587 poseStack, class_4597 buffer, int packedLight) {
        if (this.renderer != null) {
            this.field_6220 = 0.0f;
            this.field_6283 = 0.0f;
            this.field_6259 = 0.0f;
            this.field_6241 = 0.0f;
            this.field_5982 = 0.0f;
            this.field_6004 = 0.0f;
            this.renderer.render(this, yaw, partialTicks, poseStack, buffer, packedLight);
        }
    }

    @NotNull
    public String toString() {
        return String.format(Locale.ROOT, "%s['%s', r='%s' w='%b', s='%.2f' x=%.2f, y=%.2f, z=%.2f]", new Object[]{this.getClass().getSimpleName(), this.method_5477().getString(), this.renderer, this.waxed, Float.valueOf(this.scale), this.method_23317(), this.method_23318(), this.method_23321()});
    }

    @Override
    public float method_55693() {
        return this.scale;
    }

    @Override
    public boolean isWaxed() {
        return this.waxed;
    }

    @Override
    @NotNull
    public ClayMobTeam getClayTeam() {
        if (ClayMobTeamManger.isValidTeam(this.clayMobTeamId.method_40237().method_29177(), this.method_56673())) {
            return (ClayMobTeam)this.clayMobTeamId.comp_349();
        }
        this.clayMobTeamId = ClayMobTeamManger.getDefault((class_7225.class_7874)this.method_56673());
        return (ClayMobTeam)this.clayMobTeamId.comp_349();
    }

    @Override
    public class_1799 method_31480() {
        if (ClayMobTeamManger.isValidTeam(this.clayMobTeamId.method_40237().method_29177(), this.method_37908().method_30349())) {
            if (this.cachedPickResult == null) {
                this.cachedPickResult = ClayMobTeamManger.createStackForTeam(this.clayMobTeamId.method_40237().method_29177(), (class_7225.class_7874)this.method_37908().method_30349());
            }
            return this.cachedPickResult;
        }
        return class_1799.field_8037;
    }

    @Override
    public class_2960 getClayTeamType() {
        return this.clayMobTeamId.method_40237().method_29177();
    }

    @Override
    public ColorHelper getOffsetColor() {
        return this.offsetColor;
    }

    @Override
    public class_8080 getWalkAnimation() {
        return this.fakeWalkState;
    }

    @Override
    @Nullable
    public class_2561 getWorkStatus() {
        return null;
    }

    @Override
    public void method_5652(class_2487 pCompound) {
    }

    @Override
    public void method_5749(class_2487 pCompound) {
    }

    public boolean method_5765() {
        return false;
    }

    @Nullable
    public class_1297 method_5854() {
        return null;
    }

    public boolean method_18276() {
        return false;
    }

    @Override
    public void method_5773() {
    }

    public float method_36454() {
        return 0.0f;
    }

    public void method_36456(float yRot) {
    }

    public float method_36455() {
        return 0.0f;
    }

    public void method_36457(float xRot) {
    }

    public boolean method_5799() {
        return false;
    }
}

