/*
 * Decompiled with CFR 0.152.
 */
package net.bumblebee.claysoldiers.entity.client.accesories;

import java.util.HashMap;
import java.util.Map;
import net.bumblebee.claysoldiers.datamap.SoldierEquipmentSlot;
import net.bumblebee.claysoldiers.datamap.armor.SoldierMultiWearable;
import net.bumblebee.claysoldiers.datamap.armor.accessories.IAccessoryRenderLayer;
import net.bumblebee.claysoldiers.datamap.armor.accessories.RenderableAccessory;
import net.bumblebee.claysoldiers.entity.client.ClaySoldierModel;
import net.bumblebee.claysoldiers.entity.client.accesories.ClaySoldierCapeModel;
import net.bumblebee.claysoldiers.entity.client.accesories.ClaySoldierShieldModel;
import net.bumblebee.claysoldiers.entity.soldier.AbstractClaySoldierEntity;
import net.bumblebee.claysoldiers.item.itemeffectholder.ItemStackWithEffect;
import net.minecraft.class_2484;
import net.minecraft.class_3883;
import net.minecraft.class_3887;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_5598;
import net.minecraft.class_5599;
import net.minecraft.class_759;
import net.minecraft.class_836;
import net.minecraft.class_918;
import org.jetbrains.annotations.Nullable;

public class AccessoryRenderLayer
extends class_3887<AbstractClaySoldierEntity, ClaySoldierModel>
implements IAccessoryRenderLayer {
    public final ClaySoldierCapeModel capeModel;
    public final ClaySoldierShieldModel shieldModel;
    public final class_759 itemInHandRenderer;
    private final Map<class_2484.class_2485, class_5598> skullModels;
    private final class_918 itemRenderer;

    public AccessoryRenderLayer(class_3883<AbstractClaySoldierEntity, ClaySoldierModel> pRendererParent, class_5599 entityModelSet, class_759 renderer, class_918 itemRenderer) {
        super(pRendererParent);
        this.capeModel = new ClaySoldierCapeModel(entityModelSet.method_32072(ClaySoldierCapeModel.LAYER_LOCATION));
        this.itemInHandRenderer = renderer;
        this.skullModels = class_836.method_32160((class_5599)entityModelSet);
        this.shieldModel = new ClaySoldierShieldModel(entityModelSet.method_32072(ClaySoldierShieldModel.LAYER_LOCATION));
        this.itemRenderer = itemRenderer;
    }

    @Override
    public class_918 getItemRenderer() {
        return this.itemRenderer;
    }

    public void render(class_4587 pPoseStack, class_4597 pBuffer, int pPackedLight, AbstractClaySoldierEntity claySoldier, float pLimbSwing, float pLimbSwingAmount, float pPartialTick, float pAgeInTicks, float pNetHeadYaw, float pHeadPitch) {
        HashMap map = new HashMap();
        for (SoldierEquipmentSlot slot : SoldierEquipmentSlot.values()) {
            SoldierMultiWearable multi = this.getMulti(claySoldier, slot);
            if (multi == null) continue;
            map.putAll(multi.getAccessories());
        }
        boolean falling = claySoldier.isFalling();
        for (RenderableAccessory acc : map.values()) {
            acc.render(this, pPoseStack, pBuffer, pPackedLight, claySoldier, pPartialTick, falling);
        }
    }

    @Override
    @Nullable
    public class_5598 getSkullBase(class_2484.class_2485 type) {
        return this.skullModels.get(type);
    }

    @Override
    public ClaySoldierModel getSoldierModel() {
        return (ClaySoldierModel)this.method_17165();
    }

    @Override
    public ClaySoldierCapeModel getCapeModel() {
        return this.capeModel;
    }

    @Override
    public ClaySoldierShieldModel getShieldModel() {
        return this.shieldModel;
    }

    @Override
    public class_759 getItemInHandRenderer() {
        return this.itemInHandRenderer;
    }

    @Nullable
    private SoldierMultiWearable getMulti(AbstractClaySoldierEntity claySoldier, SoldierEquipmentSlot slot) {
        ItemStackWithEffect stackWithEffect = claySoldier.getItemBySlot(slot);
        if (stackWithEffect == null || stackWithEffect.isEmpty()) {
            return null;
        }
        return stackWithEffect.wearableEffectMap();
    }
}

