/*
 * Decompiled with CFR 0.152.
 */
package net.bumblebee.claysoldiers.entity.client.boss;

import java.util.EnumMap;
import java.util.List;
import net.bumblebee.claysoldiers.entity.boss.BossClaySoldierEntity;
import net.bumblebee.claysoldiers.entity.client.ClaySoldierModel;
import net.bumblebee.claysoldiers.entity.client.ClaySoldierRenderer;
import net.bumblebee.claysoldiers.entity.client.undead.SoldierSuitLayer;
import net.bumblebee.claysoldiers.entity.client.undead.VampireClaySoldierRenderer;
import net.bumblebee.claysoldiers.entity.client.undead.VampireEyesLayer;
import net.bumblebee.claysoldiers.entity.client.undead.ZombieClaySoldierRenderer;
import net.bumblebee.claysoldiers.entity.soldier.AbstractClaySoldierEntity;
import net.minecraft.class_1297;
import net.minecraft.class_3883;
import net.minecraft.class_3887;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_5617;

public class BossClaySoldierRenderer
extends ClaySoldierRenderer {
    public BossClaySoldierRenderer(class_5617.class_5618 pContext) {
        super(pContext);
        this.method_4046(new TypeBasedRenderLayer((class_3883<AbstractClaySoldierEntity, ClaySoldierModel>)this));
    }

    @Override
    protected void renderModel(AbstractClaySoldierEntity soldier, class_4587 pPoseStack, class_4588 vertexConsumer, int pPackedLight, int overlayCords, int color, int alpha) {
        int newColor = color;
        if (soldier instanceof BossClaySoldierEntity) {
            BossClaySoldierEntity bossSoldier = (BossClaySoldierEntity)soldier;
            switch (bossSoldier.getBossType()) {
                case ZOMBIE: {
                    newColor = ZombieClaySoldierRenderer.shiftColor(newColor);
                    break;
                }
                case VAMPIRE: {
                    newColor = VampireClaySoldierRenderer.shiftColor(newColor);
                }
            }
        }
        super.renderModel(soldier, pPoseStack, vertexConsumer, pPackedLight, overlayCords, newColor, alpha);
    }

    private static class TypeBasedRenderLayer
    extends class_3887<AbstractClaySoldierEntity, ClaySoldierModel> {
        private final EnumMap<BossClaySoldierEntity.BossTypes, List<class_3887<AbstractClaySoldierEntity, ClaySoldierModel>>> typeRenderLayer = new EnumMap(BossClaySoldierEntity.BossTypes.class);

        public TypeBasedRenderLayer(class_3883<AbstractClaySoldierEntity, ClaySoldierModel> renderer) {
            super(renderer);
            this.typeRenderLayer.put(BossClaySoldierEntity.BossTypes.NORMAL, List.of());
            this.typeRenderLayer.put(BossClaySoldierEntity.BossTypes.ZOMBIE, List.of(SoldierSuitLayer.zombie(renderer)));
            this.typeRenderLayer.put(BossClaySoldierEntity.BossTypes.VAMPIRE, List.of(SoldierSuitLayer.vampire(renderer), new VampireEyesLayer(renderer, s -> true)));
        }

        public void render(class_4587 poseStack, class_4597 multiBufferSource, int packedLight, AbstractClaySoldierEntity soldier, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
            this.typeRenderLayer.get((Object)((BossClaySoldierEntity)soldier).getBossType()).forEach(render -> render.method_4199(poseStack, multiBufferSource, packedLight, (class_1297)soldier, limbSwing, limbSwingAmount, partialTicks, ageInTicks, netHeadYaw, headPitch));
        }
    }
}

