/*
 * Decompiled with CFR 0.152.
 */
package net.bumblebee.claysoldiers.entity.goal;

import java.util.EnumSet;
import net.bumblebee.claysoldiers.entity.ClayMobEntity;
import net.bumblebee.claysoldiers.entity.soldier.AbstractClaySoldierEntity;
import net.minecraft.class_11;
import net.minecraft.class_1297;
import net.minecraft.class_1301;
import net.minecraft.class_1309;
import net.minecraft.class_1352;
import net.minecraft.class_1657;

public abstract class ClaySoldierMeleeGoal
extends class_1352 {
    protected final AbstractClaySoldierEntity claySoldier;
    private final double speedModifier;
    private final boolean followingTargetEvenIfNotSeen;
    private class_11 path;
    private double pathedTargetX;
    private double pathedTargetY;
    private double pathedTargetZ;
    private int ticksUntilNextPathRecalculation;
    private int ticksUntilNextAttack;
    private long lastCanUseCheck;
    private static final long COOLDOWN_BETWEEN_CAN_USE_CHECKS = 10L;
    private static final int COOLDOWN_BETWEEN_CAN_ATTACKS = 2;

    public ClaySoldierMeleeGoal(AbstractClaySoldierEntity claySoldier, double speedModifier, boolean followingTargetEvenIfNotSeen) {
        this.claySoldier = claySoldier;
        this.speedModifier = speedModifier;
        this.followingTargetEvenIfNotSeen = followingTargetEvenIfNotSeen;
        this.method_6265(EnumSet.of(class_1352.class_4134.field_18405, class_1352.class_4134.field_18406));
    }

    protected abstract boolean canUsePredicate();

    public boolean method_6264() {
        if (!this.canUsePredicate()) {
            return false;
        }
        long gameTime = this.claySoldier.method_37908().method_8510();
        if (gameTime - this.lastCanUseCheck < 10L) {
            return false;
        }
        this.lastCanUseCheck = gameTime;
        class_1309 target = this.claySoldier.method_5968();
        if (!(target instanceof ClayMobEntity) && !this.isTargetFromOwner(target)) {
            return false;
        }
        if (!target.method_5805()) {
            return false;
        }
        this.path = this.claySoldier.method_5942().method_6349((class_1297)target, 0);
        if (this.path != null) {
            return true;
        }
        return this.claySoldier.method_42150(target);
    }

    protected boolean isTargetFromOwner(class_1309 target) {
        class_1657 owner = this.claySoldier.getClayTeamOwner();
        if (owner != null && target != null) {
            return target.equals((Object)owner.method_6052()) || target.equals((Object)owner.method_6065());
        }
        return false;
    }

    public boolean method_6266() {
        class_1309 target = this.claySoldier.method_5968();
        if (!(target instanceof ClayMobEntity) && !this.isTargetFromOwner(target)) {
            return false;
        }
        if (!target.method_5805()) {
            return false;
        }
        if (!this.followingTargetEvenIfNotSeen) {
            return !this.claySoldier.method_5942().method_6357();
        }
        return this.claySoldier.method_18407(target.method_24515());
    }

    public void method_6269() {
        this.claySoldier.method_5942().method_6334(this.path, this.speedModifier);
        this.ticksUntilNextPathRecalculation = 0;
        this.ticksUntilNextAttack = 0;
    }

    public void method_6270() {
        class_1309 livingentity = this.claySoldier.method_5968();
        if (!class_1301.field_6156.test(livingentity)) {
            this.claySoldier.method_5980(null);
        }
        this.claySoldier.method_5942().method_6340();
    }

    public void method_6268() {
        class_1309 target = this.claySoldier.method_5968();
        if (target != null) {
            this.claySoldier.method_5988().method_6226((class_1297)target, 30.0f, 30.0f);
            this.ticksUntilNextPathRecalculation = Math.max(this.ticksUntilNextPathRecalculation - 1, 0);
            if ((this.followingTargetEvenIfNotSeen || this.claySoldier.method_5985().method_6369((class_1297)target)) && this.ticksUntilNextPathRecalculation <= 0 && (this.pathedTargetX == 0.0 && this.pathedTargetY == 0.0 && this.pathedTargetZ == 0.0 || target.method_5649(this.pathedTargetX, this.pathedTargetY, this.pathedTargetZ) >= 1.0 || this.claySoldier.method_59922().method_43057() < 0.05f)) {
                this.pathedTargetX = target.method_23317();
                this.pathedTargetY = target.method_23318();
                this.pathedTargetZ = target.method_23321();
                this.ticksUntilNextPathRecalculation = 2;
                double distanceTarget = this.claySoldier.method_5858((class_1297)target);
                if (distanceTarget > 1024.0) {
                    this.ticksUntilNextPathRecalculation += 10;
                } else if (distanceTarget > 256.0) {
                    this.ticksUntilNextPathRecalculation += 5;
                }
                if (!this.claySoldier.method_5942().method_6335((class_1297)target, this.speedModifier)) {
                    this.ticksUntilNextPathRecalculation += 5;
                }
                this.ticksUntilNextPathRecalculation = this.method_38847(this.ticksUntilNextPathRecalculation);
            }
            this.ticksUntilNextAttack = Math.max(this.ticksUntilNextAttack - 1, 0);
            this.checkAndPerformMeleeEffect(target);
        }
    }

    protected void checkAndPerformMeleeEffect(class_1309 pTarget) {
        if (this.canPerformMeleeAction(pTarget)) {
            this.resetAttackCooldown();
            this.performMeleeAction(pTarget);
            this.claySoldier.indicateMeleeItemUse();
        }
    }

    protected abstract void performMeleeAction(class_1309 var1);

    protected void resetAttackCooldown() {
        this.ticksUntilNextAttack = this.method_38847(2);
    }

    protected boolean isTimeToPerformMeleeAction() {
        return this.ticksUntilNextAttack <= 0;
    }

    protected boolean canPerformMeleeAction(class_1309 target) {
        return this.isTimeToPerformMeleeAction() && this.claySoldier.method_42150(target) && this.claySoldier.method_5985().method_6369((class_1297)target);
    }

    public boolean method_38846() {
        return true;
    }
}

