/*
 * Decompiled with CFR 0.152.
 */
package net.bumblebee.claysoldiers.entity.goal;

import java.util.EnumSet;
import net.bumblebee.claysoldiers.entity.soldier.AbstractClaySoldierEntity;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1352;
import net.minecraft.class_3532;
import org.jetbrains.annotations.Nullable;

public class ClaySoldierRangedAttackGoal
extends class_1352 {
    private static final int DEFAULT_ATTACK_TIME = 40;
    private final AbstractClaySoldierEntity mob;
    @Nullable
    private class_1309 target;
    private int attackTime = -1;
    private final double speedModifier;
    private int seeTime;
    private int attackIntervalMin;
    private final float attackRadius;
    private final float attackRadiusSqr;

    public ClaySoldierRangedAttackGoal(AbstractClaySoldierEntity pRangedAttackMob, double pSpeedModifier, float pAttackRadius) {
        this.mob = pRangedAttackMob;
        this.speedModifier = pSpeedModifier;
        this.attackIntervalMin = 40;
        this.attackRadius = pAttackRadius;
        this.attackRadiusSqr = pAttackRadius * pAttackRadius;
        this.method_6265(EnumSet.of(class_1352.class_4134.field_18405, class_1352.class_4134.field_18406));
    }

    public boolean method_6264() {
        if (!this.mob.canPerformRangeAttack()) {
            return false;
        }
        class_1309 livingentity = this.mob.method_5968();
        if (!(livingentity instanceof AbstractClaySoldierEntity)) {
            return false;
        }
        if (livingentity.method_5805()) {
            this.target = livingentity;
            return true;
        }
        return false;
    }

    public boolean method_6266() {
        return this.method_6264() || this.target.method_5805() && !this.mob.method_5942().method_6357();
    }

    public void method_6270() {
        this.target = null;
        this.seeTime = 0;
        this.attackTime = -1;
    }

    public boolean method_38846() {
        return true;
    }

    public void method_6268() {
        double distanceToTarget = this.mob.method_5649(this.target.method_23317(), this.target.method_23318(), this.target.method_23321());
        boolean canSeeTarget = this.mob.method_5985().method_6369((class_1297)this.target);
        this.seeTime = canSeeTarget ? ++this.seeTime : 0;
        if (!(distanceToTarget > (double)this.attackRadiusSqr) && this.seeTime >= 5) {
            this.mob.method_5942().method_6340();
        } else {
            this.mob.method_5942().method_6335((class_1297)this.target, this.speedModifier);
        }
        this.mob.method_5988().method_6226((class_1297)this.target, 30.0f, 30.0f);
        if (--this.attackTime == 0) {
            if (!canSeeTarget) {
                return;
            }
            float f = (float)Math.sqrt(distanceToTarget) / this.attackRadius;
            float f1 = class_3532.method_15363((float)f, (float)0.1f, (float)1.0f);
            this.mob.method_7105(this.target, f1);
            this.attackTime = class_3532.method_15375((float)(f * (float)this.attackIntervalMin));
            this.updateAttackInterval();
        } else if (this.attackTime < 0) {
            this.attackTime = this.attackIntervalMin;
        }
    }

    private void updateAttackInterval() {
        this.attackIntervalMin = this.mob.getAttackType().isSupportive() ? 220 : 40;
    }
}

