/*
 * Decompiled with CFR 0.152.
 */
package net.bumblebee.claysoldiers.entity.goal;

import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import net.bumblebee.claysoldiers.ClaySoldiersCommon;
import net.bumblebee.claysoldiers.capability.AssignablePoiCapability;
import net.bumblebee.claysoldiers.capability.IBlockCache;
import net.bumblebee.claysoldiers.capability.IBlockStorageAccess;
import net.bumblebee.claysoldiers.datamap.SoldierEquipmentSlot;
import net.bumblebee.claysoldiers.datamap.SoldierHoldableEffect;
import net.bumblebee.claysoldiers.datamap.SoldierSlotCallback;
import net.bumblebee.claysoldiers.entity.ClayMobEntity;
import net.bumblebee.claysoldiers.entity.soldier.AbstractClaySoldierEntity;
import net.minecraft.class_1352;
import net.minecraft.class_1799;
import net.minecraft.class_2338;
import net.minecraft.class_2374;
import net.minecraft.class_3218;
import org.jetbrains.annotations.Nullable;

public class UseAssignedPoiGoal
extends class_1352 {
    private static final int MAX_WAIT_BEFORE_NEXT_ATTEMPT = 200;
    private final ClayMobEntity clayMob;
    private final double speedModifier;
    private int waitTime = 0;

    public UseAssignedPoiGoal(ClayMobEntity clayMob, double pSpeedModifier) {
        this.clayMob = clayMob;
        this.speedModifier = pSpeedModifier;
        this.method_6265(EnumSet.of(class_1352.class_4134.field_18405, class_1352.class_4134.field_18406));
    }

    public boolean method_6264() {
        return this.isPoiUsable();
    }

    public boolean method_6266() {
        return this.clayMob.getPoiPos() != null && this.clayMob.getPoiCapability() != null;
    }

    private boolean isPoiUsable() {
        if (--this.waitTime > 0) {
            return false;
        }
        if (this.clayMob.getPoiPos() == null) {
            return false;
        }
        AssignablePoiCapability cap = this.clayMob.getPoiCapability();
        if (cap == null || !cap.canUse(this.clayMob)) {
            this.waitTime = 200;
            return false;
        }
        return true;
    }

    public void method_6269() {
        this.moveToPoi();
        this.clayMob.setUsingPoi(true);
    }

    public void method_6268() {
        if (!this.moveToPoi()) {
            return;
        }
        AssignablePoiCapability cap = this.clayMob.getPoiCapability();
        if (cap != null && cap.canUse(this.clayMob)) {
            cap.use(this.clayMob);
            if (cap.isOneTimeUse()) {
                this.clayMob.setPoiPos(null);
            }
        } else {
            this.clayMob.setPoiPos(null);
        }
    }

    public void method_6270() {
        this.clayMob.setUsingPoi(false);
    }

    private boolean moveToPoi() {
        class_2338 pos = this.clayMob.getPoiPos();
        if (pos != null) {
            if (pos.method_19769((class_2374)this.clayMob.method_19538(), 1.0)) {
                this.clayMob.method_5942().method_6340();
                return true;
            }
            this.clayMob.method_5942().method_6337((double)pos.method_10263() + 0.5, (double)pos.method_10264(), (double)pos.method_10260() + 0.5, this.speedModifier);
            return false;
        }
        return false;
    }

    public String toString() {
        return ((Object)((Object)this)).getClass().getSimpleName();
    }

    public static IBlockCache<AssignablePoiCapability> createCache(ClayMobEntity clayMob, class_3218 level) {
        IBlockCache<AssignablePoiCapability> cache = ClaySoldiersCommon.CAPABILITY_MANGER.createPoiCache(level, clayMob.getPoiPos());
        if (cache.getCapability() != null) {
            return cache;
        }
        IBlockCache<IBlockStorageAccess> storageCache = ClaySoldiersCommon.CAPABILITY_MANGER.create(level, clayMob.getPoiPos());
        if (storageCache.getCapability() != null) {
            return new StorageWrappedPoiCache(storageCache);
        }
        return cache;
    }

    private static int canEquipStack(AbstractClaySoldierEntity inventory, class_1799 stack, Set<SoldierEquipmentSlot> slots) {
        if (!inventory.method_5939(stack)) {
            return 0;
        }
        SoldierHoldableEffect effect = ClaySoldiersCommon.DATA_MAP.getEffect(stack);
        if (effect == null) {
            return 0;
        }
        boolean anySuitableSlot = false;
        for (SoldierEquipmentSlot suitableSlot : effect.slots()) {
            if (!slots.contains(suitableSlot)) continue;
            anySuitableSlot = true;
            break;
        }
        if (!anySuitableSlot) {
            return 0;
        }
        if (!inventory.couldEquipStack(effect)) {
            return 0;
        }
        return Math.min(effect.getMaxStackSize(), stack.method_7914());
    }

    private static void equipStack(AbstractClaySoldierEntity soldier, class_1799 stack, List<class_1799> overflow, Set<SoldierEquipmentSlot> remainingSlots) {
        SlotCallBack slotHolder = new SlotCallBack();
        class_1799 equippedStack = soldier.equipItemIfPossible(stack, slotHolder);
        int remaining = stack.method_7947() - equippedStack.method_7947();
        if (remaining > 0) {
            overflow.add(equippedStack.method_46651(remaining));
        }
        if (slotHolder.slot != null) {
            remainingSlots.remove(slotHolder.slot);
        }
    }

    private record StorageWrappedPoiCache(IBlockCache<IBlockStorageAccess> cache) implements IBlockCache<AssignablePoiCapability>
    {
        @Override
        public class_2338 pos() {
            return this.cache.pos();
        }

        @Override
        @Nullable
        public AssignablePoiCapability getCapability() {
            return this.cache.getCapability() == null ? null : new StorageWrappedPoiCap(this.cache.getCapability());
        }
    }

    private static class SlotCallBack
    implements SoldierSlotCallback {
        private SoldierEquipmentSlot slot = null;

        private SlotCallBack() {
        }

        @Override
        public void slot(SoldierEquipmentSlot slot) {
            this.slot = slot;
        }

        @Override
        public void capability() {
        }

        @Override
        public void carried() {
        }
    }

    private record StorageWrappedPoiCap(IBlockStorageAccess storage) implements AssignablePoiCapability
    {
        @Override
        public boolean canUse(ClayMobEntity clayMob) {
            return clayMob instanceof AbstractClaySoldierEntity;
        }

        @Override
        public void use(ClayMobEntity clayMob) {
            if (!(clayMob instanceof AbstractClaySoldierEntity)) {
                return;
            }
            AbstractClaySoldierEntity soldier = (AbstractClaySoldierEntity)clayMob;
            EnumSet<SoldierEquipmentSlot> emptySlots = EnumSet.noneOf(SoldierEquipmentSlot.class);
            for (SoldierEquipmentSlot slot : SoldierEquipmentSlot.values()) {
                if (!soldier.getItemBySlot(slot).isEmpty()) continue;
                emptySlots.add(slot);
            }
            ArrayList notNeededStacks = new ArrayList();
            this.storage.forEach(stack -> UseAssignedPoiGoal.canEquipStack(soldier, stack, emptySlots), stack -> UseAssignedPoiGoal.equipStack(soldier, stack, notNeededStacks, emptySlots), emptySlots::isEmpty);
            notNeededStacks.forEach(this.storage::tryInserting);
        }
    }
}

