/*
 * Decompiled with CFR 0.152.
 */
package net.bumblebee.claysoldiers.entity.goal.workgoal;

import java.util.List;
import java.util.function.Supplier;
import net.bumblebee.claysoldiers.ClaySoldiersCommon;
import net.bumblebee.claysoldiers.capability.IBlockCache;
import net.bumblebee.claysoldiers.capability.IBlockStorageAccess;
import net.bumblebee.claysoldiers.entity.goal.workgoal.IWorkGoal;
import net.bumblebee.claysoldiers.entity.goal.workgoal.WorkSelectorGoal;
import net.bumblebee.claysoldiers.entity.soldier.AbstractClaySoldierEntity;
import net.minecraft.class_1352;
import net.minecraft.class_2338;
import net.minecraft.class_2374;
import net.minecraft.class_2561;
import net.minecraft.class_3218;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractWorkGoal
extends class_1352
implements IWorkGoal {
    public static final String BREAK_LANG = "clay_soldier_work.%s.status.%s".formatted("csr", "on_break");
    public static final String STUCK_LANG = "clay_soldier_work.%s.status.%s".formatted("csr", "stuck");
    public static final String SEARCHING_LANG = "clay_soldier_work.%s.status.%s".formatted("csr", "searching_item");
    public static final String CARRYING_LANG = "clay_soldier_work.%s.status.%s".formatted("csr", "carrying");
    public static final String REQUIRES_POI_LANG = "clay_soldier_work.%s.status.%s".formatted("csr", "requires_poi");
    public static final String RETURNING_LANG = "clay_soldier_work.%s.job.%s".formatted("csr", "returning");
    protected static final byte BREAK_ID = 0;
    protected static final byte SEARCHING_ID = 1;
    protected static final byte CARRYING_ID = 2;
    protected static final byte REQUIRES_POI_ID = 3;
    protected static final byte RETURNING_ID = 4;
    private static final int MAX_BREAK_TIME = 20;
    protected final AbstractClaySoldierEntity soldier;
    private final Supplier<WorkSelectorGoal> workSelector;
    private IBlockCache<IBlockStorageAccess> capCache;
    private int breakTime = 0;
    private byte status = 0;
    private final List<? extends class_2561> statuses;

    public AbstractWorkGoal(AbstractClaySoldierEntity soldier, Supplier<WorkSelectorGoal> workSelector) {
        this(soldier, workSelector, List.of(BREAK_LANG, SEARCHING_LANG, CARRYING_LANG, REQUIRES_POI_LANG, RETURNING_LANG));
    }

    protected AbstractWorkGoal(AbstractClaySoldierEntity soldier, Supplier<WorkSelectorGoal> workSelector, List<String> statusesKey) {
        this.soldier = soldier;
        this.workSelector = workSelector;
        if (statusesKey.size() >= 7) {
            throw new IllegalArgumentException("Cannot have more than 7 Statuses per WorkGoal");
        }
        this.statuses = statusesKey.stream().map(class_2561::method_43471).toList();
    }

    @Nullable
    protected class_2338 getPoiPos() {
        return this.workSelector.get().getSoldierPoiPos();
    }

    protected void setCapCache() {
        this.capCache = this.getPoiPos() != null ? ClaySoldiersCommon.CAPABILITY_MANGER.create((class_3218)this.soldier.method_37908(), this.getPoiPos()) : null;
    }

    @Nullable
    protected IBlockCache<IBlockStorageAccess> getCapCache() {
        return this.capCache;
    }

    protected IBlockCache<IBlockStorageAccess> getCapCacheResetIfInvalid() {
        if (this.capCache == null) {
            this.setCapCache();
        } else if (!this.capCache.pos().equals((Object)this.getPoiPos())) {
            this.setCapCache();
        }
        return this.capCache;
    }

    protected boolean isOnBreak() {
        if (this.breakTime > 0) {
            --this.breakTime;
            return true;
        }
        return false;
    }

    protected boolean moveToPoi() {
        class_2338 pos = this.getPoiPos();
        if (pos != null) {
            if (pos.method_19769((class_2374)this.soldier.method_19538(), 2.0)) {
                this.soldier.method_5942().method_6340();
                return true;
            }
            this.soldier.method_5942().method_6337((double)pos.method_10263() + 0.5, (double)(pos.method_10264() + 1), (double)pos.method_10260() + 0.5, 1.2);
            return false;
        }
        return false;
    }

    public void setStatus(byte status) {
        this.status = status;
        this.workSelector.get().onWorkStatusChange();
    }

    protected void takeAShortBreak() {
        this.breakTime = 20;
        this.setStatus((byte)0);
    }

    @Override
    public byte getStatus() {
        return this.status;
    }

    @Override
    public class_2561 decodeStatus(byte id) {
        if (this.statuses.size() <= id || id < 0) {
            return IWorkGoal.super.decodeStatus(id);
        }
        return this.statuses.get(id);
    }
}

