/*
 * Decompiled with CFR 0.152.
 */
package net.bumblebee.claysoldiers.entity.goal.workgoal;

import java.util.Optional;
import java.util.function.Supplier;
import net.bumblebee.claysoldiers.ClaySoldiersCommon;
import net.bumblebee.claysoldiers.blueprint.BlueprintRequest;
import net.bumblebee.claysoldiers.capability.BlueprintRequestHandler;
import net.bumblebee.claysoldiers.capability.IBlockCache;
import net.bumblebee.claysoldiers.capability.IBlockStorageAccess;
import net.bumblebee.claysoldiers.entity.goal.workgoal.AbstractWorkGoal;
import net.bumblebee.claysoldiers.entity.goal.workgoal.WorkSelectorGoal;
import net.bumblebee.claysoldiers.entity.soldier.AbstractClaySoldierEntity;
import net.bumblebee.claysoldiers.init.ModBlocks;
import net.minecraft.class_11;
import net.minecraft.class_1799;
import net.minecraft.class_2338;
import net.minecraft.class_2374;
import net.minecraft.class_2382;
import net.minecraft.class_2561;
import net.minecraft.class_3218;
import net.minecraft.class_4538;
import org.jetbrains.annotations.Nullable;

public class BuildBlueprintGoal
extends AbstractWorkGoal {
    public static final String BUILDING_LANG = "clay_soldier_work.%s.job.%s".formatted("csr", "building");
    @Nullable
    private IBlockCache<BlueprintRequestHandler> easelPos = null;
    private final int searchRange;
    private final int verticalSearchRange;
    protected int verticalSearchStart;
    @Nullable
    private BlueprintRequest request = null;
    private boolean bringBack = false;

    public BuildBlueprintGoal(AbstractClaySoldierEntity soldier, Supplier<WorkSelectorGoal> workSelector, int searchRange) {
        super(soldier, workSelector);
        this.searchRange = searchRange;
        this.verticalSearchRange = 2;
    }

    public boolean method_6264() {
        if (this.isOnBreak()) {
            return false;
        }
        return this.getPoiPos() != null && this.getCapCacheResetIfInvalid() != null;
    }

    public boolean method_6266() {
        return super.method_6266();
    }

    public void method_6268() {
        if (this.easelPos == null) {
            this.setStatus((byte)3);
            this.easelPos = this.findNearestBlock().map(this::getBlueprintCache).orElse(null);
            return;
        }
        if (this.request == null) {
            if (this.bringBack) {
                this.setStatus((byte)4);
                if (this.returnCarried()) {
                    this.bringBack = false;
                }
            } else {
                this.getRequestJob();
                this.setStatus((byte)1);
            }
        } else if (this.request.isCancelled() || this.request.isFinished()) {
            this.bringBack = !this.soldier.getCarriedStack().method_7960();
            this.request = null;
        } else if (this.request.hasStarted()) {
            this.getRequestFromStorage();
        } else if (this.request.isPlacing()) {
            this.setStatus((byte)2);
            if (this.moveToRequest()) {
                this.placeBlock();
            }
        }
    }

    private void getRequestFromStorage() {
        if (this.moveToPoi()) {
            assert (this.getCapCache() != null);
            IBlockStorageAccess storage = this.getCapCache().getCapability();
            if (storage != null) {
                if (!this.soldier.getCarriedStack().method_7960()) {
                    class_1799 returned = storage.tryInserting(this.soldier.getCarriedStack());
                    this.soldier.dropItemStack(returned);
                }
                this.soldier.setCarriedStack(storage.tryExtracting(stack -> stack.method_31574(this.request.getItem()), 1));
                this.request.setPlacing();
            } else {
                this.easelPos = null;
                this.request = null;
            }
        }
    }

    private boolean returnCarried() {
        if (this.moveToPoi()) {
            assert (this.getCapCache() != null);
            IBlockStorageAccess storage = this.getCapCache().getCapability();
            if (storage != null) {
                this.soldier.method_5775(storage.tryInserting(this.soldier.getCarriedStack()));
                this.soldier.setCarriedStack(class_1799.field_8037);
            } else {
                this.soldier.dropCarried();
            }
            return true;
        }
        return false;
    }

    private void getRequestJob() {
        if (!this.moveMobToEasel()) {
            return;
        }
        BlueprintRequestHandler requestHandler = this.easelPos.getCapability();
        if (requestHandler != null) {
            this.request = requestHandler.getRequest(this::canReach);
        } else {
            this.easelPos = null;
        }
    }

    private boolean canReach(class_2338 pos) {
        class_11 path = this.soldier.method_5942().method_6348(pos, 2);
        return path != null && path.method_21655();
    }

    private void placeBlock() {
        BlueprintRequestHandler requestHandler = this.easelPos.getCapability();
        if (requestHandler != null) {
            if (requestHandler.doRequest(this.request)) {
                this.soldier.setCarriedStack(class_1799.field_8037);
                this.request.setFinished();
            } else {
                this.bringBack = true;
                this.request.cancel();
            }
            this.request = null;
        } else {
            this.easelPos = null;
        }
    }

    protected Optional<class_2338> findNearestBlock() {
        class_2338 center = this.soldier.method_24515();
        class_2338.class_2339 blockpos$mutableblockpos = new class_2338.class_2339();
        int searchIndex = this.verticalSearchStart;
        while (searchIndex <= this.verticalSearchRange) {
            for (int rangeIndex = 0; rangeIndex < this.searchRange; ++rangeIndex) {
                int i1 = 0;
                while (i1 <= rangeIndex) {
                    int j1;
                    int n = j1 = i1 < rangeIndex && i1 > -rangeIndex ? rangeIndex : 0;
                    while (j1 <= rangeIndex) {
                        blockpos$mutableblockpos.method_25504((class_2382)center, i1, searchIndex - 1, j1);
                        if (this.soldier.method_18407((class_2338)blockpos$mutableblockpos) && this.isValidTarget((class_4538)this.soldier.method_37908(), (class_2338)blockpos$mutableblockpos)) {
                            return Optional.of(blockpos$mutableblockpos);
                        }
                        j1 = j1 > 0 ? -j1 : 1 - j1;
                    }
                    i1 = i1 > 0 ? -i1 : 1 - i1;
                }
            }
            searchIndex = searchIndex > 0 ? -searchIndex : 1 - searchIndex;
        }
        return Optional.empty();
    }

    protected boolean moveMobToEasel() {
        if (this.easelPos == null) {
            return false;
        }
        if (this.easelPos.pos().method_19769((class_2374)this.soldier.method_19538(), 2.0)) {
            this.soldier.method_5942().method_6340();
            return true;
        }
        this.soldier.method_5942().method_6337((double)this.easelPos.pos().method_10263() + 0.5, (double)(this.easelPos.pos().method_10264() + 1), (double)this.easelPos.pos().method_10260() + 0.5, 1.0);
        return false;
    }

    protected boolean moveToRequest() {
        if (this.request.getPos().method_19769((class_2374)this.soldier.method_19538(), 2.0)) {
            this.soldier.method_5942().method_6340();
            return true;
        }
        this.soldier.method_5942().method_6337((double)this.request.getPos().method_10263() + 0.5, (double)(this.request.getPos().method_10264() + 1), (double)this.request.getPos().method_10260() + 0.5, 1.0);
        return false;
    }

    protected boolean isValidTarget(class_4538 pLevel, @Nullable class_2338 pPos) {
        return pPos != null && pLevel.method_8320(pPos).method_27852(ModBlocks.EASEL_BLOCK.get());
    }

    private IBlockCache<BlueprintRequestHandler> getBlueprintCache(class_2338 pos) {
        if (pos != null) {
            return ClaySoldiersCommon.CAPABILITY_MANGER.createBlueprint((class_3218)this.soldier.method_37908(), pos);
        }
        return null;
    }

    public boolean method_38846() {
        return true;
    }

    @Override
    public boolean workRequiresItemCarrying() {
        return true;
    }

    @Override
    public class_2561 getDisplayName() {
        return class_2561.method_43471((String)BUILDING_LANG);
    }

    public void method_6270() {
        if (this.request != null) {
            this.request.cancel();
        }
    }

    @Override
    public String asString() {
        Object[] objectArray = new Object[3];
        objectArray[0] = this.easelPos == null ? "Null" : "Cap";
        objectArray[1] = this.request;
        objectArray[2] = this.request == null ? (this.bringBack ? "bringBack" : "-") : (this.canReach(this.request.getPos()) ? "Can Reach" : "Cannot Reach");
        return "BuildBlueprintGoal{%s: %s(%s)}".formatted(objectArray);
    }
}

