/*
 * Decompiled with CFR 0.152.
 */
package net.bumblebee.claysoldiers.entity.goal.workgoal;

import java.util.EnumSet;
import java.util.List;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.bumblebee.claysoldiers.capability.IBlockStorageAccess;
import net.bumblebee.claysoldiers.datamap.SoldierEquipmentSlot;
import net.bumblebee.claysoldiers.entity.goal.workgoal.AbstractWorkGoal;
import net.bumblebee.claysoldiers.entity.goal.workgoal.WorkSelectorGoal;
import net.bumblebee.claysoldiers.entity.soldier.AbstractClaySoldierEntity;
import net.minecraft.class_1297;
import net.minecraft.class_1352;
import net.minecraft.class_1542;
import net.minecraft.class_2338;
import net.minecraft.class_2374;
import net.minecraft.class_2561;
import net.minecraft.class_3532;

public class PickUpItemsGoal
extends AbstractWorkGoal {
    public static final String PICK_UP_ITEM_LANG = "clay_soldier_work.%s.job.%s".formatted("csr", "pick_up_items");
    private static final Predicate<class_1542> ALLOWED_ITEMS = itemEntity -> !itemEntity.method_6977() && itemEntity.method_5805();
    private static final float VERTICAL_SEARCH_RANGE = 8.0f;

    public PickUpItemsGoal(AbstractClaySoldierEntity soldier, Supplier<WorkSelectorGoal> workSelector) {
        super(soldier, workSelector);
        this.method_6265(EnumSet.of(class_1352.class_4134.field_18405));
    }

    public boolean method_6264() {
        if (this.isOnBreak()) {
            return false;
        }
        return !this.getItemsInArea().isEmpty() || !this.soldier.getCarriedStack().method_7960();
    }

    public boolean method_6266() {
        if (this.isOnBreak()) {
            return false;
        }
        return !this.getItemsInArea().isEmpty();
    }

    public void pushToWardsItem(class_1542 itemEntity) {
        double zDif;
        double xDif = itemEntity.method_23317() - this.soldier.method_23317();
        double absMax = class_3532.method_15391((double)xDif, (double)(zDif = itemEntity.method_23321() - this.soldier.method_23321()));
        if (absMax >= (double)0.01f) {
            absMax = Math.sqrt(absMax);
            xDif /= absMax;
            zDif /= absMax;
            double invertedAbsMax = 1.0 / absMax;
            if (invertedAbsMax > 1.0) {
                invertedAbsMax = 1.0;
            }
            xDif *= invertedAbsMax;
            zDif *= invertedAbsMax;
            this.soldier.method_18799(this.soldier.method_18798().method_1031(xDif *= (double)0.05f, 0.0, zDif *= (double)0.05f));
        }
    }

    public void method_6268() {
        if (this.soldier.getCarriedStack().method_7960()) {
            this.setStatus((byte)1);
            List<class_1542> list = this.getItemsInArea();
            if (this.soldier.getItemBySlot(SoldierEquipmentSlot.MAINHAND).isEmpty() && !list.isEmpty()) {
                this.soldier.method_5942().method_6335((class_1297)list.getFirst(), (double)1.2f);
                if (this.soldier.method_5942().method_6357()) {
                    this.pushToWardsItem(list.getFirst());
                }
            }
        } else {
            class_2338 pos = this.getPoiPos();
            if (pos != null) {
                this.setStatus((byte)2);
                if (pos.method_19769((class_2374)this.soldier.method_19538(), 2.0)) {
                    this.soldier.method_5942().method_6340();
                    if (this.getCapCache() != null && pos.equals((Object)this.getCapCache().pos())) {
                        IBlockStorageAccess cap = this.getCapCache().getCapability();
                        if (cap != null) {
                            this.soldier.setCarriedStack(cap.tryInserting(this.soldier.getCarriedStack()));
                        }
                        this.takeAShortBreak();
                    } else {
                        this.setCapCache();
                    }
                } else {
                    this.soldier.method_5942().method_6337((double)pos.method_10263() + 0.5, (double)(pos.method_10264() + 1), (double)pos.method_10260() + 0.5, 1.2);
                }
            }
        }
    }

    public void method_6269() {
        this.setCapCache();
        List<class_1542> list = this.getItemsInArea();
        if (!list.isEmpty()) {
            this.soldier.method_5942().method_6335((class_1297)list.getFirst(), (double)1.2f);
        }
    }

    private List<class_1542> getItemsInArea() {
        return this.soldier.method_37908().method_8390(class_1542.class, this.soldier.method_5829().method_1009(8.0, 8.0, 8.0), ALLOWED_ITEMS);
    }

    @Override
    public class_2561 getDisplayName() {
        return class_2561.method_43471((String)PICK_UP_ITEM_LANG);
    }

    public boolean method_38846() {
        return true;
    }

    @Override
    public boolean workRequiresItemPickUp() {
        return true;
    }

    @Override
    public boolean workRequiresItemCarrying() {
        return true;
    }
}

