/*
 * Decompiled with CFR 0.152.
 */
package net.bumblebee.claysoldiers.entity.goal.workgoal;

import java.util.function.Supplier;
import net.bumblebee.claysoldiers.capability.IBlockStorageAccess;
import net.bumblebee.claysoldiers.entity.goal.workgoal.AbstractWorkGoal;
import net.bumblebee.claysoldiers.entity.goal.workgoal.WorkSelectorGoal;
import net.bumblebee.claysoldiers.entity.soldier.AbstractClaySoldierEntity;
import net.minecraft.class_1297;
import net.minecraft.class_1747;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2344;
import net.minecraft.class_2374;
import net.minecraft.class_2382;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_3489;
import net.minecraft.class_4538;
import net.minecraft.class_5712;
import net.minecraft.class_6862;
import net.minecraft.class_6880;
import org.jetbrains.annotations.Nullable;

public class PlaceSeedsGoal
extends AbstractWorkGoal {
    public static final String PLACING_SEEDS_LANG = "clay_soldier_work.%s.job.%s".formatted("csr", "placing_seeds");
    private static final class_6862<class_1792> SEEDS = class_3489.field_44591;
    @Nullable
    private class_2338 farmLandPos = null;
    private final int searchRange;
    private final int verticalSearchRange;
    protected int verticalSearchStart;
    protected int tryTicks;
    private int maxStayTicks;

    public PlaceSeedsGoal(AbstractClaySoldierEntity soldier, Supplier<WorkSelectorGoal> workSelector, int searchRange) {
        super(soldier, workSelector);
        this.searchRange = searchRange;
        this.verticalSearchRange = 2;
    }

    public boolean method_6264() {
        if (this.isOnBreak()) {
            return false;
        }
        return this.getPoiPos() != null && this.getCapCacheResetIfInvalid() != null;
    }

    public boolean method_6266() {
        if (this.isOnBreak()) {
            return false;
        }
        if (!this.soldier.getCarriedStack().method_7960()) {
            return this.tryTicks >= -this.maxStayTicks && this.tryTicks <= 1200 && this.isValidTarget((class_4538)this.soldier.method_37908(), this.farmLandPos);
        }
        return super.method_6266();
    }

    public void method_6268() {
        if (this.soldier.getCarriedStack().method_7960()) {
            this.getSeedFromChest();
            this.setStatus((byte)2);
        } else {
            this.setStatus((byte)1);
            if (this.farmLandPos == null) {
                this.findNearestBlock();
                this.moveMobToBlock();
                this.tryTicks = 0;
                this.maxStayTicks = this.soldier.method_59922().method_43048(this.soldier.method_59922().method_43048(1200) + 1200) + 1200;
                return;
            }
            class_2338 blockpos = this.getMoveToTarget();
            if (!blockpos.method_19769((class_2374)this.soldier.method_19538(), 2.0)) {
                ++this.tryTicks;
                if (this.shouldRecalculatePath()) {
                    this.soldier.method_5942().method_6337((double)blockpos.method_10263() + 0.5, (double)blockpos.method_10264(), (double)blockpos.method_10260() + 0.5, 1.0);
                }
            } else {
                this.plantSeed();
                --this.tryTicks;
            }
        }
    }

    private void getSeedFromChest() {
        if (this.moveToPoi() && this.getCapCacheResetIfInvalid() != null) {
            assert (this.getCapCache() != null);
            IBlockStorageAccess cap = this.getCapCache().getCapability();
            if (cap == null) {
                return;
            }
            this.soldier.setCarriedStack(cap.tryExtracting(stack -> stack.method_31573(SEEDS), 1));
        }
        if (this.soldier.getCarriedStack().method_7960()) {
            this.takeAShortBreak();
        }
    }

    private void plantSeed() {
        class_1799 seed = this.soldier.getCarriedStack();
        class_1937 level = this.soldier.method_37908();
        if (this.farmLandPos != null && this.isValidTarget((class_4538)level, this.farmLandPos)) {
            class_1792 class_17922;
            class_2338 aboveFarmlandPos = this.farmLandPos.method_10084();
            if (!seed.method_7960() && seed.method_31573(SEEDS) && (class_17922 = seed.method_7909()) instanceof class_1747) {
                class_1747 blockitem = (class_1747)class_17922;
                class_2680 blockState = blockitem.method_7711().method_9564();
                level.method_8501(aboveFarmlandPos, blockState);
                level.method_43276((class_6880)class_5712.field_28164, aboveFarmlandPos, class_5712.class_7397.method_43286((class_1297)this.soldier, (class_2680)blockState));
                this.soldier.setCarriedStack(class_1799.field_8037);
                this.farmLandPos = null;
            } else {
                this.soldier.dropItemStack(this.soldier.getCarriedStack().method_7972());
                this.soldier.setCarriedStack(class_1799.field_8037);
            }
        } else {
            this.findNearestBlock();
        }
    }

    protected boolean findNearestBlock() {
        class_2338 center = this.soldier.method_24515();
        class_2338.class_2339 blockpos$mutableblockpos = new class_2338.class_2339();
        int searchIndex = this.verticalSearchStart;
        while (searchIndex <= this.verticalSearchRange) {
            for (int rangeIndex = 0; rangeIndex < this.searchRange; ++rangeIndex) {
                int i1 = 0;
                while (i1 <= rangeIndex) {
                    int j1;
                    int n = j1 = i1 < rangeIndex && i1 > -rangeIndex ? rangeIndex : 0;
                    while (j1 <= rangeIndex) {
                        blockpos$mutableblockpos.method_25504((class_2382)center, i1, searchIndex - 1, j1);
                        if (this.soldier.method_18407((class_2338)blockpos$mutableblockpos) && this.isValidTarget((class_4538)this.soldier.method_37908(), (class_2338)blockpos$mutableblockpos)) {
                            this.farmLandPos = blockpos$mutableblockpos;
                            return true;
                        }
                        j1 = j1 > 0 ? -j1 : 1 - j1;
                    }
                    i1 = i1 > 0 ? -i1 : 1 - i1;
                }
            }
            searchIndex = searchIndex > 0 ? -searchIndex : 1 - searchIndex;
        }
        this.takeAShortBreak();
        return false;
    }

    protected void moveMobToBlock() {
        if (this.farmLandPos == null) {
            return;
        }
        this.soldier.method_5942().method_6337((double)this.farmLandPos.method_10263() + 0.5, (double)(this.farmLandPos.method_10264() + 1), (double)this.farmLandPos.method_10260() + 0.5, 1.0);
    }

    protected boolean isValidTarget(class_4538 pLevel, @Nullable class_2338 pPos) {
        return pPos != null && pLevel.method_8320(pPos).method_26204() instanceof class_2344 && pLevel.method_8320(pPos.method_10084()).method_26215();
    }

    protected class_2338 getMoveToTarget() {
        return this.farmLandPos.method_10084();
    }

    public boolean method_38846() {
        return true;
    }

    public boolean shouldRecalculatePath() {
        return this.tryTicks % 40 == 0;
    }

    @Override
    public boolean workRequiresItemCarrying() {
        return true;
    }

    @Override
    public class_2561 getDisplayName() {
        return class_2561.method_43471((String)PLACING_SEEDS_LANG);
    }
}

