/*
 * Decompiled with CFR 0.152.
 */
package net.bumblebee.claysoldiers.entity.goal.workgoal;

import java.util.List;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.bumblebee.claysoldiers.ClaySoldiersCommon;
import net.bumblebee.claysoldiers.entity.goal.workgoal.IWorkGoal;
import net.bumblebee.claysoldiers.entity.soldier.AbstractClaySoldierEntity;
import net.bumblebee.claysoldiers.entity.soldier.status.SoldierStatusHolder;
import net.bumblebee.claysoldiers.util.ErrorHandler;
import net.minecraft.class_1352;
import net.minecraft.class_2338;
import net.minecraft.class_2374;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import org.jetbrains.annotations.Nullable;

public class WorkSelectorGoal
extends class_1352
implements SoldierStatusHolder {
    public static final String WORK_STATUS_PAIR_LANG = "clay_soldier_work.%s.status.%s".formatted("csr", "work_pair");
    public static final String WORK_STATUS_SOMETHING_LANG = "clay_soldier_work.%s.status.%s".formatted("csr", "something");
    public static final String WORK_STATUS_RESTING_LANG = "clay_soldier_work.%s.status.%s".formatted("csr", "resting");
    private static final int MAX_INDEX_SIZE = 15;
    private static final String WORK_MODE_TAG = "WorkMode";
    public static final int RESTING_INDEX = -1;
    private final AbstractClaySoldierEntity soldier;
    private final class_1352[] availableWorkGoals;
    private int workIndex = -1;
    @Nullable
    private class_1352 activeGoal;

    public WorkSelectorGoal(AbstractClaySoldierEntity soldier, List<class_1352> goals) {
        this.soldier = soldier;
        if (goals.stream().anyMatch(goal -> !(goal instanceof IWorkGoal))) {
            ClaySoldiersCommon.LOGGER.warn("ClaySoldier has Work that does not extend {}", (Object)IWorkGoal.class.getSimpleName());
        }
        if (goals.size() > 15) {
            this.availableWorkGoals = goals.subList(0, 15).toArray(new class_1352[0]);
            ErrorHandler.INSTANCE.error("Cannot have more than 15 available work goals");
        } else {
            this.availableWorkGoals = goals.toArray(new class_1352[0]);
        }
    }

    public boolean isWorking() {
        return this.workIndex >= 0;
    }

    private void setWorkMode(int mode) {
        if (mode < this.availableWorkGoals.length) {
            this.workIndex = mode;
        }
        this.activeGoal = this.workIndex >= 0 ? this.availableWorkGoals[this.workIndex] : null;
    }

    public boolean workRequiresItemPickUp() {
        IWorkGoal iWorkGoal;
        class_1352 class_13522;
        return !this.soldier.isInSittingPose() && (class_13522 = this.activeGoal) instanceof IWorkGoal && (iWorkGoal = (IWorkGoal)class_13522).workRequiresItemPickUp();
    }

    public boolean workRequiresItemCarrying() {
        IWorkGoal workGoal;
        class_1352 class_13522;
        return !this.soldier.isInSittingPose() && (class_13522 = this.activeGoal) instanceof IWorkGoal && (workGoal = (IWorkGoal)class_13522).workRequiresItemCarrying();
    }

    public void cycleWorkMode() {
        this.workIndex = this.workIndex < this.availableWorkGoals.length - 1 ? ++this.workIndex : -1;
        this.resetGoal();
        this.setWorkMode(this.workIndex);
        this.onWorkStatusChange();
    }

    public class_2561 getWorkDisplayName() {
        class_1352 class_13522 = this.activeGoal;
        if (class_13522 instanceof IWorkGoal) {
            IWorkGoal workGoal = (IWorkGoal)class_13522;
            return workGoal.getDisplayName();
        }
        if (this.workIndex == -1) {
            return class_2561.method_43471((String)WORK_STATUS_RESTING_LANG);
        }
        return class_2561.method_43471((String)WORK_STATUS_SOMETHING_LANG);
    }

    public boolean shouldStayAtWork() {
        return this.workIndex > -1 || this.getSoldierPoiPos() != null;
    }

    public boolean method_6264() {
        return this.mayUse(class_1352::method_6264);
    }

    public boolean method_6266() {
        return this.mayUse(class_1352::method_6266);
    }

    private boolean mayUse(Predicate<class_1352> predicate) {
        if (this.soldier.isOrderedToSit()) {
            return false;
        }
        if (this.soldier.getClayTeamOwnerUUID() == null) {
            return false;
        }
        if (this.workIndex >= 0 && this.soldier.getAttackType().canWork() && this.checkGoal(predicate)) {
            return true;
        }
        this.moveToPoi(this.getSoldierPoiPos());
        return false;
    }

    private void moveToPoi(class_2338 poi) {
        if (poi != null && !poi.method_19769((class_2374)this.soldier.method_19538(), 12.0)) {
            this.soldier.method_5942().method_6337((double)poi.method_10263() + 0.5, (double)poi.method_10264(), (double)poi.method_10260() + 0.5, 1.0);
        }
    }

    public void method_6269() {
        this.doGoalEffect(class_1352::method_6269);
    }

    public void method_6270() {
        this.doGoalEffect(class_1352::method_6270);
    }

    public boolean method_38846() {
        return this.checkGoal(class_1352::method_38846);
    }

    public void method_6268() {
        this.doGoalEffect(class_1352::method_6268);
    }

    private void doGoalEffect(Consumer<class_1352> action) {
        if (this.activeGoal != null) {
            action.accept(this.activeGoal);
        }
    }

    private boolean checkGoal(Predicate<class_1352> predicate) {
        return this.activeGoal != null && predicate.test(this.activeGoal);
    }

    @Nullable
    protected class_2338 getSoldierPoiPos() {
        return this.soldier.getPoiPos();
    }

    protected void onWorkStatusChange() {
        byte by;
        class_1352 class_13522 = this.activeGoal;
        if (class_13522 instanceof IWorkGoal) {
            IWorkGoal goal = (IWorkGoal)class_13522;
            by = goal.getStatus();
        } else {
            by = 0;
        }
        byte goalStatus = by;
        this.soldier.setDataWorkStatus(WorkSelectorGoal.encodeWorkStatusToByte(this.workIndex, goalStatus));
    }

    public static byte encodeWorkStatusToByte(int workIndex, int status) {
        return (byte)(workIndex << 3 | status & 7);
    }

    @Nullable
    private class_2561 decodeWorkStatus(byte data) {
        int rebuiltWorkIndex = data >> 3 & 0x1F;
        rebuiltWorkIndex = rebuiltWorkIndex << 27 >> 27;
        byte goalStatus = (byte)(data & 7);
        if (rebuiltWorkIndex <= -1) {
            return null;
        }
        class_1352 class_13522 = this.availableWorkGoals[rebuiltWorkIndex];
        if (class_13522 instanceof IWorkGoal) {
            IWorkGoal workGoal = (IWorkGoal)class_13522;
            return class_2561.method_43469((String)WORK_STATUS_PAIR_LANG, (Object[])new Object[]{workGoal.getDisplayName(), workGoal.decodeStatus(goalStatus)});
        }
        return class_2561.method_43471((String)IWorkGoal.DEFAULT_STATUS_LANG);
    }

    @Override
    @Nullable
    public class_2561 getStatusDisplayName() {
        return this.soldier.getAttackType().canWork() ? this.decodeWorkStatus(this.soldier.getDataWorkStatus()) : null;
    }

    public void saveToTag(class_2487 tag) {
        tag.method_10567(WORK_MODE_TAG, (byte)this.workIndex);
    }

    public void readFromTag(class_2487 tag) {
        this.setWorkMode(tag.method_10571(WORK_MODE_TAG));
        this.onWorkStatusChange();
    }

    public void resetGoal() {
        if (this.activeGoal != null) {
            this.activeGoal.method_6270();
        }
    }

    public String toString() {
        String string;
        Object[] objectArray = new Object[3];
        objectArray[0] = this.workIndex;
        objectArray[1] = this.availableWorkGoals.length - 1;
        if (this.activeGoal == null) {
            string = "Null";
        } else {
            class_1352 class_13522 = this.activeGoal;
            if (class_13522 instanceof IWorkGoal) {
                IWorkGoal workGoal = (IWorkGoal)class_13522;
                string = workGoal.asString();
            } else {
                string = this.activeGoal.getClass().getSimpleName();
            }
        }
        objectArray[2] = string;
        return "WorkSelectorGoal{%s/%s [%s]}".formatted(objectArray);
    }
}

