/*
 * Decompiled with CFR 0.152.
 */
package net.bumblebee.claysoldiers.entity.goal.workgoal.dig;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.bumblebee.claysoldiers.util.ErrorHandler;
import net.minecraft.class_1297;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_3481;
import net.minecraft.class_5321;
import org.jetbrains.annotations.Nullable;

public class DigBreakManger {
    private static final DigBreakManger INSTANCE = new DigBreakManger();
    private final Map<class_5321<class_1937>, Map<class_2338, BreakData>> breakPosStateMap = new HashMap<class_5321<class_1937>, Map<class_2338, BreakData>>();

    private DigBreakManger() {
    }

    public static DigBreakManger get() {
        return INSTANCE;
    }

    public void registerPos(class_2338 pos, class_1297 entity) {
        BreakData breakData = this.getBreakData(entity.method_37908(), pos);
        if (breakData == null) {
            this.putBreakData(entity, pos, new BreakData(entity));
        } else {
            breakData.addEntity(entity);
        }
    }

    @Nullable
    private BreakData getBreakData(class_1937 level, class_2338 pos) {
        Map<class_2338, BreakData> map = this.breakPosStateMap.get(level.method_27983());
        if (map != null) {
            return map.get(pos);
        }
        return null;
    }

    private void putBreakData(class_1297 entity, class_2338 pos, BreakData data) {
        Map map = this.breakPosStateMap.computeIfAbsent((class_5321<class_1937>)entity.method_37908().method_27983(), k -> new HashMap());
        map.put(pos, data);
    }

    private void removeBreakData(class_1937 level, class_2338 pos) {
        Map map = this.breakPosStateMap.computeIfAbsent((class_5321<class_1937>)level.method_27983(), k -> new HashMap());
        map.remove(pos);
    }

    public void unregisterPos(class_2338 pos, class_1297 entity) {
        BreakData breakData = this.getBreakData(entity.method_37908(), pos);
        if (breakData != null) {
            breakData.removeEntity(entity);
            if (breakData.isEmpty()) {
                this.removeBreakData(entity.method_37908(), pos);
                entity.method_37908().method_8517(entity.method_5628(), pos, -1);
            }
        } else {
            ErrorHandler.INSTANCE.debug("Trying to unregister an Entity for a Empty BreakData");
        }
    }

    public int increaseBreakProgress(class_2338 pos, class_1937 level) {
        BreakData breakData = this.getBreakData(level, pos);
        if (breakData == null) {
            ErrorHandler.INSTANCE.error("Trying to break a block with non existing break data");
            return -2;
        }
        class_2680 state = level.method_8320(pos);
        float destroySpeed = state.method_26214((class_1922)level, pos);
        int soldierNeeded = DigBreakManger.getSoldierNeededForState(state);
        if (soldierNeeded > breakData.size()) {
            return soldierNeeded;
        }
        if ((float)breakData.progress >= destroySpeed * 10.0f * 2.0f * (float)soldierNeeded) {
            this.removeBreakData(level, pos);
            level.method_8517(breakData.getAny(), pos, -1);
            return -1;
        }
        int currentBreakProgress = (int)((float)breakData.progress / (destroySpeed * 2.0f * (float)soldierNeeded));
        if (breakData.lastBreakProgress != currentBreakProgress) {
            level.method_8517(breakData.anyEntity, pos, currentBreakProgress);
            breakData.lastBreakProgress = currentBreakProgress;
        }
        ++breakData.progress;
        return 0;
    }

    private static int getSoldierNeededForState(class_2680 state) {
        if (state.method_26164(class_3481.field_49925)) {
            return 64;
        }
        if (state.method_26164(class_3481.field_49926)) {
            return 16;
        }
        if (state.method_26164(class_3481.field_49927)) {
            return 8;
        }
        if (state.method_26164(class_3481.field_49929)) {
            return 4;
        }
        if (state.method_26164(class_3481.field_49928)) {
            return 4;
        }
        if (state.method_26164(class_3481.field_49930)) {
            return 2;
        }
        return 1;
    }

    public String toString() {
        return "DigBreakManger: " + this.breakPosStateMap.size() + String.valueOf(this.breakPosStateMap.values());
    }

    private static class BreakData {
        private final Set<class_1297> working = new HashSet<class_1297>();
        private int progress = 0;
        private int lastBreakProgress = -1;
        private int anyEntity;

        public BreakData(class_1297 entity) {
            this.working.add(entity);
            this.anyEntity = entity.method_5628();
        }

        public int getAny() {
            return this.anyEntity;
        }

        public void addEntity(class_1297 entity) {
            this.working.add(entity);
        }

        public void removeEntity(class_1297 entity) {
            if (!this.working.remove(entity)) {
                ErrorHandler.INSTANCE.debug("Tried removing non existing entity from BreakData");
            }
            if (this.anyEntity == entity.method_5628() && !this.working.isEmpty()) {
                this.anyEntity = this.working.iterator().next().method_5628();
            }
        }

        public int size() {
            return this.working.size();
        }

        public boolean isEmpty() {
            return this.working.isEmpty();
        }

        public String toString() {
            return "BD:" + this.working.size();
        }
    }
}

