/*
 * Decompiled with CFR 0.152.
 */
package net.bumblebee.claysoldiers.entity.goal.workgoal.dig;

import java.util.List;
import java.util.function.Supplier;
import net.bumblebee.claysoldiers.entity.goal.workgoal.AbstractWorkGoal;
import net.bumblebee.claysoldiers.entity.goal.workgoal.WorkSelectorGoal;
import net.bumblebee.claysoldiers.entity.goal.workgoal.dig.DigBreakManger;
import net.bumblebee.claysoldiers.entity.goal.workgoal.dig.StairPosMap;
import net.bumblebee.claysoldiers.entity.soldier.AbstractClaySoldierEntity;
import net.bumblebee.claysoldiers.util.ErrorHandler;
import net.minecraft.class_1297;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2374;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import org.jetbrains.annotations.Nullable;

public class DigHoleGoal
extends AbstractWorkGoal {
    public static final String DIG_LANG = "clay_soldier_work.%s.status.%s".formatted("csr", "dig");
    public static final String BREAKING_LANG = "clay_soldier_work.%s.status.%s".formatted("csr", "dig.breaking");
    public static final String UNBREAKABLE_BLOCK = "clay_soldier_work.%s.status.%s".formatted("csr", "dig.unbreakable_block");
    private static final byte BREAKING_ID = 2;
    private static final byte UNBREAKABLE_ID = 4;
    private final class_1937 level;
    @Nullable
    private class_2338 currentPos;
    @Nullable
    private class_2338 lastPoiPos;
    @Nullable
    private StairPosMap stairPosMap;
    private final DigBreakManger digBreakManger;

    public DigHoleGoal(AbstractClaySoldierEntity soldier, Supplier<WorkSelectorGoal> workSelector) {
        super(soldier, workSelector, List.of(BREAK_LANG, SEARCHING_LANG, BREAKING_LANG, REQUIRES_POI_LANG, UNBREAKABLE_BLOCK));
        this.level = soldier.method_37908();
        this.digBreakManger = !this.level.field_9236 ? DigBreakManger.get() : null;
    }

    @Override
    public class_2561 getDisplayName() {
        return class_2561.method_43471((String)DIG_LANG);
    }

    public void method_6268() {
        if (this.lastPoiPos == null) {
            this.lastPoiPos = this.getPoiPos();
            return;
        }
        if (this.stairPosMap == null || this.currentPos == null) {
            this.setDigging();
            return;
        }
        if (!this.lastPoiPos.equals((Object)this.getPoiPos())) {
            this.resetBreakProgress();
            this.setDigging();
            return;
        }
        boolean requiresStair = this.stairPosMap.requiresStair(this.currentPos);
        if (this.isBlockConsideredBroken(this.currentPos, requiresStair)) {
            class_2338.class_2339 mut;
            class_2338 class_23382 = this.currentPos;
            this.currentPos = this.getNextPos(class_23382 instanceof class_2338.class_2339 ? (mut = (class_2338.class_2339)class_23382) : this.currentPos.method_25503());
            return;
        }
        if (this.moveToCurrentPos()) {
            if (requiresStair && this.level.method_8320(this.currentPos).method_26215()) {
                this.stairPosMap.placeStair(this.currentPos, this.level);
            } else {
                this.breakBlock(this.currentPos);
            }
        } else {
            this.setStatus((byte)1);
        }
    }

    private class_2338 getNextPos(class_2338.class_2339 current) {
        int xStart = this.lastPoiPos.method_10263() - 2;
        int zStart = this.lastPoiPos.method_10260() - 2;
        int nextIndex = (current.method_10263() - xStart) * 5 + (current.method_10260() - zStart);
        if (++nextIndex >= 25) {
            return this.lastPoiPos.method_10069(-2, current.method_10264() - this.lastPoiPos.method_10264() - 1, -2);
        }
        if (nextIndex <= 0) {
            ErrorHandler.INSTANCE.hide("Something went wrong while trying to find the next block to break");
        }
        int xRelative = nextIndex / 5;
        int zRelative = nextIndex % 5;
        current.method_10103(xRelative + xStart, current.method_10264(), zRelative + zStart);
        return current;
    }

    public boolean method_6264() {
        if (this.getPoiPos() == null) {
            this.setStatus((byte)3);
            return false;
        }
        this.setStatus((byte)1);
        return true;
    }

    public boolean method_6266() {
        if (this.lastPoiPos == null) {
            return false;
        }
        return super.method_6266();
    }

    public void method_6269() {
        this.setDigging();
    }

    public void method_6270() {
        this.resetBreakProgress();
    }

    private void breakBlock(class_2338 pos) {
        this.digBreakManger.registerPos(pos, (class_1297)this.soldier);
        switch (this.digBreakManger.increaseBreakProgress(pos, this.level)) {
            case -2: {
                this.lastPoiPos = null;
            }
            case -1: {
                this.level.method_8651(pos, true, (class_1297)this.soldier);
            }
            case 0: {
                this.setStatus((byte)2);
            }
        }
        this.setStatus((byte)4);
    }

    private boolean isBlockConsideredBroken(class_2338 pos, boolean stair) {
        class_2680 state = this.level.method_8320(pos);
        if (state.method_26214((class_1922)this.level, pos) < 0.0f) {
            return true;
        }
        if (stair) {
            return state.method_27852(class_2246.field_10351) || state.method_27852(class_2246.field_10596);
        }
        return state.method_26215();
    }

    private void setDigging() {
        this.lastPoiPos = this.getPoiPos();
        if (this.lastPoiPos != null) {
            this.currentPos = this.lastPoiPos.method_10069(-2, 0, -2).method_25503();
            this.stairPosMap = new StairPosMap(this.lastPoiPos);
        } else {
            ErrorHandler.INSTANCE.hide("Tried to start digging but has not poi");
        }
    }

    private void resetBreakProgress() {
        if (this.currentPos != null) {
            this.digBreakManger.unregisterPos(this.currentPos, (class_1297)this.soldier);
        }
    }

    public boolean method_38846() {
        return true;
    }

    private boolean moveToCurrentPos() {
        if (this.currentPos != null) {
            if (this.currentPos.method_19769((class_2374)this.soldier.method_19538(), 2.0)) {
                this.soldier.method_5942().method_6340();
                return true;
            }
            this.soldier.method_5942().method_6337((double)this.currentPos.method_10263() + 0.5, (double)(this.currentPos.method_10264() + 1), (double)this.currentPos.method_10260() + 0.5, 1.0);
            return false;
        }
        return false;
    }
}

