/*
 * Decompiled with CFR 0.152.
 */
package net.bumblebee.claysoldiers.entity.goal.workgoal.dig;

import java.util.Optional;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2470;
import net.minecraft.class_2482;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_2771;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StairPosMap {
    private static final StairPos BASE = new StairPos(2, 2, (class_2680)class_2246.field_10351.method_9564().method_11657((class_2769)class_2482.field_11501, (Comparable)class_2771.field_12679));
    private static final StairPos[] STAIRS = new StairPos[]{new StairPos(0, 1, class_2246.field_10596.method_9564()), new StairPos(0, 2, class_2246.field_10596.method_9564()), new StairPos(0, 3, class_2246.field_10596.method_9564()), new StairPos(1, 4, class_2246.field_10596.method_9564().method_26186(class_2470.field_11465)), new StairPos(2, 4, class_2246.field_10596.method_9564().method_26186(class_2470.field_11465)), new StairPos(3, 4, class_2246.field_10596.method_9564().method_26186(class_2470.field_11465)), new StairPos(4, 3, class_2246.field_10596.method_9564().method_26186(class_2470.field_11464)), new StairPos(4, 2, class_2246.field_10596.method_9564().method_26186(class_2470.field_11464)), new StairPos(4, 1, class_2246.field_10596.method_9564().method_26186(class_2470.field_11464)), new StairPos(3, 0, class_2246.field_10596.method_9564().method_26186(class_2470.field_11463)), new StairPos(2, 0, class_2246.field_10596.method_9564().method_26186(class_2470.field_11463)), new StairPos(1, 0, class_2246.field_10596.method_9564().method_26186(class_2470.field_11463))};
    private static final StairPos[] CORNERS = new StairPos[]{new StairPos(0, 0, (class_2680)class_2246.field_10351.method_9564().method_11657((class_2769)class_2482.field_11501, (Comparable)class_2771.field_12679)), new StairPos(0, 4, (class_2680)class_2246.field_10351.method_9564().method_11657((class_2769)class_2482.field_11501, (Comparable)class_2771.field_12679)), new StairPos(4, 4, (class_2680)class_2246.field_10351.method_9564().method_11657((class_2769)class_2482.field_11501, (Comparable)class_2771.field_12679)), new StairPos(4, 0, (class_2680)class_2246.field_10351.method_9564().method_11657((class_2769)class_2482.field_11501, (Comparable)class_2771.field_12679))};
    private final class_2338 poiPos;

    public StairPosMap(@NotNull class_2338 poiPos) {
        this.poiPos = poiPos;
    }

    public void placeStair(class_2338 pos, class_1937 level) {
        this.getStairPos(pos).ifPresent(stairPos -> level.method_8652(pos, stairPos.state, 3));
    }

    public boolean requiresStair(class_2338 pos) {
        return this.getStairPos(pos).isPresent();
    }

    private StairPos getStairPosForHeight(int y) {
        return STAIRS[y % STAIRS.length];
    }

    @Nullable
    private StairPos getCornerPosForHeight(int y) {
        if (y % 3 != 0) {
            return null;
        }
        return CORNERS[y / 3 % CORNERS.length];
    }

    private Optional<StairPos> getStairPos(class_2338 pos) {
        if (pos.equals((Object)this.poiPos)) {
            return Optional.of(BASE);
        }
        int y = this.getYDiff(pos);
        StairPos stairPos = this.getCorner(y);
        if (stairPos != null && stairPos.toBlockPos(this.poiPos, y).equals((Object)pos)) {
            return Optional.of(stairPos);
        }
        stairPos = this.getStairPosForHeight(y);
        if (stairPos.toBlockPos(this.poiPos, y).equals((Object)pos)) {
            return Optional.of(stairPos);
        }
        return Optional.empty();
    }

    private int getYDiff(class_2338 pos) {
        return this.poiPos.method_10264() - pos.method_10264();
    }

    private StairPos getCorner(int y) {
        return this.getCornerPosForHeight(y);
    }

    private record StairPos(int x, int z, class_2680 state) {
        public class_2338 toBlockPos(class_2338 poiPos, int y) {
            return poiPos.method_10069(-2 + this.x, -y, -2 + this.z);
        }
    }
}

