/*
 * Decompiled with CFR 0.152.
 */
package net.bumblebee.claysoldiers.entity.horse;

import java.util.OptionalInt;
import net.bumblebee.claysoldiers.ClaySoldiersCommon;
import net.bumblebee.claysoldiers.entity.ClayMobRideableEntity;
import net.bumblebee.claysoldiers.entity.goal.horse.ClayHorseRandomStandGoal;
import net.bumblebee.claysoldiers.entity.variant.ClayHorseVariants;
import net.bumblebee.claysoldiers.init.ModTags;
import net.bumblebee.claysoldiers.item.itemeffectholder.HorseWearableItemStack;
import net.bumblebee.claysoldiers.menu.horse.ClayHorseMenu;
import net.minecraft.class_1280;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1304;
import net.minecraft.class_1306;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1314;
import net.minecraft.class_1347;
import net.minecraft.class_1352;
import net.minecraft.class_1361;
import net.minecraft.class_1374;
import net.minecraft.class_1376;
import net.minecraft.class_1394;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_1941;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2371;
import net.minecraft.class_238;
import net.minecraft.class_241;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3532;
import net.minecraft.class_3908;
import net.minecraft.class_4048;
import net.minecraft.class_4050;
import net.minecraft.class_5134;
import net.minecraft.class_5275;
import net.minecraft.class_747;
import net.minecraft.class_7988;
import net.minecraft.class_8103;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractClayHorse
extends ClayMobRideableEntity
implements class_7988<ClayHorseVariants> {
    public static final float SCALE = 0.25f;
    private static final class_2940<Byte> DATA_ID_FLAGS = class_2945.method_12791(AbstractClayHorse.class, (class_2941)class_2943.field_13319);
    private static final class_2940<Integer> VARIANT_ID_SYNC = class_2945.method_12791(AbstractClayHorse.class, (class_2941)class_2943.field_13327);
    private static final int FLAG_NOT_USED = 2;
    private static final int FLAG_SADDLE = 4;
    private static final int FLAG_BRED = 8;
    private static final int FLAG_EATING = 16;
    private static final int FLAG_STANDING = 32;
    private static final int FLAG_OPEN_MOUTH = 64;
    private static final int ARMOR_INDEX = 0;
    private int eatingCounter;
    private int standCounter;
    public int tailCounter;
    private float eatAnim;
    private float eatAnimO;
    private float standAnim;
    private float standAnimO;
    private float mouthAnim;
    private float mouthAnimO;
    protected boolean canGallop = true;
    protected int gallopSoundCounter;
    private final class_2371<HorseWearableItemStack> armorList = class_2371.method_10213((int)1, (Object)HorseWearableItemStack.EMPTY);

    protected AbstractClayHorse(class_1299<? extends ClayMobRideableEntity> pEntityType, class_1937 pLevel) {
        super(pEntityType, pLevel);
        this.method_5952(true);
    }

    protected void addBehaviourGoals() {
        this.field_6201.method_6277(0, (class_1352)new class_1347((class_1308)this));
    }

    protected void method_5959() {
        this.field_6201.method_6277(1, (class_1352)new class_1374((class_1314)this, 1.2));
        this.field_6201.method_6277(6, (class_1352)new class_1394((class_1314)this, 0.7));
        this.field_6201.method_6277(7, (class_1352)new class_1361((class_1308)this, class_1657.class, 6.0f));
        this.field_6201.method_6277(8, (class_1352)new class_1376((class_1308)this));
        if (this.canPerformRearing()) {
            this.field_6201.method_6277(9, (class_1352)new ClayHorseRandomStandGoal(this));
        }
        this.addBehaviourGoals();
    }

    @Override
    public void method_5652(class_2487 pCompound) {
        super.method_5652(pCompound);
        pCompound.method_10556("EatingHaystack", this.isEating());
        pCompound.method_10556("Bred", this.isBred());
        pCompound.method_10569("Variant", this.getVariant().getId());
    }

    @Override
    public void method_5749(class_2487 pCompound) {
        super.method_5749(pCompound);
        this.setEating(pCompound.method_10577("EatingHaystack"));
        this.setBred(pCompound.method_10577("Bred"));
        this.setVariant(ClayHorseVariants.getById(pCompound.method_10550("Variant")));
        this.setArmor(this.method_6118(class_1304.field_48824));
    }

    @Override
    protected void method_5693(class_2945.class_9222 builder) {
        super.method_5693(builder);
        builder.method_56912(DATA_ID_FLAGS, (Object)0);
        builder.method_56912(VARIANT_ID_SYNC, (Object)0);
    }

    protected boolean getFlag(int pFlagId) {
        return ((Byte)this.field_6011.method_12789(DATA_ID_FLAGS) & pFlagId) != 0;
    }

    protected void setFlag(int pFlagId, boolean pValue) {
        byte b0 = (Byte)this.field_6011.method_12789(DATA_ID_FLAGS);
        if (pValue) {
            this.field_6011.method_12778(DATA_ID_FLAGS, (Object)((byte)(b0 | pFlagId)));
        } else {
            this.field_6011.method_12778(DATA_ID_FLAGS, (Object)((byte)(b0 & ~pFlagId)));
        }
    }

    public boolean isEating() {
        return this.getFlag(16);
    }

    public boolean isStanding() {
        return this.getFlag(32);
    }

    public boolean isBred() {
        return this.getFlag(8);
    }

    public void setBred(boolean pBreeding) {
        this.setFlag(8, pBreeding);
    }

    public boolean isSaddled() {
        return this.getFlag(4);
    }

    public void setEating(boolean pEating) {
        this.setFlag(16, pEating);
    }

    public void setStanding(boolean pStanding) {
        if (pStanding) {
            this.setEating(false);
        }
        this.setFlag(32, pStanding);
    }

    public boolean method_5810() {
        return !this.method_5782();
    }

    public boolean method_5747(float pFallDistance, float pMultiplier, class_1282 pSource) {
        int i;
        if (pFallDistance > 1.0f) {
            this.method_5783(class_3417.field_14783, 0.4f, 1.0f);
        }
        if ((i = this.method_23329(pFallDistance, pMultiplier)) <= 0) {
            return false;
        }
        this.method_5643(pSource, i);
        if (this.method_5782()) {
            for (class_1297 entity : this.method_5736()) {
                entity.method_5643(pSource, (float)i);
            }
        }
        this.method_23328();
        return true;
    }

    protected int method_23329(float pDistance, float pDamageMultiplier) {
        return class_3532.method_15386((float)((pDistance * 0.5f - 3.0f) * pDamageMultiplier));
    }

    @Override
    public boolean method_5643(class_1282 pSource, float pAmount) {
        boolean flag = super.method_5643(pSource, pAmount);
        if (flag && this.field_5974.method_43048(3) == 0) {
            this.standIfPossible();
        }
        return flag;
    }

    public boolean method_6062() {
        return super.method_6062() || this.isEating() || this.isStanding();
    }

    private void moveTail() {
        this.tailCounter = 1;
    }

    public void method_6007() {
        if (this.field_5974.method_43048(200) == 0) {
            this.moveTail();
        }
        super.method_6007();
        if (!this.method_37908().field_9236 && this.method_5805()) {
            if (this.field_5974.method_43048(900) == 0 && this.field_6213 == 0) {
                this.method_6025(1.0f);
            }
            if (this.canEatGrass()) {
                if (!this.isEating() && !this.method_5782() && this.field_5974.method_43048(300) == 0 && this.method_37908().method_8320(this.method_24515().method_10074()).method_27852(class_2246.field_10219)) {
                    this.setEating(true);
                }
                if (this.isEating() && ++this.eatingCounter > 50) {
                    this.eatingCounter = 0;
                    this.setEating(false);
                }
            }
        }
    }

    public void standIfPossible() {
        if (this.canPerformRearing() && this.method_6034()) {
            this.standCounter = 1;
            this.setStanding(true);
        }
    }

    protected class_241 getRiddenRotation(class_1309 pEntity) {
        return new class_241(pEntity.method_36455() * 0.5f, pEntity.method_36454());
    }

    @Nullable
    private class_243 getDismountLocationInDirection(class_243 pDirection, class_1309 pPassenger) {
        double d0 = this.method_23317() + pDirection.field_1352;
        double d1 = this.method_5829().field_1322;
        double d2 = this.method_23321() + pDirection.field_1350;
        class_2338.class_2339 blockpos$mutableblockpos = new class_2338.class_2339();
        block0: for (class_4050 pose : pPassenger.method_24831()) {
            blockpos$mutableblockpos.method_10102(d0, d1, d2);
            double d3 = this.method_5829().field_1325 + 0.75;
            do {
                double d4 = this.method_37908().method_30347((class_2338)blockpos$mutableblockpos);
                if ((double)blockpos$mutableblockpos.method_10264() + d4 > d3) continue block0;
                if (class_5275.method_27932((double)d4)) {
                    class_238 aabb = pPassenger.method_24833(pose);
                    class_243 vec3 = new class_243(d0, (double)blockpos$mutableblockpos.method_10264() + d4, d2);
                    if (class_5275.method_27933((class_1941)this.method_37908(), (class_1309)pPassenger, (class_238)aabb.method_997(vec3))) {
                        pPassenger.method_18380(pose);
                        return vec3;
                    }
                }
                blockpos$mutableblockpos.method_10098(class_2350.field_11036);
            } while (!((double)blockpos$mutableblockpos.method_10264() < d3));
        }
        return null;
    }

    public class_243 method_24829(class_1309 pLivingEntity) {
        class_243 vec3 = AbstractClayHorse.method_24826((double)this.method_17681(), (double)pLivingEntity.method_17681(), (float)(this.method_36454() + (pLivingEntity.method_6068() == class_1306.field_6183 ? 90.0f : -90.0f)));
        class_243 vec31 = this.getDismountLocationInDirection(vec3, pLivingEntity);
        if (vec31 != null) {
            return vec31;
        }
        class_243 vec32 = AbstractClayHorse.method_24826((double)this.method_17681(), (double)pLivingEntity.method_17681(), (float)(this.method_36454() + (pLivingEntity.method_6068() == class_1306.field_6182 ? 90.0f : -90.0f)));
        class_243 vec33 = this.getDismountLocationInDirection(vec32, pLivingEntity);
        return vec33 != null ? vec33 : this.method_19538();
    }

    protected class_243 method_52533(class_1297 pEntity, class_4048 pDimensions, float pPartialTick) {
        return super.method_52533(pEntity, pDimensions, pPartialTick).method_1019(new class_243(0.0, 0.15 * (double)this.standAnimO * (double)pPartialTick, -0.7 * (double)this.standAnimO * (double)pPartialTick).method_1024(-this.method_36454() * ((float)Math.PI / 180)));
    }

    protected void method_5865(class_1297 pPassenger, class_1297.class_4738 pCallback) {
        super.method_5865(pPassenger, pCallback);
        if (pPassenger instanceof class_1309) {
            ((class_1309)pPassenger).field_6283 = this.field_6283;
        }
    }

    @NotNull
    public ClayHorseVariants getVariant() {
        return ClayHorseVariants.getById((Integer)this.field_6011.method_12789(VARIANT_ID_SYNC));
    }

    public void setVariant(ClayHorseVariants pVariant) {
        this.field_6011.method_12778(VARIANT_ID_SYNC, (Object)pVariant.getId());
    }

    public HorseWearableItemStack getArmor() {
        return (HorseWearableItemStack)this.armorList.get(0);
    }

    public void setArmor(class_1799 stack) {
        this.method_5673(class_1304.field_48824, stack);
    }

    public void method_5673(class_1304 pSlot, class_1799 pStack) {
        super.method_5673(pSlot, pStack);
        if (pSlot == class_1304.field_48824) {
            this.armorList.set(0, (Object)new HorseWearableItemStack(pStack));
        }
    }

    public boolean method_20820(class_1799 pStack) {
        return pStack.method_31573(ModTags.Items.CLAY_HORSE_ARMOR);
    }

    public class_1799 method_24523(class_1799 pStack) {
        HorseWearableItemStack horseWearableItemStack = new HorseWearableItemStack(pStack);
        if (horseWearableItemStack.effect() == null) {
            return class_1799.field_8037;
        }
        class_1304 slot = horseWearableItemStack.getEquipmentSlot();
        if (!this.method_6118(slot).method_7960()) {
            return class_1799.field_8037;
        }
        if (pStack.method_7947() > 1) {
            class_1799 stackLeft = pStack.method_46651(1);
            this.method_24834(slot, stackLeft);
            return stackLeft;
        }
        this.method_24834(slot, pStack);
        return pStack;
    }

    protected float method_6132(class_1282 pDamageSource, float pDamageAmount) {
        if (!pDamageSource.method_48789(class_8103.field_42241)) {
            this.method_6105(pDamageSource, pDamageAmount);
            pDamageAmount = class_1280.method_5496((class_1309)this, (float)pDamageAmount, (class_1282)pDamageSource, (float)((float)this.method_6096() + this.getArmor().protection()), (float)((float)this.method_45325(class_5134.field_23725)));
        }
        return pDamageAmount;
    }

    @Override
    protected OptionalInt openMenuScreen(class_1657 player) {
        return ClaySoldiersCommon.COMMON_HOOKS.openMenu(player, (class_3908)new class_747((id, inventory, player1) -> new ClayHorseMenu(id, inventory, this), this.getInventoryName()), this.method_5628());
    }

    public float getEatAnim(float pPartialTick) {
        return class_3532.method_16439((float)pPartialTick, (float)this.eatAnimO, (float)this.eatAnim);
    }

    public float getStandAnim(float pPartialTick) {
        return class_3532.method_16439((float)pPartialTick, (float)this.standAnimO, (float)this.standAnim);
    }

    public float getMouthAnim(float pPartialTick) {
        return class_3532.method_16439((float)pPartialTick, (float)this.mouthAnimO, (float)this.mouthAnim);
    }

    public boolean canPerformRearing() {
        return true;
    }

    public boolean canEatGrass() {
        return true;
    }

    @Override
    protected double getDefaultAttackReach() {
        return 0.0;
    }

    protected float method_6107() {
        return 0.8f;
    }

    public int method_5970() {
        return 400;
    }

    public boolean method_6101() {
        return false;
    }

    @Nullable
    public class_3414 getAmbientStandSound() {
        return this.method_5994();
    }

    public int getAmbientStandInterval() {
        return this.method_5970();
    }

    protected class_4048 method_55694(class_4050 pPose) {
        if (class_4050.field_40118 == pPose && !this.method_5765()) {
            return super.method_55694(pPose).method_19539(1.0f, 0.7f);
        }
        return super.method_55694(pPose);
    }
}

