/*
 * Decompiled with CFR 0.152.
 */
package net.bumblebee.claysoldiers.entity.soldier;

import com.google.common.collect.Iterables;
import com.mojang.logging.LogUtils;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.OptionalInt;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.bumblebee.claysoldiers.ClaySoldiersCommon;
import net.bumblebee.claysoldiers.capability.AssignablePoiCapability;
import net.bumblebee.claysoldiers.capability.CustomEquipCapability;
import net.bumblebee.claysoldiers.capability.ThrowableItemCapability;
import net.bumblebee.claysoldiers.clayremovalcondition.RemovalCondition;
import net.bumblebee.claysoldiers.clayremovalcondition.RemovalConditionContext;
import net.bumblebee.claysoldiers.datamap.SoldierEquipmentSlot;
import net.bumblebee.claysoldiers.datamap.SoldierHoldableEffect;
import net.bumblebee.claysoldiers.datamap.SoldierSlotCallback;
import net.bumblebee.claysoldiers.entity.ClayMobEntity;
import net.bumblebee.claysoldiers.entity.ClayMobTeamOwnerEntity;
import net.bumblebee.claysoldiers.entity.ClaySoldierRideableMap;
import net.bumblebee.claysoldiers.entity.ClayWraithEntity;
import net.bumblebee.claysoldiers.entity.goal.ClayMobFollowTeamOwner;
import net.bumblebee.claysoldiers.entity.goal.ClayMobSitGoal;
import net.bumblebee.claysoldiers.entity.goal.ClaySodlierBreathAirGoal;
import net.bumblebee.claysoldiers.entity.goal.ClaySoldierMeleeAttackGoal;
import net.bumblebee.claysoldiers.entity.goal.ClaySoldierMeleeSupportGoal;
import net.bumblebee.claysoldiers.entity.goal.ClaySoldierMountGoal;
import net.bumblebee.claysoldiers.entity.goal.ClaySoldierRangedAttackGoal;
import net.bumblebee.claysoldiers.entity.goal.UseAssignedPoiGoal;
import net.bumblebee.claysoldiers.entity.goal.target.ClayMobOwnerHurtByTarget;
import net.bumblebee.claysoldiers.entity.goal.target.ClayMobOwnerTarget;
import net.bumblebee.claysoldiers.entity.goal.target.ClaySoldierHurtByTargetGoal;
import net.bumblebee.claysoldiers.entity.goal.target.ClaySoldierNearestTargetGoal;
import net.bumblebee.claysoldiers.entity.goal.target.NearestRideableTargetGoal;
import net.bumblebee.claysoldiers.entity.goal.workgoal.BreakCropGoal;
import net.bumblebee.claysoldiers.entity.goal.workgoal.BuildBlueprintGoal;
import net.bumblebee.claysoldiers.entity.goal.workgoal.PickUpItemsGoal;
import net.bumblebee.claysoldiers.entity.goal.workgoal.PlaceSeedsGoal;
import net.bumblebee.claysoldiers.entity.goal.workgoal.WorkSelectorGoal;
import net.bumblebee.claysoldiers.entity.goal.workgoal.dig.DigHoleGoal;
import net.bumblebee.claysoldiers.entity.soldier.ClaySoldierInventoryHandler;
import net.bumblebee.claysoldiers.entity.soldier.ClaySoldierLike;
import net.bumblebee.claysoldiers.entity.soldier.ClaySoldierMoveControl;
import net.bumblebee.claysoldiers.entity.soldier.status.SoldierStatusHolder;
import net.bumblebee.claysoldiers.entity.soldier.status.SoldierStatusManager;
import net.bumblebee.claysoldiers.entity.throwables.ClaySoldierThrowableItemEntity;
import net.bumblebee.claysoldiers.init.ModDamageTypes;
import net.bumblebee.claysoldiers.init.ModItems;
import net.bumblebee.claysoldiers.init.ModTags;
import net.bumblebee.claysoldiers.item.ClayBrushItem;
import net.bumblebee.claysoldiers.item.claymobspawn.ClaySoldierSpawnItem;
import net.bumblebee.claysoldiers.item.itemeffectholder.ItemStackEffectHolder;
import net.bumblebee.claysoldiers.item.itemeffectholder.ItemStackWithEffect;
import net.bumblebee.claysoldiers.menu.soldier.ClaySoldierMenu;
import net.bumblebee.claysoldiers.networking.ClaySoldierReviveCooldownPayload;
import net.bumblebee.claysoldiers.networking.SoldierCarriedChangePayload;
import net.bumblebee.claysoldiers.networking.SoldierItemChangePayload;
import net.bumblebee.claysoldiers.networking.spawnpayloads.ClaySoldierSpawnPayload;
import net.bumblebee.claysoldiers.soldierpoi.FindNearestPoiGoal;
import net.bumblebee.claysoldiers.soldierproperties.SoldierPropertyMapReader;
import net.bumblebee.claysoldiers.soldierproperties.SoldierPropertyTypes;
import net.bumblebee.claysoldiers.soldierproperties.SoldierVehicleProperties;
import net.bumblebee.claysoldiers.soldierproperties.combined.SoldierHoldablePropertiesCombiner;
import net.bumblebee.claysoldiers.soldierproperties.customproperties.AttackTypeProperty;
import net.bumblebee.claysoldiers.soldierproperties.customproperties.RangedAttackType;
import net.bumblebee.claysoldiers.soldierproperties.customproperties.WraithProperty;
import net.bumblebee.claysoldiers.soldierproperties.customproperties.revive.ReviveProperty;
import net.bumblebee.claysoldiers.soldierproperties.customproperties.revive.ReviveResult;
import net.bumblebee.claysoldiers.soldierproperties.customproperties.revive.ReviveType;
import net.bumblebee.claysoldiers.soldierproperties.customproperties.specialattack.SpecialAttack;
import net.bumblebee.claysoldiers.soldierproperties.customproperties.specialattack.SpecialAttackType;
import net.bumblebee.claysoldiers.soldierproperties.customproperties.specialattack.SpecialEffectCategory;
import net.bumblebee.claysoldiers.team.ClayMobTeamManger;
import net.bumblebee.claysoldiers.util.color.ColorHelper;
import net.bumblebee.claysoldiers.util.color.EntityDataColorWrapper;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1280;
import net.minecraft.class_1282;
import net.minecraft.class_1291;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1295;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1304;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1314;
import net.minecraft.class_1352;
import net.minecraft.class_1376;
import net.minecraft.class_1379;
import net.minecraft.class_1391;
import net.minecraft.class_1408;
import net.minecraft.class_1542;
import net.minecraft.class_1603;
import net.minecraft.class_1657;
import net.minecraft.class_1676;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1890;
import net.minecraft.class_1937;
import net.minecraft.class_2371;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3532;
import net.minecraft.class_3908;
import net.minecraft.class_4048;
import net.minecraft.class_4050;
import net.minecraft.class_5132;
import net.minecraft.class_5134;
import net.minecraft.class_5244;
import net.minecraft.class_5250;
import net.minecraft.class_5455;
import net.minecraft.class_5712;
import net.minecraft.class_5766;
import net.minecraft.class_5819;
import net.minecraft.class_6880;
import net.minecraft.class_7;
import net.minecraft.class_7225;
import net.minecraft.class_747;
import net.minecraft.class_8080;
import net.minecraft.class_8103;
import net.minecraft.class_8111;
import net.minecraft.class_9283;
import net.minecraft.class_9331;
import net.minecraft.class_9334;
import net.minecraft.class_9701;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

public class AbstractClaySoldierEntity
extends ClayMobTeamOwnerEntity
implements class_1603,
ClaySoldierInventoryHandler,
ClaySoldierLike {
    public static final String DEFENDING_AREA_LANG = "clay_soldier_work.%s.job.%s".formatted("csr", "defending_area");
    public static final String PROTECTING_OWNER_LANG = "clay_soldier_work.%s.job.%s".formatted("csr", "protecting_owner");
    public static final String BACKPACK_ITEMS_TAG = "SoldierBackpackItems";
    public static final String HAND_ITEMS_TAG = "SoldierHandItems";
    public static final String ARMOR_ITEMS_TAG = "SoldierArmorItems";
    public static final String OFFSET_COLOR_TAG = "OffsetColor";
    public static final String REVIVE_TYPE_COOLDOWN_TAG = "revive_type_cooldown";
    public static final String SKIN_VARIANT_ID_TAG = "SkinVariantId";
    public static final String CARRIED_ITEM_TAG = "CarriedItem";
    public static final String FUSE_TAG = "Fuse";
    public static final String EXPLOSION_RADIUS_TAG = "ExplosionRadius";
    public static final String IGNITED_TAG = "ignited";
    private static final class_2940<Byte> DATA_WORK_STATUS = class_2945.method_12791(AbstractClaySoldierEntity.class, (class_2941)class_2943.field_13319);
    private static final class_2940<Integer> DATA_SWELL_DIR = class_2945.method_12791(AbstractClaySoldierEntity.class, (class_2941)class_2943.field_13327);
    private static final class_2940<Boolean> DATA_IS_IGNITED = class_2945.method_12791(AbstractClaySoldierEntity.class, (class_2941)class_2943.field_13323);
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final class_2940<Integer> DATA_OFFSET_COLOR = class_2945.method_12791(AbstractClaySoldierEntity.class, (class_2941)class_2943.field_13327);
    private static final class_2940<Boolean> DATA_IS_JEB = class_2945.method_12791(AbstractClaySoldierEntity.class, (class_2941)class_2943.field_13323);
    protected static final byte EXPLODE_FIREWORK_EVENT = 81;
    private static final int MIN_POWER_FOR_SPECIAL_ATTACKS = 1;
    protected final AttackTypeProperty defaultAttackType;
    private static final byte NO_GLIDE = -1;
    private static final byte GLIDE_UNCHECKED = -2;
    private byte lastGliderSlot = (byte)-2;
    private final class_2371<ItemStackWithEffect> soldierHandItems = class_2371.method_10213((int)2, (Object)ItemStackWithEffect.EMPTY);
    private final class_2371<ItemStackWithEffect> soldierArmorItems = class_2371.method_10213((int)5, (Object)ItemStackWithEffect.EMPTY);
    private final class_2371<ItemStackWithEffect> soldierBackpackItems = class_2371.method_10213((int)2, (Object)ItemStackWithEffect.EMPTY);
    protected final SoldierHoldablePropertiesCombiner propertyCombiner;
    public float oBob;
    public float bob;
    private static final double MAGIC_CAPE_NUMBER = 10.0;
    public double xCloakO;
    public double yCloakO;
    public double zCloakO;
    public double xCloak;
    public double yCloak;
    public double zCloak;
    private float delayedScale;
    private int oldSwell;
    private int swell;
    private int maxSwell = 30;
    private float explosionRadius = 1.0f;
    @Nullable
    private ItemStackWithEffect stackWithProjectile;
    private int skinVariantId;
    private WorkSelectorGoal workSelector;
    private class_1799 carriedStack = class_1799.field_8037;
    private final SoldierStatusHolder statusManger;
    private final EntityDataColorWrapper colorGetter;
    private final Map<ReviveType, Long> reviveTypeCooldown = new EnumMap<ReviveType, Long>(ReviveType.class);
    private final class_1408 waterNavigation;
    private final class_1408 groundNavigation;
    private boolean inCombat = false;

    protected AbstractClaySoldierEntity(class_1299<? extends AbstractClaySoldierEntity> pEntityType, class_1937 pLevel, AttackTypeProperty defaultAttackType) {
        this(pEntityType, pLevel, defaultAttackType, s -> SoldierStatusManager.initDefault(s, () -> s.workSelector));
        this.method_5952(true);
        this.setSpawnedFrom(ModItems.CLAY_SOLDIER.get().method_7854(), true);
        this.inWallDamage = (w, e) -> {
            if (this.workSelector.isWorking()) {
                return 0.2f;
            }
            return w ? 0.5f : 1.0f;
        };
        this.delayedScale = this.getSoldierSize();
    }

    protected AbstractClaySoldierEntity(class_1299<? extends AbstractClaySoldierEntity> pEntityType, class_1937 pLevel, AttackTypeProperty defaultAttackType, Function<AbstractClaySoldierEntity, SoldierStatusHolder> statusManger) {
        super(pEntityType, pLevel);
        this.defaultAttackType = defaultAttackType;
        this.stackWithProjectile = null;
        this.propertyCombiner = new SoldierHoldablePropertiesCombiner(this, this.method_6127());
        this.skinVariantId = this.method_59922().method_43048(2) == 1 ? 1 : 0;
        this.statusManger = statusManger.apply(this);
        this.colorGetter = new EntityDataColorWrapper(DATA_OFFSET_COLOR, DATA_IS_JEB, () -> ((AbstractClaySoldierEntity)this).method_5841());
        this.waterNavigation = new class_5766((class_1308)this, pLevel);
        this.groundNavigation = this.method_5965(pLevel);
        this.field_6207 = new ClaySoldierMoveControl(this, this::canSwim, 85, 10, false);
        this.workSelector = this.getOrCreateWorkSelectorGoal();
    }

    public static class_5132 setSoldierAttributes() {
        return class_1308.method_26828().method_26868(class_5134.field_23716, 20.0).method_26868(class_5134.field_23724, 0.0).method_26868(class_5134.field_23721, 2.5).method_26868(class_5134.field_23723, 0.1).method_26868(class_5134.field_23719, 0.3).method_26868(class_5134.field_23717, 16.0).method_26868(class_5134.field_23718, 0.5).method_26866();
    }

    private static Iterable<class_1799> convertToStack(List<ItemStackWithEffect> stackWithEffects) {
        return stackWithEffects.stream().map(ItemStackEffectHolder::stack).toList();
    }

    protected WorkSelectorGoal getOrCreateWorkSelectorGoal() {
        if (this.workSelector != null) {
            return this.workSelector;
        }
        ArrayList<class_1352> goals = new ArrayList<class_1352>(List.of(new BreakCropGoal(this, 1.0, 16, () -> this.workSelector), new PickUpItemsGoal(this, () -> this.workSelector), new PlaceSeedsGoal(this, () -> this.workSelector, 16), new DigHoleGoal(this, () -> this.workSelector)));
        if (ClaySoldiersCommon.COMMON_HOOKS.isBlueprintEnabled(this.method_37908().method_45162())) {
            goals.add(new BuildBlueprintGoal(this, () -> this.workSelector, 8));
        }
        this.workSelector = new WorkSelectorGoal(this, goals);
        return this.workSelector;
    }

    protected void method_5959() {
        this.field_6201.method_6277(1, (class_1352)new ClaySodlierBreathAirGoal(this));
        this.field_6201.method_6277(2, (class_1352)new ClayMobSitGoal(this));
        this.field_6201.method_6277(3, (class_1352)this.getOrCreateWorkSelectorGoal());
        this.field_6201.method_6277(4, (class_1352)new UseAssignedPoiGoal(this, 1.2));
        this.field_6201.method_6277(4, (class_1352)new FindNearestPoiGoal(this));
        this.field_6201.method_6277(4, (class_1352)new ClaySoldierMountGoal(this, 1.2f, false));
        this.field_6201.method_6277(5, (class_1352)new ClaySoldierRangedAttackGoal(this, 1.25, 10.0f));
        this.field_6201.method_6277(5, (class_1352)new ClaySoldierMeleeAttackGoal(this, 1.0, false));
        this.field_6201.method_6277(6, (class_1352)new ClaySoldierMeleeSupportGoal(this, 1.0, true));
        this.field_6201.method_6277(7, (class_1352)new ClayMobFollowTeamOwner(this, 1.0f, 5.5f, 3.0f));
        this.field_6201.method_6277(8, (class_1352)new class_1391((class_1314)this, (double)1.2f, x$0 -> this.isClayFood((class_1799)x$0), false));
        this.field_6201.method_6277(9, (class_1352)new class_1379((class_1314)this, 1.0));
        this.field_6201.method_6277(10, (class_1352)new class_1376((class_1308)this));
        this.field_6185.method_6277(0, (class_1352)new ClaySoldierHurtByTargetGoal(this, new Class[0]));
        this.field_6185.method_6277(1, (class_1352)new NearestRideableTargetGoal(this));
        this.field_6185.method_6277(2, (class_1352)new ClayMobOwnerHurtByTarget(this));
        this.field_6185.method_6277(3, (class_1352)new ClayMobOwnerTarget(this));
        this.field_6185.method_6277(4, (class_1352)new ClaySoldierNearestTargetGoal(this, false, this::targetPredicate, this::specificTargetPredicate));
    }

    @Override
    public void method_5652(class_2487 pCompound) {
        super.method_5652(pCompound);
        this.addArmorSaveData(pCompound);
        pCompound.method_10575(FUSE_TAG, (short)this.maxSwell);
        pCompound.method_10567(EXPLOSION_RADIUS_TAG, (byte)this.explosionRadius);
        pCompound.method_10556(IGNITED_TAG, this.isIgnited());
        this.getOffsetColor().writeToTag(OFFSET_COLOR_TAG, pCompound);
        class_2487 reviveCooldownMapNBT = new class_2487();
        for (Map.Entry<ReviveType, Long> entry : this.reviveTypeCooldown.entrySet()) {
            Long value = entry.getValue();
            if (value == null) continue;
            reviveCooldownMapNBT.method_10544(entry.getKey().method_15434(), value.longValue());
        }
        if (!reviveCooldownMapNBT.method_33133()) {
            pCompound.method_10566(REVIVE_TYPE_COOLDOWN_TAG, (class_2520)reviveCooldownMapNBT);
        }
        pCompound.method_10569(SKIN_VARIANT_ID_TAG, this.skinVariantId);
        this.workSelector.saveToTag(pCompound);
        this.workSelector.resetGoal();
        if (!this.carriedStack.method_7960()) {
            pCompound.method_10566(CARRIED_ITEM_TAG, this.carriedStack.method_57358((class_7225.class_7874)this.method_56673()));
        }
    }

    protected void addArmorSaveData(class_2487 tag) {
        tag.method_10566(HAND_ITEMS_TAG, (class_2520)this.createItemListTag((List<ItemStackWithEffect>)this.soldierHandItems));
        tag.method_10566(ARMOR_ITEMS_TAG, (class_2520)this.createItemListTag((List<ItemStackWithEffect>)this.soldierArmorItems));
        tag.method_10566(BACKPACK_ITEMS_TAG, (class_2520)this.createItemListTag((List<ItemStackWithEffect>)this.soldierBackpackItems));
    }

    private class_2499 createItemListTag(List<ItemStackWithEffect> itemStacks) {
        class_2499 listTag = new class_2499();
        for (ItemStackWithEffect stackWithEffect : itemStacks) {
            if (!stackWithEffect.isEmpty()) {
                listTag.add((Object)stackWithEffect.save((class_7225.class_7874)this.method_56673()));
                continue;
            }
            listTag.add((Object)new class_2487());
        }
        return listTag;
    }

    @Override
    public void method_5749(class_2487 pCompound) {
        super.method_5749(pCompound);
        this.readArmorSaveData(pCompound);
        if (pCompound.method_10573(FUSE_TAG, 99)) {
            this.maxSwell = pCompound.method_10568(FUSE_TAG);
        }
        if (pCompound.method_10573(EXPLOSION_RADIUS_TAG, 99)) {
            this.explosionRadius = pCompound.method_10571(EXPLOSION_RADIUS_TAG);
        }
        if (pCompound.method_10577(IGNITED_TAG)) {
            this.ignite();
        }
        this.setOffsetColor(ColorHelper.getFromTag(OFFSET_COLOR_TAG, pCompound));
        this.querySpecialProperties();
        this.initCombinedProperties();
        this.updateOtherProperties();
        if (pCompound.method_10573(REVIVE_TYPE_COOLDOWN_TAG, 10)) {
            class_2487 reviveTypeNbt = pCompound.method_10562(REVIVE_TYPE_COOLDOWN_TAG);
            for (String key : reviveTypeNbt.method_10541()) {
                ReviveType.getFromString(key).ifPresent(type -> this.reviveTypeCooldown.put((ReviveType)type, reviveTypeNbt.method_10537(key)));
            }
        }
        this.skinVariantId = pCompound.method_10550(SKIN_VARIANT_ID_TAG);
        this.workSelector.readFromTag(pCompound);
        if (pCompound.method_10545(CARRIED_ITEM_TAG)) {
            this.carriedStack = class_1799.method_57359((class_7225.class_7874)this.method_56673(), (class_2487)pCompound.method_10562(CARRIED_ITEM_TAG));
        }
    }

    protected void readArmorSaveData(class_2487 tag) {
        AbstractClaySoldierEntity.getFromTag(tag, HAND_ITEMS_TAG, (arg_0, arg_1) -> this.soldierHandItems.set(arg_0, arg_1), this.method_56673());
        AbstractClaySoldierEntity.getFromTag(tag, ARMOR_ITEMS_TAG, (arg_0, arg_1) -> this.soldierArmorItems.set(arg_0, arg_1), this.method_56673());
        AbstractClaySoldierEntity.getFromTag(tag, BACKPACK_ITEMS_TAG, (arg_0, arg_1) -> this.soldierBackpackItems.set(arg_0, arg_1), this.method_56673());
    }

    public static void getFromTag(class_2487 tag, String key, BiConsumer<Integer, ItemStackWithEffect> listSetter, class_5455 registryAccess) {
        if (tag.method_10573(key, 9)) {
            class_2499 listTag = tag.method_10554(key, 10);
            for (int index = 0; index < listTag.size(); ++index) {
                listSetter.accept(index, ItemStackWithEffect.parseOptional((class_7225.class_7874)registryAccess, listTag.method_10602(index)));
            }
        }
    }

    @Override
    protected void method_5693(class_2945.class_9222 builder) {
        super.method_5693(builder);
        builder.method_56912(DATA_SWELL_DIR, (Object)-1);
        builder.method_56912(DATA_IS_IGNITED, (Object)false);
        builder.method_56912(DATA_WORK_STATUS, (Object)WorkSelectorGoal.encodeWorkStatusToByte(-1, 0));
        EntityDataColorWrapper.define(builder, DATA_OFFSET_COLOR, DATA_IS_JEB);
    }

    @Override
    protected void handleTeamChange(class_2960 teamId) {
        this.propertyCombiner.addPropertyFromTeam(ClayMobTeamManger.getFromKeyAssumeValid(teamId, this.method_56673()));
        this.propertyCombiner.combine();
    }

    protected float getAttackPower(class_1297 target) {
        return target instanceof ClayMobEntity ? 1.0f : 0.2f;
    }

    public boolean method_6121(class_1297 target) {
        List<SpecialAttack<?>> specialAttacks;
        boolean wasHurt;
        float power = this.getAttackPower(target);
        class_1282 damagesource = this.method_48923().method_48812((class_1309)this);
        float attackDamage = this.getBaseAttackDamage();
        class_1937 class_19372 = this.method_37908();
        if (class_19372 instanceof class_3218) {
            class_3218 serverlevel = (class_3218)class_19372;
            attackDamage = class_1890.method_60120((class_3218)serverlevel, (class_1799)this.getItemBySlot(SoldierEquipmentSlot.MAINHAND).stack(), (class_1297)target, (class_1282)damagesource, (float)attackDamage);
            attackDamage = class_1890.method_60120((class_3218)serverlevel, (class_1799)this.getItemBySlot(SoldierEquipmentSlot.OFFHAND).stack(), (class_1297)target, (class_1282)damagesource, (float)attackDamage);
        }
        float knockBack = this.method_59924(target, damagesource) * power;
        int secOnFireInTicks = 0;
        attackDamage += this.allProperties().damage();
        if ((secOnFireInTicks += this.allProperties().setOnFire()) > 0) {
            target.method_56073((int)((float)secOnFireInTicks * power));
        }
        if (wasHurt = target.method_5643(damagesource, (attackDamage += (float)(specialAttacks = this.allProperties().specialAttacks(SpecialAttackType.MELEE, SpecialEffectCategory.HARMFUL)).stream().mapToDouble(specialAttackType -> specialAttackType.getBonusDamage(this, target)).sum()) * power)) {
            class_1937 class_19373;
            if (knockBack > 0.0f && target instanceof class_1309) {
                ((class_1309)target).method_6005((double)(knockBack * 0.5f), (double)class_3532.method_15374((float)(this.method_36454() * ((float)Math.PI / 180))), (double)(-class_3532.method_15362((float)(this.method_36454() * ((float)Math.PI / 180)))));
                this.method_18799(this.method_18798().method_18805(0.6, 1.0, 0.6));
            }
            if ((class_19373 = this.method_37908()) instanceof class_3218) {
                class_3218 serverlevel = (class_3218)class_19373;
                class_1890.method_60107((class_3218)serverlevel, (class_1297)target, (class_1282)damagesource);
            }
            this.method_6114(target);
            this.method_59928();
            if (power >= 1.0f) {
                for (SpecialAttack specialAttack : specialAttacks) {
                    specialAttack.performAttackEffect(this, target);
                }
                this.specializedAttack(target);
            }
            if (target instanceof AbstractClaySoldierEntity) {
                AbstractClaySoldierEntity soldierTarget = (AbstractClaySoldierEntity)target;
                soldierTarget.performCounterAttacks(this, SpecialAttackType.MELEE);
            }
        }
        return wasHurt;
    }

    protected void specializedAttack(class_1297 target) {
    }

    protected float getBaseAttackDamage() {
        return (float)this.method_45325(class_5134.field_23721);
    }

    private void performCounterAttacks(AbstractClaySoldierEntity target, SpecialAttackType type) {
        float sumDamage = 0.0f;
        for (SpecialAttack<?> counterAttack : this.allProperties().counterAttacks(type)) {
            counterAttack.performAttackEffect(this, (class_1297)target);
            sumDamage += counterAttack.getBonusDamage(this, (class_1297)target);
        }
        if (sumDamage > 0.0f) {
            target.method_5643(this.method_48923().method_48818((class_1297)this), sumDamage);
        }
    }

    @Override
    protected class_1269 method_5992(class_1657 pPlayer, class_1268 pHand) {
        class_1799 itemInHand = pPlayer.method_5998(pHand);
        if (this.getAttackType().isRoyalty() && this.isClayFood(itemInHand) && !pPlayer.equals((Object)this.getClayTeamOwner())) {
            if (!this.method_37908().field_9236) {
                if (this.tryClaimingTeam(pPlayer)) {
                    this.method_37908().method_8421((class_1297)this, (byte)80);
                } else {
                    this.method_37908().method_8421((class_1297)this, (byte)79);
                }
            }
            return class_1269.method_29236((boolean)this.method_37908().method_8608());
        }
        return super.method_5992(pPlayer, pHand);
    }

    @Override
    protected boolean clayBrushEffect(ClayBrushItem.Mode mode, class_1799 itemInHand, class_1657 player) {
        if (super.clayBrushEffect(mode, itemInHand, player)) {
            return true;
        }
        if (mode == ClayBrushItem.Mode.WORK && !this.method_37908().field_9236 && player instanceof class_3222) {
            class_3222 serverPlayer = (class_3222)player;
            if (this.getAttackType().canWork()) {
                this.workSelector.cycleWorkMode();
                serverPlayer.method_43502(this.workSelector.getWorkDisplayName(), true);
            } else {
                serverPlayer.method_43502(this.getCombatDisplayName(), true);
            }
        }
        return true;
    }

    public boolean method_5939(class_1799 pStack) {
        if (!this.method_37908().field_9236 && this.workSelector.workRequiresItemPickUp()) {
            return true;
        }
        return pStack.method_31573(ModTags.Items.SOLDIER_HOLDABLE);
    }

    public boolean method_20820(class_1799 pStack) {
        return this.method_5939(pStack);
    }

    @NotNull
    public class_1799 method_24523(class_1799 pStack) {
        return this.equipItemIfPossible(pStack, SoldierSlotCallback.NULL);
    }

    public class_1799 equipItemIfPossible(class_1799 stack, SoldierSlotCallback slotCallBack) {
        class_1799 equipped = this.equipSoldierItem(stack, slotCallBack);
        if (equipped.method_7960()) {
            return this.equipGoalItem(stack, slotCallBack);
        }
        return equipped;
    }

    private class_1799 equipSoldierItem(class_1799 pStack, SoldierSlotCallback slotCallBack) {
        SoldierEquipmentSlot slot;
        ItemStackWithEffect newItem = new ItemStackWithEffect(pStack);
        SoldierHoldableEffect effect = newItem.effect();
        if (effect == null) {
            return class_1799.field_8037;
        }
        if (!this.couldEquipStack(effect)) {
            return class_1799.field_8037;
        }
        List<SoldierEquipmentSlot> possibleSlots = effect.slots();
        if (possibleSlots.isEmpty()) {
            CustomEquipCapability capEquip = effect.getCustomEquipCapability(pStack);
            class_1799 resultStack = capEquip != null ? capEquip.equip(this) : class_1799.field_8037;
            slotCallBack.capability();
            return resultStack;
        }
        ItemStackEffectHolder currentItem = null;
        boolean canReplaceCurrentItem = false;
        SoldierEquipmentSlot equipmentSlot = null;
        Iterator<SoldierEquipmentSlot> iterator = possibleSlots.iterator();
        while (iterator.hasNext() && !(canReplaceCurrentItem = ((ItemStackWithEffect)(currentItem = this.getItemBySlot(equipmentSlot = (slot = iterator.next())))).canBeReplaced(newItem))) {
        }
        if (canReplaceCurrentItem && this.method_5939(pStack)) {
            if (!currentItem.isEmpty()) {
                this.dropItemStackWithChance((ItemStackWithEffect)currentItem);
            }
            class_1799 copied = pStack;
            if (pStack.method_7947() > effect.getMaxStackSize()) {
                copied = pStack.method_46651(effect.getMaxStackSize());
            }
            this.setItemSlot(equipmentSlot, copied);
            slotCallBack.slot(equipmentSlot);
            effect.executePickUpFunctions(this, copied);
            return copied;
        }
        return class_1799.field_8037;
    }

    private class_1799 equipGoalItem(class_1799 stack, SoldierSlotCallback slotCallback) {
        if (this.workSelector.workRequiresItemPickUp() && this.carriedStack.method_7960()) {
            slotCallback.carried();
            this.setCarriedStack(stack);
            return stack;
        }
        return class_1799.field_8037;
    }

    @Override
    public boolean couldEquipStack(@NotNull SoldierHoldableEffect effect) {
        AttackTypeProperty attackTypeStack;
        AttackTypeProperty attackTypeSelf = this.getAttackType();
        if (!attackTypeSelf.compatibleWith(attackTypeStack = effect.properties().attackType())) {
            return false;
        }
        if (effect.throwable()) {
            if (attackTypeStack.isSupportive()) {
                return effect.throwableType(RangedAttackType.HELPING);
            }
            if (attackTypeStack.fightsBack()) {
                return effect.throwableType(RangedAttackType.HARM);
            }
        }
        return true;
    }

    @Override
    public class_1542 dropItemStack(class_1799 stack) {
        return this.method_5775(stack);
    }

    @Override
    public ItemStackWithEffect getItemBySlot(SoldierEquipmentSlot pSlot) {
        return switch (pSlot.getType()) {
            default -> throw new MatchException(null, null);
            case SoldierEquipmentSlot.Type.HAND -> (ItemStackWithEffect)this.soldierHandItems.get(pSlot.getIndex());
            case SoldierEquipmentSlot.Type.ARMOR -> (ItemStackWithEffect)this.soldierArmorItems.get(pSlot.getIndex());
            case SoldierEquipmentSlot.Type.BACKPACK -> (ItemStackWithEffect)this.soldierBackpackItems.get(pSlot.getIndex());
        };
    }

    @Override
    public void setItemSlot(SoldierEquipmentSlot pSlot, class_1799 pStack) {
        this.setItemSlot(pSlot, new ItemStackWithEffect(pStack));
    }

    @Override
    public void setItemSlot(SoldierEquipmentSlot pSlot, ItemStackWithEffect pStack) {
        this.method_37410(pStack.stack());
        switch (pSlot.getType()) {
            case HAND: {
                this.soldierHandItems.set(pSlot.getIndex(), (Object)pStack);
                break;
            }
            case ARMOR: {
                this.soldierArmorItems.set(pSlot.getIndex(), (Object)pStack);
                break;
            }
            case BACKPACK: {
                this.soldierBackpackItems.set(pSlot.getIndex(), (Object)pStack);
            }
        }
        this.handleSlotChange(pSlot, pStack);
    }

    private void handleSlotChange(SoldierEquipmentSlot slot, ItemStackWithEffect stackWithEffect) {
        if (!this.method_37908().method_8608()) {
            ClaySoldiersCommon.NETWORK_MANGER.sendToPlayersTrackingEntity((class_1297)this, new SoldierItemChangePayload(this.method_5628(), slot, stackWithEffect.stack()));
        }
        this.updateSpecialProperties(stackWithEffect, slot);
        this.updateCombinedProperties(slot, stackWithEffect.effect());
        this.updateOtherProperties();
    }

    private void updateCombinedProperties(SoldierEquipmentSlot slot, @Nullable SoldierHoldableEffect effect) {
        if (effect != null) {
            this.propertyCombiner.addProperty(effect.predicate(), effect.properties(), slot);
        } else {
            this.propertyCombiner.removeProperty(slot);
        }
        this.propertyCombiner.addPropertyFromTeam(this.getClayTeam());
        this.propertyCombiner.combine();
    }

    private void initCombinedProperties() {
        for (SoldierEquipmentSlot slot : SoldierEquipmentSlot.values()) {
            SoldierHoldableEffect effect = this.getItemBySlot(slot).effect();
            if (effect == null) continue;
            this.propertyCombiner.addProperty(effect.predicate(), effect.properties(), slot);
        }
        if (!this.method_37908().method_8608()) {
            this.method_37908().method_8421((class_1297)this, (byte)77);
        }
        this.propertyCombiner.addPropertyFromTeam(this.getClayTeam());
        this.propertyCombiner.combine();
    }

    @Deprecated
    public void method_5673(class_1304 pSlot, class_1799 pStack) {
        SoldierEquipmentSlot.getFromSlot(pSlot).ifPresent(soldierSlot -> this.setItemSlot((SoldierEquipmentSlot)soldierSlot, pStack));
    }

    @Deprecated
    @NotNull
    public class_1799 method_6118(@NotNull class_1304 pSlot) {
        return SoldierEquipmentSlot.getFromSlot(pSlot).map(this::getItemBySlot).orElse(ItemStackWithEffect.EMPTY).stack();
    }

    public Iterable<class_1799> method_5877() {
        return AbstractClaySoldierEntity.convertToStack(this.soldierHandItems);
    }

    public Iterable<class_1799> method_5661() {
        return AbstractClaySoldierEntity.convertToStack(this.soldierArmorItems);
    }

    public Iterable<class_1799> getBackpackSlots() {
        return AbstractClaySoldierEntity.convertToStack(this.soldierBackpackItems);
    }

    @Override
    public Iterable<class_1799> method_56675() {
        return Iterables.concat(this.method_5877(), this.method_5661(), this.getBackpackSlots());
    }

    public Iterable<ItemStackWithEffect> getAllSlotsWithEffect() {
        return Iterables.concat(this.soldierHandItems, this.soldierArmorItems, this.soldierBackpackItems);
    }

    @Override
    public SoldierPropertyMapReader allProperties() {
        return this.propertyCombiner;
    }

    private void updateSpecialProperties(ItemStackWithEffect effect, SoldierEquipmentSlot slot) {
        if (effect.isThrowable()) {
            this.stackWithProjectile = effect;
        }
        if (this.stackWithProjectile == null) {
            this.querySpecialProperties();
        }
    }

    private void querySpecialProperties() {
        for (ItemStackWithEffect stackWithEffect : this.getAllSlotsWithEffect()) {
            if (!stackWithEffect.isThrowable()) continue;
            this.stackWithProjectile = stackWithEffect;
        }
    }

    public boolean canPerformRangeAttack() {
        return this.stackWithProjectile != null;
    }

    public void method_7105(@NotNull class_1309 pTarget, float pVelocity) {
        if (this.stackWithProjectile == null) {
            return;
        }
        ThrowableItemCapability capability = this.stackWithProjectile.getThrowableCap();
        SoldierHoldableEffect holdableEffect = this.stackWithProjectile.effect();
        if (holdableEffect == null) {
            this.stackWithProjectile = null;
            return;
        }
        if (capability == null) {
            capability = new ThrowableItemCapability(){

                @Override
                @NotNull
                public class_1676 createProjectile(class_1937 level, class_1309 shooter, SoldierHoldableEffect holdableEffect) {
                    ClaySoldierThrowableItemEntity pr = new ClaySoldierThrowableItemEntity(level, shooter, AbstractClaySoldierEntity.this.stackWithProjectile);
                    pr.method_16940(AbstractClaySoldierEntity.this.stackWithProjectile.stack());
                    return pr;
                }
            };
        }
        capability.performRangedAttack(this, this.method_37908(), pTarget, holdableEffect, pVelocity);
        holdableEffect.getRemovalConditions().forEach(condition -> {
            if (condition.shouldRemove(this, RemovalConditionContext.useRanged(this.stackWithProjectile.stack())) && this.stackWithProjectile.shrink(1) <= 0) {
                this.stackWithProjectile = ItemStackWithEffect.EMPTY;
            }
        });
    }

    public void indicateMeleeItemUse() {
        this.testForRemoval(RemovalConditionContext::useMelee, false);
    }

    private void testForRemoval(Function<class_1799, RemovalConditionContext> contextBuilder, boolean onlyOne) {
        if (this.method_37908().method_8608()) {
            return;
        }
        for (SoldierEquipmentSlot slot : SoldierEquipmentSlot.values()) {
            ItemStackWithEffect stack = this.getItemBySlot(slot);
            SoldierHoldableEffect effect = stack.effect();
            if (effect == null) continue;
            RemovalConditionContext context = contextBuilder.apply(stack.stack());
            for (RemovalCondition condition : effect.getRemovalConditions()) {
                if (!condition.shouldRemove(this, context)) continue;
                this.setItemSlot(slot, stack.shrink(1) <= 0 ? ItemStackWithEffect.EMPTY : stack);
                if (!onlyOne) continue;
                return;
            }
        }
    }

    @Override
    public boolean method_5643(class_1282 source, float amount) {
        class_1297 class_12972;
        if (!(source.method_5529() instanceof class_1657) && source.method_48789(ModTags.DamageTypes.CLAY_SOLDIER_DAMAGE) && this.method_6032() * 3.0f < this.method_6063() && this.allProperties().hasEvacuationProperty()) {
            class_1937 class_19372 = this.method_37908();
            if (class_19372 instanceof class_3218) {
                class_3218 serverLevel = (class_3218)class_19372;
                this.allProperties().getEvacuationProperty().evacuate(serverLevel, this);
                this.testForRemoval(RemovalConditionContext::fireworkRocket, true);
            }
            return false;
        }
        this.testForRemoval(stack -> RemovalConditionContext.hurt(source, stack), false);
        if (source.method_49708(class_8111.field_42328) && (class_12972 = source.method_5529()) instanceof AbstractClaySoldierEntity) {
            AbstractClaySoldierEntity soldierThrower = (AbstractClaySoldierEntity)class_12972;
            this.performCounterAttacks(soldierThrower, SpecialAttackType.MELEE);
            if (this.allProperties().canTeleport()) {
                this.teleportSoldier((class_1309)soldierThrower);
            }
        }
        if (source.method_48789(class_8103.field_42249) && !source.method_48789(class_8103.field_42242)) {
            amount -= amount * Math.clamp(this.allProperties().explosionResistance() * 0.08f, 0.0f, 1.0f);
        }
        if (!this.method_37908().method_8608()) {
            amount = this.allProperties().damageBlock().blocked(this.field_5974, amount, source.method_49708(class_8111.field_42328) || source.method_49708(ModDamageTypes.CLAY_HURT));
        }
        return super.method_5643(source, amount);
    }

    public boolean canSwim() {
        return this.allProperties().canSwim();
    }

    public int method_5748() {
        int breathHold = this.allProperties() != null ? this.allProperties().breathHoldDuration() : 0;
        return Math.max(10, super.method_5748() + breathHold * 100);
    }

    protected int method_6130(int pCurrentAir) {
        if (this.allProperties().breathHoldDuration() >= 1000) {
            return pCurrentAir;
        }
        if (this.allProperties().breathHoldDuration() <= -200) {
            return super.method_6130(pCurrentAir) * 30;
        }
        return super.method_6130(pCurrentAir);
    }

    protected int method_6064(int currentAir) {
        return super.method_6064(Math.min(this.allProperties().breathHoldDuration(), 0) + currentAir);
    }

    @Override
    public double getDefaultAttackReach() {
        float blindnessMultiplier = 1.0f;
        class_1293 blindnessEffect = this.getMobEffect((class_6880<class_1291>)class_1294.field_5919);
        if (blindnessEffect != null) {
            blindnessMultiplier = AbstractClaySoldierEntity.calcBlindnessReach(blindnessEffect.method_5578());
        }
        return ((double)0.7f * (double)this.getSoldierSize() + (double)this.allProperties().bonusAttackRange()) * (double)blindnessMultiplier;
    }

    private static float calcBlindnessReach(int amp) {
        return 1.0f - (float)(-Math.pow(2.0, -((float)amp + 1.0f)) + 1.0);
    }

    private void updateOtherProperties() {
        if (this.allProperties() != null) {
            if (this.allProperties().canSwim()) {
                this.method_5941(class_7.field_18, 0.0f);
                this.method_5941(class_7.field_4, 0.0f);
                this.field_6189 = this.waterNavigation;
            } else {
                this.method_5941(class_7.field_18, class_7.field_18.method_11());
                this.method_5941(class_7.field_4, class_7.field_4.method_11());
                this.field_6189 = this.groundNavigation;
            }
        }
    }

    public boolean method_5851() {
        return super.method_5851() || this.allProperties().hasGlowOutline();
    }

    @Override
    public boolean sameTeamAs(class_1297 other) {
        AttackTypeProperty attackType = this.getAttackType();
        if (attackType == AttackTypeProperty.AGGRESSIVE) {
            return false;
        }
        if (other instanceof AbstractClaySoldierEntity) {
            AbstractClaySoldierEntity claySoldier = (AbstractClaySoldierEntity)other;
            if (attackType.isRoyalty() ? claySoldier.getAttackType() == attackType : claySoldier.getAttackType() == AttackTypeProperty.AGGRESSIVE) {
                return false;
            }
        }
        return super.sameTeamAs(other);
    }

    public boolean canSeeInvis() {
        return this.allProperties().canSeeInvis();
    }

    public double method_18390(@Nullable class_1297 pLookingEntity) {
        AbstractClaySoldierEntity claySoldier;
        if (pLookingEntity instanceof AbstractClaySoldierEntity && (claySoldier = (AbstractClaySoldierEntity)pLookingEntity).canSeeInvis()) {
            return 1.0;
        }
        return super.method_18390(pLookingEntity);
    }

    protected void method_6027() {
        super.method_6027();
    }

    private void explodeTick() {
        int swellDir;
        this.oldSwell = this.swell;
        if (this.isIgnited()) {
            this.setSwellDir(1);
        }
        if ((swellDir = this.getSwellDir()) > 0 && this.swell == 0) {
            this.method_5783(class_3417.field_15057, 1.0f, 0.5f);
            this.method_32876((class_6880)class_5712.field_28727);
        }
        this.swell += swellDir;
        if (this.swell < 0) {
            this.swell = 0;
        }
        if (this.swell >= this.maxSwell) {
            this.swell = this.maxSwell;
            this.explodeSoldier();
        }
    }

    public void method_6078(class_1282 damageSource) {
        if (ClaySoldiersCommon.COMMON_HOOKS.onLivingDeath((class_1309)this, damageSource)) {
            return;
        }
        this.workSelector.resetGoal();
        if (!this.method_31481() && !this.field_6272) {
            if (this.allProperties().hasPropertyType(SoldierPropertyTypes.DEATH_EXPLOSION.get())) {
                this.ignite();
                if (this.swell < this.maxSwell) {
                    return;
                }
            } else {
                this.spawnDeathEffect();
                if (this.method_37908().method_8608()) {
                    this.spawnFireWorks();
                }
            }
            WraithProperty wraithProperty = this.allProperties().wraith();
            class_1297 entity = damageSource.method_5529();
            class_1309 livingentity = this.method_6124();
            if (this.field_6232 >= 0 && livingentity != null) {
                livingentity.method_5716((class_1297)this, this.field_6232, damageSource);
            }
            if (this.method_6113()) {
                this.method_18400();
            }
            if (!this.method_37908().field_9236 && this.method_16914()) {
                LOGGER.info("Named entity {} died: {}", (Object)this, (Object)this.method_6066().method_5548().getString());
            }
            this.field_6272 = true;
            this.method_6066().method_5539();
            class_1937 class_19372 = this.method_37908();
            if (class_19372 instanceof class_3218) {
                class_3218 serverlevel = (class_3218)class_19372;
                if (entity == null || entity.method_5874(serverlevel, (class_1309)this)) {
                    ReviveResult reviveResult = this.reviveSelf(serverlevel);
                    if (reviveResult.dropInventory()) {
                        this.method_16080(serverlevel, damageSource);
                    }
                    this.method_32876((class_6880)class_5712.field_37676);
                    this.method_23733(livingentity);
                    if (reviveResult == ReviveResult.FAIL && wraithProperty != null) {
                        ClayWraithEntity.spawnWraith(serverlevel, this, wraithProperty.duration(), wraithProperty.onSpawnEffect());
                    }
                }
                this.method_37908().method_8421((class_1297)this, (byte)3);
            }
            this.method_18380(class_4050.field_18082);
        }
    }

    protected boolean dropInventoryOnDeath() {
        return true;
    }

    @Override
    protected void method_6099(class_3218 level, class_1282 pSource, boolean pRecentlyHit) {
        super.method_6099(level, pSource, pRecentlyHit);
        if (this.dropInventoryOnDeath()) {
            AbstractClaySoldierEntity.dropInventory(level, this::getItemBySlot, (slot, stack) -> {
                this.method_5775((class_1799)stack);
                this.setItemSlot((SoldierEquipmentSlot)slot, ItemStackWithEffect.EMPTY);
            });
            if (!this.getCarriedStack().method_7960()) {
                this.dropItemStack(this.getCarriedStack());
            }
        }
    }

    public static void dropInventory(class_3218 level, Function<SoldierEquipmentSlot, ItemStackWithEffect> equipment, BiConsumer<SoldierEquipmentSlot, class_1799> dropInWorld) {
        if (!level.method_8450().method_8355(ClaySoldiersCommon.CLAY_SOLDIER_INVENTORY_DROP_RULE)) {
            return;
        }
        for (SoldierEquipmentSlot slot : SoldierEquipmentSlot.values()) {
            ItemStackWithEffect stack = equipment.apply(slot);
            if (stack.isEmpty() || class_1890.method_60142((class_1799)stack.stack(), (class_9331)class_9701.field_51655) || !(level.method_8409().method_43057() < stack.dropRate())) continue;
            dropInWorld.accept(slot, stack.stack());
        }
    }

    protected void method_6108() {
        if (this.isIgnited() && this.swell <= this.maxSwell) {
            this.explodeTick();
            return;
        }
        ++this.field_6213;
        if (this.field_6213 >= 20 && !this.method_37908().method_8608() && !this.method_31481()) {
            this.method_37908().method_8421((class_1297)this, (byte)60);
            this.method_5650(class_1297.class_5529.field_26998);
        }
    }

    public float getSwelling(float pPartialTicks) {
        return class_3532.method_16439((float)pPartialTicks, (float)this.oldSwell, (float)this.swell) / (float)(this.maxSwell - 2);
    }

    public int getSwellDir() {
        return (Integer)this.field_6011.method_12789(DATA_SWELL_DIR);
    }

    public void setSwellDir(int pState) {
        this.field_6011.method_12778(DATA_SWELL_DIR, (Object)pState);
    }

    private void explodeSoldier() {
        if (!this.method_37908().field_9236) {
            this.method_37908().method_8421((class_1297)this, (byte)81);
            float explosionPower = ((Float)this.allProperties().getValueOrDfault(SoldierPropertyTypes.DEATH_EXPLOSION)).floatValue();
            this.field_6272 = true;
            this.method_37908().method_8437((class_1297)this, this.method_23317(), this.method_23318(), this.method_23321(), this.explosionRadius * explosionPower, class_1937.class_7867.field_40888);
            this.method_31472();
            this.spawnDeathEffect();
        }
    }

    @Override
    public void method_5711(byte id) {
        if (id == 81) {
            this.spawnFireWorks();
        } else {
            super.method_5711(id);
        }
    }

    public boolean isIgnited() {
        return (Boolean)this.field_6011.method_12789(DATA_IS_IGNITED);
    }

    public void ignite() {
        this.field_6011.method_12778(DATA_IS_IGNITED, (Object)true);
    }

    private void spawnDeathEffect() {
        if (this.method_37908().method_8608()) {
            return;
        }
        List<class_1293> collection = this.allProperties().getDeathCloudEffects();
        if (!collection.isEmpty()) {
            class_1295 areaeffectcloud = new class_1295(this.method_37908(), this.method_23317(), this.method_23318(), this.method_23321());
            areaeffectcloud.method_5603(1.5f);
            areaeffectcloud.method_5609(-0.5f);
            areaeffectcloud.method_5595(10);
            areaeffectcloud.method_5604(areaeffectcloud.method_5605() / 2);
            areaeffectcloud.method_5596(-areaeffectcloud.method_5599() / (float)areaeffectcloud.method_5605());
            for (class_1293 mobeffectinstance : collection) {
                areaeffectcloud.method_5610(new class_1293(mobeffectinstance));
            }
            this.method_37908().method_8649((class_1297)areaeffectcloud);
        }
    }

    private void spawnFireWorks() {
        ArrayList<class_9283> fireworkExplosions = new ArrayList<class_9283>();
        for (class_1799 stack : this.method_56675()) {
            class_9283 exp = (class_9283)stack.method_57824(class_9334.field_49615);
            if (exp == null) continue;
            fireworkExplosions.add(exp);
        }
        if (!fireworkExplosions.isEmpty()) {
            this.method_37908().method_8547(this.method_23317(), this.method_23318(), this.method_23321(), 0.0, 1.0, 0.0, fireworkExplosions);
        }
    }

    public float getSoldierSize() {
        if (this.allProperties() == null) {
            return 1.0f;
        }
        return Math.clamp(0.2f, this.allProperties().getSoldierSize(), 3.0f);
    }

    public float method_55693() {
        if (!this.method_37908().method_8608()) {
            return super.method_55693() * this.getSoldierSize();
        }
        return this.delayedScale * super.method_55693();
    }

    public boolean fightsBack() {
        return this.getAttackType().fightsBack();
    }

    @Override
    protected boolean targetPredicate(class_1309 target) {
        return this.getAttackType().canAttack(this, target);
    }

    protected boolean specificTargetPredicate(class_1309 target) {
        if (this.canPerformRangeAttack()) {
            return this.allProperties().specialAttacks(SpecialAttackType.RANGED, this.getAttackType().forType()).stream().anyMatch(s -> s.shouldAttackTarget(target));
        }
        return this.allProperties().specialAttacks(SpecialAttackType.MELEE, this.getAttackType().forType()).stream().anyMatch(s -> s.shouldAttackTarget(target));
    }

    @Override
    public AttackTypeProperty getAttackType() {
        if (this.allProperties() != null) {
            AttackTypeProperty attackType = this.allProperties().attackType();
            return attackType == AttackTypeProperty.NORMAL ? this.defaultAttackType : attackType;
        }
        return this.defaultAttackType;
    }

    @Override
    public void method_5773() {
        super.method_5773();
        if (this.method_37908().method_8608()) {
            this.moveCloak(this.method_23317(), this.method_23318(), this.method_23321());
            this.delaySizeScale();
        }
    }

    private void delaySizeScale() {
        float actualSize = this.getSoldierSize();
        if (this.delayedScale == actualSize) {
            return;
        }
        if (this.delayedScale < actualSize) {
            this.delayedScale += 0.1f;
            if (this.delayedScale > actualSize) {
                this.delayedScale = actualSize;
            }
        } else {
            this.delayedScale -= 0.1f;
            if (this.delayedScale < actualSize) {
                this.delayedScale = actualSize;
            }
        }
    }

    public void method_5842() {
        if (this.method_37908().method_8608()) {
            this.oBob = this.bob;
            this.bob = 0.0f;
        }
        this.matchBodyRotToRidden();
        super.method_5842();
    }

    private void matchBodyRotToRidden() {
        class_1297 class_12972;
        if (this.getRidingPose().shouldMatchBodyRot() && (class_12972 = this.method_5854()) instanceof class_1309) {
            class_1309 entity = (class_1309)class_12972;
            this.field_6283 = entity.field_6283;
        }
    }

    public void method_6007() {
        if (this.method_37908().method_8608()) {
            this.oBob = this.bob;
            float movementSpeed = this.method_24828() && !this.method_29504() && !this.method_5681() ? Math.min(0.1f, (float)this.method_18798().method_37267()) : 0.0f;
            this.bob += (movementSpeed - this.bob) * 0.4f;
        } else {
            class_1308 vehicle;
            class_1297 class_12972;
            if (this.field_6012 % 20 == 0 && (class_12972 = this.method_5854()) instanceof class_1308) {
                class_1308 living = (class_1308)class_12972;
                living.method_5980(this.method_5968());
            }
            if (this.field_6012 % 100 == 0 && (class_12972 = this.method_5854()) instanceof class_1308 && !this.canRideEntity((class_1309)(vehicle = (class_1308)class_12972))) {
                this.method_5848();
            }
            class_243 movement = this.method_18798();
            if (this.isFalling() && this.allProperties().canGlide()) {
                this.method_18799(movement.method_18805(1.0, 0.7, 1.0));
            }
            this.dropCarriedTick();
        }
        this.method_6119();
        super.method_6007();
    }

    protected void moveCloak(double x, double y, double z) {
        this.xCloakO = this.xCloak;
        this.yCloakO = this.yCloak;
        this.zCloakO = this.zCloak;
        double deltaX = x - this.xCloak;
        double deltaY = y - this.yCloak;
        double deltaZ = z - this.zCloak;
        if (deltaX > 10.0) {
            this.xCloakO = this.xCloak = this.method_23317();
        }
        if (deltaZ > 10.0) {
            this.zCloakO = this.zCloak = z;
        }
        if (deltaY > 10.0) {
            this.yCloakO = this.yCloak = y;
        }
        if (deltaX < -10.0) {
            this.xCloakO = this.xCloak = x;
        }
        if (deltaZ < -10.0) {
            this.zCloakO = this.zCloak = z;
        }
        if (deltaY < -10.0) {
            this.yCloakO = this.yCloak = y;
        }
        this.xCloak += deltaX * 0.25;
        this.zCloak += deltaZ * 0.25;
        this.yCloak += deltaY * 0.25;
    }

    public void handleSpawnPayload(ClaySoldierSpawnPayload payload) {
        this.setItemSlot(SoldierEquipmentSlot.CAPE, payload.getCape());
        this.setItemSlot(SoldierEquipmentSlot.BACKPACK, payload.getBackpack1());
        this.setItemSlot(SoldierEquipmentSlot.BACKPACK_PASSIVE, payload.getBackpack2());
        for (ReviveType type : ReviveType.values()) {
            this.setReviveOnCooldown(type, payload.getReviveCooldowns().get(type.ordinal()));
        }
        this.skinVariantId = payload.getSkinId();
        this.setCarriedStack(payload.getCarried());
        this.initCombinedProperties();
        this.setDataWorkStatus(payload.getWorkStatus());
    }

    @Override
    public void sendSpawnPayload(class_3222 tracking) {
        ClaySoldiersCommon.NETWORK_MANGER.sendToPlayer(tracking, new ClaySoldierSpawnPayload(this));
    }

    @Override
    public boolean canMountEntity(class_1309 livingEntity) {
        if (!livingEntity.method_5685().isEmpty()) {
            return false;
        }
        return this.canRideEntity(livingEntity);
    }

    public boolean canRideEntity(class_1309 livingEntity) {
        return ClaySoldierRideableMap.test(livingEntity, this);
    }

    @Override
    public boolean isAbleToRide() {
        return !this.method_5765() && this.getSoldierSize() <= 1.3f;
    }

    protected class_243 method_52533(class_1297 pEntity, class_4048 pDimensions, float pPartialTick) {
        return super.method_52533(pEntity, pDimensions, pPartialTick).method_1031(0.0, 0.02 * (double)this.method_55693(), 0.0);
    }

    @Nullable
    public class_1309 method_5642() {
        class_1309 controller = super.method_5642();
        return controller instanceof ClayMobEntity ? null : controller;
    }

    @Override
    public float getCustomArmorValue() {
        return this.allProperties().protection();
    }

    public float getCustomArmorToughness() {
        return this.allProperties().heavy();
    }

    protected float method_6132(class_1282 pDamageSource, float pDamageAmount) {
        if (!pDamageSource.method_48789(class_8103.field_42241)) {
            this.method_6105(pDamageSource, pDamageAmount);
            pDamageAmount = class_1280.method_5496((class_1309)this, (float)pDamageAmount, (class_1282)pDamageSource, (float)this.method_6096(), (float)((float)this.method_45325(class_5134.field_23725) + this.getCustomArmorToughness()));
        }
        return pDamageAmount;
    }

    public int method_6096() {
        return super.method_6096() + (int)this.getCustomArmorValue();
    }

    public boolean hasShieldInHand(class_1268 hand) {
        if (hand == class_1268.field_5808) {
            return this.getItemBySlot(SoldierEquipmentSlot.MAINHAND).isShield();
        }
        return this.getItemBySlot(SoldierEquipmentSlot.OFFHAND).isShield();
    }

    public int method_22861() {
        return this.getClayTeam().getColor((class_1309)this, 0.0f);
    }

    @Override
    public void setOffsetColor(ColorHelper color) {
        this.colorGetter.setColor(color);
    }

    @Override
    public void addOffsetColor(ColorHelper color) {
        this.dyeSoldier(color);
    }

    @Override
    public ColorHelper getOffsetColor() {
        return this.colorGetter.getColor();
    }

    private void dyeSoldier(ColorHelper color) {
        this.setOffsetColor(this.getOffsetColor().addColor(color));
    }

    public boolean canRevive() {
        return this.reviveProperty().canRevive();
    }

    public boolean canBeRevived() {
        return this.getAttackType().canBeRevived();
    }

    private ReviveProperty reviveProperty() {
        return this.allProperties().reviveType();
    }

    protected ReviveResult reviveSelf(class_3218 serverLevel) {
        if (this.canBeRevived()) {
            Iterator<AbstractClaySoldierEntity> iterator = this.findReviver(new class_238(this.method_24515()).method_1014(4.0));
            while (iterator.hasNext()) {
                AbstractClaySoldierEntity reviver = iterator.next();
                ReviveResult result = reviver.reviveProperty().reviveSoldier(serverLevel, this, reviver);
                if (!result.success()) continue;
                return result;
            }
        }
        return ReviveResult.FAIL;
    }

    private Iterator<AbstractClaySoldierEntity> findReviver(class_238 area) {
        return this.method_37908().method_8390(AbstractClaySoldierEntity.class, area, AbstractClaySoldierEntity::canRevive).stream().filter(s -> !s.equals(this)).sorted(this::createReviveComparator).iterator();
    }

    private int createReviveComparator(AbstractClaySoldierEntity o1, AbstractClaySoldierEntity o2) {
        return (int)(o2.method_5739((class_1297)this) + (float)this.reviveValue(o2) - (o1.method_5739((class_1297)this) + (float)this.reviveValue(o1)));
    }

    private int reviveValue(AbstractClaySoldierEntity soldier) {
        return soldier.sameTeamAs((class_1297)this) ? -1 : 0;
    }

    public void setReviveOnCooldown(ReviveType type, int cooldown) {
        if (cooldown <= 0) {
            return;
        }
        if (!this.method_37908().field_9236) {
            ClaySoldiersCommon.NETWORK_MANGER.sendToPlayersTrackingEntity((class_1297)this, new ClaySoldierReviveCooldownPayload(this.method_5628(), type, cooldown));
        }
        this.reviveTypeCooldown.put(type, this.method_37908().method_8510() + (long)cooldown);
    }

    public boolean isReviveTypeOffCooldown(ReviveType type) {
        Long timeStamp = this.reviveTypeCooldown.get(type);
        if (timeStamp == null) {
            return true;
        }
        return timeStamp <= this.method_37908().method_8510();
    }

    public Map<ReviveType, Integer> getReviveTypeCooldown() {
        return this.reviveTypeCooldown.entrySet().stream().filter(e -> e.getValue() != null).map(e -> Map.entry((ReviveType)e.getKey(), (Long)e.getValue() - this.method_37908().method_8510())).filter(e -> (Long)e.getValue() > 0L).collect(Collectors.toMap(Map.Entry::getKey, e -> ((Long)e.getValue()).intValue(), (e1, e2) -> e1, () -> new EnumMap(ReviveType.class)));
    }

    public boolean isZombie() {
        return this.getAttackType() == AttackTypeProperty.ZOMBIE;
    }

    @Override
    public ClayMobEntity asClayMob() {
        return this;
    }

    @Override
    public <T extends ClaySoldierInventoryHandler> void copyInventory(T toCopyTo) {
        for (SoldierEquipmentSlot slot : SoldierEquipmentSlot.values()) {
            ItemStackWithEffect item = this.getItemBySlot(slot);
            SoldierHoldableEffect effect = item.effect();
            if (item.isEmpty()) continue;
            if (effect != null && toCopyTo.couldEquipStack(effect)) {
                toCopyTo.setItemSlot(slot, item.copy());
                effect.executePickUpFunctions(toCopyTo, item.stack());
                continue;
            }
            this.dropItemSlotWithChance(slot);
        }
    }

    @Override
    protected OptionalInt openMenuScreen(class_1657 player) {
        return ClaySoldiersCommon.COMMON_HOOKS.openMenu(player, (class_3908)new class_747((id, inventory, player1) -> new ClaySoldierMenu(id, inventory, this), this.getInventoryName()), this.method_5628());
    }

    @Override
    protected class_2561 getInventoryName() {
        class_5250 name = class_2561.method_43473();
        class_2561 attackTypeDisplayName = this.getAttackType().getAnimatedDisplayName((class_1309)this);
        if (attackTypeDisplayName != null) {
            name.method_10852(attackTypeDisplayName);
            name.method_10852(class_5244.field_41874);
        }
        name.method_10852(this.method_5476());
        return name;
    }

    public boolean method_5747(float pFallDistance, float pMultiplier, class_1282 pSource) {
        if (this.allProperties().canGlide()) {
            return false;
        }
        return super.method_5747(pFallDistance, pMultiplier, pSource);
    }

    protected byte getGliderItemSlot() {
        if (this.lastGliderSlot == -2) {
            for (SoldierEquipmentSlot slot : SoldierEquipmentSlot.values()) {
                if (!this.getItemBySlot(slot).isGlider()) continue;
                this.lastGliderSlot = (byte)slot.ordinal();
                return this.lastGliderSlot;
            }
            this.lastGliderSlot = (byte)-1;
            return this.lastGliderSlot;
        }
        if (this.lastGliderSlot >= 0 && this.getItemBySlot(SoldierEquipmentSlot.values()[this.lastGliderSlot]).isGlider()) {
            return this.lastGliderSlot;
        }
        this.lastGliderSlot = (byte)-1;
        return this.lastGliderSlot;
    }

    public boolean isFallingWithGlider() {
        return this.isFalling() && this.getGliderItemSlot() >= 0 && this.method_5854() == null;
    }

    public boolean isFalling() {
        return !this.method_24828() && this.method_18798().field_1351 < 0.0;
    }

    public boolean isFallingWithGlider(SoldierEquipmentSlot slot) {
        return this.isFallingWithGlider() && this.getGliderItemSlot() == (byte)slot.ordinal();
    }

    public boolean handsOccupied(SoldierEquipmentSlot slot) {
        return this.isFallingWithGlider() || !this.getCarriedStack().method_7960() || this.getItemBySlot(slot).isShield();
    }

    public class_1799 getGliderItem() {
        byte slot = this.getGliderItemSlot();
        if (slot < 0) {
            return class_1799.field_8037;
        }
        return this.getItemBySlot(SoldierEquipmentSlot.values()[slot]).stack();
    }

    public boolean method_6049(class_1293 effectInstance) {
        if (this.allProperties().immunity().isImmune((class_6880<class_1291>)effectInstance.method_5579())) {
            return false;
        }
        return super.method_6049(effectInstance);
    }

    @Override
    public boolean addMobEffect(class_1293 pEffectInstance, @Nullable class_1297 pEntity) {
        return this.method_37222(pEffectInstance, pEntity);
    }

    @Override
    @Nullable
    public class_1293 getMobEffect(class_6880<class_1291> pEffect) {
        return this.method_6112(pEffect);
    }

    @Override
    public boolean removeMobEffect(class_6880<class_1291> pEffect) {
        return this.method_6016(pEffect);
    }

    public boolean method_6016(class_6880<class_1291> pEffect) {
        if (this.allProperties().immunity().isPersistent(pEffect)) {
            return false;
        }
        return super.method_6016(pEffect);
    }

    @Override
    public void readItemPersistentData(class_2487 tag) {
    }

    @Override
    protected void tryToSit(@Nullable class_1657 player, boolean sitting) {
        if (player != null && this.getAttackType().isRoyalty()) {
            this.method_37908().method_8390(AbstractClaySoldierEntity.class, new class_238(this.method_23312()).method_1014(5.0), c -> c != this && c.isOwnedBy(player)).forEach(soldier -> soldier.tryToSit(null, sitting));
        }
        super.tryToSit(player, sitting);
    }

    @Override
    protected void modifyPickResult(class_1799 stack) {
        ClaySoldierSpawnItem.setClayMobTeam(stack, this.getClayTeamType(), (class_7225.class_7874)this.method_37908().method_30349());
    }

    public RidingPose getRidingPose() {
        class_1297 vehicle = this.method_5854();
        if (vehicle != null) {
            if (vehicle.method_5864() == class_1299.field_6140) {
                return RidingPose.RABBIT;
            }
            if (vehicle.method_5864() == class_1299.field_6133) {
                return RidingPose.FIREWORK;
            }
            if (vehicle.method_5864() == class_1299.field_6128) {
                return RidingPose.ENDERMITE;
            }
        }
        return RidingPose.DEFAULT;
    }

    protected class_4048 method_55694(class_4050 pPose) {
        if (class_4050.field_40118 == pPose && !this.method_5765()) {
            return super.method_55694(pPose).method_19539(2.0f, 0.7f);
        }
        return super.method_55694(pPose);
    }

    public int getSkinVariant() {
        return this.skinVariantId;
    }

    public class_1799 getCarriedStack() {
        return this.carriedStack;
    }

    public void setCarriedStack(class_1799 carriedStack) {
        this.carriedStack = carriedStack;
        if (!this.method_37908().method_8608()) {
            ClaySoldiersCommon.NETWORK_MANGER.sendToPlayersTrackingEntity((class_1297)this, new SoldierCarriedChangePayload(this.method_5628(), (class_6880<class_1792>)carriedStack.method_41409()));
        }
    }

    public void dropCarried() {
        this.dropItemStack(this.getCarriedStack().method_7972());
        this.setCarriedStack(class_1799.field_8037);
    }

    public void dropCarriedTick() {
        if (!this.workSelector.workRequiresItemCarrying()) {
            this.dropCarried();
        }
    }

    @Override
    public boolean unableToMoveToOwner() {
        return this.workSelector.shouldStayAtWork() || super.unableToMoveToOwner();
    }

    @Override
    @Nullable
    public class_2561 getWorkStatus() {
        return this.statusManger.getStatusDisplayName();
    }

    @Override
    @Nullable
    public AssignablePoiCapability getPoiCapability() {
        return this.workSelector.isWorking() ? null : super.getPoiCapability();
    }

    public void setDataWorkStatus(byte statusCode) {
        this.field_6011.method_12778(DATA_WORK_STATUS, (Object)statusCode);
    }

    public byte getDataWorkStatus() {
        return (Byte)this.field_6011.method_12789(DATA_WORK_STATUS);
    }

    public class_2561 getCombatDisplayName() {
        if (this.hasPoiPos()) {
            return class_2561.method_43471((String)DEFENDING_AREA_LANG);
        }
        return class_2561.method_43471((String)PROTECTING_OWNER_LANG);
    }

    @Override
    public int unpackDynamicColor(ColorHelper color, float partialTicks) {
        return color.getColor((class_1309)this, 0.0f);
    }

    private void teleportSoldier(class_1309 target) {
        if (this.getAttackType().fightsBack()) {
            Object moving = this.method_5854();
            if (moving == null) {
                this.testForRemoval(stack -> RemovalConditionContext.teleportation(stack, RemovalConditionContext.MovementType.TO_TARGET), true);
                moving = this;
            }
            moving.method_5859(target.method_23317(), target.method_23318() + 0.3, target.method_23321());
            this.method_5980(target);
            this.method_37908().method_32888((class_6880)class_5712.field_39446, this.method_19538(), class_5712.class_7397.method_43285((class_1297)this));
            class_3414 soundevent = class_3417.field_14890;
            class_3419 soundsource = class_3419.field_15254;
            this.method_37908().method_54762(null, this.method_23317(), this.method_23318(), this.method_23321(), soundevent, soundsource);
            this.method_38785();
        } else {
            class_1802.field_8233.method_7861(class_1802.field_8233.method_7854(), this.method_37908(), (class_1309)this);
            this.testForRemoval(stack -> RemovalConditionContext.teleportation(stack, RemovalConditionContext.MovementType.TO_SAFETY), true);
        }
    }

    @Override
    public boolean shouldTryTeleportToOwner() {
        if (!this.allProperties().canTeleportToOwner()) {
            return false;
        }
        class_1657 livingentity = this.getClayTeamOwner();
        return livingentity != null && this.method_5858((class_1297)this.getClayTeamOwner()) >= 144.0;
    }

    @Override
    public boolean tryToTeleportToOwner() {
        if (super.tryToTeleportToOwner()) {
            this.testForRemoval(stack -> RemovalConditionContext.teleportation(stack, RemovalConditionContext.MovementType.TO_OWNER), true);
            return true;
        }
        return false;
    }

    public boolean isInCombat() {
        return this.inCombat;
    }

    public void method_6000() {
        super.method_6000();
        this.inCombat = true;
    }

    public void method_6044() {
        super.method_6044();
        this.inCombat = false;
    }

    public class_8080 getWalkAnimation() {
        return this.field_42108;
    }

    @Override
    public List<String> getInfoState() {
        List<String> list = super.getInfoState();
        list.add("Properties: " + String.valueOf(this.allProperties()));
        list.add("Status: " + String.valueOf(this.statusManger));
        list.add("WorkSelector: " + String.valueOf(this.workSelector));
        list.add("ReviveCooldown: " + String.valueOf(this.reviveTypeCooldown));
        return list;
    }

    public boolean method_5873(class_1297 entity, boolean force) {
        boolean result = super.method_5873(entity, force);
        this.updateRidingProperties();
        ClaySoldierRideableMap.onRide(entity, this);
        return result;
    }

    public void method_5848() {
        super.method_5848();
        this.updateRidingProperties();
    }

    private void updateRidingProperties() {
        class_1297 vehicle = this.method_5854();
        SoldierVehicleProperties properties = vehicle != null ? Objects.requireNonNullElse(ClaySoldiersCommon.DATA_MAP.getVehicleProperties(vehicle.method_5864()), SoldierVehicleProperties.EMPTY) : SoldierVehicleProperties.EMPTY;
        this.propertyCombiner.addVehicle(properties);
        this.propertyCombiner.combine();
    }

    public void onBounce() {
        this.testForRemoval(RemovalConditionContext::bounce, true);
    }

    @Override
    @NotNull
    public class_5819 getClaySoldierRandom() {
        return this.method_59922();
    }

    public static enum RidingPose {
        DEFAULT(false),
        FIREWORK(false),
        RABBIT(true),
        ENDERMITE(true);

        private final boolean matchBody;

        private RidingPose(boolean matchBody) {
            this.matchBody = matchBody;
        }

        public boolean shouldMatchBodyRot() {
            return this.matchBody;
        }
    }
}

