/*
 * Decompiled with CFR 0.152.
 */
package net.bumblebee.claysoldiers.entity.soldier;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Objects;
import net.bumblebee.claysoldiers.entity.ClayMobEntity;
import net.bumblebee.claysoldiers.entity.soldier.ClaySoldierLike;
import net.minecraft.class_1299;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_5321;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import net.minecraft.class_9129;
import net.minecraft.class_9135;
import net.minecraft.class_9139;

public final class AdditionalSoldierData {
    private static final String ERROR_MESSAGE_CASTING = "Wrong Entity Type for AdditionalSoldierData. %s Does not extend ClayMobEntity and ClaySoldierLike";
    public static final Codec<AdditionalSoldierData> CODEC = RecordCodecBuilder.create(in -> in.group((App)AdditionalSoldierData.createEntityTypeCodec().fieldOf("type").forGetter(AdditionalSoldierData::soldierType), (App)class_2487.field_25128.optionalFieldOf("additional_data", (Object)new class_2487()).forGetter(AdditionalSoldierData::tag)).apply((Applicative)in, AdditionalSoldierData::new));
    public static final class_9139<class_9129, AdditionalSoldierData> STREAM_CODEC = class_9139.method_56435((class_9139)class_9135.method_56365((class_5321)class_7924.field_41266), AdditionalSoldierData::soldierType, (class_9139)class_9135.field_48556, AdditionalSoldierData::tag, (type, tag) -> new AdditionalSoldierData((class_1299)AdditionalSoldierData.cast(type).getOrThrow(), (class_2487)tag));
    private final class_1299<? extends ClayMobEntity> soldierType;
    private final class_2487 tag;

    public <T extends ClayMobEntity> AdditionalSoldierData(class_1299<T> soldierType, class_2487 tag) {
        this.soldierType = soldierType;
        this.tag = tag;
    }

    public <T extends ClayMobEntity> void convert(T soldier) {
        ((ClaySoldierLike)((Object)soldier)).convertToSoldier(this.soldierType(), newSoldier -> {
            ((ClaySoldierLike)((Object)newSoldier)).readItemPersistentData(this.tag);
            newSoldier.setClayTeamType(soldier.getClayTeamType());
            ((ClaySoldierLike)((Object)newSoldier)).onConversion(soldier, this.tag);
        });
    }

    public class_2561 displayName() {
        return this.soldierType.method_5897();
    }

    public <T extends ClayMobEntity> class_1299<T> soldierType() {
        return this.soldierType;
    }

    public class_2487 tag() {
        return this.tag;
    }

    private static <T extends ClayMobEntity> Codec<class_1299<T>> createEntityTypeCodec() {
        return class_7923.field_41177.method_39673().comapFlatMap(AdditionalSoldierData::cast, entityType -> entityType);
    }

    private static <T extends ClayMobEntity> DataResult<class_1299<T>> cast(class_1299<?> type) {
        try {
            return DataResult.success(type);
        }
        catch (ClassCastException e) {
            return DataResult.error(() -> ERROR_MESSAGE_CASTING.formatted(type));
        }
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        AdditionalSoldierData that = (AdditionalSoldierData)obj;
        return this.soldierType == that.soldierType && Objects.equals(this.tag, that.tag);
    }

    public int hashCode() {
        return Objects.hash(this.soldierType, this.tag);
    }

    public String toString() {
        return "AdditionalSoldierData[Type: " + String.valueOf(this.soldierType) + ", Data: " + String.valueOf(this.tag) + "]";
    }
}

