/*
 * Decompiled with CFR 0.152.
 */
package net.bumblebee.claysoldiers.entity.soldier;

import java.util.UUID;
import net.bumblebee.claysoldiers.entity.ClayMobEntity;
import net.bumblebee.claysoldiers.entity.soldier.AbstractClaySoldierEntity;
import net.bumblebee.claysoldiers.entity.soldier.VampireClaySoldierEntity;
import net.bumblebee.claysoldiers.entity.soldier.VampireSubjugate;
import net.bumblebee.claysoldiers.init.ModEffects;
import net.bumblebee.claysoldiers.init.ModEntityTypes;
import net.bumblebee.claysoldiers.soldierproperties.customproperties.AttackTypeProperty;
import net.minecraft.class_1293;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.class_3218;
import org.jetbrains.annotations.Nullable;

public class ClaySoldierEntity
extends AbstractClaySoldierEntity
implements VampireSubjugate {
    @Nullable
    private UUID vampOwnerUUID;
    @Nullable
    private ClayMobEntity cachedVampOwner;

    public ClaySoldierEntity(class_1299<? extends AbstractClaySoldierEntity> pEntityType, class_1937 pLevel) {
        super(pEntityType, pLevel, AttackTypeProperty.NORMAL);
    }

    @Override
    public void method_5652(class_2487 pCompound) {
        super.method_5652(pCompound);
        this.addVampOwner(pCompound);
    }

    @Override
    public void method_5749(class_2487 pCompound) {
        super.method_5749(pCompound);
        this.readVampOwner(pCompound);
    }

    @Override
    public void setVampOwner(@Nullable ClayMobEntity pOwner) {
        this.vampOwnerUUID = pOwner != null ? pOwner.method_5667() : null;
        this.cachedVampOwner = pOwner;
    }

    @Override
    @Nullable
    public ClayMobEntity getVampOwner() {
        class_1937 class_19372;
        if (!this.hasVampiricConversionEffect()) {
            return null;
        }
        if (this.cachedVampOwner != null && !this.cachedVampOwner.method_31481()) {
            return this.cachedVampOwner;
        }
        if (this.vampOwnerUUID != null && (class_19372 = this.method_37908()) instanceof class_3218) {
            class_3218 serverlevel = (class_3218)class_19372;
            class_1297 entity = serverlevel.method_14190(this.vampOwnerUUID);
            if (entity instanceof ClayMobEntity) {
                ClayMobEntity clayMob;
                this.cachedVampOwner = clayMob = (ClayMobEntity)entity;
                return clayMob;
            }
            return null;
        }
        return null;
    }

    @Override
    public boolean hasVampiricConversionEffect() {
        return this.method_6059(ModEffects.VAMPIRE_CONVERSION);
    }

    @Override
    public void applyConversionEffect(ClayMobEntity source) {
        if (!this.hasVampiricConversionEffect()) {
            this.method_6092(new class_1293(ModEffects.VAMPIRE_CONVERSION, 200, 4));
        }
        this.setVampOwner(source);
    }

    private void addVampOwner(class_2487 compound) {
        if (this.vampOwnerUUID != null || this.hasVampiricConversionEffect()) {
            compound.method_25927("VampiricOnwer", this.vampOwnerUUID);
        }
    }

    private void readVampOwner(class_2487 compound) {
        if (compound.method_25928("VampiricOnwer")) {
            this.vampOwnerUUID = compound.method_25926("VampiricOnwer");
            this.cachedVampOwner = null;
        }
    }

    @Override
    public void convertToVampire() {
        VampireClaySoldierEntity vampire = (VampireClaySoldierEntity)ModEntityTypes.VAMPIRE_CLAY_SOLDIER_ENTITY.get().method_5883(this.method_37908());
        if (vampire != null) {
            vampire.method_5808(this.method_23317(), this.method_23318(), this.method_23321(), this.method_36454(), this.method_36455());
            vampire.setIsAlpha(false);
            this.copyBasePropertiesTo(vampire, false);
            if (this.getVampOwner() != null) {
                vampire.setClayTeamType(this.getVampOwner().getClayTeamType());
            } else {
                vampire.setClayTeamType(this.getClayTeamType());
            }
            this.method_37908().method_8649((class_1297)vampire);
        }
    }
}

