/*
 * Decompiled with CFR 0.152.
 */
package net.bumblebee.claysoldiers.entity.soldier;

import net.bumblebee.claysoldiers.entity.ClayMobEntity;
import net.bumblebee.claysoldiers.entity.soldier.UndeadClaySoldier;
import net.bumblebee.claysoldiers.init.ModEntityTypes;
import net.bumblebee.claysoldiers.soldierproperties.customproperties.AttackTypeProperty;
import net.bumblebee.claysoldiers.team.ClayMobTeam;
import net.bumblebee.claysoldiers.team.ClayMobTeamManger;
import net.bumblebee.claysoldiers.team.IClayMobTeamReference;
import net.minecraft.class_1299;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3730;
import org.jetbrains.annotations.NotNull;

public class ZombieClaySoldierEntity
extends UndeadClaySoldier {
    private static final class_2940<String> PREVIOUS_TEAM_SYNC = class_2945.method_12791(ZombieClaySoldierEntity.class, (class_2941)class_2943.field_13326);
    public static final String CURABLE_TAG = "Curable";
    public static final String PICK_ITEMS_TAG = "PickUpItems";
    public static final String MATCH_TEAMS = "match_teams";
    private boolean curable = true;
    private boolean canPickItems = false;
    private IClayMobTeamReference cachedPrevTeam = null;

    public ZombieClaySoldierEntity(class_1299<? extends ZombieClaySoldierEntity> pEntityType, class_1937 pLevel) {
        super(pEntityType, pLevel, AttackTypeProperty.ZOMBIE);
    }

    @Override
    public void method_5749(class_2487 pCompound) {
        super.method_5749(pCompound);
        class_2960 prevTeamId = ClayMobTeam.read(pCompound, "zombie");
        if (ClayMobTeamManger.isValidTeam(prevTeamId, this.method_56673())) {
            this.setPreviousTeam(prevTeamId);
        } else {
            this.setClayTeamType(ClayMobTeamManger.DEFAULT_TYPE);
        }
        this.setCurable(pCompound.method_10577(CURABLE_TAG));
        this.setCanPickItems(pCompound.method_10577(PICK_ITEMS_TAG));
    }

    @Override
    public void method_5652(class_2487 pCompound) {
        super.method_5652(pCompound);
        ClayMobTeam.save(this.getPreviousTeamId(), pCompound, "zombie");
        pCompound.method_10556(CURABLE_TAG, this.isCurable());
        pCompound.method_10556(PICK_ITEMS_TAG, this.canPickItems());
    }

    @Override
    protected void method_5693(class_2945.class_9222 builder) {
        super.method_5693(builder);
        builder.method_56912(PREVIOUS_TEAM_SYNC, (Object)ClayMobTeamManger.DEFAULT_TYPE.toString());
    }

    @NotNull
    public ClayMobTeam getPreviousTeam() {
        class_2960 prevKey = this.getPreviousTeamId();
        if (this.cachedPrevTeam == null || !this.cachedPrevTeam.isValidForKey(prevKey)) {
            this.cachedPrevTeam = ClayMobTeamManger.getReferenceOrDefault(prevKey, this.method_56673(), () -> {
                this.setPreviousTeam(ClayMobTeamManger.NO_TEAM_TYPE);
                ClayMobTeamManger.LOGGER.error("{} has a Previous Team ({}) that does not exist anymore", (Object)this.getClass().getSimpleName(), (Object)prevKey);
            });
        }
        return this.cachedPrevTeam == null ? ClayMobTeamManger.ERROR : this.cachedPrevTeam.value();
    }

    public class_2960 getPreviousTeamId() {
        return class_2960.method_60654((String)((String)this.field_6011.method_12789(PREVIOUS_TEAM_SYNC)));
    }

    public void setPreviousTeam(class_2960 variant) {
        this.field_6011.method_12778(PREVIOUS_TEAM_SYNC, (Object)variant.toString());
    }

    @Override
    public boolean isAbleToRide() {
        return false;
    }

    @Override
    public boolean method_20820(class_1799 pStack) {
        return this.canPickItems && super.method_20820(pStack) || this.isItemStackHelm(pStack);
    }

    public boolean previousTeamSameAs(ClayMobEntity claySoldier) {
        if (!this.getPreviousTeam().isCooperative() || claySoldier.hasNoTeam()) {
            return false;
        }
        return this.getPreviousTeamId().equals((Object)claySoldier.getClayTeamType());
    }

    public boolean isCurable() {
        return this.curable;
    }

    public void setCurable(boolean curable) {
        this.curable = curable;
    }

    public void cureZombieSoldier() {
        if (!this.curable) {
            return;
        }
        class_1937 class_19372 = this.method_37908();
        if (class_19372 instanceof class_3218) {
            class_3218 serverLevel = (class_3218)class_19372;
            ModEntityTypes.CLAY_SOLDIER_ENTITY.get().method_5899(serverLevel, curedSoldier -> {
                this.copyInventory(curedSoldier);
                curedSoldier.setClayTeamType(this.getPreviousTeamId());
            }, this.method_24515(), class_3730.field_16468, false, false);
            this.method_31472();
        }
    }

    @Override
    public void readItemPersistentData(class_2487 tag) {
        if (tag.method_10545(CURABLE_TAG)) {
            this.setCurable(tag.method_10577(CURABLE_TAG));
        }
        if (tag.method_10545(PICK_ITEMS_TAG)) {
            this.setCanPickItems(tag.method_10577(PICK_ITEMS_TAG));
        }
    }

    public boolean canPickItems() {
        return this.canPickItems;
    }

    public void setCanPickItems(boolean canPickItems) {
        this.canPickItems = canPickItems;
    }

    @Override
    public void onConversion(ClayMobEntity oldSoldier, class_2487 tag) {
        if (tag.method_10545(MATCH_TEAMS) && tag.method_10577(MATCH_TEAMS)) {
            this.setPreviousTeam(oldSoldier.getClayTeamType());
        }
    }

    @Override
    public boolean isZombie() {
        return true;
    }
}

