/*
 * Decompiled with CFR 0.152.
 */
package net.bumblebee.claysoldiers.init;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import net.bumblebee.claysoldiers.ClaySoldiersCommon;
import net.bumblebee.claysoldiers.entity.boss.BossBatEntity;
import net.bumblebee.claysoldiers.entity.boss.BossClaySoldierBehaviour;
import net.bumblebee.claysoldiers.entity.boss.BossClaySoldierEntity;
import net.bumblebee.claysoldiers.init.ModEntityTypes;
import net.bumblebee.claysoldiers.soldierproperties.SoldierPropertyMap;
import net.bumblebee.claysoldiers.soldierproperties.SoldierPropertyTypes;
import net.minecraft.class_1259;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3532;
import net.minecraft.class_3730;
import net.minecraft.class_5134;
import net.minecraft.class_52;
import net.minecraft.class_5321;
import net.minecraft.class_7924;
import net.minecraft.class_8103;
import net.minecraft.class_8111;

public final class ModBossBehaviours {
    public static final class_5321<class_52> DEFAULT_LOOT_TABLE = ModBossBehaviours.createBossLootTable("default");
    public static final class_5321<class_52> VAMPIRE_LOOT_TABLE = ModBossBehaviours.createBossLootTable("vampire");
    public static final class_5321<class_52> ZOMBIE_LOOT_TABLE = ModBossBehaviours.createBossLootTable("zombie");
    public static final Supplier<BossClaySoldierBehaviour> DEFAULT = ClaySoldiersCommon.PLATFORM.registerClayBossBehaviour("default", () -> BossClaySoldierBehaviour.of(BossClaySoldierEntity.BossTypes.NORMAL, DEFAULT_LOOT_TABLE).setAllowedBossTypes(BossClaySoldierEntity.BossTypes.ZOMBIE).setOnDeath((boss, damageSource) -> boss.getBossDeathLoot((class_1282)damageSource).forEach(arg_0 -> ((BossClaySoldierEntity)boss).method_5775(arg_0))).setShouldDie(boss -> {
        if (boss.getBossType() == BossClaySoldierEntity.BossTypes.NORMAL) {
            boss.method_6033(boss.method_6063());
            boss.setBossType(BossClaySoldierEntity.BossTypes.ZOMBIE);
            return false;
        }
        return true;
    }).setBossEvent((boss, bar) -> bar.method_5416(class_1259.class_1260.field_5780)).build());
    public static final Supplier<BossClaySoldierBehaviour> VAMPIRE = ClaySoldiersCommon.PLATFORM.registerClayBossBehaviour("vampire", () -> BossClaySoldierBehaviour.of(BossClaySoldierEntity.BossTypes.VAMPIRE, VAMPIRE_LOOT_TABLE).setOnDeath((boss, damageSource) -> {
        class_1937 patt0$temp = boss.method_37908();
        if (patt0$temp instanceof class_3218) {
            class_3218 serverLevel = (class_3218)patt0$temp;
            class_2338 pos = boss.method_24515();
            List<class_1799> loot = boss.getBossDeathLoot((class_1282)damageSource);
            if (loot.isEmpty()) {
                return;
            }
            ModBossBehaviours.createBat(List.of(loot.getFirst()), serverLevel, pos);
            List[] lists = new List[]{new ArrayList(), new ArrayList(), new ArrayList()};
            for (int i = 1; i < loot.size(); ++i) {
                lists[i % 3].add(loot.get(i));
            }
            for (List list : lists) {
                ModBossBehaviours.createBat(list, serverLevel, pos);
            }
        } else {
            class_243 vec3 = boss.method_19538();
            for (int i = 0; i < 30; ++i) {
                boss.method_37908().method_8406((class_2394)class_2398.field_22247, vec3.field_1352, vec3.field_1351 + 0.5, vec3.field_1350, 0.0, 0.1, 0.0);
            }
        }
    }).setBossEvent((boss, bar) -> bar.method_5416(class_1259.class_1260.field_5784)).build());
    public static final Supplier<BossClaySoldierBehaviour> ZOMBIE = ClaySoldiersCommon.PLATFORM.registerClayBossBehaviour("zombie", () -> BossClaySoldierBehaviour.of(BossClaySoldierEntity.BossTypes.ZOMBIE, ZOMBIE_LOOT_TABLE).setBossEvent((b, e) -> e.method_5416(class_1259.class_1260.field_5785)).setOnHurt((boss, damage) -> {
        class_1937 patt0$temp;
        if (damage.method_49708(class_8111.field_44869) || damage.method_48789(class_8103.field_42242)) {
            return true;
        }
        if (boss.getMinionCount() > 0) {
            return false;
        }
        if (boss.getPhaseCompleted() <= 0 && boss.method_6032() < boss.method_6063() * 0.5f && (patt0$temp = boss.method_37908()) instanceof class_3218) {
            class_3218 serverLevel = (class_3218)patt0$temp;
            ModBossBehaviours.spawnZombieMinions(boss, serverLevel);
            boss.completePhase();
        }
        return true;
    }).setModifyBossEventProgress((boss, event) -> {
        if (boss.getMinionCount() > 0) {
            event.method_5409(class_1259.class_1261.field_5796);
            event.method_5408((float)boss.getMinionCount() / 6.0f);
        } else {
            event.method_5409(class_1259.class_1261.field_5795);
            event.method_5408(boss.method_6032() / boss.method_6063());
        }
    }).setOnDeath((boss, damageSource) -> boss.getBossDeathLoot((class_1282)damageSource).forEach(arg_0 -> ((BossClaySoldierEntity)boss).method_5775(arg_0))).build());
    public static final Supplier<BossClaySoldierBehaviour> ZOMBIE_MINION = ClaySoldiersCommon.PLATFORM.registerClayBossBehaviour("zombie_minion", () -> BossClaySoldierBehaviour.of(BossClaySoldierEntity.BossTypes.ZOMBIE, null).setOnDeath((boss, damageSource) -> boss.notifyMinionOwnerOfDeath()).setBossEvent((boss, bar) -> bar.method_14091(false)).build());

    private ModBossBehaviours() {
    }

    private static void createBat(List<class_1799> loot, class_3218 level, class_2338 pos) {
        if (loot.isEmpty()) {
            return;
        }
        BossBatEntity bat = (BossBatEntity)ModEntityTypes.VAMPIRE_BAT.get().method_47821(level, pos, class_3730.field_16471);
        if (bat != null) {
            bat.setLoot(loot);
        }
    }

    private static void spawnZombieMinions(BossClaySoldierEntity boss, class_3218 level) {
        int size = 6;
        ArrayList<BossClaySoldierEntity> minions = new ArrayList<BossClaySoldierEntity>(size);
        for (int i = 0; i < size; ++i) {
            BossClaySoldierEntity minion = (BossClaySoldierEntity)ModEntityTypes.BOSS_CLAY_SOLDIER_ENTITY.get().method_5883((class_1937)level);
            if (minion == null) {
                return;
            }
            minion.setBossAI(ZOMBIE_MINION.get());
            minion.setBaseProperties(SoldierPropertyMap.of(SoldierPropertyTypes.PROTECTION.get().createProperty(Float.valueOf(-3.0f))));
            minion.method_6127().method_45329(class_5134.field_23716).method_6192(10.0);
            minion.method_6127().method_45329(class_5134.field_23724).method_6192(0.0);
            minion.setMinionOwner(boss);
            minion.method_5808(boss.method_19538().field_1352 + (double)level.field_9229.method_43057(), boss.method_19538().field_1351, boss.method_19538().field_1350 + (double)level.field_9229.method_43057(), class_3532.method_15393((float)(level.field_9229.method_43057() * 360.0f)), 0.0f);
            minion.field_6241 = minion.method_36454();
            minion.field_6283 = minion.method_36454();
            minion.setClayTeamType(boss.getClayTeamType());
            minions.add(minion);
            level.method_8649((class_1297)minion);
        }
        boss.addAllMinions(minions);
    }

    private static class_5321<class_52> createBossLootTable(String name) {
        return class_5321.method_29179((class_5321)class_7924.field_50079, (class_2960)class_2960.method_60655((String)"csr", (String)"boss_clay_soldier/%s".formatted(name)));
    }

    public static void init() {
    }
}

