/*
 * Decompiled with CFR 0.152.
 */
package net.bumblebee.claysoldiers.init;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import net.bumblebee.claysoldiers.ClaySoldiersCommon;
import net.bumblebee.claysoldiers.soldieritemtypes.Generator;
import net.bumblebee.claysoldiers.soldieritemtypes.ItemGenerator;
import net.bumblebee.claysoldiers.soldieritemtypes.WeightedItem;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_2371;
import net.minecraft.class_5819;

public final class ModItemGenerators {
    private static final class_2371<class_1799> EMPTY = class_2371.method_10213((int)0, (Object)class_1799.field_8037);
    private static final ItemGenerator DEFAULT_GENERATOR = new ItemGenerator(){

        @Override
        public ItemGenerator.Limit limitedBy() {
            return ItemGenerator.Limit.COUNT;
        }

        public String toString() {
            return "Default";
        }

        @Override
        public class_2371<class_1799> generateForTag(List<WeightedItem> available, int count, class_5819 random) {
            if (available.isEmpty()) {
                return class_2371.method_10211();
            }
            if (available.size() == 1) {
                class_2371 selectedItems = class_2371.method_10211();
                ModItemGenerators.addItemStackToList((List<class_1799>)selectedItems, available.getFirst().getItem(), count);
                return selectedItems;
            }
            int i = 0;
            int pickedItems = 0;
            int size = available.size();
            HashMap<class_1792, Integer> amountMap = new HashMap<class_1792, Integer>(Math.min(count, size));
            while (pickedItems < count) {
                if (!ModItemGenerators.appendToMap(amountMap, available.get(i = (i + 1) % size), random)) continue;
                ++pickedItems;
            }
            class_2371 itemAmountAdjusted = class_2371.method_37434((int)amountMap.size());
            amountMap.forEach((item, amount) -> ModItemGenerators.addItemStackToList((List<class_1799>)itemAmountAdjusted, item, amount));
            return itemAmountAdjusted;
        }
    };
    private static final ItemGenerator ONE_OF_EACH_GENERATOR = new ItemGenerator(){

        @Override
        public ItemGenerator.Limit limitedBy() {
            return ItemGenerator.Limit.SIZE;
        }

        @Override
        public class_2371<class_1799> generateForTag(List<WeightedItem> available, int count, class_5819 random) {
            int availableSize = available.size();
            int adjustedCount = Math.min(availableSize, count);
            class_2371 selected = class_2371.method_37434((int)adjustedCount);
            int randomOffset = random.method_43048(availableSize);
            for (int i = 0; i < adjustedCount; ++i) {
                selected.add((Object)available.get((i + randomOffset) % availableSize).asStack());
            }
            return selected;
        }

        public String toString() {
            return "One of Each";
        }
    };
    public static final Supplier<ItemGenerator> DEFAULT = ClaySoldiersCommon.PLATFORM.registerItemGenerator("default", () -> DEFAULT_GENERATOR);
    public static final Supplier<ItemGenerator> ONE_OF_EACH = ClaySoldiersCommon.PLATFORM.registerItemGenerator("one_of_each", () -> ONE_OF_EACH_GENERATOR);
    public static final Supplier<ItemGenerator> ONE_OF_EACH_NO_TAG = ClaySoldiersCommon.PLATFORM.registerItemGenerator("one_of_each_no_tag", () -> ModItemGenerators.createdNoTagGenerator(ONE_OF_EACH_GENERATOR));
    public static final Supplier<ItemGenerator> COMBINED_DEFAULTED = ClaySoldiersCommon.PLATFORM.registerItemGenerator("combined_defaulted", () -> ModItemGenerators.createdCombinedGenerator(DEFAULT_GENERATOR));

    public static void init() {
    }

    private static ItemGenerator createdCombinedGenerator(final ItemGenerator base) {
        return new ItemGenerator(){

            @Override
            public class_2371<class_1799> generate(List<WeightedItem> ignored, int count, class_5819 random, List<Generator> all) {
                class_2371 selected = class_2371.method_10211();
                ArrayList<Generator> generatedExpected = new ArrayList<Generator>(all);
                int initialIndividualCount = count / generatedExpected.size();
                int remaining = count % generatedExpected.size();
                Iterator it = generatedExpected.iterator();
                while (it.hasNext()) {
                    Generator generator = (Generator)it.next();
                    class_2371<class_1799> generated = generator.generateForTag(initialIndividualCount, random);
                    selected.addAll(generated);
                    if (generator.limitedBy() != ItemGenerator.Limit.SIZE) continue;
                    remaining += initialIndividualCount - generated.size();
                    it.remove();
                }
                initialIndividualCount = remaining / generatedExpected.size();
                remaining %= generatedExpected.size();
                for (int i = 0; i < generatedExpected.size(); ++i) {
                    selected.addAll(((Generator)generatedExpected.get(i)).generateForTag(initialIndividualCount + (remaining < i ? 1 : 0), random));
                }
                return selected;
            }

            @Override
            public ItemGenerator.Limit limitedBy() {
                return base.limitedBy();
            }

            @Override
            public class_2371<class_1799> generateForTag(List<WeightedItem> available, int count, class_5819 random) {
                return base.generateForTag(available, count, random);
            }

            public String toString() {
                return "Combined(%s)".formatted(base);
            }
        };
    }

    private static ItemGenerator createdNoTagGenerator(final ItemGenerator base) {
        return new ItemGenerator(){

            @Override
            public ItemGenerator.Limit limitedBy() {
                return ItemGenerator.Limit.ZERO;
            }

            @Override
            public class_2371<class_1799> generateForTag(List<WeightedItem> available, int count, class_5819 random) {
                return EMPTY;
            }

            @Override
            public class_2371<class_1799> generate(List<WeightedItem> available, int count, class_5819 random, List<Generator> all) {
                return base.generate(available, count, random, all);
            }

            public String toString() {
                return base.toString() + "(No Tag)";
            }
        };
    }

    private static boolean appendToMap(Map<class_1792, Integer> items, WeightedItem weightItem, class_5819 random) {
        if (random.method_43057() < weightItem.getWeight()) {
            Integer count = items.get(weightItem.getItem());
            if (count == null) {
                items.put(weightItem.getItem(), 1);
            } else {
                count = count + 1;
                items.put(weightItem.getItem(), count);
            }
            return true;
        }
        return false;
    }

    private static void addItemStackToList(List<class_1799> itemsCounted, class_1792 item, int count) {
        int maxStackSize = item.method_7882();
        if (count <= maxStackSize) {
            itemsCounted.add(new class_1799((class_1935)item, count));
        } else {
            itemsCounted.add(new class_1799((class_1935)item, maxStackSize));
            ModItemGenerators.addItemStackToList(itemsCounted, item, count - maxStackSize);
        }
    }
}

