/*
 * Decompiled with CFR 0.152.
 */
package net.bumblebee.claysoldiers.integration;

import net.bumblebee.claysoldiers.entity.ClayMobEntity;
import net.bumblebee.claysoldiers.integration.FabricAirBubbleElement;
import net.bumblebee.claysoldiers.integration.FabricMultiLineTextElement;
import net.bumblebee.claysoldiers.integration.jade.CommonBlockProvider;
import net.bumblebee.claysoldiers.integration.jade.CommonEntityProvider;
import net.bumblebee.claysoldiers.integration.jade.CommonEntityServerAppender;
import net.bumblebee.claysoldiers.integration.jade.CommonTooltipHelper;
import net.bumblebee.claysoldiers.integration.jade.JadeRegistry;
import net.bumblebee.claysoldiers.integration.jade.providers.ClayMobProvider;
import net.minecraft.class_1297;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import org.jetbrains.annotations.Nullable;
import snownee.jade.api.Accessor;
import snownee.jade.api.BlockAccessor;
import snownee.jade.api.EntityAccessor;
import snownee.jade.api.IBlockComponentProvider;
import snownee.jade.api.IComponentProvider;
import snownee.jade.api.IEntityComponentProvider;
import snownee.jade.api.IServerDataProvider;
import snownee.jade.api.ITooltip;
import snownee.jade.api.IWailaClientRegistration;
import snownee.jade.api.IWailaCommonRegistration;
import snownee.jade.api.IWailaPlugin;
import snownee.jade.api.WailaPlugin;
import snownee.jade.api.config.IPluginConfig;
import snownee.jade.api.ui.IElement;
import snownee.jade.api.ui.IElementHelper;
import snownee.jade.impl.ui.CompoundElement;
import snownee.jade.impl.ui.HorizontalLineElement;
import snownee.jade.impl.ui.ItemStackElement;

@WailaPlugin
public class JadePlugin
implements IWailaPlugin {
    public void registerClient(IWailaClientRegistration registration) {
        JadeRegistry.getBlocks().forEach(jadeBlock -> registration.registerBlockComponent((IComponentProvider)new FabricBlockProvider((CommonBlockProvider)jadeBlock), jadeBlock.getTargetClass()));
        JadeRegistry.getEntities().forEach(jadeEntity -> {
            FabricEntityProvider provider = new FabricEntityProvider(jadeEntity);
            registration.registerEntityComponent(provider, jadeEntity.getTargetClass());
            if (jadeEntity == ClayMobProvider.INSTANCE) {
                registration.registerEntityIcon(provider, jadeEntity.getTargetClass());
            }
        });
    }

    public void register(IWailaCommonRegistration registration) {
        JadeRegistry.getServerEntities().forEach(jadeEntityServer -> registration.registerEntityDataProvider(new FabricEntityDataProvider(jadeEntityServer), jadeEntityServer.getTargetClass()));
    }

    private record FabricEntityDataProvider<T extends class_1297>(CommonEntityServerAppender<T> serverAppender) implements IServerDataProvider<EntityAccessor>
    {
        public void appendServerData(class_2487 compoundTag, EntityAccessor accessor) {
            this.serverAppender.appendServerData(compoundTag, accessor.getEntity());
        }

        public class_2960 getUid() {
            return this.serverAppender.getUniqueId();
        }
    }

    private record FabricEntityProvider<T extends class_1297>(CommonEntityProvider<T> provider) implements IEntityComponentProvider
    {
        public class_2960 getUid() {
            return this.provider.getUniqueId();
        }

        public void appendTooltip(ITooltip iTooltip, EntityAccessor entityAccessor, IPluginConfig iPluginConfig) {
            this.provider.appendTooltip(entityAccessor.getEntity(), new FabricTooltipHelper(iTooltip), entityAccessor.showDetails(), this.provider.requiresServerData() ? entityAccessor.getServerData() : null);
        }

        @Nullable
        public IElement getIcon(EntityAccessor accessor, IPluginConfig config, IElement currentIcon) {
            if (this.provider != ClayMobProvider.INSTANCE) {
                return super.getIcon((Accessor)accessor, config, currentIcon);
            }
            if (accessor.getPickedResult().method_7960()) {
                return currentIcon;
            }
            IElementHelper helper = IElementHelper.get();
            IElement largeIcon = helper.item(accessor.getPickedResult());
            if (((ClayMobEntity)accessor.getEntity()).isWaxed()) {
                return new CompoundElement(largeIcon, helper.item(class_1802.field_20414.method_7854(), 0.5f));
            }
            return largeIcon;
        }
    }

    private record FabricBlockProvider(CommonBlockProvider provider) implements IBlockComponentProvider
    {
        public void appendTooltip(ITooltip iTooltip, BlockAccessor blockAccessor, IPluginConfig iPluginConfig) {
            this.provider.appendTooltip(new CommonBlockProvider.BlockData(blockAccessor.getBlockState(), blockAccessor.getBlockEntity(), blockAccessor.getServerData()), new FabricTooltipHelper(iTooltip), blockAccessor.showDetails());
        }

        public class_2960 getUid() {
            return this.provider.getUniqueId();
        }
    }

    private record FabricTooltipHelper(ITooltip tooltip) implements CommonTooltipHelper
    {
        private static final HorizontalLineElement LINE_ELEMENT = new HorizontalLineElement();

        @Override
        public void add(class_2561 component) {
            this.tooltip.add(component);
        }

        @Override
        public void append(class_2561 component) {
            this.tooltip.append(component);
        }

        @Override
        public void addItemStack(class_1799 stack) {
            this.tooltip.add((IElement)ItemStackElement.of((class_1799)stack));
        }

        @Override
        public void appendItemStack(class_1799 stack) {
            this.tooltip.append((IElement)ItemStackElement.of((class_1799)stack));
        }

        @Override
        public void airBubbles(int breath, boolean bursting) {
            this.tooltip.add((IElement)new FabricAirBubbleElement(breath, bursting));
        }

        @Override
        public void appendMultilineText(class_2561 ... lines) {
            this.tooltip.append((IElement)new FabricMultiLineTextElement(lines));
        }

        @Override
        public void addCompoundItemStack(class_1799 large, class_1799 small) {
            this.tooltip.add((IElement)new CompoundElement((IElement)ItemStackElement.of((class_1799)large), (IElement)ItemStackElement.of((class_1799)small, (float)0.5f)));
        }

        @Override
        public void addHorizontalLine() {
            this.tooltip.add((IElement)LINE_ELEMENT);
        }
    }
}

