/*
 * Decompiled with CFR 0.152.
 */
package net.bumblebee.claysoldiers.integration.jade;

import java.util.ArrayList;
import java.util.List;
import net.bumblebee.claysoldiers.integration.jade.CommonBlockProvider;
import net.bumblebee.claysoldiers.integration.jade.CommonEntityProvider;
import net.bumblebee.claysoldiers.integration.jade.CommonEntityServerAppender;
import net.bumblebee.claysoldiers.integration.jade.providers.BossClaySoldierProvider;
import net.bumblebee.claysoldiers.integration.jade.providers.ClayMobProvider;
import net.bumblebee.claysoldiers.integration.jade.providers.ClaySoldierProvider;
import net.bumblebee.claysoldiers.integration.jade.providers.ClayWraithProvider;
import net.bumblebee.claysoldiers.integration.jade.providers.EaselBlockProvider;
import net.bumblebee.claysoldiers.integration.jade.providers.HamsterWheelBlockProvider;
import net.bumblebee.claysoldiers.integration.jade.providers.VampireClaySoldierProvider;
import net.bumblebee.claysoldiers.integration.jade.providers.ZombieClaySoldierProvider;
import net.minecraft.class_1297;
import net.minecraft.class_2960;

public class JadeRegistry {
    private static final List<CommonBlockProvider> JADE_BLOCKS = new ArrayList<CommonBlockProvider>();
    private static final List<CommonEntityProvider<?>> JADE_ENTITY = new ArrayList();
    private static final List<CommonEntityServerAppender<?>> JADE_ENTITY_SERVER = new ArrayList();
    public static final String BASE_LANG = "jade.plugin.csr.%s.%s";
    public static final class_2960 CLAY_MOB = class_2960.method_60655((String)"csr", (String)"clay_mob");
    public static final class_2960 CLAY_SOLDIER = class_2960.method_60655((String)"csr", (String)"clay_soldier");
    public static final class_2960 ZOMBIE_CLAY_SOLDIER = class_2960.method_60655((String)"csr", (String)"zombie_clay_soldier");
    public static final class_2960 CLAY_WRAITH = class_2960.method_60655((String)"csr", (String)"clay_wraith");
    public static final class_2960 VAMPIRE_SOLDIER = class_2960.method_60655((String)"csr", (String)"vampire_clay_soldier");
    public static final class_2960 EASEL_BLOCK = class_2960.method_60655((String)"csr", (String)"easel_block_storage");
    public static final class_2960 HAMSTER_WHEEL_BLOCK = class_2960.method_60655((String)"csr", (String)"hamster_wheel");
    public static final class_2960 BOSS_CLAY_SOLDIER = class_2960.method_60655((String)"csr", (String)"boss_clay_soldier");

    public static String getLangKey(CommonBlockProvider provider, String suffix) {
        return BASE_LANG.formatted(provider.getUniqueId().method_12832(), suffix);
    }

    public static String getLangKey(CommonEntityProvider<?> provider, String suffix) {
        return BASE_LANG.formatted(provider.getUniqueId().method_12832(), suffix);
    }

    public static void registerBlockProvider(CommonBlockProvider blockProvider) {
        JADE_BLOCKS.add(blockProvider);
    }

    public static <T extends class_1297> void registerEntityProvider(CommonEntityProvider<T> entityProvider) {
        JADE_ENTITY.add(entityProvider);
    }

    public static <T extends class_1297> void registerEntityServerAppender(CommonEntityServerAppender<T> serverAppender) {
        JADE_ENTITY_SERVER.add(serverAppender);
    }

    public static List<CommonBlockProvider> getBlocks() {
        return JADE_BLOCKS;
    }

    public static List<CommonEntityProvider<?>> getEntities() {
        return JADE_ENTITY;
    }

    public static List<CommonEntityServerAppender<?>> getServerEntities() {
        return JADE_ENTITY_SERVER;
    }

    static {
        JadeRegistry.registerEntityProvider(ClayMobProvider.INSTANCE);
        JadeRegistry.registerEntityProvider(ClaySoldierProvider.INSTANCE);
        JadeRegistry.registerEntityProvider(VampireClaySoldierProvider.INSTANCE);
        JadeRegistry.registerEntityProvider(ZombieClaySoldierProvider.INSTANCE);
        JadeRegistry.registerEntityProvider(ClayWraithProvider.INSTANCE);
        JadeRegistry.registerEntityProvider(BossClaySoldierProvider.INSTANCE);
        JadeRegistry.registerEntityServerAppender(ClayWraithProvider.INSTANCE);
        JadeRegistry.registerEntityServerAppender(ZombieClaySoldierProvider.INSTANCE);
        JadeRegistry.registerBlockProvider(EaselBlockProvider.INSTANCE);
        JadeRegistry.registerBlockProvider(HamsterWheelBlockProvider.INSTANCE);
    }
}

