/*
 * Decompiled with CFR 0.152.
 */
package net.bumblebee.claysoldiers.integration.jade.providers;

import java.util.function.BiConsumer;
import net.bumblebee.claysoldiers.entity.ClayMobEntity;
import net.bumblebee.claysoldiers.entity.soldier.AbstractClaySoldierEntity;
import net.bumblebee.claysoldiers.init.ModTags;
import net.bumblebee.claysoldiers.integration.jade.CommonEntityProvider;
import net.bumblebee.claysoldiers.integration.jade.CommonTooltipHelper;
import net.bumblebee.claysoldiers.integration.jade.JadeRegistry;
import net.minecraft.class_124;
import net.minecraft.class_1309;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2960;

public enum ClayMobProvider implements CommonEntityProvider<ClayMobEntity>
{
    INSTANCE;

    public static final String CLAY_MOB_TEAM;

    @Override
    public void appendTooltip(ClayMobEntity entity, CommonTooltipHelper tooltip, boolean detail, class_2487 tag) {
        if (entity.method_5864().method_20210(ModTags.EntityTypes.CLAY_BOSS)) {
            return;
        }
        if (entity instanceof AbstractClaySoldierEntity) {
            AbstractClaySoldierEntity soldier = (AbstractClaySoldierEntity)entity;
            ClayMobProvider.addAirBubbles(soldier, tooltip::airBubbles);
        }
        tooltip.add(this.createTeamName(entity));
        class_2561 workStatus = entity.getWorkStatus();
        if (workStatus != null) {
            tooltip.add(workStatus);
        }
    }

    @Override
    public class_2960 getUniqueId() {
        return JadeRegistry.CLAY_MOB;
    }

    @Override
    public Class<ClayMobEntity> getTargetClass() {
        return ClayMobEntity.class;
    }

    public class_2561 createTeamName(ClayMobEntity clayMob) {
        return class_2561.method_43471((String)CLAY_MOB_TEAM).method_27692(class_124.field_1063).method_10852((class_2561)class_2561.method_43470((String)": ").method_27692(class_124.field_1063)).method_10852(clayMob.getClayTeam().getDisplayNameWithColor(c -> c.getColor((class_1309)clayMob, 0.0f)));
    }

    private static void addAirBubbles(AbstractClaySoldierEntity soldier, BiConsumer<Integer, Boolean> adder) {
        if (!soldier.method_5799() || soldier.allProperties().breathHoldDuration() >= 1000) {
            return;
        }
        int breathPercent = (int)((float)(soldier.method_5669() * 10) / (float)soldier.method_5748());
        int breathPercentAfter = (int)((float)((soldier.method_5669() - 1) * 10) / (float)soldier.method_5748());
        adder.accept(breathPercent, breathPercent > breathPercentAfter);
    }

    static {
        CLAY_MOB_TEAM = JadeRegistry.getLangKey(INSTANCE, "team");
    }
}

