/*
 * Decompiled with CFR 0.152.
 */
package net.bumblebee.claysoldiers.integration.jade.providers;

import java.util.ArrayList;
import java.util.List;
import net.bumblebee.claysoldiers.entity.soldier.AbstractClaySoldierEntity;
import net.bumblebee.claysoldiers.entity.soldier.VampireClaySoldierEntity;
import net.bumblebee.claysoldiers.init.ModTags;
import net.bumblebee.claysoldiers.integration.jade.CommonEntityProvider;
import net.bumblebee.claysoldiers.integration.jade.CommonTooltipHelper;
import net.bumblebee.claysoldiers.integration.jade.JadeRegistry;
import net.bumblebee.claysoldiers.soldierproperties.SoldierPropertyTypes;
import net.bumblebee.claysoldiers.soldierproperties.customproperties.AttackTypeProperty;
import net.bumblebee.claysoldiers.util.ComponentFormating;
import net.bumblebee.claysoldiers.util.color.ColorHelper;
import net.minecraft.class_124;
import net.minecraft.class_1309;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_5244;

public enum ClaySoldierProvider implements CommonEntityProvider<AbstractClaySoldierEntity>
{
    INSTANCE;

    public static final String SOLDIER_PROPERTIES;
    public static final String ALPHA_PREFIX;
    public static final String OFFSET_COLOR;

    @Override
    public void appendTooltip(AbstractClaySoldierEntity claySoldier, CommonTooltipHelper tooltip, boolean detail, class_2487 tag) {
        if (claySoldier.method_5864().method_20210(ModTags.EntityTypes.CLAY_BOSS)) {
            return;
        }
        ClaySoldierProvider.formatAttackTypeProperty(tooltip, claySoldier.getAttackType(), claySoldier);
        ClaySoldierProvider.formatOffsetColor(tooltip, claySoldier);
        if (detail) {
            tooltip.add((class_2561)class_2561.method_43471((String)SOLDIER_PROPERTIES).method_27693(":").method_27692(class_124.field_1063));
            ArrayList<class_2561> components = new ArrayList<class_2561>();
            ComponentFormating.formatProperties(components, claySoldier.allProperties(), List.of(SoldierPropertyTypes.PROTECTION.get(), SoldierPropertyTypes.ATTACK_TYPE.get()), claySoldier);
            components.forEach(tooltip::add);
        }
    }

    private static void formatAttackTypeProperty(CommonTooltipHelper tooltip, AttackTypeProperty property, AbstractClaySoldierEntity claySoldier) {
        class_2561 name = property.getAnimatedDisplayName((class_1309)claySoldier);
        if (name != null) {
            VampireClaySoldierEntity vampireClaySoldier;
            if (claySoldier instanceof VampireClaySoldierEntity && (vampireClaySoldier = (VampireClaySoldierEntity)claySoldier).isAlpha()) {
                tooltip.add((class_2561)class_2561.method_43471((String)ALPHA_PREFIX).method_27696(AttackTypeProperty.VAMPIRE.getAnimatedStyle((class_1309)claySoldier)));
                tooltip.append(class_5244.field_41874);
                tooltip.append(name);
            } else {
                tooltip.add(name);
            }
        }
    }

    private static void formatOffsetColor(CommonTooltipHelper tooltip, AbstractClaySoldierEntity soldier) {
        if (soldier.hasOffsetColor()) {
            tooltip.add(class_5244.field_41874);
            tooltip.append((class_2561)class_2561.method_43471((String)OFFSET_COLOR).method_27693(": "));
            ColorHelper color = soldier.getOffsetColor();
            tooltip.append(color.formatDynamic((class_1309)soldier));
        }
    }

    @Override
    public class_2960 getUniqueId() {
        return JadeRegistry.CLAY_SOLDIER;
    }

    @Override
    public Class<AbstractClaySoldierEntity> getTargetClass() {
        return AbstractClaySoldierEntity.class;
    }

    static {
        SOLDIER_PROPERTIES = JadeRegistry.getLangKey(INSTANCE, "soldier_properties");
        ALPHA_PREFIX = JadeRegistry.getLangKey(INSTANCE, "alpha_prefix");
        OFFSET_COLOR = JadeRegistry.getLangKey(INSTANCE, "offset_color");
    }
}

