/*
 * Decompiled with CFR 0.152.
 */
package net.bumblebee.claysoldiers.integration.jade.providers;

import net.bumblebee.claysoldiers.ClaySoldiersCommon;
import net.bumblebee.claysoldiers.block.hamsterwheel.HamsterWheelBlock;
import net.bumblebee.claysoldiers.block.hamsterwheel.HamsterWheelBlockEntity;
import net.bumblebee.claysoldiers.block.hamsterwheel.HamsterWheelSoldierData;
import net.bumblebee.claysoldiers.entity.client.ClientClaySoldierEntity;
import net.bumblebee.claysoldiers.integration.jade.CommonBlockProvider;
import net.bumblebee.claysoldiers.integration.jade.CommonTooltipHelper;
import net.bumblebee.claysoldiers.integration.jade.JadeRegistry;
import net.bumblebee.claysoldiers.integration.jade.providers.ClayMobProvider;
import net.minecraft.class_124;
import net.minecraft.class_1802;
import net.minecraft.class_2248;
import net.minecraft.class_2561;
import net.minecraft.class_2960;

public enum HamsterWheelBlockProvider implements CommonBlockProvider
{
    INSTANCE;

    public static final String HAMSTER_WHEEL_SPEED;
    public static final String GENERATING;

    @Override
    public void appendTooltip(CommonBlockProvider.BlockData data, CommonTooltipHelper tooltip, boolean detail) {
        HamsterWheelBlockEntity blockEntity = (HamsterWheelBlockEntity)data.entity();
        HamsterWheelSoldierData soldierBlockData = blockEntity.getSoldierData();
        if (soldierBlockData != null) {
            ClientClaySoldierEntity soldier = soldierBlockData.getClientSoldier();
            tooltip.addHorizontalLine();
            if (soldier.isWaxed()) {
                tooltip.addCompoundItemStack(soldier.method_31480(), class_1802.field_20414.method_7854());
            } else {
                tooltip.addItemStack(soldier.method_31480());
            }
            tooltip.appendMultilineText(new class_2561[]{soldier.method_5476().method_27661().method_27692(class_124.field_1068), ClayMobProvider.INSTANCE.createTeamName(soldier), class_2561.method_43469((String)HAMSTER_WHEEL_SPEED, (Object[])new Object[]{Float.valueOf(soldierBlockData.getAdjustedSpeed())}).method_27692(class_124.field_1063)});
            tooltip.addHorizontalLine();
        }
        if (detail && blockEntity.hasEnergyStorage()) {
            int generating = 0;
            if (soldierBlockData != null) {
                long speed = ClaySoldiersCommon.COMMON_HOOKS.getHamsterWheelSpeed();
                generating = (int)Math.max(1.0f, (float)speed * soldierBlockData.getAdjustedSpeed());
            }
            tooltip.add((class_2561)class_2561.method_43469((String)GENERATING, (Object[])new Object[]{generating}));
        }
    }

    @Override
    public class_2960 getUniqueId() {
        return JadeRegistry.HAMSTER_WHEEL_BLOCK;
    }

    @Override
    public Class<? extends class_2248> getTargetClass() {
        return HamsterWheelBlock.class;
    }

    static {
        HAMSTER_WHEEL_SPEED = JadeRegistry.getLangKey(INSTANCE, "soldier_speed");
        GENERATING = JadeRegistry.getLangKey(INSTANCE, "generation");
    }
}

