/*
 * Decompiled with CFR 0.152.
 */
package net.bumblebee.claysoldiers.integration.jei;

import java.util.ArrayList;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.stream.Stream;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.constants.RecipeTypes;
import mezz.jei.api.ingredients.subtypes.ISubtypeInterpreter;
import mezz.jei.api.ingredients.subtypes.UidContext;
import mezz.jei.api.registration.IRecipeRegistration;
import mezz.jei.api.registration.ISubtypeRegistration;
import net.bumblebee.claysoldiers.ClaySoldiersCommon;
import net.bumblebee.claysoldiers.init.ModDataComponents;
import net.bumblebee.claysoldiers.init.ModItems;
import net.bumblebee.claysoldiers.init.ModTags;
import net.bumblebee.claysoldiers.integration.jei.ClaySoldierCookingRecipe;
import net.bumblebee.claysoldiers.integration.jei.ClaySoldierCrafting;
import net.bumblebee.claysoldiers.util.ComponentFormating;
import net.minecraft.class_124;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3859;
import net.minecraft.class_3861;
import net.minecraft.class_3862;
import net.minecraft.class_3920;
import net.minecraft.class_6880;
import net.minecraft.class_7923;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@JeiPlugin
public class JEIPlugin
implements IModPlugin {
    public void registerRecipes(IRecipeRegistration registration) {
        registration.addRecipes(RecipeTypes.CRAFTING, ClaySoldierCrafting.createRecipes());
        registration.addRecipes(RecipeTypes.CRAFTING, ClaySoldierCrafting.createClaySoldierRevive());
        registration.addRecipes(RecipeTypes.SMELTING, ClaySoldierCookingRecipe.createCookingRecipe(class_3861::new, 100));
        registration.addRecipes(RecipeTypes.BLASTING, ClaySoldierCookingRecipe.createCookingRecipe(class_3859::new, 50));
        registration.addRecipes(RecipeTypes.CAMPFIRE_COOKING, ClaySoldierCookingRecipe.createCookingRecipe(class_3920::new, 200));
        registration.addRecipes(RecipeTypes.SMOKING, ClaySoldierCookingRecipe.createCookingRecipe(class_3862::new, 300));
        class_7923.field_41178.method_40266(ModTags.Items.SOLDIER_HOLDABLE).ifPresentOrElse(set -> JEIPlugin.addItemToInfo(registration, set.method_40239().map(class_6880::comp_349), ClaySoldiersCommon.DATA_MAP::getEffect, ComponentFormating::addHoldableTooltip), () -> ClaySoldiersCommon.LOGGER.error("Could not load JEI Info for Clay Soldier Holdable Items"));
        class_7923.field_41178.method_40266(ModTags.Items.SOLDIER_POI).ifPresentOrElse(set -> {
            JEIPlugin.addItemToInfo(registration, set.method_40239().map(class_6880::comp_349), ClaySoldiersCommon.DATA_MAP::getItemPoi, (poi, list) -> {
                list.add(class_2561.method_43471((String)"item.tooltip.csr.soldier_poi_item").method_27692(class_124.field_1063));
                ComponentFormating.addPoiTooltip(poi, list);
            });
            JEIPlugin.addItemToInfo(registration, set.method_40239().map(class_6880::comp_349), ClaySoldiersCommon.DATA_MAP::getBlockPoi, (poi, list) -> {
                list.add(class_2561.method_43471((String)"item.tooltip.csr.soldier_poi_block").method_27692(class_124.field_1063));
                ComponentFormating.addPoiTooltip(poi, list);
            });
        }, () -> ClaySoldiersCommon.LOGGER.error("Could not load JEI Info for Clay Soldier POIs "));
    }

    private static <T> void addItemToInfo(IRecipeRegistration registration, Stream<class_1792> items, Function<class_1792, T> effectGetter, BiConsumer<T, List<class_2561>> getDescription) {
        items.forEach(item -> {
            Object effect = effectGetter.apply((class_1792)item);
            if (effect != null) {
                ArrayList tooltip = new ArrayList();
                getDescription.accept(effect, tooltip);
                registration.addIngredientInfo((class_1935)item, (class_2561[])tooltip.toArray(class_2561[]::new));
            }
        });
    }

    public void registerItemSubtypes(ISubtypeRegistration registration) {
        registration.registerSubtypeInterpreter((class_1792)ModItems.CLAY_SOLDIER.get(), (ISubtypeInterpreter)ClaySoldierPuppetInterpreter.INSTANCE);
        registration.registerSubtypeInterpreter(ModItems.BLUEPRINT.get(), (ISubtypeInterpreter)BlueprintInterpreter.INSTANCE);
        registration.registerSubtypeInterpreter((class_1792)ModItems.BRICKED_CLAY_SOLDIER.get(), (ISubtypeInterpreter)ClaySoldierPuppetInterpreter.INSTANCE);
    }

    @NotNull
    public class_2960 getPluginUid() {
        return class_2960.method_60655((String)"csr", (String)"jei_plugin");
    }

    private static enum ClaySoldierPuppetInterpreter implements ISubtypeInterpreter<class_1799>
    {
        INSTANCE;


        @Nullable
        public Object getSubtypeData(class_1799 ingredient, UidContext context) {
            return ingredient.method_57824(ModDataComponents.CLAY_MOB_TEAM_COMPONENT.get());
        }

        public String getLegacyStringSubtypeInfo(class_1799 ingredient, UidContext context) {
            return ((class_2960)ingredient.method_57824(ModDataComponents.CLAY_MOB_TEAM_COMPONENT.get())).toString();
        }
    }

    private static enum BlueprintInterpreter implements ISubtypeInterpreter<class_1799>
    {
        INSTANCE;


        @Nullable
        public Object getSubtypeData(class_1799 ingredient, UidContext context) {
            return ingredient.method_57824(ModDataComponents.BLUEPRINT_DATA.get());
        }

        public String getLegacyStringSubtypeInfo(class_1799 ingredient, UidContext context) {
            class_2960 data = (class_2960)ingredient.method_57824(ModDataComponents.BLUEPRINT_DATA.get());
            return data == null ? "" : data.toString();
        }
    }
}

