/*
 * Decompiled with CFR 0.152.
 */
package net.bumblebee.claysoldiers.item;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.netty.buffer.ByteBuf;
import java.lang.runtime.SwitchBootstraps;
import java.util.List;
import java.util.Objects;
import java.util.function.IntFunction;
import net.bumblebee.claysoldiers.init.ModDataComponents;
import net.bumblebee.claysoldiers.init.ModItems;
import net.bumblebee.claysoldiers.soldierproperties.translation.KeyableTranslatableProperty;
import net.minecraft.class_124;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1271;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1838;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3542;
import net.minecraft.class_5250;
import net.minecraft.class_6395;
import net.minecraft.class_7995;
import net.minecraft.class_9135;
import net.minecraft.class_9139;
import org.jetbrains.annotations.Nullable;

public class ClayBrushItem
extends class_1792 {
    public static final class_2960 MODE_PROPERTY = class_2960.method_60655((String)"csr", (String)"mode");
    public static final String POI_SET_LANG = "item.csr.clay_brush.poi.set";
    public static final String POI_CLEAR_LANG = "item.csr.clay_brush.poi.clear";
    public static final String NO_MODE_LANG = "item.csr.clay_brush.mode.no_mode";

    public ClayBrushItem(class_1792.class_1793 pProperties) {
        super(pProperties.method_57349(ModDataComponents.CLAY_BRUSH_MODE.get(), (Object)Mode.COMMAND).method_57349(ModDataComponents.CLAY_BRUSH_POI.get(), (Object)PoiPos.EMPTY));
    }

    public boolean method_7885(class_2680 pState, class_1937 pLevel, class_2338 pPos, class_1657 pPlayer) {
        class_1799 itemInHand;
        if (!pLevel.field_9236 && ClayBrushItem.getMode(itemInHand = pPlayer.method_5998(class_1268.field_5808)) == Mode.POI && pPlayer instanceof class_3222) {
            class_3222 serverPlayer = (class_3222)pPlayer;
            if (pPlayer.method_18276()) {
                ClayBrushItem.message(serverPlayer, (class_2561)class_2561.method_43471((String)POI_CLEAR_LANG).method_54663(Mode.POI.color));
                ClayBrushItem.setPoiPos(itemInHand, null);
            } else {
                ClayBrushItem.message(serverPlayer, (class_2561)class_2561.method_43469((String)POI_SET_LANG, (Object[])new Object[]{pPos.method_23854()}).method_54663(Mode.POI.color));
                ClayBrushItem.setPoiPos(itemInHand, pPos);
            }
        }
        return false;
    }

    private static void setPoiPos(class_1799 stack, @Nullable class_2338 pos) {
        stack.method_57379(ModDataComponents.CLAY_BRUSH_POI.get(), (Object)(pos == null ? PoiPos.EMPTY : new PoiPos(pos, false)));
    }

    private void cycleMode(class_1799 itemInHand, class_1657 player) {
        if (player instanceof class_3222) {
            class_3222 serverPlayer = (class_3222)player;
            Mode mode = (Mode)itemInHand.method_57824(ModDataComponents.CLAY_BRUSH_MODE.get());
            int n = 0;
            Mode newMode = switch (SwitchBootstraps.enumSwitch("enumSwitch", new Object[]{"COMMAND", "WORK", "POI"}, (Mode)mode, n)) {
                default -> throw new MatchException(null, null);
                case 0 -> Mode.WORK;
                case 1 -> Mode.POI;
                case 2 -> Mode.COMMAND;
                case -1 -> Mode.COMMAND;
            };
            itemInHand.method_57379(ModDataComponents.CLAY_BRUSH_MODE.get(), (Object)newMode);
            ClayBrushItem.message(serverPlayer, newMode.getDisplayName());
        }
    }

    public class_1269 method_7884(class_1838 pContext) {
        class_1799 itemInHand = pContext.method_8041();
        this.cycleMode(itemInHand, pContext.method_8036());
        return class_1269.method_29236((boolean)pContext.method_8045().method_8608());
    }

    public class_1271<class_1799> method_7836(class_1937 pLevel, class_1657 pPlayer, class_1268 pUsedHand) {
        this.cycleMode(pPlayer.method_5998(pUsedHand), pPlayer);
        return class_1271.method_29237((Object)pPlayer.method_5998(pUsedHand), (boolean)pLevel.method_8608());
    }

    private static void message(class_3222 pPlayer, class_2561 pMessageComponent) {
        pPlayer.method_43502(pMessageComponent, true);
    }

    public void method_7851(class_1799 pStack, class_1792.class_9635 pContext, List<class_2561> pTooltipComponents, class_1836 pTooltipFlag) {
        Mode mode = ClayBrushItem.getMode(pStack);
        if (mode != null) {
            class_5250 name = mode.getMutableDisplayName();
            PoiPos poiPos = (PoiPos)pStack.method_57824(ModDataComponents.CLAY_BRUSH_POI.get());
            if (mode == Mode.POI && poiPos != null && !poiPos.isEmpty()) {
                name.method_10852((class_2561)class_2561.method_43470((String)(" (" + poiPos.pos.method_23854() + ")")));
            }
            pTooltipComponents.add((class_2561)name);
        } else {
            pTooltipComponents.add((class_2561)class_2561.method_43471((String)NO_MODE_LANG).method_27692(class_124.field_1061));
        }
    }

    @Nullable
    public static Mode getMode(class_1799 stack) {
        return (Mode)stack.method_57824(ModDataComponents.CLAY_BRUSH_MODE.get());
    }

    public static class_2338 getPoiPos(class_1799 stack) {
        PoiPos poiPos = (PoiPos)stack.method_57824(ModDataComponents.CLAY_BRUSH_POI.get());
        return poiPos == null || poiPos.isEmpty() ? null : poiPos.pos;
    }

    public static void registerProperties(ItemPropertiesFactory factory) {
        factory.register(ModItems.CLAY_BRUSH.get(), MODE_PROPERTY, (stack, level, entity, seed) -> Objects.requireNonNullElse((Mode)stack.method_57824(ModDataComponents.CLAY_BRUSH_MODE.get()), Mode.COMMAND).overrideProperty);
    }

    public static enum Mode implements class_3542,
    KeyableTranslatableProperty
    {
        COMMAND(0, "command", 0.0f, 12671542),
        WORK(1, "work", 0.5f, 10101539),
        POI(2, "poi", 1.0f, 1719219);

        public static final IntFunction<Mode> BY_ID;
        public static final class_9139<ByteBuf, Mode> STREAM_CODEC;
        public static final Codec<Mode> CODEC;
        private static final String LANG_KEY = "item.%s.clay_rush.mode.%s";
        private final int id;
        private final String serializedName;
        private final float overrideProperty;
        private final int color;

        private Mode(int id, String serializedName, float overrideProperty, int color) {
            this.id = id;
            this.serializedName = serializedName;
            this.overrideProperty = overrideProperty;
            this.color = color;
        }

        public String method_15434() {
            return this.serializedName;
        }

        public float getOverrideProperty() {
            return this.overrideProperty;
        }

        @Override
        public String translatableKey() {
            return LANG_KEY.formatted("csr", this.serializedName);
        }

        @Override
        public class_2583 getStyle() {
            return class_2583.field_24360.method_36139(this.color);
        }

        private class_5250 getMutableDisplayName() {
            return class_2561.method_43471((String)this.translatableKey()).method_27696(this.getStyle());
        }

        static {
            BY_ID = class_7995.method_47914(mode -> mode.id, (Object[])Mode.values(), (class_7995.class_7996)class_7995.class_7996.field_41664);
            STREAM_CODEC = class_9135.method_56375(BY_ID, mode -> mode.id);
            CODEC = class_3542.method_28140(Mode::values);
        }
    }

    public record PoiPos(class_2338 pos, boolean isEmpty) {
        public static final PoiPos EMPTY = new PoiPos(class_2338.field_10980, true);
        public static final Codec<PoiPos> CODEC = RecordCodecBuilder.create(in -> in.group((App)class_2338.field_25064.optionalFieldOf("pos", (Object)class_2338.field_10980).forGetter(PoiPos::pos), (App)Codec.BOOL.optionalFieldOf("empty", (Object)true).forGetter(PoiPos::isEmpty)).apply((Applicative)in, PoiPos::new));
        public static final class_9139<ByteBuf, PoiPos> STREAM_CODEC = class_9139.method_56435((class_9139)class_2338.field_48404, PoiPos::pos, (class_9139)class_9135.field_48547, PoiPos::isEmpty, PoiPos::new);
    }

    public static interface ItemPropertiesFactory {
        public void register(class_1792 var1, class_2960 var2, class_6395 var3);
    }
}

