/*
 * Decompiled with CFR 0.152.
 */
package net.bumblebee.claysoldiers.item;

import com.mojang.serialization.Codec;
import io.netty.buffer.ByteBuf;
import java.lang.runtime.SwitchBootstraps;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.bumblebee.claysoldiers.ClaySoldiersCommon;
import net.bumblebee.claysoldiers.block.hamsterwheel.HamsterWheelBlockEntity;
import net.bumblebee.claysoldiers.block.hamsterwheel.HamsterWheelSoldierData;
import net.bumblebee.claysoldiers.entity.boss.BossClaySoldierEntity;
import net.bumblebee.claysoldiers.entity.boss.ClaySoldierBossEquipment;
import net.bumblebee.claysoldiers.entity.goal.workgoal.dig.DigBreakManger;
import net.bumblebee.claysoldiers.init.ModDataComponents;
import net.bumblebee.claysoldiers.init.ModEntityTypes;
import net.bumblebee.claysoldiers.init.ModRegistries;
import net.bumblebee.claysoldiers.init.ModTags;
import net.bumblebee.claysoldiers.team.ClayMobTeamManger;
import net.bumblebee.claysoldiers.team.TeamLoyaltyManger;
import net.minecraft.class_124;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1271;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1838;
import net.minecraft.class_1937;
import net.minecraft.class_2378;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3283;
import net.minecraft.class_3542;
import net.minecraft.class_4153;
import net.minecraft.class_4158;
import net.minecraft.class_6880;
import net.minecraft.class_7225;
import net.minecraft.class_9135;
import net.minecraft.class_9139;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestItem
extends class_1792 {
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"Clay Soldiers Remake Debug");

    public TestItem(class_1792.class_1793 pProperties) {
        super(pProperties.method_57349(ModDataComponents.DEBUG_ITEM_MODE.get(), (Object)Mode.TEAM));
    }

    public class_1269 method_7884(class_1838 context) {
        class_1937 level = context.method_8045();
        class_2586 blockEntity = context.method_8045().method_8321(context.method_8037());
        class_1937 class_19372 = context.method_8045();
        if (class_19372 instanceof class_3218) {
            class_3218 serverLevel = (class_3218)class_19372;
            TestItem.log(serverLevel.method_8320(context.method_8037()), List.of("PoiType: " + String.valueOf(serverLevel.method_19494().method_19132(context.method_8037())), "Occupants: " + (serverLevel.method_19494().method_19132(context.method_8037()).map(h -> ((class_4158)h.comp_349()).comp_816()).orElse(0) - serverLevel.method_19494().method_35155(context.method_8037()))));
        }
        if (blockEntity instanceof HamsterWheelBlockEntity) {
            HamsterWheelBlockEntity hamsterWheel;
            HamsterWheelSoldierData data = (hamsterWheel = (HamsterWheelBlockEntity)blockEntity).getSoldierData();
            TestItem.log(hamsterWheel, List.of(data == null ? "HamsterWheelSoldierData(null)" : data.toString()));
        }
        return class_1269.method_29236((boolean)context.method_8045().method_8608());
    }

    public class_1271<class_1799> method_7836(class_1937 level, class_1657 pPlayer, class_1268 pUsedHand) {
        class_1799 itemInHand = pPlayer.method_5998(pUsedHand);
        System.out.println((level.field_9236 ? "Client " : "Server ") + String.valueOf(HamsterWheelBlockEntity.withSoldiers));
        if (level instanceof class_3218) {
            class_3218 serverLevel = (class_3218)level;
            serverLevel.method_19494().method_22383(h -> h.method_40220(ModTags.PoiTypes.SOLDIER_CONTAINER), pPlayer.method_23312(), 10, class_4153.class_4155.field_18489);
        }
        if (pPlayer.method_18276()) {
            class_1799 offHand = pPlayer.method_5998(class_1268.field_5810);
            if (pUsedHand == class_1268.field_5808 && !offHand.method_7960()) {
                LOGGER.info("{}---: {}", (Object)(level.field_9236 ? "Client" : "Server"), (Object)offHand.method_7909());
                LOGGER.info("Holdable: {}", (Object)ClaySoldiersCommon.DATA_MAP.getEffect(offHand));
                LOGGER.info("Wearable: {}", (Object)ClaySoldiersCommon.DATA_MAP.getArmor(offHand));
                LOGGER.info("Item Poi: {}", (Object)ClaySoldiersCommon.DATA_MAP.getItemPoi(offHand));
                LOGGER.info("Block Poi: {}", (Object)ClaySoldiersCommon.DATA_MAP.getBlockPoi(offHand));
                LOGGER.info("---");
            } else {
                TestItem.cycleMode(itemInHand, pPlayer);
            }
        } else {
            Mode mode = (Mode)((Object)pPlayer.method_5998(pUsedHand).method_57824(ModDataComponents.DEBUG_ITEM_MODE.get()));
            if (mode == null) {
                mode = Mode.TEAM;
            }
            ArrayList<String> info = new ArrayList<String>();
            info.add(level.method_8608() ? "Client---" : "Server---");
            mode.getInfo(level, pPlayer, info);
            info.add("---");
            info.forEach(arg_0 -> ((Logger)LOGGER).info(arg_0));
        }
        return class_1271.method_29237((Object)itemInHand, (boolean)level.method_8608());
    }

    private static void cycleMode(class_1799 itemInHand, class_1657 player) {
        if (player instanceof class_3222) {
            class_3222 serverPlayer = (class_3222)player;
            Mode mode = (Mode)((Object)itemInHand.method_57824(ModDataComponents.DEBUG_ITEM_MODE.get()));
            int n = 0;
            Mode newMode = switch (SwitchBootstraps.enumSwitch("enumSwitch", new Object[]{"TEAM", "WORLD", "CONFIG", "BLUEPRINT", "TAGS", "BOSS"}, (Mode)mode, n)) {
                default -> throw new MatchException(null, null);
                case 0 -> Mode.WORLD;
                case 1 -> Mode.CONFIG;
                case 2 -> Mode.BLUEPRINT;
                case 3 -> Mode.TAGS;
                case 4 -> Mode.BOSS;
                case 5 -> Mode.TEAM;
                case -1 -> Mode.TEAM;
            };
            itemInHand.method_57379(ModDataComponents.DEBUG_ITEM_MODE.get(), (Object)newMode);
            serverPlayer.method_43496(newMode.getDisplayName());
        }
    }

    public static boolean isBlueprintEnabled(class_1937 level) {
        return ClaySoldiersCommon.COMMON_HOOKS.isBlueprintEnabled(level.method_45162());
    }

    public static long wheelSpeed() {
        return ClaySoldiersCommon.COMMON_HOOKS.getHamsterWheelSpeed();
    }

    public void method_7851(class_1799 stack, class_1792.class_9635 context, List<class_2561> tooltipComponents, class_1836 tooltipFlag) {
        tooltipComponents.add((class_2561)class_2561.method_43470((String)"Right-Click Logs Useful Information to the console").method_27692(class_124.field_1065));
        tooltipComponents.add((class_2561)class_2561.method_43470((String)"Sneak-Right-Click to change modes").method_27692(class_124.field_1065));
        Mode mode = (Mode)((Object)stack.method_57824(ModDataComponents.DEBUG_ITEM_MODE.get()));
        if (mode != null) {
            tooltipComponents.add((class_2561)class_2561.method_43470((String)"Mode: ").method_27692(class_124.field_1063).method_10852(mode.getDisplayName()));
        } else {
            tooltipComponents.add((class_2561)class_2561.method_43470((String)"Mode: Unselected").method_27692(class_124.field_1063));
        }
    }

    public static <T> void log(T entity, List<String> infos) {
        LOGGER.info("{}---", entity);
        infos.forEach(arg_0 -> ((Logger)LOGGER).info(arg_0));
        LOGGER.info("---");
    }

    public static enum Mode implements class_3542
    {
        TEAM("team", class_124.field_1077, (level, player, list) -> {
            list.add("Custom Reg and Level: " + String.valueOf(level.method_30349().method_33310(ModRegistries.CLAY_MOB_TEAMS)));
            list.add("Teams: " + String.valueOf(ClayMobTeamManger.getAllKeys((class_7225.class_7874)level.method_30349())));
            list.add("From Item: " + String.valueOf(ClayMobTeamManger.getFromItemMap()));
        }, (s, p, info) -> info.add("Loyalty: " + String.valueOf(TeamLoyaltyManger.getTeamPlayerData(s))), (c, p, info) -> info.add("Loyalty: " + String.valueOf(TeamLoyaltyManger.getClientTeamPlayerData()))),
        WORLD("world", class_124.field_1078, InfoGenerator.EMPTY, (level, player, list) -> {
            list.add("BreakData: " + String.valueOf(DigBreakManger.get()));
            list.add("DataPack");
            class_3283 packRepository = level.method_8503().method_3836();
            list.add("Selected: " + String.valueOf(packRepository.method_29210().stream().filter(id -> id.contains("csr") || id.contains("blueprint")).toList()));
            list.add("Available: " + String.valueOf(packRepository.method_29210().stream().filter(id -> id.contains("csr") || id.contains("blueprint")).toList()));
            packRepository.method_14441().stream().filter(p -> p.method_14463().contains("csr") || p.method_14463().contains("blueprint")).forEach(pack -> list.add("Pack(%s [%s], source:%s)".formatted(pack.method_14459().getString(), pack.method_14463(), pack.method_29483().method_45282((class_2561)class_2561.method_43470((String)"csr")).getString())));
        }, InfoGenerator.EMPTY),
        CONFIG("config", class_124.field_1054, (l, p, infos) -> {
            infos.add("Config: MenuModify: %s | WheelSpeed: %s | Blueprint: %s".formatted(ClaySoldiersCommon.claySolderMenuModify ? "Allowed" : "Disabled", TestItem.wheelSpeed(), TestItem.isBlueprintEnabled(l) ? "Enabled" : "Disabled"));
            infos.add("Caps: " + ClaySoldiersCommon.CAPABILITY_MANGER.toString());
        }),
        BLUEPRINT("blueprint", class_124.field_1075, (l, p, info) -> {
            class_2378 reg = l.method_30349().method_30530(ModRegistries.BLUEPRINTS);
            info.add("Registry(%s): %s".formatted(reg.method_10204(), reg.method_10235()));
            info.add("Content: " + String.valueOf(reg.method_40270().map(class_6880::comp_349).toList()));
        }),
        TAGS("soldier_item_tags", class_124.field_1064, (l, p, info) -> {
            Optional reg = l.method_30349().method_33310(ModRegistries.SOLDIER_ITEM_TYPES);
            info.add("Type Reg: " + String.valueOf(reg));
            info.add("Values: " + String.valueOf(reg.map(r -> r.method_10220().toList())));
            info.add("Entries: " + String.valueOf(reg.map(class_2378::method_29722)));
            info.add("Generators: " + String.valueOf(ModRegistries.ITEM_GENERATORS_REGISTRY.method_10220().toList()));
            info.add("Entries: " + String.valueOf(ModRegistries.ITEM_GENERATORS_REGISTRY.method_29722()));
        }),
        BOSS("boss", class_124.field_1061, InfoGenerator.EMPTY, (serverLevel, p, info) -> {
            BossClaySoldierEntity boss = (BossClaySoldierEntity)ModEntityTypes.BOSS_CLAY_SOLDIER_ENTITY.get().method_5883(serverLevel);
            if (boss == null) {
                info.add("Error creating Boss");
                return;
            }
            boss.method_29495(p.method_19538());
            ClaySoldierBossEquipment.RANDOM.setUp(boss, 8, null, false);
            if (serverLevel.method_8649((class_1297)boss)) {
                info.add("Successfully spawned Boss");
            } else {
                info.add("Error spawning Boss");
            }
        }, InfoGenerator.EMPTY);

        public static final Codec<Mode> CODEC;
        public static final class_9139<ByteBuf, Mode> STREAM_CODEC;
        private final String serializedName;
        private final String capitalizedName;
        private final class_124 chatFormatting;
        private final InfoGenerator<class_1937> toInfo;
        private final InfoGenerator<class_3218> server;
        private final InfoGenerator<class_1937> client;

        private Mode(String serializedName, class_124 chatFormatting, InfoGenerator<class_1937> toInfo) {
            this(serializedName, chatFormatting, toInfo, InfoGenerator.EMPTY_SERVER, InfoGenerator.EMPTY);
        }

        private Mode(String serializedName, class_124 chatFormatting, InfoGenerator<class_1937> toInfo, InfoGenerator<class_3218> server, InfoGenerator<class_1937> client) {
            this.serializedName = serializedName;
            this.chatFormatting = chatFormatting;
            this.toInfo = toInfo;
            this.server = server;
            this.client = client;
            StringBuilder builder = new StringBuilder();
            for (String i : serializedName.replace('_', ' ').split(" ")) {
                builder.append(i.replaceFirst("" + i.charAt(0), ("" + i.charAt(0)).toUpperCase()));
            }
            this.capitalizedName = builder.toString();
        }

        public void getInfo(class_1937 level, class_1657 player, List<String> info) {
            this.toInfo.appendInfo(level, player, info);
            if (level instanceof class_3218) {
                class_3218 serverLevel = (class_3218)level;
                this.server.appendInfo(serverLevel, player, info);
            } else {
                this.client.appendInfo(level, player, info);
            }
        }

        public class_2561 getDisplayName() {
            return class_2561.method_43470((String)this.capitalizedName).method_27692(this.chatFormatting);
        }

        @NotNull
        public String method_15434() {
            return this.serializedName;
        }

        static {
            CODEC = class_3542.method_28140(Mode::values);
            STREAM_CODEC = class_9135.method_56368(CODEC);
        }
    }

    static interface InfoGenerator<L extends class_1937> {
        public static final InfoGenerator<class_1937> EMPTY = (l, p, infoList) -> {};
        public static final InfoGenerator<class_3218> EMPTY_SERVER = (l, p, infoList) -> {};

        public void appendInfo(L var1, class_1657 var2, List<String> var3);
    }
}

