/*
 * Decompiled with CFR 0.152.
 */
package net.bumblebee.claysoldiers.item.blueprint.tooltip;

import java.util.List;
import net.bumblebee.claysoldiers.blueprint.BlueprintData;
import net.bumblebee.claysoldiers.init.ModRegistries;
import net.minecraft.class_1799;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_5684;

public class ClientBlueprintTooltip
implements class_5684 {
    private static final int MAX_ITEMS_PER_ROW = 10;
    private static final int ITEM_SIZE = 18;
    private static final int ITEM_PADDING = 1;
    private final List<class_1799> contents;

    public ClientBlueprintTooltip(class_2960 dataKey) {
        List<Object> contentCopy;
        BlueprintData data = (BlueprintData)class_310.method_1551().field_1724.method_56673().method_30530(ModRegistries.BLUEPRINTS).method_10223(dataKey);
        if (data == null) {
            contentCopy = List.of();
        } else {
            try {
                contentCopy = data.getTemplate().getNeededItems();
            }
            catch (IllegalStateException e) {
                contentCopy = List.of();
            }
        }
        this.contents = contentCopy;
    }

    public int method_32661() {
        return 4 + 18 * ClientBlueprintTooltip.divideCeil(this.contents.size());
    }

    public int method_32664(class_327 font) {
        return 18 * Math.min(this.contents.size(), 10);
    }

    public void method_32666(class_327 pFont, int pX, int pY, class_332 pGuiGraphics) {
        for (int itemIndex = 0; itemIndex < this.contents.size(); ++itemIndex) {
            int elementX = 1 + pX + itemIndex % 10 * 18;
            int elementY = 1 + pY + itemIndex / 10 * 18;
            this.renderItem(elementX, elementY, itemIndex, pGuiGraphics, pFont);
        }
    }

    private void renderItem(int pX, int pY, int pItemIndex, class_332 pGuiGraphics, class_327 pFont) {
        class_1799 itemstack = this.contents.get(pItemIndex);
        pGuiGraphics.method_51428(itemstack, pX + 1, pY + 1, pItemIndex);
        pGuiGraphics.method_51431(pFont, itemstack, pX + 1, pY + 1);
    }

    private static int divideCeil(int numerator) {
        return (int)Math.ceil((float)numerator / 10.0f);
    }
}

